// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ses

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/query"
)

// Represents a request to delete an email address from the list of email addresses
// you have attempted to verify under your AWS account.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteVerifiedEmailAddressRequest
type DeleteVerifiedEmailAddressInput struct {
	_ struct{} `type:"structure"`

	// An email address to be removed from the list of verified addresses.
	//
	// EmailAddress is a required field
	EmailAddress *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteVerifiedEmailAddressInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVerifiedEmailAddressInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteVerifiedEmailAddressInput"}

	if s.EmailAddress == nil {
		invalidParams.Add(aws.NewErrParamRequired("EmailAddress"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteVerifiedEmailAddressOutput
type DeleteVerifiedEmailAddressOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteVerifiedEmailAddressOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteVerifiedEmailAddress = "DeleteVerifiedEmailAddress"

// DeleteVerifiedEmailAddressRequest returns a request value for making API operation for
// Amazon Simple Email Service.
//
// Deprecated. Use the DeleteIdentity operation to delete email addresses and
// domains.
//
//    // Example sending a request using DeleteVerifiedEmailAddressRequest.
//    req := client.DeleteVerifiedEmailAddressRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteVerifiedEmailAddress
func (c *Client) DeleteVerifiedEmailAddressRequest(input *DeleteVerifiedEmailAddressInput) DeleteVerifiedEmailAddressRequest {
	op := &aws.Operation{
		Name:       opDeleteVerifiedEmailAddress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteVerifiedEmailAddressInput{}
	}

	req := c.newRequest(op, input, &DeleteVerifiedEmailAddressOutput{})
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeleteVerifiedEmailAddressRequest{Request: req, Input: input, Copy: c.DeleteVerifiedEmailAddressRequest}
}

// DeleteVerifiedEmailAddressRequest is the request type for the
// DeleteVerifiedEmailAddress API operation.
type DeleteVerifiedEmailAddressRequest struct {
	*aws.Request
	Input *DeleteVerifiedEmailAddressInput
	Copy  func(*DeleteVerifiedEmailAddressInput) DeleteVerifiedEmailAddressRequest
}

// Send marshals and sends the DeleteVerifiedEmailAddress API request.
func (r DeleteVerifiedEmailAddressRequest) Send(ctx context.Context) (*DeleteVerifiedEmailAddressResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteVerifiedEmailAddressResponse{
		DeleteVerifiedEmailAddressOutput: r.Request.Data.(*DeleteVerifiedEmailAddressOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteVerifiedEmailAddressResponse is the response type for the
// DeleteVerifiedEmailAddress API operation.
type DeleteVerifiedEmailAddressResponse struct {
	*DeleteVerifiedEmailAddressOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteVerifiedEmailAddress request.
func (r *DeleteVerifiedEmailAddressResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
