// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ses

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents a request to update the tracking options for a configuration set.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/UpdateConfigurationSetTrackingOptionsRequest
type UpdateConfigurationSetTrackingOptionsInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration set for which you want to update the custom
	// tracking domain.
	//
	// ConfigurationSetName is a required field
	ConfigurationSetName *string `type:"string" required:"true"`

	// A domain that is used to redirect email recipients to an Amazon SES-operated
	// domain. This domain captures open and click events generated by Amazon SES
	// emails.
	//
	// For more information, see Configuring Custom Domains to Handle Open and Click
	// Tracking (ses/latest/DeveloperGuide/configure-custom-open-click-domains.html)
	// in the Amazon SES Developer Guide.
	//
	// TrackingOptions is a required field
	TrackingOptions *TrackingOptions `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateConfigurationSetTrackingOptionsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateConfigurationSetTrackingOptionsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateConfigurationSetTrackingOptionsInput"}

	if s.ConfigurationSetName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ConfigurationSetName"))
	}

	if s.TrackingOptions == nil {
		invalidParams.Add(aws.NewErrParamRequired("TrackingOptions"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// An empty element returned on a successful request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/UpdateConfigurationSetTrackingOptionsResponse
type UpdateConfigurationSetTrackingOptionsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateConfigurationSetTrackingOptionsOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateConfigurationSetTrackingOptions = "UpdateConfigurationSetTrackingOptions"

// UpdateConfigurationSetTrackingOptionsRequest returns a request value for making API operation for
// Amazon Simple Email Service.
//
// Modifies an association between a configuration set and a custom domain for
// open and click event tracking.
//
// By default, images and links used for tracking open and click events are
// hosted on domains operated by Amazon SES. You can configure a subdomain of
// your own to handle these events. For information about using custom domains,
// see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/configure-custom-open-click-domains.html).
//
//    // Example sending a request using UpdateConfigurationSetTrackingOptionsRequest.
//    req := client.UpdateConfigurationSetTrackingOptionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/UpdateConfigurationSetTrackingOptions
func (c *Client) UpdateConfigurationSetTrackingOptionsRequest(input *UpdateConfigurationSetTrackingOptionsInput) UpdateConfigurationSetTrackingOptionsRequest {
	op := &aws.Operation{
		Name:       opUpdateConfigurationSetTrackingOptions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateConfigurationSetTrackingOptionsInput{}
	}

	req := c.newRequest(op, input, &UpdateConfigurationSetTrackingOptionsOutput{})
	return UpdateConfigurationSetTrackingOptionsRequest{Request: req, Input: input, Copy: c.UpdateConfigurationSetTrackingOptionsRequest}
}

// UpdateConfigurationSetTrackingOptionsRequest is the request type for the
// UpdateConfigurationSetTrackingOptions API operation.
type UpdateConfigurationSetTrackingOptionsRequest struct {
	*aws.Request
	Input *UpdateConfigurationSetTrackingOptionsInput
	Copy  func(*UpdateConfigurationSetTrackingOptionsInput) UpdateConfigurationSetTrackingOptionsRequest
}

// Send marshals and sends the UpdateConfigurationSetTrackingOptions API request.
func (r UpdateConfigurationSetTrackingOptionsRequest) Send(ctx context.Context) (*UpdateConfigurationSetTrackingOptionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateConfigurationSetTrackingOptionsResponse{
		UpdateConfigurationSetTrackingOptionsOutput: r.Request.Data.(*UpdateConfigurationSetTrackingOptionsOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateConfigurationSetTrackingOptionsResponse is the response type for the
// UpdateConfigurationSetTrackingOptions API operation.
type UpdateConfigurationSetTrackingOptionsResponse struct {
	*UpdateConfigurationSetTrackingOptionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateConfigurationSetTrackingOptions request.
func (r *UpdateConfigurationSetTrackingOptionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
