// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package textract

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/AnalyzeDocumentRequest
type AnalyzeDocumentInput struct {
	_ struct{} `type:"structure"`

	// The input document as base64-encoded bytes or an Amazon S3 object. If you
	// use the AWS CLI to call Amazon Textract operations, you can't pass image
	// bytes. The document must be an image in JPG or PNG format.
	//
	// If you are using an AWS SDK to call Amazon Textract, you might not need to
	// base64-encode image bytes passed using the Bytes field.
	//
	// Document is a required field
	Document *Document `type:"structure" required:"true"`

	// A list of the types of analysis to perform. Add TABLES to the list to return
	// information about the tables detected in the input document. Add FORMS to
	// return detected fields and the associated text. To perform both types of
	// analysis, add TABLES and FORMS to FeatureTypes.
	//
	// FeatureTypes is a required field
	FeatureTypes []FeatureType `type:"list" required:"true"`
}

// String returns the string representation
func (s AnalyzeDocumentInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnalyzeDocumentInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AnalyzeDocumentInput"}

	if s.Document == nil {
		invalidParams.Add(aws.NewErrParamRequired("Document"))
	}

	if s.FeatureTypes == nil {
		invalidParams.Add(aws.NewErrParamRequired("FeatureTypes"))
	}
	if s.Document != nil {
		if err := s.Document.Validate(); err != nil {
			invalidParams.AddNested("Document", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/AnalyzeDocumentResponse
type AnalyzeDocumentOutput struct {
	_ struct{} `type:"structure"`

	// The text that's detected and analyzed by AnalyzeDocument.
	Blocks []Block `type:"list"`

	// Metadata about the analyzed document. An example is the number of pages.
	DocumentMetadata *DocumentMetadata `type:"structure"`
}

// String returns the string representation
func (s AnalyzeDocumentOutput) String() string {
	return awsutil.Prettify(s)
}

const opAnalyzeDocument = "AnalyzeDocument"

// AnalyzeDocumentRequest returns a request value for making API operation for
// Amazon Textract.
//
// Analyzes an input document for relationships between detected items.
//
// The types of information returned are as follows:
//
//    * Words and lines that are related to nearby lines and words. The related
//    information is returned in two Block objects each of type KEY_VALUE_SET:
//    a KEY Block object and a VALUE Block object. For example, Name: Ana Silva
//    Carolina contains a key and value. Name: is the key. Ana Silva Carolina
//    is the value.
//
//    * Table and table cell data. A TABLE Block object contains information
//    about a detected table. A CELL Block object is returned for each cell
//    in a table.
//
//    * Selectable elements such as checkboxes and radio buttons. A SELECTION_ELEMENT
//    Block object contains information about a selectable element.
//
//    * Lines and words of text. A LINE Block object contains one or more WORD
//    Block objects.
//
// You can choose which type of analysis to perform by specifying the FeatureTypes
// list.
//
// The output is returned in a list of BLOCK objects.
//
// AnalyzeDocument is a synchronous operation. To analyze documents asynchronously,
// use StartDocumentAnalysis.
//
// For more information, see Document Text Analysis (https://docs.aws.amazon.com/textract/latest/dg/how-it-works-analyzing.html).
//
//    // Example sending a request using AnalyzeDocumentRequest.
//    req := client.AnalyzeDocumentRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/AnalyzeDocument
func (c *Client) AnalyzeDocumentRequest(input *AnalyzeDocumentInput) AnalyzeDocumentRequest {
	op := &aws.Operation{
		Name:       opAnalyzeDocument,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AnalyzeDocumentInput{}
	}

	req := c.newRequest(op, input, &AnalyzeDocumentOutput{})
	return AnalyzeDocumentRequest{Request: req, Input: input, Copy: c.AnalyzeDocumentRequest}
}

// AnalyzeDocumentRequest is the request type for the
// AnalyzeDocument API operation.
type AnalyzeDocumentRequest struct {
	*aws.Request
	Input *AnalyzeDocumentInput
	Copy  func(*AnalyzeDocumentInput) AnalyzeDocumentRequest
}

// Send marshals and sends the AnalyzeDocument API request.
func (r AnalyzeDocumentRequest) Send(ctx context.Context) (*AnalyzeDocumentResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &AnalyzeDocumentResponse{
		AnalyzeDocumentOutput: r.Request.Data.(*AnalyzeDocumentOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// AnalyzeDocumentResponse is the response type for the
// AnalyzeDocument API operation.
type AnalyzeDocumentResponse struct {
	*AnalyzeDocumentOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// AnalyzeDocument request.
func (r *AnalyzeDocumentResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
