// ----------------------------------------------------------------------------
//
//     ***     AUTO GENERATED CODE    ***    AUTO GENERATED CODE     ***
//
// ----------------------------------------------------------------------------
//
//     This file is automatically generated by Magic Modules and manual
//     changes will be clobbered when the file is regenerated.
//
//     Please read more about how to change this file in
//     .github/CONTRIBUTING.md.
//
// ----------------------------------------------------------------------------

package google

import (
	"fmt"
	"testing"

	"github.com/hashicorp/terraform-plugin-sdk/helper/acctest"
	"github.com/hashicorp/terraform-plugin-sdk/helper/resource"
)

func TestAccRuntimeConfigConfigIamBindingGenerated(t *testing.T) {
	t.Parallel()

	context := map[string]interface{}{
		"random_suffix": acctest.RandString(10),
		"role":          "roles/viewer",
	}

	resource.Test(t, resource.TestCase{
		PreCheck:  func() { testAccPreCheck(t) },
		Providers: testAccProviders,
		Steps: []resource.TestStep{
			{
				Config: testAccRuntimeConfigConfigIamBinding_basicGenerated(context),
			},
			{
				ResourceName:      "google_runtimeconfig_config_iam_binding.foo",
				ImportStateId:     fmt.Sprintf("projects/%s/configs/%s roles/viewer", getTestProjectFromEnv(), fmt.Sprintf("my-config%s", context["random_suffix"])),
				ImportState:       true,
				ImportStateVerify: true,
			},
			{
				// Test Iam Binding update
				Config: testAccRuntimeConfigConfigIamBinding_updateGenerated(context),
			},
			{
				ResourceName:      "google_runtimeconfig_config_iam_binding.foo",
				ImportStateId:     fmt.Sprintf("projects/%s/configs/%s roles/viewer", getTestProjectFromEnv(), fmt.Sprintf("my-config%s", context["random_suffix"])),
				ImportState:       true,
				ImportStateVerify: true,
			},
		},
	})
}

func TestAccRuntimeConfigConfigIamMemberGenerated(t *testing.T) {
	t.Parallel()

	context := map[string]interface{}{
		"random_suffix": acctest.RandString(10),
		"role":          "roles/viewer",
	}

	resource.Test(t, resource.TestCase{
		PreCheck:  func() { testAccPreCheck(t) },
		Providers: testAccProviders,
		Steps: []resource.TestStep{
			{
				// Test Iam Member creation (no update for member, no need to test)
				Config: testAccRuntimeConfigConfigIamMember_basicGenerated(context),
			},
			{
				ResourceName:      "google_runtimeconfig_config_iam_member.foo",
				ImportStateId:     fmt.Sprintf("projects/%s/configs/%s roles/viewer user:admin@hashicorptest.com", getTestProjectFromEnv(), fmt.Sprintf("my-config%s", context["random_suffix"])),
				ImportState:       true,
				ImportStateVerify: true,
			},
		},
	})
}

func TestAccRuntimeConfigConfigIamPolicyGenerated(t *testing.T) {
	t.Parallel()

	context := map[string]interface{}{
		"random_suffix": acctest.RandString(10),
		"role":          "roles/viewer",
	}

	resource.Test(t, resource.TestCase{
		PreCheck:  func() { testAccPreCheck(t) },
		Providers: testAccProviders,
		Steps: []resource.TestStep{
			{
				Config: testAccRuntimeConfigConfigIamPolicy_basicGenerated(context),
			},
			{
				ResourceName:      "google_runtimeconfig_config_iam_policy.foo",
				ImportStateId:     fmt.Sprintf("projects/%s/configs/%s", getTestProjectFromEnv(), fmt.Sprintf("my-config%s", context["random_suffix"])),
				ImportState:       true,
				ImportStateVerify: true,
			},
			{
				Config: testAccRuntimeConfigConfigIamPolicy_emptyBinding(context),
			},
			{
				ResourceName:      "google_runtimeconfig_config_iam_policy.foo",
				ImportStateId:     fmt.Sprintf("projects/%s/configs/%s", getTestProjectFromEnv(), fmt.Sprintf("my-config%s", context["random_suffix"])),
				ImportState:       true,
				ImportStateVerify: true,
			},
		},
	})
}

func testAccRuntimeConfigConfigIamMember_basicGenerated(context map[string]interface{}) string {
	return Nprintf(`
resource "google_runtimeconfig_config" "config" {
  name        = "my-config%{random_suffix}"
  description = "Runtime configuration values for my service"
}

resource "google_runtimeconfig_config_iam_member" "foo" {
  project = "${google_runtimeconfig_config.config.project}"
  config = "${google_runtimeconfig_config.config.name}"
  role = "%{role}"
  member = "user:admin@hashicorptest.com"
}
`, context)
}

func testAccRuntimeConfigConfigIamPolicy_basicGenerated(context map[string]interface{}) string {
	return Nprintf(`
resource "google_runtimeconfig_config" "config" {
  name        = "my-config%{random_suffix}"
  description = "Runtime configuration values for my service"
}

data "google_iam_policy" "foo" {
  binding {
    role = "%{role}"
    members = ["user:admin@hashicorptest.com"]
  }
}

resource "google_runtimeconfig_config_iam_policy" "foo" {
  project = "${google_runtimeconfig_config.config.project}"
  config = "${google_runtimeconfig_config.config.name}"
  policy_data = "${data.google_iam_policy.foo.policy_data}"
}
`, context)
}

func testAccRuntimeConfigConfigIamPolicy_emptyBinding(context map[string]interface{}) string {
	return Nprintf(`
resource "google_runtimeconfig_config" "config" {
  name        = "my-config%{random_suffix}"
  description = "Runtime configuration values for my service"
}

data "google_iam_policy" "foo" {
}

resource "google_runtimeconfig_config_iam_policy" "foo" {
  project = "${google_runtimeconfig_config.config.project}"
  config = "${google_runtimeconfig_config.config.name}"
  policy_data = "${data.google_iam_policy.foo.policy_data}"
}
`, context)
}

func testAccRuntimeConfigConfigIamBinding_basicGenerated(context map[string]interface{}) string {
	return Nprintf(`
resource "google_runtimeconfig_config" "config" {
  name        = "my-config%{random_suffix}"
  description = "Runtime configuration values for my service"
}

resource "google_runtimeconfig_config_iam_binding" "foo" {
  project = "${google_runtimeconfig_config.config.project}"
  config = "${google_runtimeconfig_config.config.name}"
  role = "%{role}"
  members = ["user:admin@hashicorptest.com"]
}
`, context)
}

func testAccRuntimeConfigConfigIamBinding_updateGenerated(context map[string]interface{}) string {
	return Nprintf(`
resource "google_runtimeconfig_config" "config" {
  name        = "my-config%{random_suffix}"
  description = "Runtime configuration values for my service"
}

resource "google_runtimeconfig_config_iam_binding" "foo" {
  project = "${google_runtimeconfig_config.config.project}"
  config = "${google_runtimeconfig_config.config.name}"
  role = "%{role}"
  members = ["user:admin@hashicorptest.com", "user:paddy@hashicorp.com"]
}
`, context)
}
