// ----------------------------------------------------------------------------
//
//     ***     AUTO GENERATED CODE    ***    AUTO GENERATED CODE     ***
//
// ----------------------------------------------------------------------------
//
//     This file is automatically generated by Magic Modules and manual
//     changes will be clobbered when the file is regenerated.
//
//     Please read more about how to change this file in
//     .github/CONTRIBUTING.md.
//
// ----------------------------------------------------------------------------

package google

import (
	"fmt"
	"strings"
	"testing"

	"github.com/hashicorp/terraform-plugin-sdk/helper/acctest"
	"github.com/hashicorp/terraform-plugin-sdk/helper/resource"
	"github.com/hashicorp/terraform-plugin-sdk/terraform"
)

func TestAccSourceRepoRepository_sourcerepoRepositoryBasicExample(t *testing.T) {
	t.Parallel()

	context := map[string]interface{}{
		"random_suffix": acctest.RandString(10),
	}

	resource.Test(t, resource.TestCase{
		PreCheck:     func() { testAccPreCheck(t) },
		Providers:    testAccProviders,
		CheckDestroy: testAccCheckSourceRepoRepositoryDestroy,
		Steps: []resource.TestStep{
			{
				Config: testAccSourceRepoRepository_sourcerepoRepositoryBasicExample(context),
			},
			{
				ResourceName:      "google_sourcerepo_repository.my-repo",
				ImportState:       true,
				ImportStateVerify: true,
			},
		},
	})
}

func testAccSourceRepoRepository_sourcerepoRepositoryBasicExample(context map[string]interface{}) string {
	return Nprintf(`
resource "google_sourcerepo_repository" "my-repo" {
  name = "my/repository%{random_suffix}"
}
`, context)
}

func TestAccSourceRepoRepository_sourcerepoRepositoryFullExample(t *testing.T) {
	t.Parallel()

	context := map[string]interface{}{
		"random_suffix": acctest.RandString(10),
	}

	resource.Test(t, resource.TestCase{
		PreCheck:     func() { testAccPreCheck(t) },
		Providers:    testAccProviders,
		CheckDestroy: testAccCheckSourceRepoRepositoryDestroy,
		Steps: []resource.TestStep{
			{
				Config: testAccSourceRepoRepository_sourcerepoRepositoryFullExample(context),
			},
			{
				ResourceName:      "google_sourcerepo_repository.my-repo",
				ImportState:       true,
				ImportStateVerify: true,
			},
		},
	})
}

func testAccSourceRepoRepository_sourcerepoRepositoryFullExample(context map[string]interface{}) string {
	return Nprintf(`
resource "google_service_account" "test-account" {
  account_id   = "my-account%{random_suffix}"
  display_name = "Test Service Account"
}

resource "google_pubsub_topic" "topic" {
  name     = "my-topic%{random_suffix}"
}

resource "google_sourcerepo_repository" "my-repo" {
  name = "my-repository%{random_suffix}"
  pubsub_configs {
      topic = google_pubsub_topic.topic.id
      message_format = "JSON"
      service_account_email = google_service_account.test-account.email
  }
}
`, context)
}

func testAccCheckSourceRepoRepositoryDestroy(s *terraform.State) error {
	for name, rs := range s.RootModule().Resources {
		if rs.Type != "google_sourcerepo_repository" {
			continue
		}
		if strings.HasPrefix(name, "data.") {
			continue
		}

		config := testAccProvider.Meta().(*Config)

		url, err := replaceVarsForTest(config, rs, "{{SourceRepoBasePath}}projects/{{project}}/repos/{{name}}")
		if err != nil {
			return err
		}

		_, err = sendRequest(config, "GET", "", url, nil)
		if err == nil {
			return fmt.Errorf("SourceRepoRepository still exists at %s", url)
		}
	}

	return nil
}
