// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v1/services/keyword_plan_ad_group_service.proto

package services

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	resources "google.golang.org/genproto/googleapis/ads/googleads/v1/resources"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Request message for [KeywordPlanAdGroupService.GetKeywordPlanAdGroup][google.ads.googleads.v1.services.KeywordPlanAdGroupService.GetKeywordPlanAdGroup].
type GetKeywordPlanAdGroupRequest struct {
	// The resource name of the Keyword Plan ad group to fetch.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetKeywordPlanAdGroupRequest) Reset()         { *m = GetKeywordPlanAdGroupRequest{} }
func (m *GetKeywordPlanAdGroupRequest) String() string { return proto.CompactTextString(m) }
func (*GetKeywordPlanAdGroupRequest) ProtoMessage()    {}
func (*GetKeywordPlanAdGroupRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_ccc3a69fa60910db, []int{0}
}

func (m *GetKeywordPlanAdGroupRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetKeywordPlanAdGroupRequest.Unmarshal(m, b)
}
func (m *GetKeywordPlanAdGroupRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetKeywordPlanAdGroupRequest.Marshal(b, m, deterministic)
}
func (m *GetKeywordPlanAdGroupRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetKeywordPlanAdGroupRequest.Merge(m, src)
}
func (m *GetKeywordPlanAdGroupRequest) XXX_Size() int {
	return xxx_messageInfo_GetKeywordPlanAdGroupRequest.Size(m)
}
func (m *GetKeywordPlanAdGroupRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetKeywordPlanAdGroupRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetKeywordPlanAdGroupRequest proto.InternalMessageInfo

func (m *GetKeywordPlanAdGroupRequest) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

// Request message for [KeywordPlanAdGroupService.MutateKeywordPlanAdGroups][google.ads.googleads.v1.services.KeywordPlanAdGroupService.MutateKeywordPlanAdGroups].
type MutateKeywordPlanAdGroupsRequest struct {
	// The ID of the customer whose Keyword Plan ad groups are being modified.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// The list of operations to perform on individual Keyword Plan ad groups.
	Operations []*KeywordPlanAdGroupOperation `protobuf:"bytes,2,rep,name=operations,proto3" json:"operations,omitempty"`
	// If true, successful operations will be carried out and invalid
	// operations will return errors. If false, all operations will be carried
	// out in one transaction if and only if they are all valid.
	// Default is false.
	PartialFailure bool `protobuf:"varint,3,opt,name=partial_failure,json=partialFailure,proto3" json:"partial_failure,omitempty"`
	// If true, the request is validated but not executed. Only errors are
	// returned, not results.
	ValidateOnly         bool     `protobuf:"varint,4,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MutateKeywordPlanAdGroupsRequest) Reset()         { *m = MutateKeywordPlanAdGroupsRequest{} }
func (m *MutateKeywordPlanAdGroupsRequest) String() string { return proto.CompactTextString(m) }
func (*MutateKeywordPlanAdGroupsRequest) ProtoMessage()    {}
func (*MutateKeywordPlanAdGroupsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_ccc3a69fa60910db, []int{1}
}

func (m *MutateKeywordPlanAdGroupsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateKeywordPlanAdGroupsRequest.Unmarshal(m, b)
}
func (m *MutateKeywordPlanAdGroupsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateKeywordPlanAdGroupsRequest.Marshal(b, m, deterministic)
}
func (m *MutateKeywordPlanAdGroupsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateKeywordPlanAdGroupsRequest.Merge(m, src)
}
func (m *MutateKeywordPlanAdGroupsRequest) XXX_Size() int {
	return xxx_messageInfo_MutateKeywordPlanAdGroupsRequest.Size(m)
}
func (m *MutateKeywordPlanAdGroupsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateKeywordPlanAdGroupsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MutateKeywordPlanAdGroupsRequest proto.InternalMessageInfo

func (m *MutateKeywordPlanAdGroupsRequest) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

func (m *MutateKeywordPlanAdGroupsRequest) GetOperations() []*KeywordPlanAdGroupOperation {
	if m != nil {
		return m.Operations
	}
	return nil
}

func (m *MutateKeywordPlanAdGroupsRequest) GetPartialFailure() bool {
	if m != nil {
		return m.PartialFailure
	}
	return false
}

func (m *MutateKeywordPlanAdGroupsRequest) GetValidateOnly() bool {
	if m != nil {
		return m.ValidateOnly
	}
	return false
}

// A single operation (create, update, remove) on a Keyword Plan ad group.
type KeywordPlanAdGroupOperation struct {
	// The FieldMask that determines which resource fields are modified in an
	// update.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// The mutate operation.
	//
	// Types that are valid to be assigned to Operation:
	//	*KeywordPlanAdGroupOperation_Create
	//	*KeywordPlanAdGroupOperation_Update
	//	*KeywordPlanAdGroupOperation_Remove
	Operation            isKeywordPlanAdGroupOperation_Operation `protobuf_oneof:"operation"`
	XXX_NoUnkeyedLiteral struct{}                                `json:"-"`
	XXX_unrecognized     []byte                                  `json:"-"`
	XXX_sizecache        int32                                   `json:"-"`
}

func (m *KeywordPlanAdGroupOperation) Reset()         { *m = KeywordPlanAdGroupOperation{} }
func (m *KeywordPlanAdGroupOperation) String() string { return proto.CompactTextString(m) }
func (*KeywordPlanAdGroupOperation) ProtoMessage()    {}
func (*KeywordPlanAdGroupOperation) Descriptor() ([]byte, []int) {
	return fileDescriptor_ccc3a69fa60910db, []int{2}
}

func (m *KeywordPlanAdGroupOperation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_KeywordPlanAdGroupOperation.Unmarshal(m, b)
}
func (m *KeywordPlanAdGroupOperation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_KeywordPlanAdGroupOperation.Marshal(b, m, deterministic)
}
func (m *KeywordPlanAdGroupOperation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_KeywordPlanAdGroupOperation.Merge(m, src)
}
func (m *KeywordPlanAdGroupOperation) XXX_Size() int {
	return xxx_messageInfo_KeywordPlanAdGroupOperation.Size(m)
}
func (m *KeywordPlanAdGroupOperation) XXX_DiscardUnknown() {
	xxx_messageInfo_KeywordPlanAdGroupOperation.DiscardUnknown(m)
}

var xxx_messageInfo_KeywordPlanAdGroupOperation proto.InternalMessageInfo

func (m *KeywordPlanAdGroupOperation) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

type isKeywordPlanAdGroupOperation_Operation interface {
	isKeywordPlanAdGroupOperation_Operation()
}

type KeywordPlanAdGroupOperation_Create struct {
	Create *resources.KeywordPlanAdGroup `protobuf:"bytes,1,opt,name=create,proto3,oneof"`
}

type KeywordPlanAdGroupOperation_Update struct {
	Update *resources.KeywordPlanAdGroup `protobuf:"bytes,2,opt,name=update,proto3,oneof"`
}

type KeywordPlanAdGroupOperation_Remove struct {
	Remove string `protobuf:"bytes,3,opt,name=remove,proto3,oneof"`
}

func (*KeywordPlanAdGroupOperation_Create) isKeywordPlanAdGroupOperation_Operation() {}

func (*KeywordPlanAdGroupOperation_Update) isKeywordPlanAdGroupOperation_Operation() {}

func (*KeywordPlanAdGroupOperation_Remove) isKeywordPlanAdGroupOperation_Operation() {}

func (m *KeywordPlanAdGroupOperation) GetOperation() isKeywordPlanAdGroupOperation_Operation {
	if m != nil {
		return m.Operation
	}
	return nil
}

func (m *KeywordPlanAdGroupOperation) GetCreate() *resources.KeywordPlanAdGroup {
	if x, ok := m.GetOperation().(*KeywordPlanAdGroupOperation_Create); ok {
		return x.Create
	}
	return nil
}

func (m *KeywordPlanAdGroupOperation) GetUpdate() *resources.KeywordPlanAdGroup {
	if x, ok := m.GetOperation().(*KeywordPlanAdGroupOperation_Update); ok {
		return x.Update
	}
	return nil
}

func (m *KeywordPlanAdGroupOperation) GetRemove() string {
	if x, ok := m.GetOperation().(*KeywordPlanAdGroupOperation_Remove); ok {
		return x.Remove
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*KeywordPlanAdGroupOperation) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*KeywordPlanAdGroupOperation_Create)(nil),
		(*KeywordPlanAdGroupOperation_Update)(nil),
		(*KeywordPlanAdGroupOperation_Remove)(nil),
	}
}

// Response message for a Keyword Plan ad group mutate.
type MutateKeywordPlanAdGroupsResponse struct {
	// Errors that pertain to operation failures in the partial failure mode.
	// Returned only when partial_failure = true and all errors occur inside the
	// operations. If any errors occur outside the operations (e.g. auth errors),
	// we return an RPC level error.
	PartialFailureError *status.Status `protobuf:"bytes,3,opt,name=partial_failure_error,json=partialFailureError,proto3" json:"partial_failure_error,omitempty"`
	// All results for the mutate.
	Results              []*MutateKeywordPlanAdGroupResult `protobuf:"bytes,2,rep,name=results,proto3" json:"results,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                          `json:"-"`
	XXX_unrecognized     []byte                            `json:"-"`
	XXX_sizecache        int32                             `json:"-"`
}

func (m *MutateKeywordPlanAdGroupsResponse) Reset()         { *m = MutateKeywordPlanAdGroupsResponse{} }
func (m *MutateKeywordPlanAdGroupsResponse) String() string { return proto.CompactTextString(m) }
func (*MutateKeywordPlanAdGroupsResponse) ProtoMessage()    {}
func (*MutateKeywordPlanAdGroupsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_ccc3a69fa60910db, []int{3}
}

func (m *MutateKeywordPlanAdGroupsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateKeywordPlanAdGroupsResponse.Unmarshal(m, b)
}
func (m *MutateKeywordPlanAdGroupsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateKeywordPlanAdGroupsResponse.Marshal(b, m, deterministic)
}
func (m *MutateKeywordPlanAdGroupsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateKeywordPlanAdGroupsResponse.Merge(m, src)
}
func (m *MutateKeywordPlanAdGroupsResponse) XXX_Size() int {
	return xxx_messageInfo_MutateKeywordPlanAdGroupsResponse.Size(m)
}
func (m *MutateKeywordPlanAdGroupsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateKeywordPlanAdGroupsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_MutateKeywordPlanAdGroupsResponse proto.InternalMessageInfo

func (m *MutateKeywordPlanAdGroupsResponse) GetPartialFailureError() *status.Status {
	if m != nil {
		return m.PartialFailureError
	}
	return nil
}

func (m *MutateKeywordPlanAdGroupsResponse) GetResults() []*MutateKeywordPlanAdGroupResult {
	if m != nil {
		return m.Results
	}
	return nil
}

// The result for the Keyword Plan ad group mutate.
type MutateKeywordPlanAdGroupResult struct {
	// Returned for successful operations.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MutateKeywordPlanAdGroupResult) Reset()         { *m = MutateKeywordPlanAdGroupResult{} }
func (m *MutateKeywordPlanAdGroupResult) String() string { return proto.CompactTextString(m) }
func (*MutateKeywordPlanAdGroupResult) ProtoMessage()    {}
func (*MutateKeywordPlanAdGroupResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_ccc3a69fa60910db, []int{4}
}

func (m *MutateKeywordPlanAdGroupResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateKeywordPlanAdGroupResult.Unmarshal(m, b)
}
func (m *MutateKeywordPlanAdGroupResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateKeywordPlanAdGroupResult.Marshal(b, m, deterministic)
}
func (m *MutateKeywordPlanAdGroupResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateKeywordPlanAdGroupResult.Merge(m, src)
}
func (m *MutateKeywordPlanAdGroupResult) XXX_Size() int {
	return xxx_messageInfo_MutateKeywordPlanAdGroupResult.Size(m)
}
func (m *MutateKeywordPlanAdGroupResult) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateKeywordPlanAdGroupResult.DiscardUnknown(m)
}

var xxx_messageInfo_MutateKeywordPlanAdGroupResult proto.InternalMessageInfo

func (m *MutateKeywordPlanAdGroupResult) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func init() {
	proto.RegisterType((*GetKeywordPlanAdGroupRequest)(nil), "google.ads.googleads.v1.services.GetKeywordPlanAdGroupRequest")
	proto.RegisterType((*MutateKeywordPlanAdGroupsRequest)(nil), "google.ads.googleads.v1.services.MutateKeywordPlanAdGroupsRequest")
	proto.RegisterType((*KeywordPlanAdGroupOperation)(nil), "google.ads.googleads.v1.services.KeywordPlanAdGroupOperation")
	proto.RegisterType((*MutateKeywordPlanAdGroupsResponse)(nil), "google.ads.googleads.v1.services.MutateKeywordPlanAdGroupsResponse")
	proto.RegisterType((*MutateKeywordPlanAdGroupResult)(nil), "google.ads.googleads.v1.services.MutateKeywordPlanAdGroupResult")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v1/services/keyword_plan_ad_group_service.proto", fileDescriptor_ccc3a69fa60910db)
}

var fileDescriptor_ccc3a69fa60910db = []byte{
	// 742 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x95, 0xcd, 0x6a, 0xdb, 0x4a,
	0x14, 0xc7, 0xaf, 0xe4, 0x4b, 0xee, 0xcd, 0x38, 0xf7, 0x16, 0xa6, 0x84, 0x3a, 0x4e, 0x48, 0x5d,
	0x35, 0xd0, 0xe0, 0x85, 0x84, 0x5d, 0x42, 0x8b, 0x82, 0x4b, 0xed, 0x34, 0x71, 0x4a, 0x49, 0x13,
	0x14, 0xc8, 0x22, 0xb8, 0x88, 0x89, 0x34, 0x31, 0x22, 0x92, 0x46, 0x9d, 0x19, 0xb9, 0x84, 0x90,
	0x4d, 0xa1, 0x4f, 0xd0, 0x37, 0x68, 0x77, 0x7d, 0x91, 0x42, 0xa0, 0xab, 0xbe, 0x42, 0x37, 0xed,
	0xaa, 0x8b, 0x3e, 0x40, 0x19, 0x8d, 0xc6, 0xf9, 0x94, 0x5d, 0x92, 0xdd, 0xf1, 0xcc, 0x5f, 0xbf,
	0xf3, 0x39, 0xc7, 0xe0, 0x59, 0x9f, 0x90, 0x7e, 0x88, 0x2d, 0xe4, 0x33, 0x4b, 0x9a, 0xc2, 0x1a,
	0x34, 0x2c, 0x86, 0xe9, 0x20, 0xf0, 0x30, 0xb3, 0x0e, 0xf0, 0xe1, 0x1b, 0x42, 0x7d, 0x37, 0x09,
	0x51, 0xec, 0x22, 0xdf, 0xed, 0x53, 0x92, 0x26, 0x6e, 0x7e, 0x6d, 0x26, 0x94, 0x70, 0x02, 0x6b,
	0xf2, 0x53, 0x13, 0xf9, 0xcc, 0x1c, 0x52, 0xcc, 0x41, 0xc3, 0x54, 0x94, 0x6a, 0xab, 0xc8, 0x0f,
	0xc5, 0x8c, 0xa4, 0xb4, 0xd0, 0x91, 0x74, 0x50, 0x9d, 0x53, 0x9f, 0x27, 0x81, 0x85, 0xe2, 0x98,
	0x70, 0xc4, 0x03, 0x12, 0xb3, 0xfc, 0x36, 0x77, 0x6f, 0x65, 0xbf, 0xf6, 0xd2, 0x7d, 0x6b, 0x3f,
	0xc0, 0xa1, 0xef, 0x46, 0x88, 0x1d, 0xe4, 0x8a, 0x3b, 0xb9, 0x82, 0x26, 0x9e, 0xc5, 0x38, 0xe2,
	0x29, 0xbb, 0x70, 0x21, 0xc0, 0x5e, 0x18, 0xe0, 0x98, 0xcb, 0x0b, 0x63, 0x05, 0xcc, 0x75, 0x31,
	0x7f, 0x21, 0x63, 0xda, 0x0a, 0x51, 0xdc, 0xf6, 0xbb, 0x22, 0x20, 0x07, 0xbf, 0x4e, 0x31, 0xe3,
	0xf0, 0x3e, 0xf8, 0x4f, 0x85, 0xee, 0xc6, 0x28, 0xc2, 0x15, 0xad, 0xa6, 0x2d, 0x4e, 0x3a, 0x53,
	0xea, 0xf0, 0x25, 0x8a, 0xb0, 0xf1, 0x53, 0x03, 0xb5, 0x8d, 0x94, 0x23, 0x8e, 0x2f, 0x83, 0x98,
	0x22, 0xdd, 0x05, 0x65, 0x2f, 0x65, 0x9c, 0x44, 0x98, 0xba, 0x81, 0x9f, 0x73, 0x80, 0x3a, 0x7a,
	0xee, 0xc3, 0x57, 0x00, 0x90, 0x04, 0x53, 0x99, 0x72, 0x45, 0xaf, 0x95, 0x16, 0xcb, 0xcd, 0x96,
	0x39, 0xae, 0xe4, 0xe6, 0x65, 0x97, 0x9b, 0x8a, 0xe2, 0x9c, 0x01, 0xc2, 0x07, 0xe0, 0x56, 0x82,
	0x28, 0x0f, 0x50, 0xe8, 0xee, 0xa3, 0x20, 0x4c, 0x29, 0xae, 0x94, 0x6a, 0xda, 0xe2, 0xbf, 0xce,
	0xff, 0xf9, 0xf1, 0x9a, 0x3c, 0x15, 0x29, 0x0f, 0x50, 0x18, 0xf8, 0x88, 0x63, 0x97, 0xc4, 0xe1,
	0x61, 0xe5, 0xef, 0x4c, 0x36, 0xa5, 0x0e, 0x37, 0xe3, 0xf0, 0xd0, 0xf8, 0xa8, 0x83, 0xd9, 0x11,
	0x9e, 0xe1, 0x32, 0x28, 0xa7, 0x49, 0x86, 0x10, 0xed, 0xc9, 0x10, 0xe5, 0x66, 0x55, 0x65, 0xa3,
	0x3a, 0x68, 0xae, 0x89, 0x0e, 0x6e, 0x20, 0x76, 0xe0, 0x00, 0x29, 0x17, 0x36, 0xdc, 0x04, 0x13,
	0x1e, 0xc5, 0x88, 0xcb, 0x6a, 0x97, 0x9b, 0x4b, 0x85, 0x55, 0x18, 0x8e, 0xd5, 0x15, 0x65, 0x58,
	0xff, 0xcb, 0xc9, 0x31, 0x02, 0x28, 0xf1, 0x15, 0xfd, 0x86, 0x40, 0x89, 0x81, 0x15, 0x30, 0x41,
	0x71, 0x44, 0x06, 0xb2, 0x86, 0x93, 0xe2, 0x46, 0xfe, 0xee, 0x94, 0xc1, 0xe4, 0xb0, 0xe8, 0xc6,
	0x67, 0x0d, 0xdc, 0x1b, 0x31, 0x18, 0x2c, 0x21, 0x31, 0xc3, 0x70, 0x0d, 0x4c, 0x5f, 0xe8, 0x8c,
	0x8b, 0x29, 0x25, 0x34, 0x63, 0x97, 0x9b, 0x50, 0x05, 0x4b, 0x13, 0xcf, 0xdc, 0xce, 0xa6, 0xda,
	0xb9, 0x7d, 0xbe, 0x67, 0xab, 0x42, 0x0e, 0x77, 0xc1, 0x3f, 0x14, 0xb3, 0x34, 0xe4, 0x6a, 0x7a,
	0x9e, 0x8e, 0x9f, 0x9e, 0xa2, 0xe8, 0x9c, 0x0c, 0xe4, 0x28, 0xa0, 0xb1, 0x0a, 0xe6, 0x47, 0x4b,
	0xff, 0xe8, 0xa5, 0x34, 0x7f, 0x95, 0xc0, 0xcc, 0x65, 0xc2, 0xb6, 0x8c, 0x06, 0x7e, 0xd1, 0xc0,
	0xf4, 0x95, 0xaf, 0x11, 0x3e, 0x19, 0x9f, 0xc9, 0xa8, 0x67, 0x5c, 0xbd, 0x5e, 0xc3, 0x8d, 0xd6,
	0xdb, 0xaf, 0xdf, 0xde, 0xeb, 0x8f, 0xe0, 0x92, 0x58, 0x61, 0x47, 0xe7, 0xd2, 0x6b, 0xa9, 0x97,
	0xcb, 0xac, 0xba, 0xda, 0x69, 0x67, 0xbb, 0x6b, 0xd5, 0x8f, 0xe1, 0x77, 0x0d, 0xcc, 0x14, 0xb6,
	0x1f, 0x76, 0xae, 0xdf, 0x1d, 0xb5, 0x54, 0xaa, 0x2b, 0x37, 0x62, 0xc8, 0xf9, 0x33, 0x56, 0xb2,
	0x2c, 0x5b, 0xc6, 0x63, 0x91, 0xe5, 0x69, 0x5a, 0x47, 0x67, 0xd6, 0x55, 0xab, 0x7e, 0x7c, 0x55,
	0x92, 0x76, 0x94, 0xc1, 0x6d, 0xad, 0x5e, 0x9d, 0x3d, 0x69, 0x57, 0x4e, 0x03, 0xc8, 0xad, 0x24,
	0x60, 0xa6, 0x47, 0xa2, 0xce, 0x3b, 0x1d, 0x2c, 0x78, 0x24, 0x1a, 0x1b, 0x6c, 0x67, 0xbe, 0x70,
	0x38, 0xb6, 0xc4, 0xca, 0xd8, 0xd2, 0x76, 0xd7, 0x73, 0x46, 0x9f, 0x84, 0x28, 0xee, 0x9b, 0x84,
	0xf6, 0xad, 0x3e, 0x8e, 0xb3, 0x85, 0x62, 0x9d, 0x7a, 0x2d, 0xfe, 0xa3, 0x5b, 0x56, 0xc6, 0x07,
	0xbd, 0xd4, 0x6d, 0xb7, 0x3f, 0xe9, 0xb5, 0xae, 0x04, 0xb6, 0x7d, 0x66, 0x4a, 0x53, 0x58, 0x3b,
	0x0d, 0x33, 0x77, 0xcc, 0x4e, 0x94, 0xa4, 0xd7, 0xf6, 0x59, 0x6f, 0x28, 0xe9, 0xed, 0x34, 0x7a,
	0x4a, 0xf2, 0x43, 0x5f, 0x90, 0xe7, 0xb6, 0xdd, 0xf6, 0x99, 0x6d, 0x0f, 0x45, 0xb6, 0xbd, 0xd3,
	0xb0, 0x6d, 0x25, 0xdb, 0x9b, 0xc8, 0xe2, 0x7c, 0xf8, 0x3b, 0x00, 0x00, 0xff, 0xff, 0x5f, 0xdc,
	0xdd, 0xf8, 0x8f, 0x07, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// KeywordPlanAdGroupServiceClient is the client API for KeywordPlanAdGroupService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type KeywordPlanAdGroupServiceClient interface {
	// Returns the requested Keyword Plan ad group in full detail.
	GetKeywordPlanAdGroup(ctx context.Context, in *GetKeywordPlanAdGroupRequest, opts ...grpc.CallOption) (*resources.KeywordPlanAdGroup, error)
	// Creates, updates, or removes Keyword Plan ad groups. Operation statuses are
	// returned.
	MutateKeywordPlanAdGroups(ctx context.Context, in *MutateKeywordPlanAdGroupsRequest, opts ...grpc.CallOption) (*MutateKeywordPlanAdGroupsResponse, error)
}

type keywordPlanAdGroupServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewKeywordPlanAdGroupServiceClient(cc grpc.ClientConnInterface) KeywordPlanAdGroupServiceClient {
	return &keywordPlanAdGroupServiceClient{cc}
}

func (c *keywordPlanAdGroupServiceClient) GetKeywordPlanAdGroup(ctx context.Context, in *GetKeywordPlanAdGroupRequest, opts ...grpc.CallOption) (*resources.KeywordPlanAdGroup, error) {
	out := new(resources.KeywordPlanAdGroup)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v1.services.KeywordPlanAdGroupService/GetKeywordPlanAdGroup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keywordPlanAdGroupServiceClient) MutateKeywordPlanAdGroups(ctx context.Context, in *MutateKeywordPlanAdGroupsRequest, opts ...grpc.CallOption) (*MutateKeywordPlanAdGroupsResponse, error) {
	out := new(MutateKeywordPlanAdGroupsResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v1.services.KeywordPlanAdGroupService/MutateKeywordPlanAdGroups", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// KeywordPlanAdGroupServiceServer is the server API for KeywordPlanAdGroupService service.
type KeywordPlanAdGroupServiceServer interface {
	// Returns the requested Keyword Plan ad group in full detail.
	GetKeywordPlanAdGroup(context.Context, *GetKeywordPlanAdGroupRequest) (*resources.KeywordPlanAdGroup, error)
	// Creates, updates, or removes Keyword Plan ad groups. Operation statuses are
	// returned.
	MutateKeywordPlanAdGroups(context.Context, *MutateKeywordPlanAdGroupsRequest) (*MutateKeywordPlanAdGroupsResponse, error)
}

// UnimplementedKeywordPlanAdGroupServiceServer can be embedded to have forward compatible implementations.
type UnimplementedKeywordPlanAdGroupServiceServer struct {
}

func (*UnimplementedKeywordPlanAdGroupServiceServer) GetKeywordPlanAdGroup(ctx context.Context, req *GetKeywordPlanAdGroupRequest) (*resources.KeywordPlanAdGroup, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetKeywordPlanAdGroup not implemented")
}
func (*UnimplementedKeywordPlanAdGroupServiceServer) MutateKeywordPlanAdGroups(ctx context.Context, req *MutateKeywordPlanAdGroupsRequest) (*MutateKeywordPlanAdGroupsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method MutateKeywordPlanAdGroups not implemented")
}

func RegisterKeywordPlanAdGroupServiceServer(s *grpc.Server, srv KeywordPlanAdGroupServiceServer) {
	s.RegisterService(&_KeywordPlanAdGroupService_serviceDesc, srv)
}

func _KeywordPlanAdGroupService_GetKeywordPlanAdGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetKeywordPlanAdGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeywordPlanAdGroupServiceServer).GetKeywordPlanAdGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v1.services.KeywordPlanAdGroupService/GetKeywordPlanAdGroup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeywordPlanAdGroupServiceServer).GetKeywordPlanAdGroup(ctx, req.(*GetKeywordPlanAdGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeywordPlanAdGroupService_MutateKeywordPlanAdGroups_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MutateKeywordPlanAdGroupsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeywordPlanAdGroupServiceServer).MutateKeywordPlanAdGroups(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v1.services.KeywordPlanAdGroupService/MutateKeywordPlanAdGroups",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeywordPlanAdGroupServiceServer).MutateKeywordPlanAdGroups(ctx, req.(*MutateKeywordPlanAdGroupsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _KeywordPlanAdGroupService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.ads.googleads.v1.services.KeywordPlanAdGroupService",
	HandlerType: (*KeywordPlanAdGroupServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetKeywordPlanAdGroup",
			Handler:    _KeywordPlanAdGroupService_GetKeywordPlanAdGroup_Handler,
		},
		{
			MethodName: "MutateKeywordPlanAdGroups",
			Handler:    _KeywordPlanAdGroupService_MutateKeywordPlanAdGroups_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/ads/googleads/v1/services/keyword_plan_ad_group_service.proto",
}
