// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v3/resources/billing_setup.proto

package resources

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	enums "google.golang.org/genproto/googleapis/ads/googleads/v3/enums"
	_ "google.golang.org/genproto/googleapis/api/annotations"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// A billing setup, which associates a payments account and an advertiser. A
// billing setup is specific to one advertiser.
type BillingSetup struct {
	// The resource name of the billing setup.
	// BillingSetup resource names have the form:
	//
	// `customers/{customer_id}/billingSetups/{billing_setup_id}`
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// The ID of the billing setup.
	Id *wrappers.Int64Value `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	// The status of the billing setup.
	Status enums.BillingSetupStatusEnum_BillingSetupStatus `protobuf:"varint,3,opt,name=status,proto3,enum=google.ads.googleads.v3.enums.BillingSetupStatusEnum_BillingSetupStatus" json:"status,omitempty"`
	// The resource name of the payments account associated with this billing
	// setup. Payments resource names have the form:
	//
	// `customers/{customer_id}/paymentsAccounts/{payments_account_id}`
	// When setting up billing, this is used to signup with an existing payments
	// account (and then payments_account_info should not be set).
	// When getting a billing setup, this and payments_account_info will be
	// populated.
	PaymentsAccount *wrappers.StringValue `protobuf:"bytes,11,opt,name=payments_account,json=paymentsAccount,proto3" json:"payments_account,omitempty"`
	// The payments account information associated with this billing setup.
	// When setting up billing, this is used to signup with a new payments account
	// (and then payments_account should not be set).
	// When getting a billing setup, this and payments_account will be
	// populated.
	PaymentsAccountInfo *BillingSetup_PaymentsAccountInfo `protobuf:"bytes,12,opt,name=payments_account_info,json=paymentsAccountInfo,proto3" json:"payments_account_info,omitempty"`
	// When creating a new billing setup, this is when the setup should take
	// effect. NOW is the only acceptable start time if the customer doesn't have
	// any approved setups.
	//
	// When fetching an existing billing setup, this is the requested start time.
	// However, if the setup was approved (see status) after the requested start
	// time, then this is the approval time.
	//
	// Types that are valid to be assigned to StartTime:
	//	*BillingSetup_StartDateTime
	//	*BillingSetup_StartTimeType
	StartTime isBillingSetup_StartTime `protobuf_oneof:"start_time"`
	// When the billing setup ends / ended. This is either FOREVER or the start
	// time of the next scheduled billing setup.
	//
	// Types that are valid to be assigned to EndTime:
	//	*BillingSetup_EndDateTime
	//	*BillingSetup_EndTimeType
	EndTime              isBillingSetup_EndTime `protobuf_oneof:"end_time"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *BillingSetup) Reset()         { *m = BillingSetup{} }
func (m *BillingSetup) String() string { return proto.CompactTextString(m) }
func (*BillingSetup) ProtoMessage()    {}
func (*BillingSetup) Descriptor() ([]byte, []int) {
	return fileDescriptor_979051338dc39b64, []int{0}
}

func (m *BillingSetup) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BillingSetup.Unmarshal(m, b)
}
func (m *BillingSetup) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BillingSetup.Marshal(b, m, deterministic)
}
func (m *BillingSetup) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BillingSetup.Merge(m, src)
}
func (m *BillingSetup) XXX_Size() int {
	return xxx_messageInfo_BillingSetup.Size(m)
}
func (m *BillingSetup) XXX_DiscardUnknown() {
	xxx_messageInfo_BillingSetup.DiscardUnknown(m)
}

var xxx_messageInfo_BillingSetup proto.InternalMessageInfo

func (m *BillingSetup) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func (m *BillingSetup) GetId() *wrappers.Int64Value {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *BillingSetup) GetStatus() enums.BillingSetupStatusEnum_BillingSetupStatus {
	if m != nil {
		return m.Status
	}
	return enums.BillingSetupStatusEnum_UNSPECIFIED
}

func (m *BillingSetup) GetPaymentsAccount() *wrappers.StringValue {
	if m != nil {
		return m.PaymentsAccount
	}
	return nil
}

func (m *BillingSetup) GetPaymentsAccountInfo() *BillingSetup_PaymentsAccountInfo {
	if m != nil {
		return m.PaymentsAccountInfo
	}
	return nil
}

type isBillingSetup_StartTime interface {
	isBillingSetup_StartTime()
}

type BillingSetup_StartDateTime struct {
	StartDateTime *wrappers.StringValue `protobuf:"bytes,9,opt,name=start_date_time,json=startDateTime,proto3,oneof"`
}

type BillingSetup_StartTimeType struct {
	StartTimeType enums.TimeTypeEnum_TimeType `protobuf:"varint,10,opt,name=start_time_type,json=startTimeType,proto3,enum=google.ads.googleads.v3.enums.TimeTypeEnum_TimeType,oneof"`
}

func (*BillingSetup_StartDateTime) isBillingSetup_StartTime() {}

func (*BillingSetup_StartTimeType) isBillingSetup_StartTime() {}

func (m *BillingSetup) GetStartTime() isBillingSetup_StartTime {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *BillingSetup) GetStartDateTime() *wrappers.StringValue {
	if x, ok := m.GetStartTime().(*BillingSetup_StartDateTime); ok {
		return x.StartDateTime
	}
	return nil
}

func (m *BillingSetup) GetStartTimeType() enums.TimeTypeEnum_TimeType {
	if x, ok := m.GetStartTime().(*BillingSetup_StartTimeType); ok {
		return x.StartTimeType
	}
	return enums.TimeTypeEnum_UNSPECIFIED
}

type isBillingSetup_EndTime interface {
	isBillingSetup_EndTime()
}

type BillingSetup_EndDateTime struct {
	EndDateTime *wrappers.StringValue `protobuf:"bytes,13,opt,name=end_date_time,json=endDateTime,proto3,oneof"`
}

type BillingSetup_EndTimeType struct {
	EndTimeType enums.TimeTypeEnum_TimeType `protobuf:"varint,14,opt,name=end_time_type,json=endTimeType,proto3,enum=google.ads.googleads.v3.enums.TimeTypeEnum_TimeType,oneof"`
}

func (*BillingSetup_EndDateTime) isBillingSetup_EndTime() {}

func (*BillingSetup_EndTimeType) isBillingSetup_EndTime() {}

func (m *BillingSetup) GetEndTime() isBillingSetup_EndTime {
	if m != nil {
		return m.EndTime
	}
	return nil
}

func (m *BillingSetup) GetEndDateTime() *wrappers.StringValue {
	if x, ok := m.GetEndTime().(*BillingSetup_EndDateTime); ok {
		return x.EndDateTime
	}
	return nil
}

func (m *BillingSetup) GetEndTimeType() enums.TimeTypeEnum_TimeType {
	if x, ok := m.GetEndTime().(*BillingSetup_EndTimeType); ok {
		return x.EndTimeType
	}
	return enums.TimeTypeEnum_UNSPECIFIED
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*BillingSetup) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*BillingSetup_StartDateTime)(nil),
		(*BillingSetup_StartTimeType)(nil),
		(*BillingSetup_EndDateTime)(nil),
		(*BillingSetup_EndTimeType)(nil),
	}
}

// Container of payments account information for this billing.
type BillingSetup_PaymentsAccountInfo struct {
	// A 16 digit id used to identify the payments account associated with the
	// billing setup.
	//
	// This must be passed as a string with dashes, e.g. "1234-5678-9012-3456".
	PaymentsAccountId *wrappers.StringValue `protobuf:"bytes,1,opt,name=payments_account_id,json=paymentsAccountId,proto3" json:"payments_account_id,omitempty"`
	// The name of the payments account associated with the billing setup.
	//
	// This enables the user to specify a meaningful name for a payments account
	// to aid in reconciling monthly invoices.
	//
	// This name will be printed in the monthly invoices.
	PaymentsAccountName *wrappers.StringValue `protobuf:"bytes,2,opt,name=payments_account_name,json=paymentsAccountName,proto3" json:"payments_account_name,omitempty"`
	// A 12 digit id used to identify the payments profile associated with the
	// billing setup.
	//
	// This must be passed in as a string with dashes, e.g. "1234-5678-9012".
	PaymentsProfileId *wrappers.StringValue `protobuf:"bytes,3,opt,name=payments_profile_id,json=paymentsProfileId,proto3" json:"payments_profile_id,omitempty"`
	// The name of the payments profile associated with the billing setup.
	PaymentsProfileName *wrappers.StringValue `protobuf:"bytes,4,opt,name=payments_profile_name,json=paymentsProfileName,proto3" json:"payments_profile_name,omitempty"`
	// A secondary payments profile id present in uncommon situations, e.g.
	// when a sequential liability agreement has been arranged.
	SecondaryPaymentsProfileId *wrappers.StringValue `protobuf:"bytes,5,opt,name=secondary_payments_profile_id,json=secondaryPaymentsProfileId,proto3" json:"secondary_payments_profile_id,omitempty"`
	XXX_NoUnkeyedLiteral       struct{}              `json:"-"`
	XXX_unrecognized           []byte                `json:"-"`
	XXX_sizecache              int32                 `json:"-"`
}

func (m *BillingSetup_PaymentsAccountInfo) Reset()         { *m = BillingSetup_PaymentsAccountInfo{} }
func (m *BillingSetup_PaymentsAccountInfo) String() string { return proto.CompactTextString(m) }
func (*BillingSetup_PaymentsAccountInfo) ProtoMessage()    {}
func (*BillingSetup_PaymentsAccountInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_979051338dc39b64, []int{0, 0}
}

func (m *BillingSetup_PaymentsAccountInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BillingSetup_PaymentsAccountInfo.Unmarshal(m, b)
}
func (m *BillingSetup_PaymentsAccountInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BillingSetup_PaymentsAccountInfo.Marshal(b, m, deterministic)
}
func (m *BillingSetup_PaymentsAccountInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BillingSetup_PaymentsAccountInfo.Merge(m, src)
}
func (m *BillingSetup_PaymentsAccountInfo) XXX_Size() int {
	return xxx_messageInfo_BillingSetup_PaymentsAccountInfo.Size(m)
}
func (m *BillingSetup_PaymentsAccountInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_BillingSetup_PaymentsAccountInfo.DiscardUnknown(m)
}

var xxx_messageInfo_BillingSetup_PaymentsAccountInfo proto.InternalMessageInfo

func (m *BillingSetup_PaymentsAccountInfo) GetPaymentsAccountId() *wrappers.StringValue {
	if m != nil {
		return m.PaymentsAccountId
	}
	return nil
}

func (m *BillingSetup_PaymentsAccountInfo) GetPaymentsAccountName() *wrappers.StringValue {
	if m != nil {
		return m.PaymentsAccountName
	}
	return nil
}

func (m *BillingSetup_PaymentsAccountInfo) GetPaymentsProfileId() *wrappers.StringValue {
	if m != nil {
		return m.PaymentsProfileId
	}
	return nil
}

func (m *BillingSetup_PaymentsAccountInfo) GetPaymentsProfileName() *wrappers.StringValue {
	if m != nil {
		return m.PaymentsProfileName
	}
	return nil
}

func (m *BillingSetup_PaymentsAccountInfo) GetSecondaryPaymentsProfileId() *wrappers.StringValue {
	if m != nil {
		return m.SecondaryPaymentsProfileId
	}
	return nil
}

func init() {
	proto.RegisterType((*BillingSetup)(nil), "google.ads.googleads.v3.resources.BillingSetup")
	proto.RegisterType((*BillingSetup_PaymentsAccountInfo)(nil), "google.ads.googleads.v3.resources.BillingSetup.PaymentsAccountInfo")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v3/resources/billing_setup.proto", fileDescriptor_979051338dc39b64)
}

var fileDescriptor_979051338dc39b64 = []byte{
	// 681 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x95, 0xed, 0x4e, 0xdb, 0x3a,
	0x18, 0xc7, 0x4f, 0xd2, 0x73, 0xd0, 0xc1, 0xb4, 0x70, 0x08, 0x3a, 0x52, 0xd6, 0xb1, 0x09, 0x36,
	0x21, 0x21, 0x4d, 0x73, 0x24, 0xca, 0xa6, 0x29, 0xfb, 0x94, 0xee, 0x05, 0x98, 0xa6, 0xa9, 0x0a,
	0xa8, 0x1f, 0x58, 0x45, 0x66, 0x62, 0x37, 0x8a, 0xd4, 0xd8, 0x51, 0xec, 0x80, 0x2a, 0xc4, 0xcd,
	0xec, 0xe3, 0x2e, 0x60, 0x17, 0xb1, 0x4b, 0xe1, 0x22, 0xb6, 0x29, 0x76, 0x9c, 0xbe, 0x50, 0x28,
	0x68, 0xdf, 0x9e, 0xd8, 0xcf, 0xff, 0xdf, 0xdf, 0xf3, 0xf8, 0xb1, 0x0b, 0x5e, 0x44, 0x8c, 0x45,
	0x03, 0xe2, 0x20, 0xcc, 0x1d, 0x15, 0x16, 0xd1, 0x59, 0xcb, 0xc9, 0x08, 0x67, 0x79, 0x16, 0x12,
	0xee, 0x9c, 0xc6, 0x83, 0x41, 0x4c, 0xa3, 0x80, 0x13, 0x91, 0xa7, 0x30, 0xcd, 0x98, 0x60, 0xd6,
	0xa6, 0xca, 0x85, 0x08, 0x73, 0x58, 0xc9, 0xe0, 0x59, 0x0b, 0x56, 0xb2, 0xe6, 0xab, 0x9b, 0x9c,
	0x09, 0xcd, 0x93, 0x29, 0xd7, 0x80, 0x0b, 0x24, 0x72, 0xae, 0xcc, 0x9b, 0xcf, 0x6f, 0x57, 0x8a,
	0x38, 0x21, 0x81, 0x18, 0xa6, 0xa4, 0x4c, 0x7f, 0xa0, 0xd3, 0xd3, 0xb8, 0xa2, 0x2e, 0xb7, 0x1e,
	0x97, 0x5b, 0xf2, 0xeb, 0x34, 0xef, 0x3b, 0xe7, 0x19, 0x4a, 0x53, 0x92, 0xe9, 0x5f, 0x5a, 0x1f,
	0x93, 0x22, 0x4a, 0x99, 0x40, 0x22, 0x66, 0xb4, 0xdc, 0x7d, 0xf2, 0x6b, 0x11, 0xd4, 0xdb, 0x0a,
	0xf3, 0xb0, 0xa0, 0xb4, 0x9e, 0x82, 0x86, 0xfe, 0x81, 0x80, 0xa2, 0x84, 0xd8, 0xc6, 0x86, 0xb1,
	0xbd, 0xe8, 0xd7, 0xf5, 0xe2, 0x27, 0x94, 0x10, 0xeb, 0x19, 0x30, 0x63, 0x6c, 0x9b, 0x1b, 0xc6,
	0xf6, 0xd2, 0xce, 0xc3, 0xb2, 0x39, 0x50, 0x03, 0xc0, 0x03, 0x2a, 0x5e, 0xee, 0x76, 0xd1, 0x20,
	0x27, 0xbe, 0x19, 0x63, 0xeb, 0x0b, 0x58, 0x50, 0xa5, 0xdb, 0xb5, 0x0d, 0x63, 0x7b, 0x79, 0x67,
	0x1f, 0xde, 0xd4, 0x58, 0x59, 0x3b, 0x1c, 0xc7, 0x39, 0x94, 0xc2, 0x77, 0x34, 0x4f, 0x66, 0x2c,
	0xfb, 0xa5, 0xaf, 0xb5, 0x07, 0xfe, 0x4b, 0xd1, 0x30, 0x21, 0x54, 0xf0, 0x00, 0x85, 0x21, 0xcb,
	0xa9, 0xb0, 0x97, 0x24, 0xdc, 0xfa, 0x35, 0xb8, 0x43, 0x91, 0xc5, 0x34, 0x52, 0x74, 0x2b, 0x5a,
	0xe5, 0x29, 0x91, 0x75, 0x0e, 0xfe, 0x9f, 0x36, 0x0a, 0x62, 0xda, 0x67, 0x76, 0x5d, 0xba, 0xbd,
	0x81, 0x73, 0x47, 0x62, 0x02, 0x13, 0x76, 0x26, 0xfd, 0x0f, 0x68, 0x9f, 0xf9, 0x6b, 0xe9, 0xf5,
	0x45, 0xeb, 0x3d, 0x58, 0xe1, 0x02, 0x65, 0x22, 0xc0, 0x48, 0x90, 0xa0, 0x38, 0x7d, 0x7b, 0x71,
	0x7e, 0x01, 0xfb, 0x7f, 0xf9, 0x0d, 0x29, 0x7b, 0x8b, 0x04, 0x39, 0x8a, 0x13, 0x62, 0x9d, 0x68,
	0x9f, 0x6a, 0x80, 0x6c, 0x20, 0x9b, 0xbe, 0x3b, 0xa7, 0xe9, 0x85, 0xfa, 0x68, 0x98, 0x12, 0xd9,
	0x6a, 0xfd, 0x51, 0xf9, 0xeb, 0x05, 0xab, 0x0d, 0x1a, 0x84, 0xe2, 0x31, 0xca, 0xc6, 0x1d, 0x28,
	0x0d, 0x7f, 0x89, 0x50, 0x5c, 0x31, 0x1e, 0x2b, 0x8f, 0x11, 0xe1, 0xf2, 0x1f, 0x10, 0x2a, 0x6f,
	0xfd, 0xd9, 0xfc, 0x5e, 0x03, 0x6b, 0x33, 0x9a, 0x6e, 0x7d, 0x04, 0x6b, 0xd7, 0x0f, 0x16, 0xcb,
	0xd9, 0x9e, 0x37, 0x24, 0xab, 0xd3, 0xe7, 0x85, 0xad, 0xce, 0x8c, 0x31, 0x91, 0x77, 0xc5, 0xbc,
	0x83, 0xdf, 0xf4, 0xf9, 0xcb, 0x0b, 0x35, 0xce, 0x97, 0x66, 0xac, 0x1f, 0x0f, 0x48, 0xc1, 0x57,
	0xbb, 0x0f, 0x5f, 0x47, 0xe9, 0xa6, 0xf8, 0xb4, 0x9b, 0xe4, 0xfb, 0xfb, 0x3e, 0x7c, 0xa5, 0x9f,
	0xe4, 0x0b, 0xc0, 0x23, 0x4e, 0x42, 0x46, 0x31, 0xca, 0x86, 0xc1, 0x2c, 0xd2, 0x7f, 0xee, 0xe0,
	0xdc, 0xac, 0x2c, 0x3a, 0xd3, 0xc8, 0xee, 0xc9, 0x95, 0xf7, 0x19, 0x6c, 0x8d, 0x8e, 0xbd, 0x8c,
	0xd2, 0x98, 0xc3, 0x90, 0x25, 0xce, 0xc4, 0x13, 0xb5, 0x13, 0xe6, 0x5c, 0xb0, 0x84, 0x64, 0xdc,
	0xb9, 0xd0, 0xe1, 0xa5, 0x7e, 0x6c, 0x65, 0x0a, 0x77, 0x2e, 0x26, 0xde, 0xde, 0xcb, 0x76, 0x1d,
	0x80, 0xd1, 0xc5, 0x68, 0x03, 0xf0, 0xaf, 0x1e, 0xc1, 0xf6, 0x4f, 0x03, 0x6c, 0x85, 0x2c, 0x99,
	0x7f, 0xb5, 0xdb, 0xab, 0xe3, 0x14, 0x9d, 0xa2, 0xc2, 0x8e, 0x71, 0xfc, 0xa1, 0xd4, 0x45, 0x6c,
	0x80, 0x68, 0x04, 0x59, 0x16, 0x39, 0x11, 0xa1, 0xb2, 0x7e, 0x67, 0x54, 0xc4, 0x2d, 0xff, 0x3d,
	0xaf, 0xab, 0xe8, 0xab, 0x59, 0xdb, 0xf3, 0xbc, 0x6f, 0xe6, 0xe6, 0x9e, 0xb2, 0xf4, 0x30, 0x87,
	0x2a, 0x2c, 0xa2, 0x6e, 0x0b, 0xfa, 0x3a, 0xf3, 0x87, 0xce, 0xe9, 0x79, 0x98, 0xf7, 0xaa, 0x9c,
	0x5e, 0xb7, 0xd5, 0xab, 0x72, 0xae, 0xcc, 0x2d, 0xb5, 0xe1, 0xba, 0x1e, 0xe6, 0xae, 0x5b, 0x65,
	0xb9, 0x6e, 0xb7, 0xe5, 0xba, 0x55, 0xde, 0xe9, 0x82, 0x84, 0x6d, 0xfd, 0x0e, 0x00, 0x00, 0xff,
	0xff, 0xfa, 0xda, 0xc8, 0xb5, 0x27, 0x07, 0x00, 0x00,
}
