// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v3/resources/campaign_budget.proto

package resources

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	enums "google.golang.org/genproto/googleapis/ads/googleads/v3/enums"
	_ "google.golang.org/genproto/googleapis/api/annotations"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// A campaign budget.
type CampaignBudget struct {
	// The resource name of the campaign budget.
	// Campaign budget resource names have the form:
	//
	// `customers/{customer_id}/campaignBudgets/{budget_id}`
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// The ID of the campaign budget.
	//
	// A campaign budget is created using the CampaignBudgetService create
	// operation and is assigned a budget ID. A budget ID can be shared across
	// different campaigns; the system will then allocate the campaign budget
	// among different campaigns to get optimum results.
	Id *wrappers.Int64Value `protobuf:"bytes,3,opt,name=id,proto3" json:"id,omitempty"`
	// The name of the campaign budget.
	//
	// When creating a campaign budget through CampaignBudgetService, every
	// explicitly shared campaign budget must have a non-null, non-empty name.
	// Campaign budgets that are not explicitly shared derive their name from the
	// attached campaign's name.
	//
	// The length of this string must be between 1 and 255, inclusive,
	// in UTF-8 bytes, (trimmed).
	Name *wrappers.StringValue `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	// The amount of the budget, in the local currency for the account.
	// Amount is specified in micros, where one million is equivalent to one
	// currency unit. Monthly spend is capped at 30.4 times this amount.
	AmountMicros *wrappers.Int64Value `protobuf:"bytes,5,opt,name=amount_micros,json=amountMicros,proto3" json:"amount_micros,omitempty"`
	// The lifetime amount of the budget, in the local currency for the account.
	// Amount is specified in micros, where one million is equivalent to one
	// currency unit.
	TotalAmountMicros *wrappers.Int64Value `protobuf:"bytes,10,opt,name=total_amount_micros,json=totalAmountMicros,proto3" json:"total_amount_micros,omitempty"`
	// The status of this campaign budget. This field is read-only.
	Status enums.BudgetStatusEnum_BudgetStatus `protobuf:"varint,6,opt,name=status,proto3,enum=google.ads.googleads.v3.enums.BudgetStatusEnum_BudgetStatus" json:"status,omitempty"`
	// The delivery method that determines the rate at which the campaign budget
	// is spent.
	//
	// Defaults to STANDARD if unspecified in a create operation.
	DeliveryMethod enums.BudgetDeliveryMethodEnum_BudgetDeliveryMethod `protobuf:"varint,7,opt,name=delivery_method,json=deliveryMethod,proto3,enum=google.ads.googleads.v3.enums.BudgetDeliveryMethodEnum_BudgetDeliveryMethod" json:"delivery_method,omitempty"`
	// Specifies whether the budget is explicitly shared. Defaults to true if
	// unspecified in a create operation.
	//
	// If true, the budget was created with the purpose of sharing
	// across one or more campaigns.
	//
	// If false, the budget was created with the intention of only being used
	// with a single campaign. The budget's name and status will stay in sync
	// with the campaign's name and status. Attempting to share the budget with a
	// second campaign will result in an error.
	//
	// A non-shared budget can become an explicitly shared. The same operation
	// must also assign the budget a name.
	//
	// A shared campaign budget can never become non-shared.
	ExplicitlyShared *wrappers.BoolValue `protobuf:"bytes,8,opt,name=explicitly_shared,json=explicitlyShared,proto3" json:"explicitly_shared,omitempty"`
	// The number of campaigns actively using the budget.
	//
	// This field is read-only.
	ReferenceCount *wrappers.Int64Value `protobuf:"bytes,9,opt,name=reference_count,json=referenceCount,proto3" json:"reference_count,omitempty"`
	// Indicates whether there is a recommended budget for this campaign budget.
	//
	// This field is read-only.
	HasRecommendedBudget *wrappers.BoolValue `protobuf:"bytes,11,opt,name=has_recommended_budget,json=hasRecommendedBudget,proto3" json:"has_recommended_budget,omitempty"`
	// The recommended budget amount. If no recommendation is available, this will
	// be set to the budget amount.
	// Amount is specified in micros, where one million is equivalent to one
	// currency unit.
	//
	// This field is read-only.
	RecommendedBudgetAmountMicros *wrappers.Int64Value `protobuf:"bytes,12,opt,name=recommended_budget_amount_micros,json=recommendedBudgetAmountMicros,proto3" json:"recommended_budget_amount_micros,omitempty"`
	// Period over which to spend the budget. Defaults to DAILY if not specified.
	Period enums.BudgetPeriodEnum_BudgetPeriod `protobuf:"varint,13,opt,name=period,proto3,enum=google.ads.googleads.v3.enums.BudgetPeriodEnum_BudgetPeriod" json:"period,omitempty"`
	// The estimated change in weekly clicks if the recommended budget is applied.
	//
	// This field is read-only.
	RecommendedBudgetEstimatedChangeWeeklyClicks *wrappers.Int64Value `protobuf:"bytes,14,opt,name=recommended_budget_estimated_change_weekly_clicks,json=recommendedBudgetEstimatedChangeWeeklyClicks,proto3" json:"recommended_budget_estimated_change_weekly_clicks,omitempty"`
	// The estimated change in weekly cost in micros if the recommended budget is
	// applied. One million is equivalent to one currency unit.
	//
	// This field is read-only.
	RecommendedBudgetEstimatedChangeWeeklyCostMicros *wrappers.Int64Value `protobuf:"bytes,15,opt,name=recommended_budget_estimated_change_weekly_cost_micros,json=recommendedBudgetEstimatedChangeWeeklyCostMicros,proto3" json:"recommended_budget_estimated_change_weekly_cost_micros,omitempty"`
	// The estimated change in weekly interactions if the recommended budget is
	// applied.
	//
	// This field is read-only.
	RecommendedBudgetEstimatedChangeWeeklyInteractions *wrappers.Int64Value `protobuf:"bytes,16,opt,name=recommended_budget_estimated_change_weekly_interactions,json=recommendedBudgetEstimatedChangeWeeklyInteractions,proto3" json:"recommended_budget_estimated_change_weekly_interactions,omitempty"`
	// The estimated change in weekly views if the recommended budget is applied.
	//
	// This field is read-only.
	RecommendedBudgetEstimatedChangeWeeklyViews *wrappers.Int64Value `protobuf:"bytes,17,opt,name=recommended_budget_estimated_change_weekly_views,json=recommendedBudgetEstimatedChangeWeeklyViews,proto3" json:"recommended_budget_estimated_change_weekly_views,omitempty"`
	// The type of the campaign budget.
	Type                 enums.BudgetTypeEnum_BudgetType `protobuf:"varint,18,opt,name=type,proto3,enum=google.ads.googleads.v3.enums.BudgetTypeEnum_BudgetType" json:"type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                        `json:"-"`
	XXX_unrecognized     []byte                          `json:"-"`
	XXX_sizecache        int32                           `json:"-"`
}

func (m *CampaignBudget) Reset()         { *m = CampaignBudget{} }
func (m *CampaignBudget) String() string { return proto.CompactTextString(m) }
func (*CampaignBudget) ProtoMessage()    {}
func (*CampaignBudget) Descriptor() ([]byte, []int) {
	return fileDescriptor_3160509214176301, []int{0}
}

func (m *CampaignBudget) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CampaignBudget.Unmarshal(m, b)
}
func (m *CampaignBudget) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CampaignBudget.Marshal(b, m, deterministic)
}
func (m *CampaignBudget) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CampaignBudget.Merge(m, src)
}
func (m *CampaignBudget) XXX_Size() int {
	return xxx_messageInfo_CampaignBudget.Size(m)
}
func (m *CampaignBudget) XXX_DiscardUnknown() {
	xxx_messageInfo_CampaignBudget.DiscardUnknown(m)
}

var xxx_messageInfo_CampaignBudget proto.InternalMessageInfo

func (m *CampaignBudget) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func (m *CampaignBudget) GetId() *wrappers.Int64Value {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *CampaignBudget) GetName() *wrappers.StringValue {
	if m != nil {
		return m.Name
	}
	return nil
}

func (m *CampaignBudget) GetAmountMicros() *wrappers.Int64Value {
	if m != nil {
		return m.AmountMicros
	}
	return nil
}

func (m *CampaignBudget) GetTotalAmountMicros() *wrappers.Int64Value {
	if m != nil {
		return m.TotalAmountMicros
	}
	return nil
}

func (m *CampaignBudget) GetStatus() enums.BudgetStatusEnum_BudgetStatus {
	if m != nil {
		return m.Status
	}
	return enums.BudgetStatusEnum_UNSPECIFIED
}

func (m *CampaignBudget) GetDeliveryMethod() enums.BudgetDeliveryMethodEnum_BudgetDeliveryMethod {
	if m != nil {
		return m.DeliveryMethod
	}
	return enums.BudgetDeliveryMethodEnum_UNSPECIFIED
}

func (m *CampaignBudget) GetExplicitlyShared() *wrappers.BoolValue {
	if m != nil {
		return m.ExplicitlyShared
	}
	return nil
}

func (m *CampaignBudget) GetReferenceCount() *wrappers.Int64Value {
	if m != nil {
		return m.ReferenceCount
	}
	return nil
}

func (m *CampaignBudget) GetHasRecommendedBudget() *wrappers.BoolValue {
	if m != nil {
		return m.HasRecommendedBudget
	}
	return nil
}

func (m *CampaignBudget) GetRecommendedBudgetAmountMicros() *wrappers.Int64Value {
	if m != nil {
		return m.RecommendedBudgetAmountMicros
	}
	return nil
}

func (m *CampaignBudget) GetPeriod() enums.BudgetPeriodEnum_BudgetPeriod {
	if m != nil {
		return m.Period
	}
	return enums.BudgetPeriodEnum_UNSPECIFIED
}

func (m *CampaignBudget) GetRecommendedBudgetEstimatedChangeWeeklyClicks() *wrappers.Int64Value {
	if m != nil {
		return m.RecommendedBudgetEstimatedChangeWeeklyClicks
	}
	return nil
}

func (m *CampaignBudget) GetRecommendedBudgetEstimatedChangeWeeklyCostMicros() *wrappers.Int64Value {
	if m != nil {
		return m.RecommendedBudgetEstimatedChangeWeeklyCostMicros
	}
	return nil
}

func (m *CampaignBudget) GetRecommendedBudgetEstimatedChangeWeeklyInteractions() *wrappers.Int64Value {
	if m != nil {
		return m.RecommendedBudgetEstimatedChangeWeeklyInteractions
	}
	return nil
}

func (m *CampaignBudget) GetRecommendedBudgetEstimatedChangeWeeklyViews() *wrappers.Int64Value {
	if m != nil {
		return m.RecommendedBudgetEstimatedChangeWeeklyViews
	}
	return nil
}

func (m *CampaignBudget) GetType() enums.BudgetTypeEnum_BudgetType {
	if m != nil {
		return m.Type
	}
	return enums.BudgetTypeEnum_UNSPECIFIED
}

func init() {
	proto.RegisterType((*CampaignBudget)(nil), "google.ads.googleads.v3.resources.CampaignBudget")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v3/resources/campaign_budget.proto", fileDescriptor_3160509214176301)
}

var fileDescriptor_3160509214176301 = []byte{
	// 800 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x56, 0xdd, 0x6e, 0xe3, 0x44,
	0x18, 0x95, 0xb3, 0xa5, 0xb0, 0xb3, 0x69, 0xba, 0xf5, 0x22, 0x64, 0xca, 0x82, 0xb2, 0xa0, 0x15,
	0x95, 0x16, 0xd9, 0xdd, 0x06, 0x75, 0x91, 0xe1, 0x82, 0x24, 0xbb, 0xaa, 0x16, 0xb6, 0x28, 0x72,
	0xab, 0x20, 0xa1, 0x48, 0xd6, 0xd4, 0xf3, 0xd5, 0x19, 0xd5, 0x9e, 0xb1, 0x66, 0xc6, 0x29, 0x11,
	0xaa, 0x84, 0x10, 0xb7, 0x48, 0x3c, 0x03, 0x97, 0x3c, 0x0a, 0x8f, 0xd2, 0x2b, 0x1e, 0x01, 0x79,
	0xfc, 0x93, 0x3f, 0xba, 0x4e, 0xee, 0x3e, 0xcf, 0x9c, 0x73, 0xbe, 0xe3, 0x33, 0x5f, 0x3c, 0x41,
	0x2f, 0x42, 0xce, 0xc3, 0x08, 0x1c, 0x4c, 0xa4, 0x93, 0x97, 0x59, 0x35, 0xe9, 0x38, 0x02, 0x24,
	0x4f, 0x45, 0x00, 0xd2, 0x09, 0x70, 0x9c, 0x60, 0x1a, 0x32, 0xff, 0x22, 0x25, 0x21, 0x28, 0x3b,
	0x11, 0x5c, 0x71, 0xf3, 0x49, 0x8e, 0xb6, 0x31, 0x91, 0x76, 0x45, 0xb4, 0x27, 0x1d, 0xbb, 0x22,
	0xee, 0xbb, 0x77, 0x69, 0x03, 0x4b, 0x63, 0xe9, 0xe4, 0x72, 0x3e, 0x81, 0x88, 0x4e, 0x40, 0x4c,
	0xfd, 0x18, 0xd4, 0x98, 0x93, 0x5c, 0x7e, 0xff, 0xf9, 0x5a, 0xdc, 0x04, 0x04, 0xdd, 0x90, 0x22,
	0x15, 0x56, 0xa9, 0x2c, 0x28, 0xce, 0x5a, 0x14, 0x35, 0x4d, 0xa0, 0x20, 0x7c, 0x58, 0x12, 0x12,
	0x5a, 0x25, 0x54, 0x6c, 0x7d, 0x52, 0x6c, 0xe9, 0xa7, 0x8b, 0xf4, 0xd2, 0xb9, 0x16, 0x38, 0x49,
	0x40, 0x94, 0xbd, 0x1e, 0xcf, 0x51, 0x31, 0x63, 0x5c, 0x61, 0x45, 0x39, 0x2b, 0x76, 0x3f, 0xfd,
	0xb7, 0x89, 0x5a, 0xfd, 0x22, 0xe8, 0x9e, 0x6e, 0x6b, 0x7e, 0x86, 0x76, 0xca, 0x16, 0x3e, 0xc3,
	0x31, 0x58, 0x46, 0xdb, 0x38, 0xb8, 0xef, 0x35, 0xcb, 0xc5, 0x1f, 0x70, 0x0c, 0xe6, 0x33, 0xd4,
	0xa0, 0xc4, 0xba, 0xd7, 0x36, 0x0e, 0x1e, 0x1c, 0x7d, 0x54, 0x1c, 0x84, 0x5d, 0x5a, 0xb0, 0x5f,
	0x33, 0x75, 0xfc, 0xe5, 0x10, 0x47, 0x29, 0x78, 0x0d, 0x4a, 0xcc, 0x43, 0xb4, 0xa5, 0x85, 0xb6,
	0x34, 0xfc, 0xf1, 0x0a, 0xfc, 0x4c, 0x09, 0xca, 0xc2, 0x1c, 0xaf, 0x91, 0xe6, 0xb7, 0x68, 0x07,
	0xc7, 0x3c, 0x65, 0xca, 0x8f, 0x69, 0x20, 0xb8, 0xb4, 0xde, 0xa9, 0xef, 0xd4, 0xcc, 0x19, 0xa7,
	0x9a, 0x60, 0x7e, 0x8f, 0x1e, 0x29, 0xae, 0x70, 0xe4, 0x2f, 0xea, 0xa0, 0x7a, 0x9d, 0x3d, 0xcd,
	0xeb, 0xce, 0x8b, 0x9d, 0xa3, 0xed, 0xfc, 0xfc, 0xac, 0xed, 0xb6, 0x71, 0xd0, 0x3a, 0xfa, 0xc6,
	0xbe, 0x6b, 0x0a, 0xf5, 0x01, 0xda, 0x79, 0x92, 0x67, 0x9a, 0xf2, 0x8a, 0xa5, 0xf1, 0xc2, 0x82,
	0x57, 0x68, 0x99, 0x29, 0xda, 0x5d, 0x1a, 0x42, 0xeb, 0x5d, 0x2d, 0xff, 0x66, 0x2d, 0xf9, 0x97,
	0x05, 0xf7, 0x54, 0x53, 0xe7, 0xda, 0x2c, 0x6e, 0x78, 0x2d, 0xb2, 0xf0, 0x6c, 0x9e, 0xa0, 0x3d,
	0xf8, 0x39, 0x89, 0x68, 0x40, 0x55, 0x34, 0xf5, 0xe5, 0x18, 0x0b, 0x20, 0xd6, 0x7b, 0x3a, 0x97,
	0xfd, 0x95, 0x5c, 0x7a, 0x9c, 0x47, 0x79, 0x2c, 0x0f, 0x67, 0xa4, 0x33, 0xcd, 0x31, 0x5f, 0xa2,
	0x5d, 0x01, 0x97, 0x20, 0x80, 0x05, 0xe0, 0x07, 0x59, 0x5c, 0xd6, 0xfd, 0xfa, 0x78, 0x5b, 0x15,
	0xa7, 0x9f, 0x51, 0xcc, 0x01, 0xfa, 0x60, 0x8c, 0xa5, 0x2f, 0x20, 0xe0, 0x71, 0x0c, 0x8c, 0x00,
	0x29, 0x7e, 0xf0, 0xd6, 0x83, 0x5a, 0x4f, 0xef, 0x8f, 0xb1, 0xf4, 0x66, 0xc4, 0x62, 0x80, 0x09,
	0x6a, 0xaf, 0xaa, 0x2d, 0xcd, 0x41, 0xb3, 0xde, 0xe8, 0xc7, 0x62, 0x59, 0x79, 0x79, 0x26, 0xf2,
	0xcf, 0x80, 0xb5, 0xb3, 0xc1, 0x4c, 0x0c, 0x34, 0x65, 0xee, 0xb0, 0xf2, 0x05, 0xaf, 0xd0, 0x32,
	0x7f, 0x37, 0xd0, 0xf3, 0xff, 0x31, 0x0f, 0x52, 0xd1, 0x18, 0x2b, 0x20, 0x7e, 0x30, 0xc6, 0x2c,
	0x04, 0xff, 0x1a, 0xe0, 0x2a, 0x9a, 0xfa, 0x41, 0x44, 0x83, 0x2b, 0x69, 0xb5, 0xea, 0xdf, 0xe6,
	0x8b, 0x95, 0xb7, 0x79, 0x55, 0x6a, 0xf6, 0xb5, 0xe4, 0x8f, 0x5a, 0xb1, 0xaf, 0x05, 0xcd, 0x3f,
	0x0c, 0x74, 0xbc, 0x89, 0x0d, 0x2e, 0xab, 0x64, 0x77, 0xeb, 0xbd, 0x1c, 0xae, 0xe9, 0x85, 0xcb,
	0x32, 0xec, 0x3f, 0x0d, 0xf4, 0x62, 0x03, 0x3f, 0x94, 0x29, 0x10, 0x38, 0xd0, 0x1f, 0x3a, 0xeb,
	0x61, 0xbd, 0xa1, 0xa3, 0xf5, 0x0c, 0xbd, 0x9e, 0x93, 0x35, 0x7f, 0x33, 0xd0, 0xe1, 0x06, 0x96,
	0x26, 0x14, 0xae, 0xa5, 0xb5, 0x57, 0xef, 0xe5, 0xd9, 0x7a, 0x5e, 0x86, 0x99, 0x9e, 0xf9, 0x06,
	0x6d, 0x65, 0xb7, 0x84, 0x65, 0xea, 0x11, 0xfc, 0x6a, 0xad, 0x11, 0x3c, 0x9f, 0x26, 0x30, 0x37,
	0x80, 0xd9, 0xa3, 0xa7, 0x55, 0x5c, 0x72, 0xdb, 0xc5, 0xe8, 0xf3, 0x19, 0xb1, 0xa8, 0x12, 0x2a,
	0xed, 0x80, 0xc7, 0xce, 0xd2, 0x3d, 0x71, 0x1c, 0xa4, 0x52, 0xf1, 0x18, 0x84, 0x74, 0x7e, 0x29,
	0xcb, 0x9b, 0xea, 0xd6, 0xce, 0x41, 0xd9, 0xd6, 0xe2, 0x35, 0x7e, 0xd3, 0xfb, 0xb5, 0x81, 0x9e,
	0x06, 0x3c, 0xb6, 0x6b, 0x2f, 0xf2, 0xde, 0xa3, 0xc5, 0x8e, 0x83, 0x2c, 0xad, 0x81, 0xf1, 0xd3,
	0x77, 0x05, 0x33, 0xe4, 0x11, 0x66, 0xa1, 0xcd, 0x45, 0xe8, 0x84, 0xc0, 0x74, 0x96, 0xce, 0xcc,
	0xf2, 0x5b, 0xfe, 0x5a, 0x7c, 0x5d, 0x55, 0x7f, 0x35, 0xee, 0x9d, 0x74, 0xbb, 0x7f, 0x37, 0x9e,
	0x9c, 0xe4, 0x92, 0x5d, 0x22, 0xed, 0xbc, 0xcc, 0xaa, 0x61, 0xc7, 0xf6, 0x4a, 0xe4, 0x3f, 0x25,
	0x66, 0xd4, 0x25, 0x72, 0x54, 0x61, 0x46, 0xc3, 0xce, 0xa8, 0xc2, 0xdc, 0x36, 0x9e, 0xe6, 0x1b,
	0xae, 0xdb, 0x25, 0xd2, 0x75, 0x2b, 0x94, 0xeb, 0x0e, 0x3b, 0xae, 0x5b, 0xe1, 0x2e, 0xb6, 0xb5,
	0xd9, 0xce, 0x7f, 0x01, 0x00, 0x00, 0xff, 0xff, 0xf2, 0x67, 0x6e, 0xd9, 0x06, 0x09, 0x00, 0x00,
}
