// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/asset/v1p4beta1/asset_service.proto

package asset

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	duration "github.com/golang/protobuf/ptypes/duration"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	_ "google.golang.org/genproto/googleapis/iam/v1"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// IAM policy analysis query message.
type IamPolicyAnalysisQuery struct {
	// Required. The relative name of the root asset. Only resources and IAM policies within
	// the parent will be analyzed. This can only be an organization number (such
	// as "organizations/123") or a folder number (such as "folders/123").
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Specifies a resource for analysis. Leaving it empty means ANY.
	ResourceSelector *IamPolicyAnalysisQuery_ResourceSelector `protobuf:"bytes,2,opt,name=resource_selector,json=resourceSelector,proto3" json:"resource_selector,omitempty"`
	// Optional. Specifies an identity for analysis. Leaving it empty means ANY.
	IdentitySelector *IamPolicyAnalysisQuery_IdentitySelector `protobuf:"bytes,3,opt,name=identity_selector,json=identitySelector,proto3" json:"identity_selector,omitempty"`
	// Optional. Specifies roles or permissions for analysis. Leaving it empty
	// means ANY.
	AccessSelector       *IamPolicyAnalysisQuery_AccessSelector `protobuf:"bytes,4,opt,name=access_selector,json=accessSelector,proto3" json:"access_selector,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                               `json:"-"`
	XXX_unrecognized     []byte                                 `json:"-"`
	XXX_sizecache        int32                                  `json:"-"`
}

func (m *IamPolicyAnalysisQuery) Reset()         { *m = IamPolicyAnalysisQuery{} }
func (m *IamPolicyAnalysisQuery) String() string { return proto.CompactTextString(m) }
func (*IamPolicyAnalysisQuery) ProtoMessage()    {}
func (*IamPolicyAnalysisQuery) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d37c6d1bea9ee6a, []int{0}
}

func (m *IamPolicyAnalysisQuery) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_IamPolicyAnalysisQuery.Unmarshal(m, b)
}
func (m *IamPolicyAnalysisQuery) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_IamPolicyAnalysisQuery.Marshal(b, m, deterministic)
}
func (m *IamPolicyAnalysisQuery) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IamPolicyAnalysisQuery.Merge(m, src)
}
func (m *IamPolicyAnalysisQuery) XXX_Size() int {
	return xxx_messageInfo_IamPolicyAnalysisQuery.Size(m)
}
func (m *IamPolicyAnalysisQuery) XXX_DiscardUnknown() {
	xxx_messageInfo_IamPolicyAnalysisQuery.DiscardUnknown(m)
}

var xxx_messageInfo_IamPolicyAnalysisQuery proto.InternalMessageInfo

func (m *IamPolicyAnalysisQuery) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *IamPolicyAnalysisQuery) GetResourceSelector() *IamPolicyAnalysisQuery_ResourceSelector {
	if m != nil {
		return m.ResourceSelector
	}
	return nil
}

func (m *IamPolicyAnalysisQuery) GetIdentitySelector() *IamPolicyAnalysisQuery_IdentitySelector {
	if m != nil {
		return m.IdentitySelector
	}
	return nil
}

func (m *IamPolicyAnalysisQuery) GetAccessSelector() *IamPolicyAnalysisQuery_AccessSelector {
	if m != nil {
		return m.AccessSelector
	}
	return nil
}

// Specifies the resource to analyze for access policies, which may be set
// directly on the resource, or on ancestors such as organizations, folders or
// projects. At least one of [ResourceSelector][google.cloud.asset.v1p4beta1.IamPolicyAnalysisQuery.ResourceSelector], [IdentitySelector][google.cloud.asset.v1p4beta1.IamPolicyAnalysisQuery.IdentitySelector] or
// [AccessSelector][google.cloud.asset.v1p4beta1.IamPolicyAnalysisQuery.AccessSelector] must be specified in a request.
type IamPolicyAnalysisQuery_ResourceSelector struct {
	// Required. The [full resource
	// name](https://cloud.google.com/apis/design/resource_names#full_resource_name)
	// .
	FullResourceName     string   `protobuf:"bytes,1,opt,name=full_resource_name,json=fullResourceName,proto3" json:"full_resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *IamPolicyAnalysisQuery_ResourceSelector) Reset() {
	*m = IamPolicyAnalysisQuery_ResourceSelector{}
}
func (m *IamPolicyAnalysisQuery_ResourceSelector) String() string { return proto.CompactTextString(m) }
func (*IamPolicyAnalysisQuery_ResourceSelector) ProtoMessage()    {}
func (*IamPolicyAnalysisQuery_ResourceSelector) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d37c6d1bea9ee6a, []int{0, 0}
}

func (m *IamPolicyAnalysisQuery_ResourceSelector) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_IamPolicyAnalysisQuery_ResourceSelector.Unmarshal(m, b)
}
func (m *IamPolicyAnalysisQuery_ResourceSelector) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_IamPolicyAnalysisQuery_ResourceSelector.Marshal(b, m, deterministic)
}
func (m *IamPolicyAnalysisQuery_ResourceSelector) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IamPolicyAnalysisQuery_ResourceSelector.Merge(m, src)
}
func (m *IamPolicyAnalysisQuery_ResourceSelector) XXX_Size() int {
	return xxx_messageInfo_IamPolicyAnalysisQuery_ResourceSelector.Size(m)
}
func (m *IamPolicyAnalysisQuery_ResourceSelector) XXX_DiscardUnknown() {
	xxx_messageInfo_IamPolicyAnalysisQuery_ResourceSelector.DiscardUnknown(m)
}

var xxx_messageInfo_IamPolicyAnalysisQuery_ResourceSelector proto.InternalMessageInfo

func (m *IamPolicyAnalysisQuery_ResourceSelector) GetFullResourceName() string {
	if m != nil {
		return m.FullResourceName
	}
	return ""
}

// Specifies an identity for which to determine resource access, based on
// roles assigned either directly to them or to the groups they belong to,
// directly or indirectly.
type IamPolicyAnalysisQuery_IdentitySelector struct {
	// Required. The identity appear in the form of members in
	// [IAM policy
	// binding](https://cloud.google.com/iam/reference/rest/v1/Binding).
	Identity             string   `protobuf:"bytes,1,opt,name=identity,proto3" json:"identity,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *IamPolicyAnalysisQuery_IdentitySelector) Reset() {
	*m = IamPolicyAnalysisQuery_IdentitySelector{}
}
func (m *IamPolicyAnalysisQuery_IdentitySelector) String() string { return proto.CompactTextString(m) }
func (*IamPolicyAnalysisQuery_IdentitySelector) ProtoMessage()    {}
func (*IamPolicyAnalysisQuery_IdentitySelector) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d37c6d1bea9ee6a, []int{0, 1}
}

func (m *IamPolicyAnalysisQuery_IdentitySelector) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_IamPolicyAnalysisQuery_IdentitySelector.Unmarshal(m, b)
}
func (m *IamPolicyAnalysisQuery_IdentitySelector) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_IamPolicyAnalysisQuery_IdentitySelector.Marshal(b, m, deterministic)
}
func (m *IamPolicyAnalysisQuery_IdentitySelector) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IamPolicyAnalysisQuery_IdentitySelector.Merge(m, src)
}
func (m *IamPolicyAnalysisQuery_IdentitySelector) XXX_Size() int {
	return xxx_messageInfo_IamPolicyAnalysisQuery_IdentitySelector.Size(m)
}
func (m *IamPolicyAnalysisQuery_IdentitySelector) XXX_DiscardUnknown() {
	xxx_messageInfo_IamPolicyAnalysisQuery_IdentitySelector.DiscardUnknown(m)
}

var xxx_messageInfo_IamPolicyAnalysisQuery_IdentitySelector proto.InternalMessageInfo

func (m *IamPolicyAnalysisQuery_IdentitySelector) GetIdentity() string {
	if m != nil {
		return m.Identity
	}
	return ""
}

// Specifies roles and/or permissions to analyze, to determine both the
// identities possessing them and the resources they control. If multiple
// values are specified, results will include identities and resources
// matching any of them.
type IamPolicyAnalysisQuery_AccessSelector struct {
	// Optional. The roles to appear in result.
	Roles []string `protobuf:"bytes,1,rep,name=roles,proto3" json:"roles,omitempty"`
	// Optional. The permissions to appear in result.
	Permissions          []string `protobuf:"bytes,2,rep,name=permissions,proto3" json:"permissions,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *IamPolicyAnalysisQuery_AccessSelector) Reset()         { *m = IamPolicyAnalysisQuery_AccessSelector{} }
func (m *IamPolicyAnalysisQuery_AccessSelector) String() string { return proto.CompactTextString(m) }
func (*IamPolicyAnalysisQuery_AccessSelector) ProtoMessage()    {}
func (*IamPolicyAnalysisQuery_AccessSelector) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d37c6d1bea9ee6a, []int{0, 2}
}

func (m *IamPolicyAnalysisQuery_AccessSelector) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_IamPolicyAnalysisQuery_AccessSelector.Unmarshal(m, b)
}
func (m *IamPolicyAnalysisQuery_AccessSelector) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_IamPolicyAnalysisQuery_AccessSelector.Marshal(b, m, deterministic)
}
func (m *IamPolicyAnalysisQuery_AccessSelector) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IamPolicyAnalysisQuery_AccessSelector.Merge(m, src)
}
func (m *IamPolicyAnalysisQuery_AccessSelector) XXX_Size() int {
	return xxx_messageInfo_IamPolicyAnalysisQuery_AccessSelector.Size(m)
}
func (m *IamPolicyAnalysisQuery_AccessSelector) XXX_DiscardUnknown() {
	xxx_messageInfo_IamPolicyAnalysisQuery_AccessSelector.DiscardUnknown(m)
}

var xxx_messageInfo_IamPolicyAnalysisQuery_AccessSelector proto.InternalMessageInfo

func (m *IamPolicyAnalysisQuery_AccessSelector) GetRoles() []string {
	if m != nil {
		return m.Roles
	}
	return nil
}

func (m *IamPolicyAnalysisQuery_AccessSelector) GetPermissions() []string {
	if m != nil {
		return m.Permissions
	}
	return nil
}

// A request message for [AssetService.AnalyzeIamPolicy][google.cloud.asset.v1p4beta1.AssetService.AnalyzeIamPolicy].
type AnalyzeIamPolicyRequest struct {
	// Required. The request query.
	AnalysisQuery *IamPolicyAnalysisQuery `protobuf:"bytes,1,opt,name=analysis_query,json=analysisQuery,proto3" json:"analysis_query,omitempty"`
	// Optional. The request options.
	Options              *AnalyzeIamPolicyRequest_Options `protobuf:"bytes,2,opt,name=options,proto3" json:"options,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                         `json:"-"`
	XXX_unrecognized     []byte                           `json:"-"`
	XXX_sizecache        int32                            `json:"-"`
}

func (m *AnalyzeIamPolicyRequest) Reset()         { *m = AnalyzeIamPolicyRequest{} }
func (m *AnalyzeIamPolicyRequest) String() string { return proto.CompactTextString(m) }
func (*AnalyzeIamPolicyRequest) ProtoMessage()    {}
func (*AnalyzeIamPolicyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d37c6d1bea9ee6a, []int{1}
}

func (m *AnalyzeIamPolicyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AnalyzeIamPolicyRequest.Unmarshal(m, b)
}
func (m *AnalyzeIamPolicyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AnalyzeIamPolicyRequest.Marshal(b, m, deterministic)
}
func (m *AnalyzeIamPolicyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AnalyzeIamPolicyRequest.Merge(m, src)
}
func (m *AnalyzeIamPolicyRequest) XXX_Size() int {
	return xxx_messageInfo_AnalyzeIamPolicyRequest.Size(m)
}
func (m *AnalyzeIamPolicyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AnalyzeIamPolicyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AnalyzeIamPolicyRequest proto.InternalMessageInfo

func (m *AnalyzeIamPolicyRequest) GetAnalysisQuery() *IamPolicyAnalysisQuery {
	if m != nil {
		return m.AnalysisQuery
	}
	return nil
}

func (m *AnalyzeIamPolicyRequest) GetOptions() *AnalyzeIamPolicyRequest_Options {
	if m != nil {
		return m.Options
	}
	return nil
}

// Contains request options.
type AnalyzeIamPolicyRequest_Options struct {
	// Optional. If true, the identities section of the result will expand any
	// Google groups appearing in an IAM policy binding.
	//
	// If [identity_selector][] is specified, the identity in the result will
	// be determined by the selector, and this flag will have no effect.
	//
	// Default is false.
	ExpandGroups bool `protobuf:"varint,1,opt,name=expand_groups,json=expandGroups,proto3" json:"expand_groups,omitempty"`
	// Optional. If true, the access section of result will expand any roles
	// appearing in IAM policy bindings to include their permissions.
	//
	// If [access_selector][] is specified, the access section of the result
	// will be determined by the selector, and this flag will have no effect.
	//
	// Default is false.
	ExpandRoles bool `protobuf:"varint,2,opt,name=expand_roles,json=expandRoles,proto3" json:"expand_roles,omitempty"`
	// Optional. If true, the resource section of the result will expand any
	// resource attached to an IAM policy to include resources lower in the
	// resource hierarchy.
	//
	// For example, if the request analyzes for which resources user A has
	// permission P, and the results include an IAM policy with P on a GCP
	// folder, the results will also include resources in that folder with
	// permission P.
	//
	// If [resource_selector][] is specified, the resource section of the result
	// will be determined by the selector, and this flag will have no effect.
	// Default is false.
	ExpandResources bool `protobuf:"varint,3,opt,name=expand_resources,json=expandResources,proto3" json:"expand_resources,omitempty"`
	// Optional. If true, the result will output resource edges, starting
	// from the policy attached resource, to any expanded resources.
	// Default is false.
	OutputResourceEdges bool `protobuf:"varint,4,opt,name=output_resource_edges,json=outputResourceEdges,proto3" json:"output_resource_edges,omitempty"`
	// Optional. If true, the result will output group identity edges, starting
	// from the binding's group members, to any expanded identities.
	// Default is false.
	OutputGroupEdges bool `protobuf:"varint,5,opt,name=output_group_edges,json=outputGroupEdges,proto3" json:"output_group_edges,omitempty"`
	// Optional. If true, the response will include access analysis from identities to
	// resources via service account impersonation. This is a very expensive
	// operation, because many derived queries will be executed. We highly
	// recommend you use ExportIamPolicyAnalysis rpc instead.
	//
	// For example, if the request analyzes for which resources user A has
	// permission P, and there's an IAM policy states user A has
	// iam.serviceAccounts.getAccessToken permission to a service account SA,
	// and there's another IAM policy states service account SA has permission P
	// to a GCP folder F, then user A potentially has access to the GCP folder
	// F. And those advanced analysis results will be included in
	// [AnalyzeIamPolicyResponse.service_account_impersonation_analysis][google.cloud.asset.v1p4beta1.AnalyzeIamPolicyResponse.service_account_impersonation_analysis].
	//
	// Another example, if the request analyzes for who has
	// permission P to a GCP folder F, and there's an IAM policy states user A
	// has iam.serviceAccounts.actAs permission to a service account SA, and
	// there's another IAM policy states service account SA has permission P to
	// the GCP folder F, then user A potentially has access to the GCP folder
	// F. And those advanced analysis results will be included in
	// [AnalyzeIamPolicyResponse.service_account_impersonation_analysis][google.cloud.asset.v1p4beta1.AnalyzeIamPolicyResponse.service_account_impersonation_analysis].
	//
	// Default is false.
	AnalyzeServiceAccountImpersonation bool `protobuf:"varint,6,opt,name=analyze_service_account_impersonation,json=analyzeServiceAccountImpersonation,proto3" json:"analyze_service_account_impersonation,omitempty"`
	// Optional. Amount of time executable has to complete.  See JSON representation of
	// [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json).
	//
	// If this field is set with a value less than the RPC deadline, and the
	// execution of your query hasn't finished in the specified
	// execution timeout,  you will get a response with partial result.
	// Otherwise, your query's execution will continue until the RPC deadline.
	// If it's not finished until then, you will get a  DEADLINE_EXCEEDED error.
	//
	// Default is empty.
	ExecutionTimeout     *duration.Duration `protobuf:"bytes,7,opt,name=execution_timeout,json=executionTimeout,proto3" json:"execution_timeout,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *AnalyzeIamPolicyRequest_Options) Reset()         { *m = AnalyzeIamPolicyRequest_Options{} }
func (m *AnalyzeIamPolicyRequest_Options) String() string { return proto.CompactTextString(m) }
func (*AnalyzeIamPolicyRequest_Options) ProtoMessage()    {}
func (*AnalyzeIamPolicyRequest_Options) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d37c6d1bea9ee6a, []int{1, 0}
}

func (m *AnalyzeIamPolicyRequest_Options) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AnalyzeIamPolicyRequest_Options.Unmarshal(m, b)
}
func (m *AnalyzeIamPolicyRequest_Options) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AnalyzeIamPolicyRequest_Options.Marshal(b, m, deterministic)
}
func (m *AnalyzeIamPolicyRequest_Options) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AnalyzeIamPolicyRequest_Options.Merge(m, src)
}
func (m *AnalyzeIamPolicyRequest_Options) XXX_Size() int {
	return xxx_messageInfo_AnalyzeIamPolicyRequest_Options.Size(m)
}
func (m *AnalyzeIamPolicyRequest_Options) XXX_DiscardUnknown() {
	xxx_messageInfo_AnalyzeIamPolicyRequest_Options.DiscardUnknown(m)
}

var xxx_messageInfo_AnalyzeIamPolicyRequest_Options proto.InternalMessageInfo

func (m *AnalyzeIamPolicyRequest_Options) GetExpandGroups() bool {
	if m != nil {
		return m.ExpandGroups
	}
	return false
}

func (m *AnalyzeIamPolicyRequest_Options) GetExpandRoles() bool {
	if m != nil {
		return m.ExpandRoles
	}
	return false
}

func (m *AnalyzeIamPolicyRequest_Options) GetExpandResources() bool {
	if m != nil {
		return m.ExpandResources
	}
	return false
}

func (m *AnalyzeIamPolicyRequest_Options) GetOutputResourceEdges() bool {
	if m != nil {
		return m.OutputResourceEdges
	}
	return false
}

func (m *AnalyzeIamPolicyRequest_Options) GetOutputGroupEdges() bool {
	if m != nil {
		return m.OutputGroupEdges
	}
	return false
}

func (m *AnalyzeIamPolicyRequest_Options) GetAnalyzeServiceAccountImpersonation() bool {
	if m != nil {
		return m.AnalyzeServiceAccountImpersonation
	}
	return false
}

func (m *AnalyzeIamPolicyRequest_Options) GetExecutionTimeout() *duration.Duration {
	if m != nil {
		return m.ExecutionTimeout
	}
	return nil
}

// A response message for [AssetService.AnalyzeIamPolicy][google.cloud.asset.v1p4beta1.AssetService.AnalyzeIamPolicy].
type AnalyzeIamPolicyResponse struct {
	// The main analysis that matches the original request.
	MainAnalysis *AnalyzeIamPolicyResponse_IamPolicyAnalysis `protobuf:"bytes,1,opt,name=main_analysis,json=mainAnalysis,proto3" json:"main_analysis,omitempty"`
	// The service account impersonation analysis if
	// [AnalyzeIamPolicyRequest.analyze_service_account_impersonation][] is
	// enabled.
	ServiceAccountImpersonationAnalysis []*AnalyzeIamPolicyResponse_IamPolicyAnalysis `protobuf:"bytes,2,rep,name=service_account_impersonation_analysis,json=serviceAccountImpersonationAnalysis,proto3" json:"service_account_impersonation_analysis,omitempty"`
	// Represents whether all entries in the [main_analysis][google.cloud.asset.v1p4beta1.AnalyzeIamPolicyResponse.main_analysis] and
	// [service_account_impersonation_analysis][google.cloud.asset.v1p4beta1.AnalyzeIamPolicyResponse.service_account_impersonation_analysis] have been fully explored to
	// answer the query in the request.
	FullyExplored bool `protobuf:"varint,3,opt,name=fully_explored,json=fullyExplored,proto3" json:"fully_explored,omitempty"`
	// A list of non-critical errors happened during the request handling to
	// explain why `fully_explored` is false, or empty if no error happened.
	NonCriticalErrors    []*IamPolicyAnalysisResult_AnalysisState `protobuf:"bytes,4,rep,name=non_critical_errors,json=nonCriticalErrors,proto3" json:"non_critical_errors,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                 `json:"-"`
	XXX_unrecognized     []byte                                   `json:"-"`
	XXX_sizecache        int32                                    `json:"-"`
}

func (m *AnalyzeIamPolicyResponse) Reset()         { *m = AnalyzeIamPolicyResponse{} }
func (m *AnalyzeIamPolicyResponse) String() string { return proto.CompactTextString(m) }
func (*AnalyzeIamPolicyResponse) ProtoMessage()    {}
func (*AnalyzeIamPolicyResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d37c6d1bea9ee6a, []int{2}
}

func (m *AnalyzeIamPolicyResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AnalyzeIamPolicyResponse.Unmarshal(m, b)
}
func (m *AnalyzeIamPolicyResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AnalyzeIamPolicyResponse.Marshal(b, m, deterministic)
}
func (m *AnalyzeIamPolicyResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AnalyzeIamPolicyResponse.Merge(m, src)
}
func (m *AnalyzeIamPolicyResponse) XXX_Size() int {
	return xxx_messageInfo_AnalyzeIamPolicyResponse.Size(m)
}
func (m *AnalyzeIamPolicyResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_AnalyzeIamPolicyResponse.DiscardUnknown(m)
}

var xxx_messageInfo_AnalyzeIamPolicyResponse proto.InternalMessageInfo

func (m *AnalyzeIamPolicyResponse) GetMainAnalysis() *AnalyzeIamPolicyResponse_IamPolicyAnalysis {
	if m != nil {
		return m.MainAnalysis
	}
	return nil
}

func (m *AnalyzeIamPolicyResponse) GetServiceAccountImpersonationAnalysis() []*AnalyzeIamPolicyResponse_IamPolicyAnalysis {
	if m != nil {
		return m.ServiceAccountImpersonationAnalysis
	}
	return nil
}

func (m *AnalyzeIamPolicyResponse) GetFullyExplored() bool {
	if m != nil {
		return m.FullyExplored
	}
	return false
}

func (m *AnalyzeIamPolicyResponse) GetNonCriticalErrors() []*IamPolicyAnalysisResult_AnalysisState {
	if m != nil {
		return m.NonCriticalErrors
	}
	return nil
}

// An analysis message to group the query and results.
type AnalyzeIamPolicyResponse_IamPolicyAnalysis struct {
	// The analysis query.
	AnalysisQuery *IamPolicyAnalysisQuery `protobuf:"bytes,1,opt,name=analysis_query,json=analysisQuery,proto3" json:"analysis_query,omitempty"`
	// A list of [IamPolicyAnalysisResult][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult] that matches the analysis query, or
	// empty if no result is found.
	AnalysisResults []*IamPolicyAnalysisResult `protobuf:"bytes,2,rep,name=analysis_results,json=analysisResults,proto3" json:"analysis_results,omitempty"`
	// Represents whether all entries in the [analysis_results][google.cloud.asset.v1p4beta1.AnalyzeIamPolicyResponse.IamPolicyAnalysis.analysis_results] have been
	// fully explored to answer the query.
	FullyExplored        bool     `protobuf:"varint,3,opt,name=fully_explored,json=fullyExplored,proto3" json:"fully_explored,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AnalyzeIamPolicyResponse_IamPolicyAnalysis) Reset() {
	*m = AnalyzeIamPolicyResponse_IamPolicyAnalysis{}
}
func (m *AnalyzeIamPolicyResponse_IamPolicyAnalysis) String() string {
	return proto.CompactTextString(m)
}
func (*AnalyzeIamPolicyResponse_IamPolicyAnalysis) ProtoMessage() {}
func (*AnalyzeIamPolicyResponse_IamPolicyAnalysis) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d37c6d1bea9ee6a, []int{2, 0}
}

func (m *AnalyzeIamPolicyResponse_IamPolicyAnalysis) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AnalyzeIamPolicyResponse_IamPolicyAnalysis.Unmarshal(m, b)
}
func (m *AnalyzeIamPolicyResponse_IamPolicyAnalysis) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AnalyzeIamPolicyResponse_IamPolicyAnalysis.Marshal(b, m, deterministic)
}
func (m *AnalyzeIamPolicyResponse_IamPolicyAnalysis) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AnalyzeIamPolicyResponse_IamPolicyAnalysis.Merge(m, src)
}
func (m *AnalyzeIamPolicyResponse_IamPolicyAnalysis) XXX_Size() int {
	return xxx_messageInfo_AnalyzeIamPolicyResponse_IamPolicyAnalysis.Size(m)
}
func (m *AnalyzeIamPolicyResponse_IamPolicyAnalysis) XXX_DiscardUnknown() {
	xxx_messageInfo_AnalyzeIamPolicyResponse_IamPolicyAnalysis.DiscardUnknown(m)
}

var xxx_messageInfo_AnalyzeIamPolicyResponse_IamPolicyAnalysis proto.InternalMessageInfo

func (m *AnalyzeIamPolicyResponse_IamPolicyAnalysis) GetAnalysisQuery() *IamPolicyAnalysisQuery {
	if m != nil {
		return m.AnalysisQuery
	}
	return nil
}

func (m *AnalyzeIamPolicyResponse_IamPolicyAnalysis) GetAnalysisResults() []*IamPolicyAnalysisResult {
	if m != nil {
		return m.AnalysisResults
	}
	return nil
}

func (m *AnalyzeIamPolicyResponse_IamPolicyAnalysis) GetFullyExplored() bool {
	if m != nil {
		return m.FullyExplored
	}
	return false
}

// Output configuration for export IAM policy analysis destination.
type IamPolicyAnalysisOutputConfig struct {
	// IAM policy analysis export destination.
	//
	// Types that are valid to be assigned to Destination:
	//	*IamPolicyAnalysisOutputConfig_GcsDestination_
	Destination          isIamPolicyAnalysisOutputConfig_Destination `protobuf_oneof:"destination"`
	XXX_NoUnkeyedLiteral struct{}                                    `json:"-"`
	XXX_unrecognized     []byte                                      `json:"-"`
	XXX_sizecache        int32                                       `json:"-"`
}

func (m *IamPolicyAnalysisOutputConfig) Reset()         { *m = IamPolicyAnalysisOutputConfig{} }
func (m *IamPolicyAnalysisOutputConfig) String() string { return proto.CompactTextString(m) }
func (*IamPolicyAnalysisOutputConfig) ProtoMessage()    {}
func (*IamPolicyAnalysisOutputConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d37c6d1bea9ee6a, []int{3}
}

func (m *IamPolicyAnalysisOutputConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_IamPolicyAnalysisOutputConfig.Unmarshal(m, b)
}
func (m *IamPolicyAnalysisOutputConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_IamPolicyAnalysisOutputConfig.Marshal(b, m, deterministic)
}
func (m *IamPolicyAnalysisOutputConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IamPolicyAnalysisOutputConfig.Merge(m, src)
}
func (m *IamPolicyAnalysisOutputConfig) XXX_Size() int {
	return xxx_messageInfo_IamPolicyAnalysisOutputConfig.Size(m)
}
func (m *IamPolicyAnalysisOutputConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_IamPolicyAnalysisOutputConfig.DiscardUnknown(m)
}

var xxx_messageInfo_IamPolicyAnalysisOutputConfig proto.InternalMessageInfo

type isIamPolicyAnalysisOutputConfig_Destination interface {
	isIamPolicyAnalysisOutputConfig_Destination()
}

type IamPolicyAnalysisOutputConfig_GcsDestination_ struct {
	GcsDestination *IamPolicyAnalysisOutputConfig_GcsDestination `protobuf:"bytes,1,opt,name=gcs_destination,json=gcsDestination,proto3,oneof"`
}

func (*IamPolicyAnalysisOutputConfig_GcsDestination_) isIamPolicyAnalysisOutputConfig_Destination() {}

func (m *IamPolicyAnalysisOutputConfig) GetDestination() isIamPolicyAnalysisOutputConfig_Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (m *IamPolicyAnalysisOutputConfig) GetGcsDestination() *IamPolicyAnalysisOutputConfig_GcsDestination {
	if x, ok := m.GetDestination().(*IamPolicyAnalysisOutputConfig_GcsDestination_); ok {
		return x.GcsDestination
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*IamPolicyAnalysisOutputConfig) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*IamPolicyAnalysisOutputConfig_GcsDestination_)(nil),
	}
}

// A Cloud Storage location.
type IamPolicyAnalysisOutputConfig_GcsDestination struct {
	// Required. The uri of the Cloud Storage object. It's the same uri that is used by
	// gsutil. For example: "gs://bucket_name/object_name". See [Viewing and
	// Editing Object
	// Metadata](https://cloud.google.com/storage/docs/viewing-editing-metadata)
	// for more information.
	Uri                  string   `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *IamPolicyAnalysisOutputConfig_GcsDestination) Reset() {
	*m = IamPolicyAnalysisOutputConfig_GcsDestination{}
}
func (m *IamPolicyAnalysisOutputConfig_GcsDestination) String() string {
	return proto.CompactTextString(m)
}
func (*IamPolicyAnalysisOutputConfig_GcsDestination) ProtoMessage() {}
func (*IamPolicyAnalysisOutputConfig_GcsDestination) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d37c6d1bea9ee6a, []int{3, 0}
}

func (m *IamPolicyAnalysisOutputConfig_GcsDestination) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_IamPolicyAnalysisOutputConfig_GcsDestination.Unmarshal(m, b)
}
func (m *IamPolicyAnalysisOutputConfig_GcsDestination) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_IamPolicyAnalysisOutputConfig_GcsDestination.Marshal(b, m, deterministic)
}
func (m *IamPolicyAnalysisOutputConfig_GcsDestination) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IamPolicyAnalysisOutputConfig_GcsDestination.Merge(m, src)
}
func (m *IamPolicyAnalysisOutputConfig_GcsDestination) XXX_Size() int {
	return xxx_messageInfo_IamPolicyAnalysisOutputConfig_GcsDestination.Size(m)
}
func (m *IamPolicyAnalysisOutputConfig_GcsDestination) XXX_DiscardUnknown() {
	xxx_messageInfo_IamPolicyAnalysisOutputConfig_GcsDestination.DiscardUnknown(m)
}

var xxx_messageInfo_IamPolicyAnalysisOutputConfig_GcsDestination proto.InternalMessageInfo

func (m *IamPolicyAnalysisOutputConfig_GcsDestination) GetUri() string {
	if m != nil {
		return m.Uri
	}
	return ""
}

// A request message for [AssetService.ExportIamPolicyAnalysis][google.cloud.asset.v1p4beta1.AssetService.ExportIamPolicyAnalysis].
type ExportIamPolicyAnalysisRequest struct {
	// Required. The request query.
	AnalysisQuery *IamPolicyAnalysisQuery `protobuf:"bytes,1,opt,name=analysis_query,json=analysisQuery,proto3" json:"analysis_query,omitempty"`
	// Optional. The request options.
	Options *ExportIamPolicyAnalysisRequest_Options `protobuf:"bytes,2,opt,name=options,proto3" json:"options,omitempty"`
	// Required. Output configuration indicating where the results will be output to.
	OutputConfig         *IamPolicyAnalysisOutputConfig `protobuf:"bytes,3,opt,name=output_config,json=outputConfig,proto3" json:"output_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                       `json:"-"`
	XXX_unrecognized     []byte                         `json:"-"`
	XXX_sizecache        int32                          `json:"-"`
}

func (m *ExportIamPolicyAnalysisRequest) Reset()         { *m = ExportIamPolicyAnalysisRequest{} }
func (m *ExportIamPolicyAnalysisRequest) String() string { return proto.CompactTextString(m) }
func (*ExportIamPolicyAnalysisRequest) ProtoMessage()    {}
func (*ExportIamPolicyAnalysisRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d37c6d1bea9ee6a, []int{4}
}

func (m *ExportIamPolicyAnalysisRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExportIamPolicyAnalysisRequest.Unmarshal(m, b)
}
func (m *ExportIamPolicyAnalysisRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExportIamPolicyAnalysisRequest.Marshal(b, m, deterministic)
}
func (m *ExportIamPolicyAnalysisRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExportIamPolicyAnalysisRequest.Merge(m, src)
}
func (m *ExportIamPolicyAnalysisRequest) XXX_Size() int {
	return xxx_messageInfo_ExportIamPolicyAnalysisRequest.Size(m)
}
func (m *ExportIamPolicyAnalysisRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ExportIamPolicyAnalysisRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ExportIamPolicyAnalysisRequest proto.InternalMessageInfo

func (m *ExportIamPolicyAnalysisRequest) GetAnalysisQuery() *IamPolicyAnalysisQuery {
	if m != nil {
		return m.AnalysisQuery
	}
	return nil
}

func (m *ExportIamPolicyAnalysisRequest) GetOptions() *ExportIamPolicyAnalysisRequest_Options {
	if m != nil {
		return m.Options
	}
	return nil
}

func (m *ExportIamPolicyAnalysisRequest) GetOutputConfig() *IamPolicyAnalysisOutputConfig {
	if m != nil {
		return m.OutputConfig
	}
	return nil
}

// Contains request options.
type ExportIamPolicyAnalysisRequest_Options struct {
	// Optional. If true, the identities section of the result will expand any
	// Google groups appearing in an IAM policy binding.
	//
	// If [identity_selector][] is specified, the identity in the result will
	// be determined by the selector, and this flag will have no effect.
	//
	// Default is false.
	ExpandGroups bool `protobuf:"varint,1,opt,name=expand_groups,json=expandGroups,proto3" json:"expand_groups,omitempty"`
	// Optional. If true, the access section of result will expand any roles
	// appearing in IAM policy bindings to include their permissions.
	//
	// If [access_selector][] is specified, the access section of the result
	// will be determined by the selector, and this flag will have no effect.
	//
	// Default is false.
	ExpandRoles bool `protobuf:"varint,2,opt,name=expand_roles,json=expandRoles,proto3" json:"expand_roles,omitempty"`
	// Optional. If true, the resource section of the result will expand any
	// resource attached to an IAM policy to include resources lower in the
	// resource hierarchy.
	//
	// For example, if the request analyzes for which resources user A has
	// permission P, and the results include an IAM policy with P on a GCP
	// folder, the results will also include resources in that folder with
	// permission P.
	//
	// If [resource_selector][] is specified, the resource section of the result
	// will be determined by the selector, and this flag will have no effect.
	// Default is false.
	ExpandResources bool `protobuf:"varint,3,opt,name=expand_resources,json=expandResources,proto3" json:"expand_resources,omitempty"`
	// Optional. If true, the result will output resource edges, starting
	// from the policy attached resource, to any expanded resources.
	// Default is false.
	OutputResourceEdges bool `protobuf:"varint,4,opt,name=output_resource_edges,json=outputResourceEdges,proto3" json:"output_resource_edges,omitempty"`
	// Optional. If true, the result will output group identity edges, starting
	// from the binding's group members, to any expanded identities.
	// Default is false.
	OutputGroupEdges bool `protobuf:"varint,5,opt,name=output_group_edges,json=outputGroupEdges,proto3" json:"output_group_edges,omitempty"`
	// Optional. If true, the response will include access analysis from identities to
	// resources via service account impersonation. This is a very expensive
	// operation, because many derived queries will be executed.
	//
	// For example, if the request analyzes for which resources user A has
	// permission P, and there's an IAM policy states user A has
	// iam.serviceAccounts.getAccessToken permission to a service account SA,
	// and there's another IAM policy states service account SA has permission P
	// to a GCP folder F, then user A potentially has access to the GCP folder
	// F. And those advanced analysis results will be included in
	// [AnalyzeIamPolicyResponse.service_account_impersonation_analysis][google.cloud.asset.v1p4beta1.AnalyzeIamPolicyResponse.service_account_impersonation_analysis].
	//
	// Another example, if the request analyzes for who has
	// permission P to a GCP folder F, and there's an IAM policy states user A
	// has iam.serviceAccounts.actAs permission to a service account SA, and
	// there's another IAM policy states service account SA has permission P to
	// the GCP folder F, then user A potentially has access to the GCP folder
	// F. And those advanced analysis results will be included in
	// [AnalyzeIamPolicyResponse.service_account_impersonation_analysis][google.cloud.asset.v1p4beta1.AnalyzeIamPolicyResponse.service_account_impersonation_analysis].
	//
	// Default is false.
	AnalyzeServiceAccountImpersonation bool     `protobuf:"varint,6,opt,name=analyze_service_account_impersonation,json=analyzeServiceAccountImpersonation,proto3" json:"analyze_service_account_impersonation,omitempty"`
	XXX_NoUnkeyedLiteral               struct{} `json:"-"`
	XXX_unrecognized                   []byte   `json:"-"`
	XXX_sizecache                      int32    `json:"-"`
}

func (m *ExportIamPolicyAnalysisRequest_Options) Reset() {
	*m = ExportIamPolicyAnalysisRequest_Options{}
}
func (m *ExportIamPolicyAnalysisRequest_Options) String() string { return proto.CompactTextString(m) }
func (*ExportIamPolicyAnalysisRequest_Options) ProtoMessage()    {}
func (*ExportIamPolicyAnalysisRequest_Options) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d37c6d1bea9ee6a, []int{4, 0}
}

func (m *ExportIamPolicyAnalysisRequest_Options) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExportIamPolicyAnalysisRequest_Options.Unmarshal(m, b)
}
func (m *ExportIamPolicyAnalysisRequest_Options) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExportIamPolicyAnalysisRequest_Options.Marshal(b, m, deterministic)
}
func (m *ExportIamPolicyAnalysisRequest_Options) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExportIamPolicyAnalysisRequest_Options.Merge(m, src)
}
func (m *ExportIamPolicyAnalysisRequest_Options) XXX_Size() int {
	return xxx_messageInfo_ExportIamPolicyAnalysisRequest_Options.Size(m)
}
func (m *ExportIamPolicyAnalysisRequest_Options) XXX_DiscardUnknown() {
	xxx_messageInfo_ExportIamPolicyAnalysisRequest_Options.DiscardUnknown(m)
}

var xxx_messageInfo_ExportIamPolicyAnalysisRequest_Options proto.InternalMessageInfo

func (m *ExportIamPolicyAnalysisRequest_Options) GetExpandGroups() bool {
	if m != nil {
		return m.ExpandGroups
	}
	return false
}

func (m *ExportIamPolicyAnalysisRequest_Options) GetExpandRoles() bool {
	if m != nil {
		return m.ExpandRoles
	}
	return false
}

func (m *ExportIamPolicyAnalysisRequest_Options) GetExpandResources() bool {
	if m != nil {
		return m.ExpandResources
	}
	return false
}

func (m *ExportIamPolicyAnalysisRequest_Options) GetOutputResourceEdges() bool {
	if m != nil {
		return m.OutputResourceEdges
	}
	return false
}

func (m *ExportIamPolicyAnalysisRequest_Options) GetOutputGroupEdges() bool {
	if m != nil {
		return m.OutputGroupEdges
	}
	return false
}

func (m *ExportIamPolicyAnalysisRequest_Options) GetAnalyzeServiceAccountImpersonation() bool {
	if m != nil {
		return m.AnalyzeServiceAccountImpersonation
	}
	return false
}

func init() {
	proto.RegisterType((*IamPolicyAnalysisQuery)(nil), "google.cloud.asset.v1p4beta1.IamPolicyAnalysisQuery")
	proto.RegisterType((*IamPolicyAnalysisQuery_ResourceSelector)(nil), "google.cloud.asset.v1p4beta1.IamPolicyAnalysisQuery.ResourceSelector")
	proto.RegisterType((*IamPolicyAnalysisQuery_IdentitySelector)(nil), "google.cloud.asset.v1p4beta1.IamPolicyAnalysisQuery.IdentitySelector")
	proto.RegisterType((*IamPolicyAnalysisQuery_AccessSelector)(nil), "google.cloud.asset.v1p4beta1.IamPolicyAnalysisQuery.AccessSelector")
	proto.RegisterType((*AnalyzeIamPolicyRequest)(nil), "google.cloud.asset.v1p4beta1.AnalyzeIamPolicyRequest")
	proto.RegisterType((*AnalyzeIamPolicyRequest_Options)(nil), "google.cloud.asset.v1p4beta1.AnalyzeIamPolicyRequest.Options")
	proto.RegisterType((*AnalyzeIamPolicyResponse)(nil), "google.cloud.asset.v1p4beta1.AnalyzeIamPolicyResponse")
	proto.RegisterType((*AnalyzeIamPolicyResponse_IamPolicyAnalysis)(nil), "google.cloud.asset.v1p4beta1.AnalyzeIamPolicyResponse.IamPolicyAnalysis")
	proto.RegisterType((*IamPolicyAnalysisOutputConfig)(nil), "google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig")
	proto.RegisterType((*IamPolicyAnalysisOutputConfig_GcsDestination)(nil), "google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination")
	proto.RegisterType((*ExportIamPolicyAnalysisRequest)(nil), "google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest")
	proto.RegisterType((*ExportIamPolicyAnalysisRequest_Options)(nil), "google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options")
}

func init() {
	proto.RegisterFile("google/cloud/asset/v1p4beta1/asset_service.proto", fileDescriptor_6d37c6d1bea9ee6a)
}

var fileDescriptor_6d37c6d1bea9ee6a = []byte{
	// 1184 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xec, 0x57, 0x4d, 0x4f, 0x24, 0xc5,
	0x1b, 0xff, 0xf7, 0x0c, 0x2f, 0xfb, 0x2f, 0x98, 0x61, 0xa8, 0xcd, 0xca, 0xd0, 0xee, 0x0b, 0x99,
	0x0d, 0x2b, 0x92, 0xd8, 0x2d, 0x2c, 0xeb, 0x46, 0xd8, 0xd5, 0x0c, 0x30, 0x61, 0xd1, 0x28, 0xd8,
	0x18, 0x0e, 0x4a, 0xd2, 0x5b, 0xf4, 0x14, 0x4d, 0x27, 0xdd, 0x55, 0x4d, 0x55, 0x35, 0x2f, 0x6e,
	0xbc, 0xf8, 0x15, 0xbc, 0x6a, 0xe2, 0xd9, 0x4f, 0xe0, 0x51, 0xbd, 0x98, 0x70, 0xd0, 0x44, 0xbf,
	0x80, 0x07, 0xbd, 0xf8, 0x09, 0xf4, 0x66, 0xba, 0xaa, 0x7a, 0xa6, 0x67, 0x80, 0x71, 0x77, 0x20,
	0x9e, 0x3c, 0xd6, 0xf3, 0xf2, 0x7b, 0x7e, 0xf5, 0xab, 0xa7, 0x9f, 0xea, 0x02, 0xaf, 0xfb, 0x94,
	0xfa, 0x21, 0xb6, 0xbd, 0x90, 0x26, 0x4d, 0x1b, 0x71, 0x8e, 0x85, 0x7d, 0x38, 0x17, 0x2f, 0xec,
	0x62, 0x81, 0xe6, 0xd4, 0xda, 0xe5, 0x98, 0x1d, 0x06, 0x1e, 0xb6, 0x62, 0x46, 0x05, 0x85, 0x37,
	0x55, 0x86, 0x25, 0x33, 0x2c, 0x19, 0x61, 0xb5, 0x32, 0x4c, 0xed, 0xb5, 0x51, 0x1c, 0xd8, 0x88,
	0x10, 0x2a, 0x90, 0x08, 0x28, 0xe1, 0x2a, 0xd7, 0xbc, 0x93, 0xf3, 0xee, 0x05, 0x38, 0x6c, 0xba,
	0xbb, 0x78, 0x1f, 0x1d, 0x06, 0x94, 0xe9, 0x80, 0x57, 0xff, 0x99, 0x4e, 0x86, 0x65, 0xea, 0xd0,
	0x00, 0x45, 0xf6, 0xe1, 0x9c, 0x1d, 0xd3, 0x30, 0xf0, 0x4e, 0xb4, 0xef, 0xae, 0xf6, 0x85, 0x94,
	0xf8, 0x2c, 0x21, 0x24, 0x20, 0xbe, 0x4d, 0x63, 0xcc, 0x3a, 0xc8, 0xdc, 0xd6, 0x41, 0x72, 0xb5,
	0x9b, 0xec, 0xd9, 0xcd, 0x44, 0x05, 0x68, 0xff, 0x44, 0x8e, 0xac, 0x17, 0x06, 0x98, 0x08, 0xe5,
	0xa8, 0xfd, 0x31, 0x00, 0x5e, 0x5a, 0x47, 0xd1, 0xa6, 0xac, 0x58, 0x27, 0x28, 0x3c, 0xe1, 0x01,
	0xff, 0x20, 0xc1, 0xec, 0x04, 0xbe, 0x0c, 0x86, 0x62, 0xc4, 0x30, 0x11, 0x55, 0x63, 0xca, 0x98,
	0xf9, 0xff, 0x72, 0xf1, 0xd7, 0x7a, 0xc1, 0xd1, 0x26, 0x78, 0x04, 0xc6, 0x19, 0xe6, 0x34, 0x61,
	0x1e, 0x76, 0x39, 0x0e, 0xb1, 0x27, 0x28, 0xab, 0x16, 0xa6, 0x8c, 0x99, 0x91, 0xf9, 0x86, 0xd5,
	0x4b, 0x55, 0xeb, 0xfc, 0x6a, 0x96, 0xa3, 0xd1, 0xb6, 0x34, 0x58, 0x5a, 0xce, 0x70, 0x2a, 0xac,
	0xcb, 0x9c, 0x16, 0x0e, 0x9a, 0x98, 0x88, 0x40, 0x9c, 0xb4, 0x0b, 0x17, 0x2f, 0x51, 0x78, 0x5d,
	0xa3, 0x75, 0x15, 0x0e, 0xba, 0xcc, 0xf0, 0x00, 0x8c, 0x21, 0xcf, 0xc3, 0x9c, 0xb7, 0xcb, 0x0e,
	0xc8, 0xb2, 0x2b, 0x7d, 0x95, 0xad, 0x4b, 0xac, 0xce, 0xa2, 0x65, 0xd4, 0x61, 0x34, 0x1b, 0xa0,
	0xd2, 0x2d, 0x0b, 0x9c, 0x03, 0x70, 0x2f, 0x09, 0x43, 0xb7, 0xa5, 0x3e, 0x41, 0x11, 0xce, 0x9f,
	0x50, 0x25, 0x75, 0x67, 0x69, 0xef, 0xa3, 0x08, 0x9b, 0xf7, 0x41, 0xa5, 0x7b, 0x93, 0xf0, 0x0e,
	0xb8, 0x96, 0xed, 0x30, 0x9f, 0xdc, 0x32, 0x9a, 0x0e, 0x28, 0x77, 0x52, 0x84, 0x93, 0x60, 0x90,
	0xd1, 0x10, 0xf3, 0xaa, 0x31, 0x55, 0x54, 0xf1, 0x86, 0xa3, 0x2c, 0x70, 0x1a, 0x8c, 0xc4, 0x98,
	0x45, 0x01, 0xe7, 0x69, 0x4f, 0x56, 0x0b, 0xed, 0x80, 0xbc, 0xbd, 0xf6, 0xe7, 0x00, 0x98, 0x90,
	0x2a, 0x7c, 0x82, 0x5b, 0xaa, 0x38, 0xf8, 0x20, 0xc1, 0x5c, 0xc0, 0xa7, 0xa0, 0x8c, 0xb4, 0x40,
	0xee, 0x41, 0xaa, 0x90, 0xa4, 0x35, 0x32, 0xbf, 0xd0, 0x8f, 0xba, 0x6a, 0x33, 0x25, 0xd4, 0xd1,
	0xcf, 0x3b, 0x60, 0x98, 0xc6, 0x42, 0x13, 0x4c, 0xa1, 0x1f, 0xf7, 0x86, 0xbe, 0x80, 0xa9, 0xb5,
	0xa1, 0x40, 0xd4, 0xfe, 0x32, 0x48, 0xf3, 0x8b, 0x22, 0x18, 0xd6, 0x1e, 0x38, 0x03, 0x4a, 0xf8,
	0x38, 0x46, 0xa4, 0xe9, 0xfa, 0x8c, 0x26, 0x31, 0x97, 0x5b, 0xb9, 0xa6, 0x12, 0x46, 0x95, 0x67,
	0x4d, 0x3a, 0xe0, 0x3d, 0xa0, 0xd7, 0xae, 0x92, 0xb6, 0xd0, 0x0e, 0x1c, 0x51, 0x0e, 0x47, 0x0a,
	0x6c, 0x81, 0x4a, 0x16, 0xa7, 0x4f, 0x96, 0xcb, 0xa6, 0xd7, 0xb1, 0x63, 0x3a, 0x36, 0xf3, 0xc1,
	0x87, 0xe0, 0x06, 0x4d, 0x44, 0x9c, 0x88, 0x76, 0x9f, 0xe0, 0xa6, 0x8f, 0xb9, 0x6c, 0x59, 0x9d,
	0x74, 0x5d, 0x45, 0x64, 0x49, 0x8d, 0xd4, 0x9f, 0xb6, 0x97, 0x4e, 0x94, 0xd4, 0x75, 0xd6, 0x60,
	0x3b, 0xab, 0xa2, 0xdc, 0x92, 0xbf, 0x4a, 0xd9, 0x06, 0xd3, 0x48, 0x49, 0x95, 0x4d, 0x57, 0x17,
	0x79, 0x1e, 0x4d, 0x88, 0x70, 0x83, 0x28, 0xc6, 0x8c, 0x53, 0x22, 0x47, 0x51, 0x75, 0xa8, 0x8d,
	0x52, 0xd3, 0x19, 0x5b, 0x2a, 0xa1, 0xae, 0xe2, 0xd7, 0xf3, 0xe1, 0xf0, 0x5d, 0x30, 0x8e, 0x8f,
	0xb1, 0x97, 0xa4, 0x0b, 0x57, 0x04, 0x11, 0xa6, 0x89, 0xa8, 0x0e, 0xcb, 0x93, 0x9b, 0xcc, 0x4e,
	0x2e, 0x9b, 0x77, 0xd6, 0xaa, 0x9e, 0x77, 0x9a, 0x64, 0x2b, 0xf1, 0x43, 0x95, 0x57, 0xfb, 0x6e,
	0x10, 0x54, 0xcf, 0x1e, 0x28, 0x8f, 0x29, 0xe1, 0x18, 0x46, 0xa0, 0x14, 0xa1, 0x80, 0xb8, 0x59,
	0xbf, 0xe8, 0xd6, 0x7b, 0xf2, 0xa2, 0xfd, 0xa1, 0xe0, 0xce, 0xf6, 0xa4, 0x33, 0x9a, 0xc2, 0x67,
	0x2b, 0xf8, 0xa5, 0x01, 0xee, 0xf5, 0x54, 0xaa, 0x4d, 0x24, 0xfd, 0x92, 0xae, 0x92, 0xc8, 0x5d,
	0x7e, 0xb1, 0xe0, 0x2d, 0x7e, 0xd3, 0xa0, 0x9c, 0xce, 0x90, 0x13, 0x17, 0x1f, 0xc7, 0x21, 0x65,
	0xb8, 0xa9, 0x5a, 0xcd, 0x29, 0x49, 0x6b, 0x43, 0x1b, 0x21, 0x07, 0xd7, 0x09, 0x25, 0xae, 0xc7,
	0x02, 0x11, 0x78, 0x28, 0x74, 0x31, 0x63, 0x94, 0xa5, 0x1d, 0x56, 0xec, 0x63, 0x28, 0x3a, 0x98,
	0x27, 0xa1, 0xb0, 0xb2, 0xe5, 0x96, 0x40, 0x02, 0x3b, 0xe3, 0x84, 0x92, 0x15, 0x0d, 0xdf, 0x90,
	0xe8, 0xe6, 0x5f, 0x06, 0x18, 0x3f, 0x93, 0x0c, 0x3f, 0xbe, 0xca, 0xe1, 0xd1, 0x3d, 0x37, 0x9e,
	0x82, 0x4a, 0x0b, 0x9c, 0x49, 0x9a, 0xd9, 0xb9, 0x3c, 0xe8, 0x6b, 0x93, 0xce, 0x18, 0xea, 0x58,
	0x3f, 0xaf, 0xe0, 0xb5, 0x1f, 0x0d, 0x70, 0xeb, 0x0c, 0xe6, 0x86, 0xfc, 0x1c, 0x57, 0x28, 0xd9,
	0x0b, 0x7c, 0x98, 0x80, 0x31, 0xdf, 0xe3, 0x6e, 0x13, 0x73, 0x11, 0xe8, 0x8f, 0x4e, 0x09, 0xf1,
	0xce, 0x0b, 0x32, 0xcd, 0xa3, 0x5a, 0x6b, 0x1e, 0x5f, 0x6d, 0x23, 0x3e, 0xf9, 0x9f, 0x53, 0xf6,
	0x3b, 0x2c, 0xe6, 0x2b, 0xa0, 0xdc, 0x19, 0x03, 0x6f, 0x80, 0x62, 0xc2, 0x82, 0xfc, 0xcd, 0x92,
	0xae, 0x97, 0x4b, 0x60, 0x24, 0xc7, 0xad, 0xf6, 0xd5, 0x20, 0xb8, 0xdd, 0x38, 0x8e, 0x29, 0x13,
	0xe7, 0x48, 0xf5, 0x6f, 0x5d, 0x0b, 0x5e, 0xf7, 0xb5, 0xb0, 0xda, 0x1b, 0xba, 0x37, 0xe1, 0xf3,
	0x6f, 0x07, 0x88, 0x41, 0x49, 0x8f, 0x55, 0x4f, 0x6a, 0xaa, 0xff, 0x58, 0x96, 0x2e, 0x71, 0x2c,
	0x6a, 0x33, 0xa3, 0x34, 0x67, 0x32, 0x7f, 0x2a, 0xfc, 0x77, 0x09, 0x5d, 0xe9, 0x25, 0x34, 0xff,
	0xfb, 0x00, 0x18, 0xad, 0xa7, 0xc7, 0xa2, 0x83, 0xe0, 0xf7, 0x06, 0xa8, 0x74, 0x0f, 0x5c, 0xf8,
	0xa0, 0xaf, 0x3f, 0x09, 0xf3, 0x8d, 0xfe, 0xe6, 0x7a, 0xed, 0xed, 0xcf, 0x7e, 0xf9, 0xed, 0xf3,
	0xc2, 0x9b, 0xf0, 0x61, 0xee, 0x3d, 0xf1, 0xac, 0xf3, 0x33, 0xb1, 0xd4, 0x7f, 0xfa, 0xe3, 0x59,
	0x7b, 0xf6, 0xd3, 0x45, 0xd4, 0xcd, 0xf7, 0xdb, 0x02, 0x98, 0xb8, 0xa0, 0x8f, 0xe1, 0xa3, 0xcb,
	0xb4, 0xbf, 0x79, 0x2b, 0xcb, 0xce, 0x3d, 0x57, 0xac, 0x8d, 0xec, 0xb9, 0x52, 0xfb, 0xc1, 0x38,
	0xad, 0x3f, 0x03, 0x8f, 0xfa, 0xab, 0xa0, 0x6f, 0xeb, 0xa5, 0x4b, 0xf0, 0x93, 0xc2, 0xad, 0xd4,
	0xde, 0x7a, 0x4e, 0xe1, 0xf0, 0xf9, 0x60, 0x8b, 0xc6, 0xac, 0xf9, 0xde, 0x69, 0x7d, 0x52, 0x32,
	0x50, 0x04, 0x14, 0x27, 0x14, 0x07, 0xdc, 0xf2, 0x68, 0xf4, 0x73, 0xdd, 0xda, 0x17, 0x22, 0xe6,
	0x8b, 0xb6, 0x7d, 0x74, 0x74, 0xd4, 0xe5, 0xb4, 0x51, 0x22, 0xf6, 0xd5, 0xab, 0xf0, 0xb5, 0x38,
	0x44, 0x62, 0x8f, 0xb2, 0x68, 0xf9, 0x1b, 0x03, 0x4c, 0x79, 0x34, 0xea, 0xa9, 0xfd, 0xf2, 0x78,
	0xbe, 0x13, 0x37, 0xd3, 0x5f, 0x9f, 0x4d, 0xe3, 0xa3, 0xba, 0x4e, 0xf1, 0x69, 0x88, 0x88, 0x6f,
	0x51, 0xe6, 0xdb, 0x3e, 0x26, 0xf2, 0xc7, 0xc8, 0x6e, 0x17, 0x3e, 0xff, 0x15, 0xba, 0x24, 0xd7,
	0x5f, 0x17, 0x6e, 0xae, 0x29, 0x8c, 0x15, 0x59, 0x56, 0x56, 0xb1, 0xb6, 0xe7, 0x36, 0x17, 0x96,
	0xd3, 0xa0, 0xd3, 0xcc, 0xbd, 0x23, 0xdd, 0x3b, 0xd2, 0xbd, 0xb3, 0x9d, 0x61, 0xec, 0x0e, 0xc9,
	0x5a, 0xf7, 0xff, 0x0e, 0x00, 0x00, 0xff, 0xff, 0x67, 0xa0, 0x6a, 0x2f, 0x7f, 0x0f, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// AssetServiceClient is the client API for AssetService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AssetServiceClient interface {
	// Analyzes IAM policies based on the specified request. Returns
	// a list of [IamPolicyAnalysisResult][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult] matching the request.
	AnalyzeIamPolicy(ctx context.Context, in *AnalyzeIamPolicyRequest, opts ...grpc.CallOption) (*AnalyzeIamPolicyResponse, error)
	// Exports IAM policy analysis based on the specified request. This API
	// implements the [google.longrunning.Operation][google.longrunning.Operation] API allowing you to keep
	// track of the export. The metadata contains the request to help callers to
	// map responses to requests.
	ExportIamPolicyAnalysis(ctx context.Context, in *ExportIamPolicyAnalysisRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
}

type assetServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewAssetServiceClient(cc grpc.ClientConnInterface) AssetServiceClient {
	return &assetServiceClient{cc}
}

func (c *assetServiceClient) AnalyzeIamPolicy(ctx context.Context, in *AnalyzeIamPolicyRequest, opts ...grpc.CallOption) (*AnalyzeIamPolicyResponse, error) {
	out := new(AnalyzeIamPolicyResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1p4beta1.AssetService/AnalyzeIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) ExportIamPolicyAnalysis(ctx context.Context, in *ExportIamPolicyAnalysisRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1p4beta1.AssetService/ExportIamPolicyAnalysis", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AssetServiceServer is the server API for AssetService service.
type AssetServiceServer interface {
	// Analyzes IAM policies based on the specified request. Returns
	// a list of [IamPolicyAnalysisResult][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult] matching the request.
	AnalyzeIamPolicy(context.Context, *AnalyzeIamPolicyRequest) (*AnalyzeIamPolicyResponse, error)
	// Exports IAM policy analysis based on the specified request. This API
	// implements the [google.longrunning.Operation][google.longrunning.Operation] API allowing you to keep
	// track of the export. The metadata contains the request to help callers to
	// map responses to requests.
	ExportIamPolicyAnalysis(context.Context, *ExportIamPolicyAnalysisRequest) (*longrunning.Operation, error)
}

// UnimplementedAssetServiceServer can be embedded to have forward compatible implementations.
type UnimplementedAssetServiceServer struct {
}

func (*UnimplementedAssetServiceServer) AnalyzeIamPolicy(ctx context.Context, req *AnalyzeIamPolicyRequest) (*AnalyzeIamPolicyResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AnalyzeIamPolicy not implemented")
}
func (*UnimplementedAssetServiceServer) ExportIamPolicyAnalysis(ctx context.Context, req *ExportIamPolicyAnalysisRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExportIamPolicyAnalysis not implemented")
}

func RegisterAssetServiceServer(s *grpc.Server, srv AssetServiceServer) {
	s.RegisterService(&_AssetService_serviceDesc, srv)
}

func _AssetService_AnalyzeIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AnalyzeIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).AnalyzeIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1p4beta1.AssetService/AnalyzeIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).AnalyzeIamPolicy(ctx, req.(*AnalyzeIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_ExportIamPolicyAnalysis_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportIamPolicyAnalysisRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).ExportIamPolicyAnalysis(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1p4beta1.AssetService/ExportIamPolicyAnalysis",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).ExportIamPolicyAnalysis(ctx, req.(*ExportIamPolicyAnalysisRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _AssetService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.asset.v1p4beta1.AssetService",
	HandlerType: (*AssetServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "AnalyzeIamPolicy",
			Handler:    _AssetService_AnalyzeIamPolicy_Handler,
		},
		{
			MethodName: "ExportIamPolicyAnalysis",
			Handler:    _AssetService_ExportIamPolicyAnalysis_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/asset/v1p4beta1/asset_service.proto",
}
