package windowsesuapi

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/preview/windowsesu/2019-09-16-preview/windowsesu"
	"github.com/Azure/go-autorest/autorest"
)

// OperationsClientAPI contains the set of methods on the OperationsClient type.
type OperationsClientAPI interface {
	List(ctx context.Context) (result windowsesu.OperationListPage, err error)
}

var _ OperationsClientAPI = (*windowsesu.OperationsClient)(nil)

// MultipleActivationKeysClientAPI contains the set of methods on the MultipleActivationKeysClient type.
type MultipleActivationKeysClientAPI interface {
	Create(ctx context.Context, resourceGroupName string, multipleActivationKeyName string, multipleActivationKey windowsesu.MultipleActivationKey) (result windowsesu.MultipleActivationKeysCreateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, multipleActivationKeyName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, multipleActivationKeyName string) (result windowsesu.MultipleActivationKey, err error)
	List(ctx context.Context) (result windowsesu.MultipleActivationKeyListPage, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result windowsesu.MultipleActivationKeyListPage, err error)
	Update(ctx context.Context, resourceGroupName string, multipleActivationKeyName string, multipleActivationKey windowsesu.MultipleActivationKeyUpdate) (result windowsesu.MultipleActivationKey, err error)
}

var _ MultipleActivationKeysClientAPI = (*windowsesu.MultipleActivationKeysClient)(nil)
