---
title: S3
series: customization
hideFromIndex: true
weight: 115
---

Since [v0.74.0](https://github.com/goreleaser/goreleaser/releases/tag/v0.74.0),
GoReleaser supports pushing artifacts to Amazon S3 and other API-compatible
block storages ([minio][] for example).

[minio]: https://www.minio.io

Right now, the implementation is quite simple and probably won't cover all
use cases. If you need one of such use cases, please open an issue/pull request.

## Customization

```yaml
# .goreleaser.yml
s3:
  # You can have multiple s3 configs
  -
    # Bucket name (without the s3:// prefix)
    # Default is empty.
    bucket: my-bucket
    # AWS Region to use.
    # Defaults is us-east-1
    region: us-east-1
    # Template for the path/name inside the bucket.
    # Default is `{{ .ProjectName }}/{{ .Tag }}`
    folder: "foo/bar/{{.Version}}"
    # Set a custom profile to use for this s3 config. If you have multiple
    # profiles setup in you ~/.aws config, this shall help defining which
    # profile to use in which s3 bucket.
    # Default is empty.
    profile: my-profile
    # Endpoint allows you to set a custom endpoint, which is useful if you
    # want to push your artifacts to a minio server for example.
    # Default is AWS S3 URL.
    endpoint: "http://minio.foo.com"
    # Sets the ACL of the object using the specified canned ACL.
    # Default is private.
    acl: public-read
```

> Learn more about the [name template engine](/templates).
> Learn more about the [acl](https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectPUTacl.html).

## Authentication

GoReleaser will authenticate using the [same methods defined by aws-cli][auth].
You can read the [docs][auth] to find out more about it.

Currently it supports authentication with:

* A [EnvProvider][EnvProvider] which retrieves credentials from the environment variables of the
  running process. Environment credentials never expire.
  Environment variables used:
  
  * Access Key ID:     AWS_ACCESS_KEY_ID or AWS_ACCESS_KEY

  * Secret Access Key: AWS_SECRET_ACCESS_KEY or AWS_SECRET_KEY
  
* A [SharedCredentialsProvider][SharedCredentialsProvider] which retrieves credentials from the current user's home
  directory, and keeps track if those credentials are expired.
  
  Profile ini file example: $HOME/.aws/credentials
  
* A AssumeRoleTokenProvider with enabled SharedConfigState which uses MFA prompting for token code on stdin.
  Go to [session doc][session] for more details.

You can also set different profile names for each S3 config, so you may be able
to push to buckets in different accounts, for example.

[auth]: https://docs.aws.amazon.com/cli/latest/userguide/cli-chap-getting-started.html
[envProvider]: https://docs.aws.amazon.com/sdk-for-go/api/aws/credentials/#EnvProvider
[sharedCredentialsProvider]: https://docs.aws.amazon.com/sdk-for-go/api/aws/credentials/#SharedCredentialsProvider
[session]: https://docs.aws.amazon.com/sdk-for-go/api/aws/session/
