// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"time"

	v1 "github.com/openshift/hive/pkg/apis/hive/v1"
	scheme "github.com/openshift/hive/pkg/client/clientset-generated/clientset/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// SelectorSyncIdentityProvidersGetter has a method to return a SelectorSyncIdentityProviderInterface.
// A group's client should implement this interface.
type SelectorSyncIdentityProvidersGetter interface {
	SelectorSyncIdentityProviders() SelectorSyncIdentityProviderInterface
}

// SelectorSyncIdentityProviderInterface has methods to work with SelectorSyncIdentityProvider resources.
type SelectorSyncIdentityProviderInterface interface {
	Create(*v1.SelectorSyncIdentityProvider) (*v1.SelectorSyncIdentityProvider, error)
	Update(*v1.SelectorSyncIdentityProvider) (*v1.SelectorSyncIdentityProvider, error)
	UpdateStatus(*v1.SelectorSyncIdentityProvider) (*v1.SelectorSyncIdentityProvider, error)
	Delete(name string, options *metav1.DeleteOptions) error
	DeleteCollection(options *metav1.DeleteOptions, listOptions metav1.ListOptions) error
	Get(name string, options metav1.GetOptions) (*v1.SelectorSyncIdentityProvider, error)
	List(opts metav1.ListOptions) (*v1.SelectorSyncIdentityProviderList, error)
	Watch(opts metav1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.SelectorSyncIdentityProvider, err error)
	SelectorSyncIdentityProviderExpansion
}

// selectorSyncIdentityProviders implements SelectorSyncIdentityProviderInterface
type selectorSyncIdentityProviders struct {
	client rest.Interface
}

// newSelectorSyncIdentityProviders returns a SelectorSyncIdentityProviders
func newSelectorSyncIdentityProviders(c *HiveV1Client) *selectorSyncIdentityProviders {
	return &selectorSyncIdentityProviders{
		client: c.RESTClient(),
	}
}

// Get takes name of the selectorSyncIdentityProvider, and returns the corresponding selectorSyncIdentityProvider object, and an error if there is any.
func (c *selectorSyncIdentityProviders) Get(name string, options metav1.GetOptions) (result *v1.SelectorSyncIdentityProvider, err error) {
	result = &v1.SelectorSyncIdentityProvider{}
	err = c.client.Get().
		Resource("selectorsyncidentityproviders").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of SelectorSyncIdentityProviders that match those selectors.
func (c *selectorSyncIdentityProviders) List(opts metav1.ListOptions) (result *v1.SelectorSyncIdentityProviderList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.SelectorSyncIdentityProviderList{}
	err = c.client.Get().
		Resource("selectorsyncidentityproviders").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested selectorSyncIdentityProviders.
func (c *selectorSyncIdentityProviders) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("selectorsyncidentityproviders").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch()
}

// Create takes the representation of a selectorSyncIdentityProvider and creates it.  Returns the server's representation of the selectorSyncIdentityProvider, and an error, if there is any.
func (c *selectorSyncIdentityProviders) Create(selectorSyncIdentityProvider *v1.SelectorSyncIdentityProvider) (result *v1.SelectorSyncIdentityProvider, err error) {
	result = &v1.SelectorSyncIdentityProvider{}
	err = c.client.Post().
		Resource("selectorsyncidentityproviders").
		Body(selectorSyncIdentityProvider).
		Do().
		Into(result)
	return
}

// Update takes the representation of a selectorSyncIdentityProvider and updates it. Returns the server's representation of the selectorSyncIdentityProvider, and an error, if there is any.
func (c *selectorSyncIdentityProviders) Update(selectorSyncIdentityProvider *v1.SelectorSyncIdentityProvider) (result *v1.SelectorSyncIdentityProvider, err error) {
	result = &v1.SelectorSyncIdentityProvider{}
	err = c.client.Put().
		Resource("selectorsyncidentityproviders").
		Name(selectorSyncIdentityProvider.Name).
		Body(selectorSyncIdentityProvider).
		Do().
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().

func (c *selectorSyncIdentityProviders) UpdateStatus(selectorSyncIdentityProvider *v1.SelectorSyncIdentityProvider) (result *v1.SelectorSyncIdentityProvider, err error) {
	result = &v1.SelectorSyncIdentityProvider{}
	err = c.client.Put().
		Resource("selectorsyncidentityproviders").
		Name(selectorSyncIdentityProvider.Name).
		SubResource("status").
		Body(selectorSyncIdentityProvider).
		Do().
		Into(result)
	return
}

// Delete takes name of the selectorSyncIdentityProvider and deletes it. Returns an error if one occurs.
func (c *selectorSyncIdentityProviders) Delete(name string, options *metav1.DeleteOptions) error {
	return c.client.Delete().
		Resource("selectorsyncidentityproviders").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *selectorSyncIdentityProviders) DeleteCollection(options *metav1.DeleteOptions, listOptions metav1.ListOptions) error {
	var timeout time.Duration
	if listOptions.TimeoutSeconds != nil {
		timeout = time.Duration(*listOptions.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("selectorsyncidentityproviders").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Timeout(timeout).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched selectorSyncIdentityProvider.
func (c *selectorSyncIdentityProviders) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.SelectorSyncIdentityProvider, err error) {
	result = &v1.SelectorSyncIdentityProvider{}
	err = c.client.Patch(pt).
		Resource("selectorsyncidentityproviders").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
