// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package alexaforbusiness

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateBusinessReportScheduleRequest
type CreateBusinessReportScheduleInput struct {
	_ struct{} `type:"structure"`

	// The client request token.
	ClientRequestToken *string `min:"10" type:"string" idempotencyToken:"true"`

	// The content range of the reports.
	//
	// ContentRange is a required field
	ContentRange *BusinessReportContentRange `type:"structure" required:"true"`

	// The format of the generated report (individual CSV files or zipped files
	// of individual files).
	//
	// Format is a required field
	Format BusinessReportFormat `type:"string" required:"true" enum:"true"`

	// The recurrence of the reports. If this isn't specified, the report will only
	// be delivered one time when the API is called.
	Recurrence *BusinessReportRecurrence `type:"structure"`

	// The S3 bucket name of the output reports. If this isn't specified, the report
	// can be retrieved from a download link by calling ListBusinessReportSchedule.
	S3BucketName *string `type:"string"`

	// The S3 key where the report is delivered.
	S3KeyPrefix *string `type:"string"`

	// The name identifier of the schedule.
	ScheduleName *string `type:"string"`
}

// String returns the string representation
func (s CreateBusinessReportScheduleInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateBusinessReportScheduleInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateBusinessReportScheduleInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 10 {
		invalidParams.Add(aws.NewErrParamMinLen("ClientRequestToken", 10))
	}

	if s.ContentRange == nil {
		invalidParams.Add(aws.NewErrParamRequired("ContentRange"))
	}
	if len(s.Format) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Format"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateBusinessReportScheduleResponse
type CreateBusinessReportScheduleOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the business report schedule.
	ScheduleArn *string `type:"string"`
}

// String returns the string representation
func (s CreateBusinessReportScheduleOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateBusinessReportSchedule = "CreateBusinessReportSchedule"

// CreateBusinessReportScheduleRequest returns a request value for making API operation for
// Alexa For Business.
//
// Creates a recurring schedule for usage reports to deliver to the specified
// S3 location with a specified daily or weekly interval.
//
//    // Example sending a request using CreateBusinessReportScheduleRequest.
//    req := client.CreateBusinessReportScheduleRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateBusinessReportSchedule
func (c *Client) CreateBusinessReportScheduleRequest(input *CreateBusinessReportScheduleInput) CreateBusinessReportScheduleRequest {
	op := &aws.Operation{
		Name:       opCreateBusinessReportSchedule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateBusinessReportScheduleInput{}
	}

	req := c.newRequest(op, input, &CreateBusinessReportScheduleOutput{})
	return CreateBusinessReportScheduleRequest{Request: req, Input: input, Copy: c.CreateBusinessReportScheduleRequest}
}

// CreateBusinessReportScheduleRequest is the request type for the
// CreateBusinessReportSchedule API operation.
type CreateBusinessReportScheduleRequest struct {
	*aws.Request
	Input *CreateBusinessReportScheduleInput
	Copy  func(*CreateBusinessReportScheduleInput) CreateBusinessReportScheduleRequest
}

// Send marshals and sends the CreateBusinessReportSchedule API request.
func (r CreateBusinessReportScheduleRequest) Send(ctx context.Context) (*CreateBusinessReportScheduleResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateBusinessReportScheduleResponse{
		CreateBusinessReportScheduleOutput: r.Request.Data.(*CreateBusinessReportScheduleOutput),
		response:                           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateBusinessReportScheduleResponse is the response type for the
// CreateBusinessReportSchedule API operation.
type CreateBusinessReportScheduleResponse struct {
	*CreateBusinessReportScheduleOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateBusinessReportSchedule request.
func (r *CreateBusinessReportScheduleResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
