// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package alexaforbusiness

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateProfileRequest
type UpdateProfileInput struct {
	_ struct{} `type:"structure"`

	// The updated address for the room profile.
	Address *string `min:"1" type:"string"`

	// The updated distance unit for the room profile.
	DistanceUnit DistanceUnit `type:"string" enum:"true"`

	// Sets the profile as default if selected. If this is missing, no update is
	// done to the default status.
	IsDefault *bool `type:"boolean"`

	// The updated maximum volume limit for the room profile.
	MaxVolumeLimit *int64 `type:"integer"`

	// Whether the PSTN setting of the room profile is enabled.
	PSTNEnabled *bool `type:"boolean"`

	// The ARN of the room profile to update. Required.
	ProfileArn *string `type:"string"`

	// The updated name for the room profile.
	ProfileName *string `min:"1" type:"string"`

	// Whether the setup mode of the profile is enabled.
	SetupModeDisabled *bool `type:"boolean"`

	// The updated temperature unit for the room profile.
	TemperatureUnit TemperatureUnit `type:"string" enum:"true"`

	// The updated timezone for the room profile.
	Timezone *string `min:"1" type:"string"`

	// The updated wake word for the room profile.
	WakeWord WakeWord `type:"string" enum:"true"`
}

// String returns the string representation
func (s UpdateProfileInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateProfileInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateProfileInput"}
	if s.Address != nil && len(*s.Address) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Address", 1))
	}
	if s.ProfileName != nil && len(*s.ProfileName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ProfileName", 1))
	}
	if s.Timezone != nil && len(*s.Timezone) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Timezone", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateProfileResponse
type UpdateProfileOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateProfileOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateProfile = "UpdateProfile"

// UpdateProfileRequest returns a request value for making API operation for
// Alexa For Business.
//
// Updates an existing room profile by room profile ARN.
//
//    // Example sending a request using UpdateProfileRequest.
//    req := client.UpdateProfileRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateProfile
func (c *Client) UpdateProfileRequest(input *UpdateProfileInput) UpdateProfileRequest {
	op := &aws.Operation{
		Name:       opUpdateProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateProfileInput{}
	}

	req := c.newRequest(op, input, &UpdateProfileOutput{})
	return UpdateProfileRequest{Request: req, Input: input, Copy: c.UpdateProfileRequest}
}

// UpdateProfileRequest is the request type for the
// UpdateProfile API operation.
type UpdateProfileRequest struct {
	*aws.Request
	Input *UpdateProfileInput
	Copy  func(*UpdateProfileInput) UpdateProfileRequest
}

// Send marshals and sends the UpdateProfile API request.
func (r UpdateProfileRequest) Send(ctx context.Context) (*UpdateProfileResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateProfileResponse{
		UpdateProfileOutput: r.Request.Data.(*UpdateProfileOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateProfileResponse is the response type for the
// UpdateProfile API operation.
type UpdateProfileResponse struct {
	*UpdateProfileOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateProfile request.
func (r *UpdateProfileResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
