// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package apigatewayv2

import (
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

var _ aws.Config
var _ = awsutil.Prettify

// Settings for logging access in a stage.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/AccessLogSettings
type AccessLogSettings struct {
	_ struct{} `type:"structure"`

	// The ARN of the CloudWatch Logs log group to receive access logs.
	DestinationArn *string `locationName:"destinationArn" type:"string"`

	// A single line format of the access logs of data, as specified by selected
	// $context variables. The format must include at least $context.requestId.
	Format *string `locationName:"format" type:"string"`
}

// String returns the string representation
func (s AccessLogSettings) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AccessLogSettings) MarshalFields(e protocol.FieldEncoder) error {
	if s.DestinationArn != nil {
		v := *s.DestinationArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "destinationArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Format != nil {
		v := *s.Format

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "format", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Represents an API.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/Api
type Api struct {
	_ struct{} `type:"structure"`

	// The URI of the API, of the form {api-id}.execute-api.{region}.amazonaws.com.
	// The stage name is typically appended to this URI to form a complete path
	// to a deployed API stage.
	ApiEndpoint *string `locationName:"apiEndpoint" type:"string"`

	// The API ID.
	ApiId *string `locationName:"apiId" type:"string"`

	// An API key selection expression. See API Key Selection Expressions (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions).
	ApiKeySelectionExpression *string `locationName:"apiKeySelectionExpression" type:"string"`

	// The timestamp when the API was created.
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp" timestampFormat:"unix"`

	// The description of the API.
	Description *string `locationName:"description" type:"string"`

	// Avoid validating models when creating a deployment.
	DisableSchemaValidation *bool `locationName:"disableSchemaValidation" type:"boolean"`

	// The name of the API.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The API protocol: Currently only WEBSOCKET is supported.
	//
	// ProtocolType is a required field
	ProtocolType ProtocolType `locationName:"protocolType" type:"string" required:"true" enum:"true"`

	// The route selection expression for the API.
	//
	// RouteSelectionExpression is a required field
	RouteSelectionExpression *string `locationName:"routeSelectionExpression" type:"string" required:"true"`

	// A version identifier for the API.
	Version *string `locationName:"version" type:"string"`

	// The warning messages reported when failonwarnings is turned on during API
	// import.
	Warnings []string `locationName:"warnings" type:"list"`
}

// String returns the string representation
func (s Api) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Api) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApiEndpoint != nil {
		v := *s.ApiEndpoint

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "apiEndpoint", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ApiId != nil {
		v := *s.ApiId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "apiId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ApiKeySelectionExpression != nil {
		v := *s.ApiKeySelectionExpression

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "apiKeySelectionExpression", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreatedDate != nil {
		v := *s.CreatedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "createdDate", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DisableSchemaValidation != nil {
		v := *s.DisableSchemaValidation

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "disableSchemaValidation", protocol.BoolValue(v), metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ProtocolType) > 0 {
		v := s.ProtocolType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "protocolType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.RouteSelectionExpression != nil {
		v := *s.RouteSelectionExpression

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "routeSelectionExpression", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "version", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Warnings) > 0 {
		v := s.Warnings

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "warnings", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// Represents an API mapping.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/ApiMapping
type ApiMapping struct {
	_ struct{} `type:"structure"`

	// The API identifier.
	//
	// ApiId is a required field
	ApiId *string `locationName:"apiId" type:"string" required:"true"`

	// The API mapping identifier.
	ApiMappingId *string `locationName:"apiMappingId" type:"string"`

	// The API mapping key.
	ApiMappingKey *string `locationName:"apiMappingKey" type:"string"`

	// The API stage.
	//
	// Stage is a required field
	Stage *string `locationName:"stage" type:"string" required:"true"`
}

// String returns the string representation
func (s ApiMapping) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ApiMapping) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApiId != nil {
		v := *s.ApiId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "apiId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ApiMappingId != nil {
		v := *s.ApiMappingId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "apiMappingId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ApiMappingKey != nil {
		v := *s.ApiMappingKey

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "apiMappingKey", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Stage != nil {
		v := *s.Stage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "stage", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Represents an authorizer.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/Authorizer
type Authorizer struct {
	_ struct{} `type:"structure"`

	// Specifies the required credentials as an IAM role for API Gateway to invoke
	// the authorizer. To specify an IAM role for API Gateway to assume, use the
	// role's Amazon Resource Name (ARN). To use resource-based permissions on the
	// Lambda function, specify null.
	AuthorizerCredentialsArn *string `locationName:"authorizerCredentialsArn" type:"string"`

	// The authorizer identifier.
	AuthorizerId *string `locationName:"authorizerId" type:"string"`

	// The time to live (TTL), in seconds, of cached authorizer results. If it equals
	// 0, authorization caching is disabled. If it is greater than 0, API Gateway
	// will cache authorizer responses. If this field is not set, the default value
	// is 300. The maximum value is 3600, or 1 hour.
	AuthorizerResultTtlInSeconds *int64 `locationName:"authorizerResultTtlInSeconds" type:"integer"`

	// The authorizer type. Currently the only valid value is REQUEST, for a Lambda
	// function using incoming request parameters.
	AuthorizerType AuthorizerType `locationName:"authorizerType" type:"string" enum:"true"`

	// The authorizer's Uniform Resource Identifier (URI). ForREQUEST authorizers,
	// this must be a well-formed Lambda function URI, for example, arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:{account_id}:function:{lambda_function_name}/invocations.
	// In general, the URI has this form: arn:aws:apigateway:{region}:lambda:path/{service_api}
	// , where {region} is the same as the region hosting the Lambda function, path
	// indicates that the remaining substring in the URI should be treated as the
	// path to the resource, including the initial /. For Lambda functions, this
	// is usually of the form /2015-03-31/functions/[FunctionARN]/invocations.
	AuthorizerUri *string `locationName:"authorizerUri" type:"string"`

	// The identity source for which authorization is requested.
	//
	// For the REQUEST authorizer, this is required when authorization caching is
	// enabled. The value is a comma-separated string of one or more mapping expressions
	// of the specified request parameters. For example, if an Auth header and a
	// Name query string parameters are defined as identity sources, this value
	// is method.request.header.Auth, method.request.querystring.Name. These parameters
	// will be used to derive the authorization caching key and to perform runtime
	// validation of the REQUEST authorizer by verifying all of the identity-related
	// request parameters are present, not null, and non-empty. Only when this is
	// true does the authorizer invoke the authorizer Lambda function, otherwise,
	// it returns a 401 Unauthorized response without calling the Lambda function.
	// The valid value is a string of comma-separated mapping expressions of the
	// specified request parameters. When the authorization caching is not enabled,
	// this property is optional.
	IdentitySource []string `locationName:"identitySource" type:"list"`

	// The validation expression does not apply to the REQUEST authorizer.
	IdentityValidationExpression *string `locationName:"identityValidationExpression" type:"string"`

	// The name of the authorizer.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// For REQUEST authorizer, this is not defined.
	ProviderArns []string `locationName:"providerArns" type:"list"`
}

// String returns the string representation
func (s Authorizer) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Authorizer) MarshalFields(e protocol.FieldEncoder) error {
	if s.AuthorizerCredentialsArn != nil {
		v := *s.AuthorizerCredentialsArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "authorizerCredentialsArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AuthorizerId != nil {
		v := *s.AuthorizerId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "authorizerId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AuthorizerResultTtlInSeconds != nil {
		v := *s.AuthorizerResultTtlInSeconds

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "authorizerResultTtlInSeconds", protocol.Int64Value(v), metadata)
	}
	if len(s.AuthorizerType) > 0 {
		v := s.AuthorizerType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "authorizerType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.AuthorizerUri != nil {
		v := *s.AuthorizerUri

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "authorizerUri", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.IdentitySource) > 0 {
		v := s.IdentitySource

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "identitySource", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.IdentityValidationExpression != nil {
		v := *s.IdentityValidationExpression

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "identityValidationExpression", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ProviderArns) > 0 {
		v := s.ProviderArns

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "providerArns", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// An immutable representation of an API that can be called by users. A Deployment
// must be associated with a Stage for it to be callable over the internet.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/Deployment
type Deployment struct {
	_ struct{} `type:"structure"`

	// The date and time when the Deployment resource was created.
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp" timestampFormat:"unix"`

	// The identifier for the deployment.
	DeploymentId *string `locationName:"deploymentId" type:"string"`

	// The status of the deployment: PENDING, FAILED, or SUCCEEDED.
	DeploymentStatus DeploymentStatus `locationName:"deploymentStatus" type:"string" enum:"true"`

	// May contain additional feedback on the status of an API deployment.
	DeploymentStatusMessage *string `locationName:"deploymentStatusMessage" type:"string"`

	// The description for the deployment.
	Description *string `locationName:"description" type:"string"`
}

// String returns the string representation
func (s Deployment) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Deployment) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreatedDate != nil {
		v := *s.CreatedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "createdDate", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.DeploymentId != nil {
		v := *s.DeploymentId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "deploymentId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.DeploymentStatus) > 0 {
		v := s.DeploymentStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "deploymentStatus", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.DeploymentStatusMessage != nil {
		v := *s.DeploymentStatusMessage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "deploymentStatusMessage", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Represents a domain name.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/DomainName
type DomainName struct {
	_ struct{} `type:"structure"`

	// The API mapping selection expression.
	ApiMappingSelectionExpression *string `locationName:"apiMappingSelectionExpression" type:"string"`

	// The name of the DomainName resource.
	//
	// DomainName is a required field
	DomainName *string `locationName:"domainName" type:"string" required:"true"`

	// The domain name configurations.
	DomainNameConfigurations []DomainNameConfiguration `locationName:"domainNameConfigurations" type:"list"`
}

// String returns the string representation
func (s DomainName) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DomainName) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApiMappingSelectionExpression != nil {
		v := *s.ApiMappingSelectionExpression

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "apiMappingSelectionExpression", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DomainName != nil {
		v := *s.DomainName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "domainName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.DomainNameConfigurations) > 0 {
		v := s.DomainNameConfigurations

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "domainNameConfigurations", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// The domain name configuration.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/DomainNameConfiguration
type DomainNameConfiguration struct {
	_ struct{} `type:"structure"`

	// A domain name for the WebSocket API.
	ApiGatewayDomainName *string `locationName:"apiGatewayDomainName" type:"string"`

	// An AWS-managed certificate that will be used by the edge-optimized endpoint
	// for this domain name. AWS Certificate Manager is the only supported source.
	CertificateArn *string `locationName:"certificateArn" type:"string"`

	// The user-friendly name of the certificate that will be used by the edge-optimized
	// endpoint for this domain name.
	CertificateName *string `locationName:"certificateName" type:"string"`

	// The timestamp when the certificate that was used by edge-optimized endpoint
	// for this domain name was uploaded.
	CertificateUploadDate *time.Time `locationName:"certificateUploadDate" type:"timestamp" timestampFormat:"unix"`

	// The endpoint type.
	EndpointType EndpointType `locationName:"endpointType" type:"string" enum:"true"`

	// The Amazon Route 53 Hosted Zone ID of the endpoint.
	HostedZoneId *string `locationName:"hostedZoneId" type:"string"`
}

// String returns the string representation
func (s DomainNameConfiguration) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DomainNameConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApiGatewayDomainName != nil {
		v := *s.ApiGatewayDomainName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "apiGatewayDomainName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CertificateArn != nil {
		v := *s.CertificateArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "certificateArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CertificateName != nil {
		v := *s.CertificateName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "certificateName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CertificateUploadDate != nil {
		v := *s.CertificateUploadDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "certificateUploadDate", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if len(s.EndpointType) > 0 {
		v := s.EndpointType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "endpointType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.HostedZoneId != nil {
		v := *s.HostedZoneId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "hostedZoneId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Represents an integration.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/Integration
type Integration struct {
	_ struct{} `type:"structure"`

	// The connection ID.
	ConnectionId *string `locationName:"connectionId" type:"string"`

	// The type of the network connection to the integration endpoint. Currently
	// the only valid value is INTERNET, for connections through the public routable
	// internet.
	ConnectionType ConnectionType `locationName:"connectionType" type:"string" enum:"true"`

	// Specifies how to handle response payload content type conversions. Supported
	// values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:
	//
	// CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string
	// to the corresponding binary blob.
	//
	// CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded
	// string.
	//
	// If this property is not defined, the response payload will be passed through
	// from the integration response to the route response or method response without
	// modification.
	ContentHandlingStrategy ContentHandlingStrategy `locationName:"contentHandlingStrategy" type:"string" enum:"true"`

	// Specifies the credentials required for the integration, if any. For AWS integrations,
	// three options are available. To specify an IAM Role for API Gateway to assume,
	// use the role's Amazon Resource Name (ARN). To require that the caller's identity
	// be passed through from the request, specify the string arn:aws:iam::*:user/*.
	// To use resource-based permissions on supported AWS services, specify null.
	CredentialsArn *string `locationName:"credentialsArn" type:"string"`

	// Represents the description of an integration.
	Description *string `locationName:"description" type:"string"`

	// Represents the identifier of an integration.
	IntegrationId *string `locationName:"integrationId" type:"string"`

	// Specifies the integration's HTTP method type.
	IntegrationMethod *string `locationName:"integrationMethod" type:"string"`

	// The integration response selection expression for the integration. See Integration
	// Response Selection Expressions (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-integration-response-selection-expressions).
	IntegrationResponseSelectionExpression *string `locationName:"integrationResponseSelectionExpression" type:"string"`

	// The integration type of an integration. One of the following:
	//
	// AWS: for integrating the route or method request with an AWS service action,
	// including the Lambda function-invoking action. With the Lambda function-invoking
	// action, this is referred to as the Lambda custom integration. With any other
	// AWS service action, this is known as AWS integration.
	//
	// AWS_PROXY: for integrating the route or method request with the Lambda function-invoking
	// action with the client request passed through as-is. This integration is
	// also referred to as Lambda proxy integration.
	//
	// HTTP: for integrating the route or method request with an HTTP endpoint.
	// This integration is also referred to as the HTTP custom integration.
	//
	// HTTP_PROXY: for integrating route or method request with an HTTP endpoint,
	// with the client request passed through as-is. This is also referred to as
	// HTTP proxy integration.
	//
	// MOCK: for integrating the route or method request with API Gateway as a "loopback"
	// endpoint without invoking any backend.
	IntegrationType IntegrationType `locationName:"integrationType" type:"string" enum:"true"`

	// For a Lambda proxy integration, this is the URI of the Lambda function.
	IntegrationUri *string `locationName:"integrationUri" type:"string"`

	// Specifies the pass-through behavior for incoming requests based on the Content-Type
	// header in the request, and the available mapping templates specified as the
	// requestTemplates property on the Integration resource. There are three valid
	// values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER.
	//
	// WHEN_NO_MATCH passes the request body for unmapped content types through
	// to the integration backend without transformation.
	//
	// NEVER rejects unmapped content types with an HTTP 415 Unsupported Media Type
	// response.
	//
	// WHEN_NO_TEMPLATES allows pass-through when the integration has no content
	// types mapped to templates. However, if there is at least one content type
	// defined, unmapped content types will be rejected with the same HTTP 415 Unsupported
	// Media Type response.
	PassthroughBehavior PassthroughBehavior `locationName:"passthroughBehavior" type:"string" enum:"true"`

	// A key-value map specifying request parameters that are passed from the method
	// request to the backend. The key is an integration request parameter name
	// and the associated value is a method request parameter value or static value
	// that must be enclosed within single quotes and pre-encoded as required by
	// the backend. The method request parameter value must match the pattern of
	// method.request.{location}.{name} , where {location} is querystring, path,
	// or header; and {name} must be a valid and unique method request parameter
	// name.
	RequestParameters map[string]string `locationName:"requestParameters" type:"map"`

	// Represents a map of Velocity templates that are applied on the request payload
	// based on the value of the Content-Type header sent by the client. The content
	// type value is the key in this map, and the template (as a String) is the
	// value.
	RequestTemplates map[string]string `locationName:"requestTemplates" type:"map"`

	// The template selection expression for the integration.
	TemplateSelectionExpression *string `locationName:"templateSelectionExpression" type:"string"`

	// Custom timeout between 50 and 29,000 milliseconds. The default value is 29,000
	// milliseconds or 29 seconds.
	TimeoutInMillis *int64 `locationName:"timeoutInMillis" min:"50" type:"integer"`
}

// String returns the string representation
func (s Integration) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Integration) MarshalFields(e protocol.FieldEncoder) error {
	if s.ConnectionId != nil {
		v := *s.ConnectionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "connectionId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ConnectionType) > 0 {
		v := s.ConnectionType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "connectionType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.ContentHandlingStrategy) > 0 {
		v := s.ContentHandlingStrategy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "contentHandlingStrategy", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.CredentialsArn != nil {
		v := *s.CredentialsArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "credentialsArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IntegrationId != nil {
		v := *s.IntegrationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "integrationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IntegrationMethod != nil {
		v := *s.IntegrationMethod

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "integrationMethod", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IntegrationResponseSelectionExpression != nil {
		v := *s.IntegrationResponseSelectionExpression

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "integrationResponseSelectionExpression", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.IntegrationType) > 0 {
		v := s.IntegrationType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "integrationType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.IntegrationUri != nil {
		v := *s.IntegrationUri

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "integrationUri", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.PassthroughBehavior) > 0 {
		v := s.PassthroughBehavior

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "passthroughBehavior", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.RequestParameters) > 0 {
		v := s.RequestParameters

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "requestParameters", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if len(s.RequestTemplates) > 0 {
		v := s.RequestTemplates

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "requestTemplates", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.TemplateSelectionExpression != nil {
		v := *s.TemplateSelectionExpression

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "templateSelectionExpression", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TimeoutInMillis != nil {
		v := *s.TimeoutInMillis

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "timeoutInMillis", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Represents an integration response.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/IntegrationResponse
type IntegrationResponse struct {
	_ struct{} `type:"structure"`

	// Specifies how to handle response payload content type conversions. Supported
	// values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:
	//
	// CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string
	// to the corresponding binary blob.
	//
	// CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded
	// string.
	//
	// If this property is not defined, the response payload will be passed through
	// from the integration response to the route response or method response without
	// modification.
	ContentHandlingStrategy ContentHandlingStrategy `locationName:"contentHandlingStrategy" type:"string" enum:"true"`

	// The integration response ID.
	IntegrationResponseId *string `locationName:"integrationResponseId" type:"string"`

	// The integration response key.
	//
	// IntegrationResponseKey is a required field
	IntegrationResponseKey *string `locationName:"integrationResponseKey" type:"string" required:"true"`

	// A key-value map specifying response parameters that are passed to the method
	// response from the backend. The key is a method response header parameter
	// name and the mapped value is an integration response header value, a static
	// value enclosed within a pair of single quotes, or a JSON expression from
	// the integration response body. The mapping key must match the pattern of
	// method.response.header.{name}, where name is a valid and unique header name.
	// The mapped non-static value must match the pattern of integration.response.header.{name}
	// or integration.response.body.{JSON-expression}, where name is a valid and
	// unique response header name and JSON-expression is a valid JSON expression
	// without the $ prefix.
	ResponseParameters map[string]string `locationName:"responseParameters" type:"map"`

	// The collection of response templates for the integration response as a string-to-string
	// map of key-value pairs. Response templates are represented as a key/value
	// map, with a content-type as the key and a template as the value.
	ResponseTemplates map[string]string `locationName:"responseTemplates" type:"map"`

	// The template selection expressions for the integration response.
	TemplateSelectionExpression *string `locationName:"templateSelectionExpression" type:"string"`
}

// String returns the string representation
func (s IntegrationResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s IntegrationResponse) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.ContentHandlingStrategy) > 0 {
		v := s.ContentHandlingStrategy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "contentHandlingStrategy", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.IntegrationResponseId != nil {
		v := *s.IntegrationResponseId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "integrationResponseId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IntegrationResponseKey != nil {
		v := *s.IntegrationResponseKey

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "integrationResponseKey", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ResponseParameters) > 0 {
		v := s.ResponseParameters

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "responseParameters", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if len(s.ResponseTemplates) > 0 {
		v := s.ResponseTemplates

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "responseTemplates", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.TemplateSelectionExpression != nil {
		v := *s.TemplateSelectionExpression

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "templateSelectionExpression", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Represents a data model for an API. See Create Models and Mapping Templates
// for Request and Response Mappings (https://docs.aws.amazon.com/apigateway/latest/developerguide/models-mappings.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/Model
type Model struct {
	_ struct{} `type:"structure"`

	// The content-type for the model, for example, "application/json".
	ContentType *string `locationName:"contentType" type:"string"`

	// The description of the model.
	Description *string `locationName:"description" type:"string"`

	// The model identifier.
	ModelId *string `locationName:"modelId" type:"string"`

	// The name of the model. Must be alphanumeric.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The schema for the model. For application/json models, this should be JSON
	// schema draft 4 model.
	Schema *string `locationName:"schema" type:"string"`
}

// String returns the string representation
func (s Model) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Model) MarshalFields(e protocol.FieldEncoder) error {
	if s.ContentType != nil {
		v := *s.ContentType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "contentType", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ModelId != nil {
		v := *s.ModelId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "modelId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Schema != nil {
		v := *s.Schema

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "schema", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Validation constraints imposed on parameters of a request (path, query string,
// headers).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/ParameterConstraints
type ParameterConstraints struct {
	_ struct{} `type:"structure"`

	// Whether or not the parameter is required.
	Required *bool `locationName:"required" type:"boolean"`
}

// String returns the string representation
func (s ParameterConstraints) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ParameterConstraints) MarshalFields(e protocol.FieldEncoder) error {
	if s.Required != nil {
		v := *s.Required

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "required", protocol.BoolValue(v), metadata)
	}
	return nil
}

// Represents a route.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/Route
type Route struct {
	_ struct{} `type:"structure"`

	// Specifies whether an API key is required for this route.
	ApiKeyRequired *bool `locationName:"apiKeyRequired" type:"boolean"`

	// A list of authorization scopes configured on a route. The scopes are used
	// with a COGNITO_USER_POOLS authorizer to authorize the method invocation.
	// The authorization works by matching the route scopes against the scopes parsed
	// from the access token in the incoming request. The method invocation is authorized
	// if any route scope matches a claimed scope in the access token. Otherwise,
	// the invocation is not authorized. When the route scope is configured, the
	// client must provide an access token instead of an identity token for authorization
	// purposes.
	AuthorizationScopes []string `locationName:"authorizationScopes" type:"list"`

	// The authorization type for the route. Valid values are NONE for open access,
	// AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer
	AuthorizationType AuthorizationType `locationName:"authorizationType" type:"string" enum:"true"`

	// The identifier of the Authorizer resource to be associated with this route,
	// if the authorizationType is CUSTOM . The authorizer identifier is generated
	// by API Gateway when you created the authorizer.
	AuthorizerId *string `locationName:"authorizerId" type:"string"`

	// The model selection expression for the route.
	ModelSelectionExpression *string `locationName:"modelSelectionExpression" type:"string"`

	// The operation name for the route.
	OperationName *string `locationName:"operationName" type:"string"`

	// The request models for the route.
	RequestModels map[string]string `locationName:"requestModels" type:"map"`

	// The request parameters for the route.
	RequestParameters map[string]ParameterConstraints `locationName:"requestParameters" type:"map"`

	// The route ID.
	RouteId *string `locationName:"routeId" type:"string"`

	// The route key for the route.
	//
	// RouteKey is a required field
	RouteKey *string `locationName:"routeKey" type:"string" required:"true"`

	// The route response selection expression for the route.
	RouteResponseSelectionExpression *string `locationName:"routeResponseSelectionExpression" type:"string"`

	// The target for the route.
	Target *string `locationName:"target" type:"string"`
}

// String returns the string representation
func (s Route) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Route) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApiKeyRequired != nil {
		v := *s.ApiKeyRequired

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "apiKeyRequired", protocol.BoolValue(v), metadata)
	}
	if len(s.AuthorizationScopes) > 0 {
		v := s.AuthorizationScopes

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "authorizationScopes", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if len(s.AuthorizationType) > 0 {
		v := s.AuthorizationType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "authorizationType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.AuthorizerId != nil {
		v := *s.AuthorizerId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "authorizerId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ModelSelectionExpression != nil {
		v := *s.ModelSelectionExpression

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "modelSelectionExpression", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.OperationName != nil {
		v := *s.OperationName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "operationName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.RequestModels) > 0 {
		v := s.RequestModels

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "requestModels", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if len(s.RequestParameters) > 0 {
		v := s.RequestParameters

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "requestParameters", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetFields(k1, v1)
		}
		ms0.End()

	}
	if s.RouteId != nil {
		v := *s.RouteId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "routeId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RouteKey != nil {
		v := *s.RouteKey

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "routeKey", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RouteResponseSelectionExpression != nil {
		v := *s.RouteResponseSelectionExpression

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "routeResponseSelectionExpression", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Target != nil {
		v := *s.Target

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "target", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Represents a route response.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/RouteResponse
type RouteResponse struct {
	_ struct{} `type:"structure"`

	// Represents the model selection expression of a route response.
	ModelSelectionExpression *string `locationName:"modelSelectionExpression" type:"string"`

	// Represents the response models of a route response.
	ResponseModels map[string]string `locationName:"responseModels" type:"map"`

	// Represents the response parameters of a route response.
	ResponseParameters map[string]ParameterConstraints `locationName:"responseParameters" type:"map"`

	// Represents the identifier of a route response.
	RouteResponseId *string `locationName:"routeResponseId" type:"string"`

	// Represents the route response key of a route response.
	//
	// RouteResponseKey is a required field
	RouteResponseKey *string `locationName:"routeResponseKey" type:"string" required:"true"`
}

// String returns the string representation
func (s RouteResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RouteResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.ModelSelectionExpression != nil {
		v := *s.ModelSelectionExpression

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "modelSelectionExpression", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ResponseModels) > 0 {
		v := s.ResponseModels

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "responseModels", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if len(s.ResponseParameters) > 0 {
		v := s.ResponseParameters

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "responseParameters", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetFields(k1, v1)
		}
		ms0.End()

	}
	if s.RouteResponseId != nil {
		v := *s.RouteResponseId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "routeResponseId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RouteResponseKey != nil {
		v := *s.RouteResponseKey

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "routeResponseKey", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Represents a collection of route settings.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/RouteSettings
type RouteSettings struct {
	_ struct{} `type:"structure"`

	// Specifies whether (true) or not (false) data trace logging is enabled for
	// this route. This property affects the log entries pushed to Amazon CloudWatch
	// Logs.
	DataTraceEnabled *bool `locationName:"dataTraceEnabled" type:"boolean"`

	// Specifies whether detailed metrics are enabled.
	DetailedMetricsEnabled *bool `locationName:"detailedMetricsEnabled" type:"boolean"`

	// Specifies the logging level for this route: DEBUG, INFO, or WARN. This property
	// affects the log entries pushed to Amazon CloudWatch Logs.
	LoggingLevel LoggingLevel `locationName:"loggingLevel" type:"string" enum:"true"`

	// Specifies the throttling burst limit.
	ThrottlingBurstLimit *int64 `locationName:"throttlingBurstLimit" type:"integer"`

	// Specifies the throttling rate limit.
	ThrottlingRateLimit *float64 `locationName:"throttlingRateLimit" type:"double"`
}

// String returns the string representation
func (s RouteSettings) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RouteSettings) MarshalFields(e protocol.FieldEncoder) error {
	if s.DataTraceEnabled != nil {
		v := *s.DataTraceEnabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "dataTraceEnabled", protocol.BoolValue(v), metadata)
	}
	if s.DetailedMetricsEnabled != nil {
		v := *s.DetailedMetricsEnabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "detailedMetricsEnabled", protocol.BoolValue(v), metadata)
	}
	if len(s.LoggingLevel) > 0 {
		v := s.LoggingLevel

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "loggingLevel", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.ThrottlingBurstLimit != nil {
		v := *s.ThrottlingBurstLimit

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "throttlingBurstLimit", protocol.Int64Value(v), metadata)
	}
	if s.ThrottlingRateLimit != nil {
		v := *s.ThrottlingRateLimit

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "throttlingRateLimit", protocol.Float64Value(v), metadata)
	}
	return nil
}

// Represents an API stage.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/Stage
type Stage struct {
	_ struct{} `type:"structure"`

	// Settings for logging access in this stage.
	AccessLogSettings *AccessLogSettings `locationName:"accessLogSettings" type:"structure"`

	// The identifier of a client certificate for a Stage.
	ClientCertificateId *string `locationName:"clientCertificateId" type:"string"`

	// The timestamp when the stage was created.
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp" timestampFormat:"unix"`

	// Default route settings for the stage.
	DefaultRouteSettings *RouteSettings `locationName:"defaultRouteSettings" type:"structure"`

	// The identifier of the Deployment that the Stage is associated with.
	DeploymentId *string `locationName:"deploymentId" type:"string"`

	// The description of the stage.
	Description *string `locationName:"description" type:"string"`

	// The timestamp when the stage was last updated.
	LastUpdatedDate *time.Time `locationName:"lastUpdatedDate" type:"timestamp" timestampFormat:"unix"`

	// Route settings for the stage.
	RouteSettings map[string]RouteSettings `locationName:"routeSettings" type:"map"`

	// The name of the stage.
	//
	// StageName is a required field
	StageName *string `locationName:"stageName" type:"string" required:"true"`

	// A map that defines the stage variables for a stage resource. Variable names
	// can have alphanumeric and underscore characters, and the values must match
	// [A-Za-z0-9-._~:/?#&=,]+.
	StageVariables map[string]string `locationName:"stageVariables" type:"map"`
}

// String returns the string representation
func (s Stage) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Stage) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccessLogSettings != nil {
		v := s.AccessLogSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "accessLogSettings", v, metadata)
	}
	if s.ClientCertificateId != nil {
		v := *s.ClientCertificateId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "clientCertificateId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreatedDate != nil {
		v := *s.CreatedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "createdDate", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.DefaultRouteSettings != nil {
		v := s.DefaultRouteSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "defaultRouteSettings", v, metadata)
	}
	if s.DeploymentId != nil {
		v := *s.DeploymentId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "deploymentId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastUpdatedDate != nil {
		v := *s.LastUpdatedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastUpdatedDate", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if len(s.RouteSettings) > 0 {
		v := s.RouteSettings

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "routeSettings", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetFields(k1, v1)
		}
		ms0.End()

	}
	if s.StageName != nil {
		v := *s.StageName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "stageName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.StageVariables) > 0 {
		v := s.StageVariables

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "stageVariables", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}
