// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package autoscaling

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/query"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/AttachInstancesQuery
type AttachInstancesInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// The IDs of the instances. You can specify up to 20 instances.
	InstanceIds []string `type:"list"`
}

// String returns the string representation
func (s AttachInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttachInstancesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AttachInstancesInput"}

	if s.AutoScalingGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AutoScalingGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/AttachInstancesOutput
type AttachInstancesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AttachInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

const opAttachInstances = "AttachInstances"

// AttachInstancesRequest returns a request value for making API operation for
// Auto Scaling.
//
// Attaches one or more EC2 instances to the specified Auto Scaling group.
//
// When you attach instances, Amazon EC2 Auto Scaling increases the desired
// capacity of the group by the number of instances being attached. If the number
// of instances being attached plus the desired capacity of the group exceeds
// the maximum size of the group, the operation fails.
//
// If there is a Classic Load Balancer attached to your Auto Scaling group,
// the instances are also registered with the load balancer. If there are target
// groups attached to your Auto Scaling group, the instances are also registered
// with the target groups.
//
// For more information, see Attach EC2 Instances to Your Auto Scaling Group
// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/attach-instance-asg.html)
// in the Amazon EC2 Auto Scaling User Guide.
//
//    // Example sending a request using AttachInstancesRequest.
//    req := client.AttachInstancesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/AttachInstances
func (c *Client) AttachInstancesRequest(input *AttachInstancesInput) AttachInstancesRequest {
	op := &aws.Operation{
		Name:       opAttachInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AttachInstancesInput{}
	}

	req := c.newRequest(op, input, &AttachInstancesOutput{})
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return AttachInstancesRequest{Request: req, Input: input, Copy: c.AttachInstancesRequest}
}

// AttachInstancesRequest is the request type for the
// AttachInstances API operation.
type AttachInstancesRequest struct {
	*aws.Request
	Input *AttachInstancesInput
	Copy  func(*AttachInstancesInput) AttachInstancesRequest
}

// Send marshals and sends the AttachInstances API request.
func (r AttachInstancesRequest) Send(ctx context.Context) (*AttachInstancesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &AttachInstancesResponse{
		AttachInstancesOutput: r.Request.Data.(*AttachInstancesOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// AttachInstancesResponse is the response type for the
// AttachInstances API operation.
type AttachInstancesResponse struct {
	*AttachInstancesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// AttachInstances request.
func (r *AttachInstancesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
