// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package batch

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/DeleteComputeEnvironmentRequest
type DeleteComputeEnvironmentInput struct {
	_ struct{} `type:"structure"`

	// The name or Amazon Resource Name (ARN) of the compute environment to delete.
	//
	// ComputeEnvironment is a required field
	ComputeEnvironment *string `locationName:"computeEnvironment" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteComputeEnvironmentInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteComputeEnvironmentInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteComputeEnvironmentInput"}

	if s.ComputeEnvironment == nil {
		invalidParams.Add(aws.NewErrParamRequired("ComputeEnvironment"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteComputeEnvironmentInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/x-amz-json-1.1"), protocol.Metadata{})

	if s.ComputeEnvironment != nil {
		v := *s.ComputeEnvironment

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "computeEnvironment", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/DeleteComputeEnvironmentResponse
type DeleteComputeEnvironmentOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteComputeEnvironmentOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteComputeEnvironmentOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteComputeEnvironment = "DeleteComputeEnvironment"

// DeleteComputeEnvironmentRequest returns a request value for making API operation for
// AWS Batch.
//
// Deletes an AWS Batch compute environment.
//
// Before you can delete a compute environment, you must set its state to DISABLED
// with the UpdateComputeEnvironment API operation and disassociate it from
// any job queues with the UpdateJobQueue API operation.
//
//    // Example sending a request using DeleteComputeEnvironmentRequest.
//    req := client.DeleteComputeEnvironmentRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/DeleteComputeEnvironment
func (c *Client) DeleteComputeEnvironmentRequest(input *DeleteComputeEnvironmentInput) DeleteComputeEnvironmentRequest {
	op := &aws.Operation{
		Name:       opDeleteComputeEnvironment,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/deletecomputeenvironment",
	}

	if input == nil {
		input = &DeleteComputeEnvironmentInput{}
	}

	req := c.newRequest(op, input, &DeleteComputeEnvironmentOutput{})
	return DeleteComputeEnvironmentRequest{Request: req, Input: input, Copy: c.DeleteComputeEnvironmentRequest}
}

// DeleteComputeEnvironmentRequest is the request type for the
// DeleteComputeEnvironment API operation.
type DeleteComputeEnvironmentRequest struct {
	*aws.Request
	Input *DeleteComputeEnvironmentInput
	Copy  func(*DeleteComputeEnvironmentInput) DeleteComputeEnvironmentRequest
}

// Send marshals and sends the DeleteComputeEnvironment API request.
func (r DeleteComputeEnvironmentRequest) Send(ctx context.Context) (*DeleteComputeEnvironmentResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteComputeEnvironmentResponse{
		DeleteComputeEnvironmentOutput: r.Request.Data.(*DeleteComputeEnvironmentOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteComputeEnvironmentResponse is the response type for the
// DeleteComputeEnvironment API operation.
type DeleteComputeEnvironmentResponse struct {
	*DeleteComputeEnvironmentOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteComputeEnvironment request.
func (r *DeleteComputeEnvironmentResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
