// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package chime

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restjson"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateGlobalSettingsRequest
type UpdateGlobalSettingsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime Business Calling settings.
	//
	// BusinessCalling is a required field
	BusinessCalling *BusinessCallingSettings `type:"structure" required:"true"`

	// The Amazon Chime Voice Connector settings.
	//
	// VoiceConnector is a required field
	VoiceConnector *VoiceConnectorSettings `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateGlobalSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateGlobalSettingsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateGlobalSettingsInput"}

	if s.BusinessCalling == nil {
		invalidParams.Add(aws.NewErrParamRequired("BusinessCalling"))
	}

	if s.VoiceConnector == nil {
		invalidParams.Add(aws.NewErrParamRequired("VoiceConnector"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateGlobalSettingsInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.BusinessCalling != nil {
		v := s.BusinessCalling

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "BusinessCalling", v, metadata)
	}
	if s.VoiceConnector != nil {
		v := s.VoiceConnector

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "VoiceConnector", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateGlobalSettingsOutput
type UpdateGlobalSettingsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateGlobalSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateGlobalSettingsOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opUpdateGlobalSettings = "UpdateGlobalSettings"

// UpdateGlobalSettingsRequest returns a request value for making API operation for
// Amazon Chime.
//
// Updates global settings for the administrator's AWS account, such as Amazon
// Chime Business Calling and Amazon Chime Voice Connector settings.
//
//    // Example sending a request using UpdateGlobalSettingsRequest.
//    req := client.UpdateGlobalSettingsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateGlobalSettings
func (c *Client) UpdateGlobalSettingsRequest(input *UpdateGlobalSettingsInput) UpdateGlobalSettingsRequest {
	op := &aws.Operation{
		Name:       opUpdateGlobalSettings,
		HTTPMethod: "PUT",
		HTTPPath:   "/settings",
	}

	if input == nil {
		input = &UpdateGlobalSettingsInput{}
	}

	req := c.newRequest(op, input, &UpdateGlobalSettingsOutput{})
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return UpdateGlobalSettingsRequest{Request: req, Input: input, Copy: c.UpdateGlobalSettingsRequest}
}

// UpdateGlobalSettingsRequest is the request type for the
// UpdateGlobalSettings API operation.
type UpdateGlobalSettingsRequest struct {
	*aws.Request
	Input *UpdateGlobalSettingsInput
	Copy  func(*UpdateGlobalSettingsInput) UpdateGlobalSettingsRequest
}

// Send marshals and sends the UpdateGlobalSettings API request.
func (r UpdateGlobalSettingsRequest) Send(ctx context.Context) (*UpdateGlobalSettingsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateGlobalSettingsResponse{
		UpdateGlobalSettingsOutput: r.Request.Data.(*UpdateGlobalSettingsOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateGlobalSettingsResponse is the response type for the
// UpdateGlobalSettings API operation.
type UpdateGlobalSettingsResponse struct {
	*UpdateGlobalSettingsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateGlobalSettings request.
func (r *UpdateGlobalSettingsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
