// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloud9

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloud9-2017-09-23/UpdateEnvironmentRequest
type UpdateEnvironmentInput struct {
	_ struct{} `type:"structure"`

	// Any new or replacement description for the environment.
	Description *string `locationName:"description" type:"string"`

	// The ID of the environment to change settings.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `locationName:"environmentId" type:"string" required:"true"`

	// A replacement name for the environment.
	Name *string `locationName:"name" min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateEnvironmentInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateEnvironmentInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateEnvironmentInput"}

	if s.EnvironmentId == nil {
		invalidParams.Add(aws.NewErrParamRequired("EnvironmentId"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloud9-2017-09-23/UpdateEnvironmentResult
type UpdateEnvironmentOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateEnvironmentOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateEnvironment = "UpdateEnvironment"

// UpdateEnvironmentRequest returns a request value for making API operation for
// AWS Cloud9.
//
// Changes the settings of an existing AWS Cloud9 development environment.
//
//    // Example sending a request using UpdateEnvironmentRequest.
//    req := client.UpdateEnvironmentRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloud9-2017-09-23/UpdateEnvironment
func (c *Client) UpdateEnvironmentRequest(input *UpdateEnvironmentInput) UpdateEnvironmentRequest {
	op := &aws.Operation{
		Name:       opUpdateEnvironment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateEnvironmentInput{}
	}

	req := c.newRequest(op, input, &UpdateEnvironmentOutput{})
	return UpdateEnvironmentRequest{Request: req, Input: input, Copy: c.UpdateEnvironmentRequest}
}

// UpdateEnvironmentRequest is the request type for the
// UpdateEnvironment API operation.
type UpdateEnvironmentRequest struct {
	*aws.Request
	Input *UpdateEnvironmentInput
	Copy  func(*UpdateEnvironmentInput) UpdateEnvironmentRequest
}

// Send marshals and sends the UpdateEnvironment API request.
func (r UpdateEnvironmentRequest) Send(ctx context.Context) (*UpdateEnvironmentResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateEnvironmentResponse{
		UpdateEnvironmentOutput: r.Request.Data.(*UpdateEnvironmentOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateEnvironmentResponse is the response type for the
// UpdateEnvironment API operation.
type UpdateEnvironmentResponse struct {
	*UpdateEnvironmentOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateEnvironment request.
func (r *UpdateEnvironmentResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
