// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloud9

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloud9-2017-09-23/UpdateEnvironmentMembershipRequest
type UpdateEnvironmentMembershipInput struct {
	_ struct{} `type:"structure"`

	// The ID of the environment for the environment member whose settings you want
	// to change.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `locationName:"environmentId" type:"string" required:"true"`

	// The replacement type of environment member permissions you want to associate
	// with this environment member. Available values include:
	//
	//    * read-only: Has read-only access to the environment.
	//
	//    * read-write: Has read-write access to the environment.
	//
	// Permissions is a required field
	Permissions MemberPermissions `locationName:"permissions" type:"string" required:"true" enum:"true"`

	// The Amazon Resource Name (ARN) of the environment member whose settings you
	// want to change.
	//
	// UserArn is a required field
	UserArn *string `locationName:"userArn" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateEnvironmentMembershipInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateEnvironmentMembershipInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateEnvironmentMembershipInput"}

	if s.EnvironmentId == nil {
		invalidParams.Add(aws.NewErrParamRequired("EnvironmentId"))
	}
	if len(s.Permissions) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Permissions"))
	}

	if s.UserArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("UserArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloud9-2017-09-23/UpdateEnvironmentMembershipResult
type UpdateEnvironmentMembershipOutput struct {
	_ struct{} `type:"structure"`

	// Information about the environment member whose settings were changed.
	Membership *EnvironmentMember `locationName:"membership" type:"structure"`
}

// String returns the string representation
func (s UpdateEnvironmentMembershipOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateEnvironmentMembership = "UpdateEnvironmentMembership"

// UpdateEnvironmentMembershipRequest returns a request value for making API operation for
// AWS Cloud9.
//
// Changes the settings of an existing environment member for an AWS Cloud9
// development environment.
//
//    // Example sending a request using UpdateEnvironmentMembershipRequest.
//    req := client.UpdateEnvironmentMembershipRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloud9-2017-09-23/UpdateEnvironmentMembership
func (c *Client) UpdateEnvironmentMembershipRequest(input *UpdateEnvironmentMembershipInput) UpdateEnvironmentMembershipRequest {
	op := &aws.Operation{
		Name:       opUpdateEnvironmentMembership,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateEnvironmentMembershipInput{}
	}

	req := c.newRequest(op, input, &UpdateEnvironmentMembershipOutput{})
	return UpdateEnvironmentMembershipRequest{Request: req, Input: input, Copy: c.UpdateEnvironmentMembershipRequest}
}

// UpdateEnvironmentMembershipRequest is the request type for the
// UpdateEnvironmentMembership API operation.
type UpdateEnvironmentMembershipRequest struct {
	*aws.Request
	Input *UpdateEnvironmentMembershipInput
	Copy  func(*UpdateEnvironmentMembershipInput) UpdateEnvironmentMembershipRequest
}

// Send marshals and sends the UpdateEnvironmentMembership API request.
func (r UpdateEnvironmentMembershipRequest) Send(ctx context.Context) (*UpdateEnvironmentMembershipResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateEnvironmentMembershipResponse{
		UpdateEnvironmentMembershipOutput: r.Request.Data.(*UpdateEnvironmentMembershipOutput),
		response:                          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateEnvironmentMembershipResponse is the response type for the
// UpdateEnvironmentMembership API operation.
type UpdateEnvironmentMembershipResponse struct {
	*UpdateEnvironmentMembershipOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateEnvironmentMembership request.
func (r *UpdateEnvironmentMembershipResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
