// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package clouddirectory

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/UpdateSchemaRequest
type UpdateSchemaInput struct {
	_ struct{} `type:"structure"`

	// The name of the schema.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the development schema. For more information,
	// see arns.
	//
	// SchemaArn is a required field
	SchemaArn *string `location:"header" locationName:"x-amz-data-partition" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateSchemaInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSchemaInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateSchemaInput"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if s.SchemaArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("SchemaArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateSchemaInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SchemaArn != nil {
		v := *s.SchemaArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-data-partition", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/UpdateSchemaResponse
type UpdateSchemaOutput struct {
	_ struct{} `type:"structure"`

	// The ARN that is associated with the updated schema. For more information,
	// see arns.
	SchemaArn *string `type:"string"`
}

// String returns the string representation
func (s UpdateSchemaOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateSchemaOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.SchemaArn != nil {
		v := *s.SchemaArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SchemaArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opUpdateSchema = "UpdateSchema"

// UpdateSchemaRequest returns a request value for making API operation for
// Amazon CloudDirectory.
//
// Updates the schema name with a new name. Only development schema names can
// be updated.
//
//    // Example sending a request using UpdateSchemaRequest.
//    req := client.UpdateSchemaRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/UpdateSchema
func (c *Client) UpdateSchemaRequest(input *UpdateSchemaInput) UpdateSchemaRequest {
	op := &aws.Operation{
		Name:       opUpdateSchema,
		HTTPMethod: "PUT",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/schema/update",
	}

	if input == nil {
		input = &UpdateSchemaInput{}
	}

	req := c.newRequest(op, input, &UpdateSchemaOutput{})
	return UpdateSchemaRequest{Request: req, Input: input, Copy: c.UpdateSchemaRequest}
}

// UpdateSchemaRequest is the request type for the
// UpdateSchema API operation.
type UpdateSchemaRequest struct {
	*aws.Request
	Input *UpdateSchemaInput
	Copy  func(*UpdateSchemaInput) UpdateSchemaRequest
}

// Send marshals and sends the UpdateSchema API request.
func (r UpdateSchemaRequest) Send(ctx context.Context) (*UpdateSchemaResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateSchemaResponse{
		UpdateSchemaOutput: r.Request.Data.(*UpdateSchemaOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateSchemaResponse is the response type for the
// UpdateSchema API operation.
type UpdateSchemaResponse struct {
	*UpdateSchemaOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateSchema request.
func (r *UpdateSchemaResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
