// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package clouddirectory

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

var _ aws.Config
var _ = awsutil.Prettify

// A unique identifier for an attribute.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/AttributeKey
type AttributeKey struct {
	_ struct{} `type:"structure"`

	// The name of the facet that the attribute exists within.
	//
	// FacetName is a required field
	FacetName *string `min:"1" type:"string" required:"true"`

	// The name of the attribute.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the schema that contains the facet and
	// attribute.
	//
	// SchemaArn is a required field
	SchemaArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AttributeKey) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttributeKey) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AttributeKey"}

	if s.FacetName == nil {
		invalidParams.Add(aws.NewErrParamRequired("FacetName"))
	}
	if s.FacetName != nil && len(*s.FacetName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FacetName", 1))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if s.SchemaArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("SchemaArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AttributeKey) MarshalFields(e protocol.FieldEncoder) error {
	if s.FacetName != nil {
		v := *s.FacetName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FacetName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SchemaArn != nil {
		v := *s.SchemaArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SchemaArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The combination of an attribute key and an attribute value.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/AttributeKeyAndValue
type AttributeKeyAndValue struct {
	_ struct{} `type:"structure"`

	// The key of the attribute.
	//
	// Key is a required field
	Key *AttributeKey `type:"structure" required:"true"`

	// The value of the attribute.
	//
	// Value is a required field
	Value *TypedAttributeValue `type:"structure" required:"true"`
}

// String returns the string representation
func (s AttributeKeyAndValue) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttributeKeyAndValue) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AttributeKeyAndValue"}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}
	if s.Key != nil {
		if err := s.Key.Validate(); err != nil {
			invalidParams.AddNested("Key", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AttributeKeyAndValue) MarshalFields(e protocol.FieldEncoder) error {
	if s.Key != nil {
		v := s.Key

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Key", v, metadata)
	}
	if s.Value != nil {
		v := s.Value

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Value", v, metadata)
	}
	return nil
}

// Identifies the attribute name and value for a typed link.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/AttributeNameAndValue
type AttributeNameAndValue struct {
	_ struct{} `type:"structure"`

	// The attribute name of the typed link.
	//
	// AttributeName is a required field
	AttributeName *string `min:"1" type:"string" required:"true"`

	// The value for the typed link.
	//
	// Value is a required field
	Value *TypedAttributeValue `type:"structure" required:"true"`
}

// String returns the string representation
func (s AttributeNameAndValue) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttributeNameAndValue) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AttributeNameAndValue"}

	if s.AttributeName == nil {
		invalidParams.Add(aws.NewErrParamRequired("AttributeName"))
	}
	if s.AttributeName != nil && len(*s.AttributeName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AttributeName", 1))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AttributeNameAndValue) MarshalFields(e protocol.FieldEncoder) error {
	if s.AttributeName != nil {
		v := *s.AttributeName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AttributeName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Value != nil {
		v := s.Value

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Value", v, metadata)
	}
	return nil
}

// Represents the output of a batch add facet to object operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/BatchAddFacetToObject
type BatchAddFacetToObject struct {
	_ struct{} `type:"structure"`

	// The attributes to set on the object.
	//
	// ObjectAttributeList is a required field
	ObjectAttributeList []AttributeKeyAndValue `type:"list" required:"true"`

	// A reference to the object being mutated.
	//
	// ObjectReference is a required field
	ObjectReference *ObjectReference `type:"structure" required:"true"`

	// Represents the facet being added to the object.
	//
	// SchemaFacet is a required field
	SchemaFacet *SchemaFacet `type:"structure" required:"true"`
}

// String returns the string representation
func (s BatchAddFacetToObject) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchAddFacetToObject) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BatchAddFacetToObject"}

	if s.ObjectAttributeList == nil {
		invalidParams.Add(aws.NewErrParamRequired("ObjectAttributeList"))
	}

	if s.ObjectReference == nil {
		invalidParams.Add(aws.NewErrParamRequired("ObjectReference"))
	}

	if s.SchemaFacet == nil {
		invalidParams.Add(aws.NewErrParamRequired("SchemaFacet"))
	}
	if s.ObjectAttributeList != nil {
		for i, v := range s.ObjectAttributeList {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ObjectAttributeList", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.SchemaFacet != nil {
		if err := s.SchemaFacet.Validate(); err != nil {
			invalidParams.AddNested("SchemaFacet", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchAddFacetToObject) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.ObjectAttributeList) > 0 {
		v := s.ObjectAttributeList

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ObjectAttributeList", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ObjectReference != nil {
		v := s.ObjectReference

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ObjectReference", v, metadata)
	}
	if s.SchemaFacet != nil {
		v := s.SchemaFacet

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "SchemaFacet", v, metadata)
	}
	return nil
}

// The result of a batch add facet to object operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/BatchAddFacetToObjectResponse
type BatchAddFacetToObjectResponse struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s BatchAddFacetToObjectResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchAddFacetToObjectResponse) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

// Represents the output of an AttachObject operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/BatchAttachObject
type BatchAttachObject struct {
	_ struct{} `type:"structure"`

	// The child object reference that is to be attached to the object.
	//
	// ChildReference is a required field
	ChildReference *ObjectReference `type:"structure" required:"true"`

	// The name of the link.
	//
	// LinkName is a required field
	LinkName *string `min:"1" type:"string" required:"true"`

	// The parent object reference.
	//
	// ParentReference is a required field
	ParentReference *ObjectReference `type:"structure" required:"true"`
}

// String returns the string representation
func (s BatchAttachObject) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchAttachObject) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BatchAttachObject"}

	if s.ChildReference == nil {
		invalidParams.Add(aws.NewErrParamRequired("ChildReference"))
	}

	if s.LinkName == nil {
		invalidParams.Add(aws.NewErrParamRequired("LinkName"))
	}
	if s.LinkName != nil && len(*s.LinkName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LinkName", 1))
	}

	if s.ParentReference == nil {
		invalidParams.Add(aws.NewErrParamRequired("ParentReference"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchAttachObject) MarshalFields(e protocol.FieldEncoder) error {
	if s.ChildReference != nil {
		v := s.ChildReference

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ChildReference", v, metadata)
	}
	if s.LinkName != nil {
		v := *s.LinkName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LinkName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ParentReference != nil {
		v := s.ParentReference

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ParentReference", v, metadata)
	}
	return nil
}

// Represents the output batch AttachObject response operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/BatchAttachObjectResponse
type BatchAttachObjectResponse struct {
	_ struct{} `type:"structure"`

	// The ObjectIdentifier of the object that has been attached.
	AttachedObjectIdentifier *string `locationName:"attachedObjectIdentifier" type:"string"`
}

// String returns the string representation
func (s BatchAttachObjectResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchAttachObjectResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.AttachedObjectIdentifier != nil {
		v := *s.AttachedObjectIdentifier

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "attachedObjectIdentifier", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Attaches a policy object to a regular object inside a BatchRead operation.
// For more information, see AttachPolicy and BatchReadRequest$Operations.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/BatchAttachPolicy
type BatchAttachPolicy struct {
	_ struct{} `type:"structure"`

	// The reference that identifies the object to which the policy will be attached.
	//
	// ObjectReference is a required field
	ObjectReference *ObjectReference `type:"structure" required:"true"`

	// The reference that is associated with the policy object.
	//
	// PolicyReference is a required field
	PolicyReference *ObjectReference `type:"structure" required:"true"`
}

// String returns the string representation
func (s BatchAttachPolicy) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchAttachPolicy) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BatchAttachPolicy"}

	if s.ObjectReference == nil {
		invalidParams.Add(aws.NewErrParamRequired("ObjectReference"))
	}

	if s.PolicyReference == nil {
		invalidParams.Add(aws.NewErrParamRequired("PolicyReference"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchAttachPolicy) MarshalFields(e protocol.FieldEncoder) error {
	if s.ObjectReference != nil {
		v := s.ObjectReference

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ObjectReference", v, metadata)
	}
	if s.PolicyReference != nil {
		v := s.PolicyReference

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "PolicyReference", v, metadata)
	}
	return nil
}

// Represents the output of an AttachPolicy response operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/BatchAttachPolicyResponse
type BatchAttachPolicyResponse struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s BatchAttachPolicyResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchAttachPolicyResponse) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

// Attaches the specified object to the specified index inside a BatchRead operation.
// For more information, see AttachToIndex and BatchReadRequest$Operations.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/BatchAttachToIndex
type BatchAttachToIndex struct {
	_ struct{} `type:"structure"`

	// A reference to the index that you are attaching the object to.
	//
	// IndexReference is a required field
	IndexReference *ObjectReference `type:"structure" required:"true"`

	// A reference to the object that you are attaching to the index.
	//
	// TargetReference is a required field
	TargetReference *ObjectReference `type:"structure" required:"true"`
}

// String returns the string representation
func (s BatchAttachToIndex) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchAttachToIndex) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BatchAttachToIndex"}

	if s.IndexReference == nil {
		invalidParams.Add(aws.NewErrParamRequired("IndexReference"))
	}

	if s.TargetReference == nil {
		invalidParams.Add(aws.NewErrParamRequired("TargetReference"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchAttachToIndex) MarshalFields(e protocol.FieldEncoder) error {
	if s.IndexReference != nil {
		v := s.IndexReference

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "IndexReference", v, metadata)
	}
	if s.TargetReference != nil {
		v := s.TargetReference

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "TargetReference", v, metadata)
	}
	return nil
}

// Represents the output of a AttachToIndex response operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/BatchAttachToIndexResponse
type BatchAttachToIndexResponse struct {
	_ struct{} `type:"structure"`

	// The ObjectIdentifier of the object that was attached to the index.
	AttachedObjectIdentifier *string `type:"string"`
}

// String returns the string representation
func (s BatchAttachToIndexResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchAttachToIndexResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.AttachedObjectIdentifier != nil {
		v := *s.AttachedObjectIdentifier

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AttachedObjectIdentifier", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Attaches a typed link to a specified source and target object inside a BatchRead
// operation. For more information, see AttachTypedLink and BatchReadRequest$Operations.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/BatchAttachTypedLink
type BatchAttachTypedLink struct {
	_ struct{} `type:"structure"`

	// A set of attributes that are associated with the typed link.
	//
	// Attributes is a required field
	Attributes []AttributeNameAndValue `type:"list" required:"true"`

	// Identifies the source object that the typed link will attach to.
	//
	// SourceObjectReference is a required field
	SourceObjectReference *ObjectReference `type:"structure" required:"true"`

	// Identifies the target object that the typed link will attach to.
	//
	// TargetObjectReference is a required field
	TargetObjectReference *ObjectReference `type:"structure" required:"true"`

	// Identifies the typed link facet that is associated with the typed link.
	//
	// TypedLinkFacet is a required field
	TypedLinkFacet *TypedLinkSchemaAndFacetName `type:"structure" required:"true"`
}

// String returns the string representation
func (s BatchAttachTypedLink) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchAttachTypedLink) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BatchAttachTypedLink"}

	if s.Attributes == nil {
		invalidParams.Add(aws.NewErrParamRequired("Attributes"))
	}

	if s.SourceObjectReference == nil {
		invalidParams.Add(aws.NewErrParamRequired("SourceObjectReference"))
	}

	if s.TargetObjectReference == nil {
		invalidParams.Add(aws.NewErrParamRequired("TargetObjectReference"))
	}

	if s.TypedLinkFacet == nil {
		invalidParams.Add(aws.NewErrParamRequired("TypedLinkFacet"))
	}
	if s.Attributes != nil {
		for i, v := range s.Attributes {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Attributes", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.TypedLinkFacet != nil {
		if err := s.TypedLinkFacet.Validate(); err != nil {
			invalidParams.AddNested("TypedLinkFacet", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchAttachTypedLink) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Attributes) > 0 {
		v := s.Attributes

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Attributes", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.SourceObjectReference != nil {
		v := s.SourceObjectReference

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "SourceObjectReference", v, metadata)
	}
	if s.TargetObjectReference != nil {
		v := s.TargetObjectReference

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "TargetObjectReference", v, metadata)
	}
	if s.TypedLinkFacet != nil {
		v := s.TypedLinkFacet

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "TypedLinkFacet", v, metadata)
	}
	return nil
}

// Represents the output of a AttachTypedLink response operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/BatchAttachTypedLinkResponse
type BatchAttachTypedLinkResponse struct {
	_ struct{} `type:"structure"`

	// Returns a typed link specifier as output.
	TypedLinkSpecifier *TypedLinkSpecifier `type:"structure"`
}

// String returns the string representation
func (s BatchAttachTypedLinkResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchAttachTypedLinkResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.TypedLinkSpecifier != nil {
		v := s.TypedLinkSpecifier

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "TypedLinkSpecifier", v, metadata)
	}
	return nil
}

// Creates an index object inside of a BatchRead operation. For more information,
// see CreateIndex and BatchReadRequest$Operations.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/BatchCreateIndex
type BatchCreateIndex struct {
	_ struct{} `type:"structure"`

	// The batch reference name. See Transaction Support (https://docs.aws.amazon.com/clouddirectory/latest/developerguide/transaction_support.html)
	// for more information.
	BatchReferenceName *string `type:"string"`

	// Indicates whether the attribute that is being indexed has unique values or
	// not.
	//
	// IsUnique is a required field
	IsUnique *bool `type:"boolean" required:"true"`

	// The name of the link between the parent object and the index object.
	LinkName *string `min:"1" type:"string"`

	// Specifies the attributes that should be indexed on. Currently only a single
	// attribute is supported.
	//
	// OrderedIndexedAttributeList is a required field
	OrderedIndexedAttributeList []AttributeKey `type:"list" required:"true"`

	// A reference to the parent object that contains the index object.
	ParentReference *ObjectReference `type:"structure"`
}

// String returns the string representation
func (s BatchCreateIndex) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchCreateIndex) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BatchCreateIndex"}

	if s.IsUnique == nil {
		invalidParams.Add(aws.NewErrParamRequired("IsUnique"))
	}
	if s.LinkName != nil && len(*s.LinkName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LinkName", 1))
	}

	if s.OrderedIndexedAttributeList == nil {
		invalidParams.Add(aws.NewErrParamRequired("OrderedIndexedAttributeList"))
	}
	if s.OrderedIndexedAttributeList != nil {
		for i, v := range s.OrderedIndexedAttributeList {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "OrderedIndexedAttributeList", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchCreateIndex) MarshalFields(e protocol.FieldEncoder) error {
	if s.BatchReferenceName != nil {
		v := *s.BatchReferenceName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BatchReferenceName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IsUnique != nil {
		v := *s.IsUnique

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IsUnique", protocol.BoolValue(v), metadata)
	}
	if s.LinkName != nil {
		v := *s.LinkName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LinkName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.OrderedIndexedAttributeList) > 0 {
		v := s.OrderedIndexedAttributeList

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "OrderedIndexedAttributeList", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ParentReference != nil {
		v := s.ParentReference

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ParentReference", v, metadata)
	}
	return nil
}

// Represents the output of a CreateIndex response operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/BatchCreateIndexResponse
type BatchCreateIndexResponse struct {
	_ struct{} `type:"structure"`

	// The ObjectIdentifier of the index created by this operation.
	ObjectIdentifier *string `type:"string"`
}

// String returns the string representation
func (s BatchCreateIndexResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchCreateIndexResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.ObjectIdentifier != nil {
		v := *s.ObjectIdentifier

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ObjectIdentifier", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Represents the output of a CreateObject operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/BatchCreateObject
type BatchCreateObject struct {
	_ struct{} `type:"structure"`

	// The batch reference name. See Transaction Support (https://docs.aws.amazon.com/clouddirectory/latest/developerguide/transaction_support.html)
	// for more information.
	BatchReferenceName *string `type:"string"`

	// The name of the link.
	LinkName *string `min:"1" type:"string"`

	// An attribute map, which contains an attribute ARN as the key and attribute
	// value as the map value.
	//
	// ObjectAttributeList is a required field
	ObjectAttributeList []AttributeKeyAndValue `type:"list" required:"true"`

	// If specified, the parent reference to which this object will be attached.
	ParentReference *ObjectReference `type:"structure"`

	// A list of FacetArns that will be associated with the object. For more information,
	// see arns.
	//
	// SchemaFacet is a required field
	SchemaFacet []SchemaFacet `type:"list" required:"true"`
}

// String returns the string representation
func (s BatchCreateObject) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchCreateObject) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BatchCreateObject"}
	if s.LinkName != nil && len(*s.LinkName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LinkName", 1))
	}

	if s.ObjectAttributeList == nil {
		invalidParams.Add(aws.NewErrParamRequired("ObjectAttributeList"))
	}

	if s.SchemaFacet == nil {
		invalidParams.Add(aws.NewErrParamRequired("SchemaFacet"))
	}
	if s.ObjectAttributeList != nil {
		for i, v := range s.ObjectAttributeList {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ObjectAttributeList", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.SchemaFacet != nil {
		for i, v := range s.SchemaFacet {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SchemaFacet", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchCreateObject) MarshalFields(e protocol.FieldEncoder) error {
	if s.BatchReferenceName != nil {
		v := *s.BatchReferenceName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BatchReferenceName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LinkName != nil {
		v := *s.LinkName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LinkName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ObjectAttributeList) > 0 {
		v := s.ObjectAttributeList

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ObjectAttributeList", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ParentReference != nil {
		v := s.ParentReference

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ParentReference", v, metadata)
	}
	if len(s.SchemaFacet) > 0 {
		v := s.SchemaFacet

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "SchemaFacet", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Represents the output of a CreateObject response operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/BatchCreateObjectResponse
type BatchCreateObjectResponse struct {
	_ struct{} `type:"structure"`

	// The ID that is associated with the object.
	ObjectIdentifier *string `type:"string"`
}

// String returns the string representation
func (s BatchCreateObjectResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchCreateObjectResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.ObjectIdentifier != nil {
		v := *s.ObjectIdentifier

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ObjectIdentifier", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Represents the output of a DeleteObject operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/BatchDeleteObject
type BatchDeleteObject struct {
	_ struct{} `type:"structure"`

	// The reference that identifies the object.
	//
	// ObjectReference is a required field
	ObjectReference *ObjectReference `type:"structure" required:"true"`
}

// String returns the string representation
func (s BatchDeleteObject) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDeleteObject) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BatchDeleteObject"}

	if s.ObjectReference == nil {
		invalidParams.Add(aws.NewErrParamRequired("ObjectReference"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchDeleteObject) MarshalFields(e protocol.FieldEncoder) error {
	if s.ObjectReference != nil {
		v := s.ObjectReference

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ObjectReference", v, metadata)
	}
	return nil
}

// Represents the output of a DeleteObject response operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/BatchDeleteObjectResponse
type BatchDeleteObjectResponse struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s BatchDeleteObjectResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchDeleteObjectResponse) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

// Detaches the specified object from the specified index inside a BatchRead
// operation. For more information, see DetachFromIndex and BatchReadRequest$Operations.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/BatchDetachFromIndex
type BatchDetachFromIndex struct {
	_ struct{} `type:"structure"`

	// A reference to the index object.
	//
	// IndexReference is a required field
	IndexReference *ObjectReference `type:"structure" required:"true"`

	// A reference to the object being detached from the index.
	//
	// TargetReference is a required field
	TargetReference *ObjectReference `type:"structure" required:"true"`
}

// String returns the string representation
func (s BatchDetachFromIndex) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDetachFromIndex) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BatchDetachFromIndex"}

	if s.IndexReference == nil {
		invalidParams.Add(aws.NewErrParamRequired("IndexReference"))
	}

	if s.TargetReference == nil {
		invalidParams.Add(aws.NewErrParamRequired("TargetReference"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchDetachFromIndex) MarshalFields(e protocol.FieldEncoder) error {
	if s.IndexReference != nil {
		v := s.IndexReference

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "IndexReference", v, metadata)
	}
	if s.TargetReference != nil {
		v := s.TargetReference

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "TargetReference", v, metadata)
	}
	return nil
}

// Represents the output of a DetachFromIndex response operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/BatchDetachFromIndexResponse
type BatchDetachFromIndexResponse struct {
	_ struct{} `type:"structure"`

	// The ObjectIdentifier of the object that was detached from the index.
	DetachedObjectIdentifier *string `type:"string"`
}

// String returns the string representation
func (s BatchDetachFromIndexResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchDetachFromIndexResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.DetachedObjectIdentifier != nil {
		v := *s.DetachedObjectIdentifier

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DetachedObjectIdentifier", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Represents the output of a DetachObject operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/BatchDetachObject
type BatchDetachObject struct {
	_ struct{} `type:"structure"`

	// The batch reference name. See Transaction Support (https://docs.aws.amazon.com/clouddirectory/latest/developerguide/transaction_support.html)
	// for more information.
	BatchReferenceName *string `type:"string"`

	// The name of the link.
	//
	// LinkName is a required field
	LinkName *string `min:"1" type:"string" required:"true"`

	// Parent reference from which the object with the specified link name is detached.
	//
	// ParentReference is a required field
	ParentReference *ObjectReference `type:"structure" required:"true"`
}

// String returns the string representation
func (s BatchDetachObject) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDetachObject) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BatchDetachObject"}

	if s.LinkName == nil {
		invalidParams.Add(aws.NewErrParamRequired("LinkName"))
	}
	if s.LinkName != nil && len(*s.LinkName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LinkName", 1))
	}

	if s.ParentReference == nil {
		invalidParams.Add(aws.NewErrParamRequired("ParentReference"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchDetachObject) MarshalFields(e protocol.FieldEncoder) error {
	if s.BatchReferenceName != nil {
		v := *s.BatchReferenceName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BatchReferenceName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LinkName != nil {
		v := *s.LinkName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LinkName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ParentReference != nil {
		v := s.ParentReference

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ParentReference", v, metadata)
	}
	return nil
}

// Represents the output of a DetachObject response operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/BatchDetachObjectResponse
type BatchDetachObjectResponse struct {
	_ struct{} `type:"structure"`

	// The ObjectIdentifier of the detached object.
	DetachedObjectIdentifier *string `locationName:"detachedObjectIdentifier" type:"string"`
}

// String returns the string representation
func (s BatchDetachObjectResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchDetachObjectResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.DetachedObjectIdentifier != nil {
		v := *s.DetachedObjectIdentifier

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "detachedObjectIdentifier", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Detaches the specified policy from the specified directory inside a BatchWrite
// operation. For more information, see DetachPolicy and BatchWriteRequest$Operations.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/BatchDetachPolicy
type BatchDetachPolicy struct {
	_ struct{} `type:"structure"`

	// Reference that identifies the object whose policy object will be detached.
	//
	// ObjectReference is a required field
	ObjectReference *ObjectReference `type:"structure" required:"true"`

	// Reference that identifies the policy object.
	//
	// PolicyReference is a required field
	PolicyReference *ObjectReference `type:"structure" required:"true"`
}

// String returns the string representation
func (s BatchDetachPolicy) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDetachPolicy) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BatchDetachPolicy"}

	if s.ObjectReference == nil {
		invalidParams.Add(aws.NewErrParamRequired("ObjectReference"))
	}

	if s.PolicyReference == nil {
		invalidParams.Add(aws.NewErrParamRequired("PolicyReference"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchDetachPolicy) MarshalFields(e protocol.FieldEncoder) error {
	if s.ObjectReference != nil {
		v := s.ObjectReference

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ObjectReference", v, metadata)
	}
	if s.PolicyReference != nil {
		v := s.PolicyReference

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "PolicyReference", v, metadata)
	}
	return nil
}

// Represents the output of a DetachPolicy response operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/BatchDetachPolicyResponse
type BatchDetachPolicyResponse struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s BatchDetachPolicyResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchDetachPolicyResponse) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

// Detaches a typed link from a specified source and target object inside a
// BatchRead operation. For more information, see DetachTypedLink and BatchReadRequest$Operations.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/BatchDetachTypedLink
type BatchDetachTypedLink struct {
	_ struct{} `type:"structure"`

	// Used to accept a typed link specifier as input.
	//
	// TypedLinkSpecifier is a required field
	TypedLinkSpecifier *TypedLinkSpecifier `type:"structure" required:"true"`
}

// String returns the string representation
func (s BatchDetachTypedLink) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDetachTypedLink) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BatchDetachTypedLink"}

	if s.TypedLinkSpecifier == nil {
		invalidParams.Add(aws.NewErrParamRequired("TypedLinkSpecifier"))
	}
	if s.TypedLinkSpecifier != nil {
		if err := s.TypedLinkSpecifier.Validate(); err != nil {
			invalidParams.AddNested("TypedLinkSpecifier", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchDetachTypedLink) MarshalFields(e protocol.FieldEncoder) error {
	if s.TypedLinkSpecifier != nil {
		v := s.TypedLinkSpecifier

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "TypedLinkSpecifier", v, metadata)
	}
	return nil
}

// Represents the output of a DetachTypedLink response operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/BatchDetachTypedLinkResponse
type BatchDetachTypedLinkResponse struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s BatchDetachTypedLinkResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchDetachTypedLinkResponse) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

// Retrieves attributes that are associated with a typed link inside a BatchRead
// operation. For more information, see GetLinkAttributes and BatchReadRequest$Operations.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/BatchGetLinkAttributes
type BatchGetLinkAttributes struct {
	_ struct{} `type:"structure"`

	// A list of attribute names whose values will be retrieved.
	//
	// AttributeNames is a required field
	AttributeNames []string `type:"list" required:"true"`

	// Allows a typed link specifier to be accepted as input.
	//
	// TypedLinkSpecifier is a required field
	TypedLinkSpecifier *TypedLinkSpecifier `type:"structure" required:"true"`
}

// String returns the string representation
func (s BatchGetLinkAttributes) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetLinkAttributes) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BatchGetLinkAttributes"}

	if s.AttributeNames == nil {
		invalidParams.Add(aws.NewErrParamRequired("AttributeNames"))
	}

	if s.TypedLinkSpecifier == nil {
		invalidParams.Add(aws.NewErrParamRequired("TypedLinkSpecifier"))
	}
	if s.TypedLinkSpecifier != nil {
		if err := s.TypedLinkSpecifier.Validate(); err != nil {
			invalidParams.AddNested("TypedLinkSpecifier", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchGetLinkAttributes) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.AttributeNames) > 0 {
		v := s.AttributeNames

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "AttributeNames", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.TypedLinkSpecifier != nil {
		v := s.TypedLinkSpecifier

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "TypedLinkSpecifier", v, metadata)
	}
	return nil
}

// Represents the output of a GetLinkAttributes response operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/BatchGetLinkAttributesResponse
type BatchGetLinkAttributesResponse struct {
	_ struct{} `type:"structure"`

	// The attributes that are associated with the typed link.
	Attributes []AttributeKeyAndValue `type:"list"`
}

// String returns the string representation
func (s BatchGetLinkAttributesResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchGetLinkAttributesResponse) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Attributes) > 0 {
		v := s.Attributes

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Attributes", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Retrieves attributes within a facet that are associated with an object inside
// an BatchRead operation. For more information, see GetObjectAttributes and
// BatchReadRequest$Operations.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/BatchGetObjectAttributes
type BatchGetObjectAttributes struct {
	_ struct{} `type:"structure"`

	// List of attribute names whose values will be retrieved.
	//
	// AttributeNames is a required field
	AttributeNames []string `type:"list" required:"true"`

	// Reference that identifies the object whose attributes will be retrieved.
	//
	// ObjectReference is a required field
	ObjectReference *ObjectReference `type:"structure" required:"true"`

	// Identifier for the facet whose attributes will be retrieved. See SchemaFacet
	// for details.
	//
	// SchemaFacet is a required field
	SchemaFacet *SchemaFacet `type:"structure" required:"true"`
}

// String returns the string representation
func (s BatchGetObjectAttributes) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetObjectAttributes) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BatchGetObjectAttributes"}

	if s.AttributeNames == nil {
		invalidParams.Add(aws.NewErrParamRequired("AttributeNames"))
	}

	if s.ObjectReference == nil {
		invalidParams.Add(aws.NewErrParamRequired("ObjectReference"))
	}

	if s.SchemaFacet == nil {
		invalidParams.Add(aws.NewErrParamRequired("SchemaFacet"))
	}
	if s.SchemaFacet != nil {
		if err := s.SchemaFacet.Validate(); err != nil {
			invalidParams.AddNested("SchemaFacet", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchGetObjectAttributes) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.AttributeNames) > 0 {
		v := s.AttributeNames

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "AttributeNames", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.ObjectReference != nil {
		v := s.ObjectReference

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ObjectReference", v, metadata)
	}
	if s.SchemaFacet != nil {
		v := s.SchemaFacet

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "SchemaFacet", v, metadata)
	}
	return nil
}

// Represents the output of a GetObjectAttributes response operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/BatchGetObjectAttributesResponse
type BatchGetObjectAttributesResponse struct {
	_ struct{} `type:"structure"`

	// The attribute values that are associated with an object.
	Attributes []AttributeKeyAndValue `type:"list"`
}

// String returns the string representation
func (s BatchGetObjectAttributesResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchGetObjectAttributesResponse) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Attributes) > 0 {
		v := s.Attributes

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Attributes", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Retrieves metadata about an object inside a BatchRead operation. For more
// information, see GetObjectInformation and BatchReadRequest$Operations.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/BatchGetObjectInformation
type BatchGetObjectInformation struct {
	_ struct{} `type:"structure"`

	// A reference to the object.
	//
	// ObjectReference is a required field
	ObjectReference *ObjectReference `type:"structure" required:"true"`
}

// String returns the string representation
func (s BatchGetObjectInformation) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetObjectInformation) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BatchGetObjectInformation"}

	if s.ObjectReference == nil {
		invalidParams.Add(aws.NewErrParamRequired("ObjectReference"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchGetObjectInformation) MarshalFields(e protocol.FieldEncoder) error {
	if s.ObjectReference != nil {
		v := s.ObjectReference

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ObjectReference", v, metadata)
	}
	return nil
}

// Represents the output of a GetObjectInformation response operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/BatchGetObjectInformationResponse
type BatchGetObjectInformationResponse struct {
	_ struct{} `type:"structure"`

	// The ObjectIdentifier of the specified object.
	ObjectIdentifier *string `type:"string"`

	// The facets attached to the specified object.
	SchemaFacets []SchemaFacet `type:"list"`
}

// String returns the string representation
func (s BatchGetObjectInformationResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchGetObjectInformationResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.ObjectIdentifier != nil {
		v := *s.ObjectIdentifier

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ObjectIdentifier", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.SchemaFacets) > 0 {
		v := s.SchemaFacets

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "SchemaFacets", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Lists indices attached to an object inside a BatchRead operation. For more
// information, see ListAttachedIndices and BatchReadRequest$Operations.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/BatchListAttachedIndices
type BatchListAttachedIndices struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to retrieve.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token.
	NextToken *string `type:"string"`

	// A reference to the object that has indices attached.
	//
	// TargetReference is a required field
	TargetReference *ObjectReference `type:"structure" required:"true"`
}

// String returns the string representation
func (s BatchListAttachedIndices) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchListAttachedIndices) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BatchListAttachedIndices"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if s.TargetReference == nil {
		invalidParams.Add(aws.NewErrParamRequired("TargetReference"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchListAttachedIndices) MarshalFields(e protocol.FieldEncoder) error {
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MaxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TargetReference != nil {
		v := s.TargetReference

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "TargetReference", v, metadata)
	}
	return nil
}

// Represents the output of a ListAttachedIndices response operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/BatchListAttachedIndicesResponse
type BatchListAttachedIndicesResponse struct {
	_ struct{} `type:"structure"`

	// The indices attached to the specified object.
	IndexAttachments []IndexAttachment `type:"list"`

	// The pagination token.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s BatchListAttachedIndicesResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchListAttachedIndicesResponse) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.IndexAttachments) > 0 {
		v := s.IndexAttachments

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "IndexAttachments", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Returns a paginated list of all the incoming TypedLinkSpecifier information
// for an object inside a BatchRead operation. For more information, see ListIncomingTypedLinks
// and BatchReadRequest$Operations.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/BatchListIncomingTypedLinks
type BatchListIncomingTypedLinks struct {
	_ struct{} `type:"structure"`

	// Provides range filters for multiple attributes. When providing ranges to
	// typed link selection, any inexact ranges must be specified at the end. Any
	// attributes that do not have a range specified are presumed to match the entire
	// range.
	FilterAttributeRanges []TypedLinkAttributeRange `type:"list"`

	// Filters are interpreted in the order of the attributes on the typed link
	// facet, not the order in which they are supplied to any API calls.
	FilterTypedLink *TypedLinkSchemaAndFacetName `type:"structure"`

	// The maximum number of results to retrieve.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token.
	NextToken *string `type:"string"`

	// The reference that identifies the object whose attributes will be listed.
	//
	// ObjectReference is a required field
	ObjectReference *ObjectReference `type:"structure" required:"true"`
}

// String returns the string representation
func (s BatchListIncomingTypedLinks) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchListIncomingTypedLinks) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BatchListIncomingTypedLinks"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if s.ObjectReference == nil {
		invalidParams.Add(aws.NewErrParamRequired("ObjectReference"))
	}
	if s.FilterAttributeRanges != nil {
		for i, v := range s.FilterAttributeRanges {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "FilterAttributeRanges", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.FilterTypedLink != nil {
		if err := s.FilterTypedLink.Validate(); err != nil {
			invalidParams.AddNested("FilterTypedLink", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchListIncomingTypedLinks) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.FilterAttributeRanges) > 0 {
		v := s.FilterAttributeRanges

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "FilterAttributeRanges", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.FilterTypedLink != nil {
		v := s.FilterTypedLink

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "FilterTypedLink", v, metadata)
	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MaxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ObjectReference != nil {
		v := s.ObjectReference

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ObjectReference", v, metadata)
	}
	return nil
}

// Represents the output of a ListIncomingTypedLinks response operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/BatchListIncomingTypedLinksResponse
type BatchListIncomingTypedLinksResponse struct {
	_ struct{} `type:"structure"`

	// Returns one or more typed link specifiers as output.
	LinkSpecifiers []TypedLinkSpecifier `type:"list"`

	// The pagination token.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s BatchListIncomingTypedLinksResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchListIncomingTypedLinksResponse) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.LinkSpecifiers) > 0 {
		v := s.LinkSpecifiers

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "LinkSpecifiers", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Lists objects attached to the specified index inside a BatchRead operation.
// For more information, see ListIndex and BatchReadRequest$Operations.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/BatchListIndex
type BatchListIndex struct {
	_ struct{} `type:"structure"`

	// The reference to the index to list.
	//
	// IndexReference is a required field
	IndexReference *ObjectReference `type:"structure" required:"true"`

	// The maximum number of results to retrieve.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token.
	NextToken *string `type:"string"`

	// Specifies the ranges of indexed values that you want to query.
	RangesOnIndexedValues []ObjectAttributeRange `type:"list"`
}

// String returns the string representation
func (s BatchListIndex) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchListIndex) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BatchListIndex"}

	if s.IndexReference == nil {
		invalidParams.Add(aws.NewErrParamRequired("IndexReference"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.RangesOnIndexedValues != nil {
		for i, v := range s.RangesOnIndexedValues {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RangesOnIndexedValues", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchListIndex) MarshalFields(e protocol.FieldEncoder) error {
	if s.IndexReference != nil {
		v := s.IndexReference

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "IndexReference", v, metadata)
	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MaxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.RangesOnIndexedValues) > 0 {
		v := s.RangesOnIndexedValues

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "RangesOnIndexedValues", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Represents the output of a ListIndex response operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/BatchListIndexResponse
type BatchListIndexResponse struct {
	_ struct{} `type:"structure"`

	// The objects and indexed values attached to the index.
	IndexAttachments []IndexAttachment `type:"list"`

	// The pagination token.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s BatchListIndexResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchListIndexResponse) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.IndexAttachments) > 0 {
		v := s.IndexAttachments

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "IndexAttachments", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Represents the output of a ListObjectAttributes operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/BatchListObjectAttributes
type BatchListObjectAttributes struct {
	_ struct{} `type:"structure"`

	// Used to filter the list of object attributes that are associated with a certain
	// facet.
	FacetFilter *SchemaFacet `type:"structure"`

	// The maximum number of items to be retrieved in a single call. This is an
	// approximate number.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token.
	NextToken *string `type:"string"`

	// Reference of the object whose attributes need to be listed.
	//
	// ObjectReference is a required field
	ObjectReference *ObjectReference `type:"structure" required:"true"`
}

// String returns the string representation
func (s BatchListObjectAttributes) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchListObjectAttributes) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BatchListObjectAttributes"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if s.ObjectReference == nil {
		invalidParams.Add(aws.NewErrParamRequired("ObjectReference"))
	}
	if s.FacetFilter != nil {
		if err := s.FacetFilter.Validate(); err != nil {
			invalidParams.AddNested("FacetFilter", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchListObjectAttributes) MarshalFields(e protocol.FieldEncoder) error {
	if s.FacetFilter != nil {
		v := s.FacetFilter

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "FacetFilter", v, metadata)
	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MaxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ObjectReference != nil {
		v := s.ObjectReference

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ObjectReference", v, metadata)
	}
	return nil
}

// Represents the output of a ListObjectAttributes response operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/BatchListObjectAttributesResponse
type BatchListObjectAttributesResponse struct {
	_ struct{} `type:"structure"`

	// The attributes map that is associated with the object. AttributeArn is the
	// key; attribute value is the value.
	Attributes []AttributeKeyAndValue `type:"list"`

	// The pagination token.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s BatchListObjectAttributesResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchListObjectAttributesResponse) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Attributes) > 0 {
		v := s.Attributes

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Attributes", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Represents the output of a ListObjectChildren operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/BatchListObjectChildren
type BatchListObjectChildren struct {
	_ struct{} `type:"structure"`

	// Maximum number of items to be retrieved in a single call. This is an approximate
	// number.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token.
	NextToken *string `type:"string"`

	// Reference of the object for which child objects are being listed.
	//
	// ObjectReference is a required field
	ObjectReference *ObjectReference `type:"structure" required:"true"`
}

// String returns the string representation
func (s BatchListObjectChildren) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchListObjectChildren) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BatchListObjectChildren"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if s.ObjectReference == nil {
		invalidParams.Add(aws.NewErrParamRequired("ObjectReference"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchListObjectChildren) MarshalFields(e protocol.FieldEncoder) error {
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MaxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ObjectReference != nil {
		v := s.ObjectReference

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ObjectReference", v, metadata)
	}
	return nil
}

// Represents the output of a ListObjectChildren response operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/BatchListObjectChildrenResponse
type BatchListObjectChildrenResponse struct {
	_ struct{} `type:"structure"`

	// The children structure, which is a map with the key as the LinkName and ObjectIdentifier
	// as the value.
	Children map[string]string `type:"map"`

	// The pagination token.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s BatchListObjectChildrenResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchListObjectChildrenResponse) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Children) > 0 {
		v := s.Children

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Children", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Retrieves all available parent paths for any object type such as node, leaf
// node, policy node, and index node objects inside a BatchRead operation. For
// more information, see ListObjectParentPaths and BatchReadRequest$Operations.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/BatchListObjectParentPaths
type BatchListObjectParentPaths struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to retrieve.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token.
	NextToken *string `type:"string"`

	// The reference that identifies the object whose attributes will be listed.
	//
	// ObjectReference is a required field
	ObjectReference *ObjectReference `type:"structure" required:"true"`
}

// String returns the string representation
func (s BatchListObjectParentPaths) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchListObjectParentPaths) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BatchListObjectParentPaths"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if s.ObjectReference == nil {
		invalidParams.Add(aws.NewErrParamRequired("ObjectReference"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchListObjectParentPaths) MarshalFields(e protocol.FieldEncoder) error {
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MaxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ObjectReference != nil {
		v := s.ObjectReference

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ObjectReference", v, metadata)
	}
	return nil
}

// Represents the output of a ListObjectParentPaths response operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/BatchListObjectParentPathsResponse
type BatchListObjectParentPathsResponse struct {
	_ struct{} `type:"structure"`

	// The pagination token.
	NextToken *string `type:"string"`

	// Returns the path to the ObjectIdentifiers that are associated with the directory.
	PathToObjectIdentifiersList []PathToObjectIdentifiers `type:"list"`
}

// String returns the string representation
func (s BatchListObjectParentPathsResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchListObjectParentPathsResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.PathToObjectIdentifiersList) > 0 {
		v := s.PathToObjectIdentifiersList

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "PathToObjectIdentifiersList", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/BatchListObjectParents
type BatchListObjectParents struct {
	_ struct{} `type:"structure"`

	MaxResults *int64 `min:"1" type:"integer"`

	NextToken *string `type:"string"`

	// The reference that identifies an object.
	//
	// ObjectReference is a required field
	ObjectReference *ObjectReference `type:"structure" required:"true"`
}

// String returns the string representation
func (s BatchListObjectParents) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchListObjectParents) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BatchListObjectParents"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if s.ObjectReference == nil {
		invalidParams.Add(aws.NewErrParamRequired("ObjectReference"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchListObjectParents) MarshalFields(e protocol.FieldEncoder) error {
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MaxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ObjectReference != nil {
		v := s.ObjectReference

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ObjectReference", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/BatchListObjectParentsResponse
type BatchListObjectParentsResponse struct {
	_ struct{} `type:"structure"`

	NextToken *string `type:"string"`

	ParentLinks []ObjectIdentifierAndLinkNameTuple `type:"list"`
}

// String returns the string representation
func (s BatchListObjectParentsResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchListObjectParentsResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ParentLinks) > 0 {
		v := s.ParentLinks

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ParentLinks", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Returns policies attached to an object in pagination fashion inside a BatchRead
// operation. For more information, see ListObjectPolicies and BatchReadRequest$Operations.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/BatchListObjectPolicies
type BatchListObjectPolicies struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to retrieve.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token.
	NextToken *string `type:"string"`

	// The reference that identifies the object whose attributes will be listed.
	//
	// ObjectReference is a required field
	ObjectReference *ObjectReference `type:"structure" required:"true"`
}

// String returns the string representation
func (s BatchListObjectPolicies) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchListObjectPolicies) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BatchListObjectPolicies"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if s.ObjectReference == nil {
		invalidParams.Add(aws.NewErrParamRequired("ObjectReference"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchListObjectPolicies) MarshalFields(e protocol.FieldEncoder) error {
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MaxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ObjectReference != nil {
		v := s.ObjectReference

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ObjectReference", v, metadata)
	}
	return nil
}

// Represents the output of a ListObjectPolicies response operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/BatchListObjectPoliciesResponse
type BatchListObjectPoliciesResponse struct {
	_ struct{} `type:"structure"`

	// A list of policy ObjectIdentifiers, that are attached to the object.
	AttachedPolicyIds []string `type:"list"`

	// The pagination token.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s BatchListObjectPoliciesResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchListObjectPoliciesResponse) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.AttachedPolicyIds) > 0 {
		v := s.AttachedPolicyIds

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "AttachedPolicyIds", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Returns a paginated list of all the outgoing TypedLinkSpecifier information
// for an object inside a BatchRead operation. For more information, see ListOutgoingTypedLinks
// and BatchReadRequest$Operations.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/BatchListOutgoingTypedLinks
type BatchListOutgoingTypedLinks struct {
	_ struct{} `type:"structure"`

	// Provides range filters for multiple attributes. When providing ranges to
	// typed link selection, any inexact ranges must be specified at the end. Any
	// attributes that do not have a range specified are presumed to match the entire
	// range.
	FilterAttributeRanges []TypedLinkAttributeRange `type:"list"`

	// Filters are interpreted in the order of the attributes defined on the typed
	// link facet, not the order they are supplied to any API calls.
	FilterTypedLink *TypedLinkSchemaAndFacetName `type:"structure"`

	// The maximum number of results to retrieve.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token.
	NextToken *string `type:"string"`

	// The reference that identifies the object whose attributes will be listed.
	//
	// ObjectReference is a required field
	ObjectReference *ObjectReference `type:"structure" required:"true"`
}

// String returns the string representation
func (s BatchListOutgoingTypedLinks) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchListOutgoingTypedLinks) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BatchListOutgoingTypedLinks"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if s.ObjectReference == nil {
		invalidParams.Add(aws.NewErrParamRequired("ObjectReference"))
	}
	if s.FilterAttributeRanges != nil {
		for i, v := range s.FilterAttributeRanges {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "FilterAttributeRanges", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.FilterTypedLink != nil {
		if err := s.FilterTypedLink.Validate(); err != nil {
			invalidParams.AddNested("FilterTypedLink", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchListOutgoingTypedLinks) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.FilterAttributeRanges) > 0 {
		v := s.FilterAttributeRanges

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "FilterAttributeRanges", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.FilterTypedLink != nil {
		v := s.FilterTypedLink

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "FilterTypedLink", v, metadata)
	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MaxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ObjectReference != nil {
		v := s.ObjectReference

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ObjectReference", v, metadata)
	}
	return nil
}

// Represents the output of a ListOutgoingTypedLinks response operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/BatchListOutgoingTypedLinksResponse
type BatchListOutgoingTypedLinksResponse struct {
	_ struct{} `type:"structure"`

	// The pagination token.
	NextToken *string `type:"string"`

	// Returns a typed link specifier as output.
	TypedLinkSpecifiers []TypedLinkSpecifier `type:"list"`
}

// String returns the string representation
func (s BatchListOutgoingTypedLinksResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchListOutgoingTypedLinksResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.TypedLinkSpecifiers) > 0 {
		v := s.TypedLinkSpecifiers

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "TypedLinkSpecifiers", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Returns all of the ObjectIdentifiers to which a given policy is attached
// inside a BatchRead operation. For more information, see ListPolicyAttachments
// and BatchReadRequest$Operations.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/BatchListPolicyAttachments
type BatchListPolicyAttachments struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to retrieve.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token.
	NextToken *string `type:"string"`

	// The reference that identifies the policy object.
	//
	// PolicyReference is a required field
	PolicyReference *ObjectReference `type:"structure" required:"true"`
}

// String returns the string representation
func (s BatchListPolicyAttachments) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchListPolicyAttachments) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BatchListPolicyAttachments"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if s.PolicyReference == nil {
		invalidParams.Add(aws.NewErrParamRequired("PolicyReference"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchListPolicyAttachments) MarshalFields(e protocol.FieldEncoder) error {
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MaxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PolicyReference != nil {
		v := s.PolicyReference

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "PolicyReference", v, metadata)
	}
	return nil
}

// Represents the output of a ListPolicyAttachments response operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/BatchListPolicyAttachmentsResponse
type BatchListPolicyAttachmentsResponse struct {
	_ struct{} `type:"structure"`

	// The pagination token.
	NextToken *string `type:"string"`

	// A list of ObjectIdentifiers to which the policy is attached.
	ObjectIdentifiers []string `type:"list"`
}

// String returns the string representation
func (s BatchListPolicyAttachmentsResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchListPolicyAttachmentsResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ObjectIdentifiers) > 0 {
		v := s.ObjectIdentifiers

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ObjectIdentifiers", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// Lists all policies from the root of the Directory to the object specified
// inside a BatchRead operation. For more information, see LookupPolicy and
// BatchReadRequest$Operations.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/BatchLookupPolicy
type BatchLookupPolicy struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to retrieve.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token.
	NextToken *string `type:"string"`

	// Reference that identifies the object whose policies will be looked up.
	//
	// ObjectReference is a required field
	ObjectReference *ObjectReference `type:"structure" required:"true"`
}

// String returns the string representation
func (s BatchLookupPolicy) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchLookupPolicy) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BatchLookupPolicy"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if s.ObjectReference == nil {
		invalidParams.Add(aws.NewErrParamRequired("ObjectReference"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchLookupPolicy) MarshalFields(e protocol.FieldEncoder) error {
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MaxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ObjectReference != nil {
		v := s.ObjectReference

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ObjectReference", v, metadata)
	}
	return nil
}

// Represents the output of a LookupPolicy response operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/BatchLookupPolicyResponse
type BatchLookupPolicyResponse struct {
	_ struct{} `type:"structure"`

	// The pagination token.
	NextToken *string `type:"string"`

	// Provides list of path to policies. Policies contain PolicyId, ObjectIdentifier,
	// and PolicyType. For more information, see Policies (https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies).
	PolicyToPathList []PolicyToPath `type:"list"`
}

// String returns the string representation
func (s BatchLookupPolicyResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchLookupPolicyResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.PolicyToPathList) > 0 {
		v := s.PolicyToPathList

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "PolicyToPathList", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// The batch read exception structure, which contains the exception type and
// message.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/BatchReadException
type BatchReadException struct {
	_ struct{} `type:"structure"`

	// An exception message that is associated with the failure.
	Message *string `type:"string"`

	// A type of exception, such as InvalidArnException.
	Type BatchReadExceptionType `type:"string" enum:"true"`
}

// String returns the string representation
func (s BatchReadException) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchReadException) MarshalFields(e protocol.FieldEncoder) error {
	if s.Message != nil {
		v := *s.Message

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Message", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Represents the output of a BatchRead operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/BatchReadOperation
type BatchReadOperation struct {
	_ struct{} `type:"structure"`

	// Retrieves attributes that are associated with a typed link.
	GetLinkAttributes *BatchGetLinkAttributes `type:"structure"`

	// Retrieves attributes within a facet that are associated with an object.
	GetObjectAttributes *BatchGetObjectAttributes `type:"structure"`

	// Retrieves metadata about an object.
	GetObjectInformation *BatchGetObjectInformation `type:"structure"`

	// Lists indices attached to an object.
	ListAttachedIndices *BatchListAttachedIndices `type:"structure"`

	// Returns a paginated list of all the incoming TypedLinkSpecifier information
	// for an object. It also supports filtering by typed link facet and identity
	// attributes. For more information, see Typed Links (https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink).
	ListIncomingTypedLinks *BatchListIncomingTypedLinks `type:"structure"`

	// Lists objects attached to the specified index.
	ListIndex *BatchListIndex `type:"structure"`

	// Lists all attributes that are associated with an object.
	ListObjectAttributes *BatchListObjectAttributes `type:"structure"`

	// Returns a paginated list of child objects that are associated with a given
	// object.
	ListObjectChildren *BatchListObjectChildren `type:"structure"`

	// Retrieves all available parent paths for any object type such as node, leaf
	// node, policy node, and index node objects. For more information about objects,
	// see Directory Structure (https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directorystructure.html).
	ListObjectParentPaths *BatchListObjectParentPaths `type:"structure"`

	ListObjectParents *BatchListObjectParents `type:"structure"`

	// Returns policies attached to an object in pagination fashion.
	ListObjectPolicies *BatchListObjectPolicies `type:"structure"`

	// Returns a paginated list of all the outgoing TypedLinkSpecifier information
	// for an object. It also supports filtering by typed link facet and identity
	// attributes. For more information, see Typed Links (https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink).
	ListOutgoingTypedLinks *BatchListOutgoingTypedLinks `type:"structure"`

	// Returns all of the ObjectIdentifiers to which a given policy is attached.
	ListPolicyAttachments *BatchListPolicyAttachments `type:"structure"`

	// Lists all policies from the root of the Directory to the object specified.
	// If there are no policies present, an empty list is returned. If policies
	// are present, and if some objects don't have the policies attached, it returns
	// the ObjectIdentifier for such objects. If policies are present, it returns
	// ObjectIdentifier, policyId, and policyType. Paths that don't lead to the
	// root from the target object are ignored. For more information, see Policies
	// (https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies).
	LookupPolicy *BatchLookupPolicy `type:"structure"`
}

// String returns the string representation
func (s BatchReadOperation) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchReadOperation) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BatchReadOperation"}
	if s.GetLinkAttributes != nil {
		if err := s.GetLinkAttributes.Validate(); err != nil {
			invalidParams.AddNested("GetLinkAttributes", err.(aws.ErrInvalidParams))
		}
	}
	if s.GetObjectAttributes != nil {
		if err := s.GetObjectAttributes.Validate(); err != nil {
			invalidParams.AddNested("GetObjectAttributes", err.(aws.ErrInvalidParams))
		}
	}
	if s.GetObjectInformation != nil {
		if err := s.GetObjectInformation.Validate(); err != nil {
			invalidParams.AddNested("GetObjectInformation", err.(aws.ErrInvalidParams))
		}
	}
	if s.ListAttachedIndices != nil {
		if err := s.ListAttachedIndices.Validate(); err != nil {
			invalidParams.AddNested("ListAttachedIndices", err.(aws.ErrInvalidParams))
		}
	}
	if s.ListIncomingTypedLinks != nil {
		if err := s.ListIncomingTypedLinks.Validate(); err != nil {
			invalidParams.AddNested("ListIncomingTypedLinks", err.(aws.ErrInvalidParams))
		}
	}
	if s.ListIndex != nil {
		if err := s.ListIndex.Validate(); err != nil {
			invalidParams.AddNested("ListIndex", err.(aws.ErrInvalidParams))
		}
	}
	if s.ListObjectAttributes != nil {
		if err := s.ListObjectAttributes.Validate(); err != nil {
			invalidParams.AddNested("ListObjectAttributes", err.(aws.ErrInvalidParams))
		}
	}
	if s.ListObjectChildren != nil {
		if err := s.ListObjectChildren.Validate(); err != nil {
			invalidParams.AddNested("ListObjectChildren", err.(aws.ErrInvalidParams))
		}
	}
	if s.ListObjectParentPaths != nil {
		if err := s.ListObjectParentPaths.Validate(); err != nil {
			invalidParams.AddNested("ListObjectParentPaths", err.(aws.ErrInvalidParams))
		}
	}
	if s.ListObjectParents != nil {
		if err := s.ListObjectParents.Validate(); err != nil {
			invalidParams.AddNested("ListObjectParents", err.(aws.ErrInvalidParams))
		}
	}
	if s.ListObjectPolicies != nil {
		if err := s.ListObjectPolicies.Validate(); err != nil {
			invalidParams.AddNested("ListObjectPolicies", err.(aws.ErrInvalidParams))
		}
	}
	if s.ListOutgoingTypedLinks != nil {
		if err := s.ListOutgoingTypedLinks.Validate(); err != nil {
			invalidParams.AddNested("ListOutgoingTypedLinks", err.(aws.ErrInvalidParams))
		}
	}
	if s.ListPolicyAttachments != nil {
		if err := s.ListPolicyAttachments.Validate(); err != nil {
			invalidParams.AddNested("ListPolicyAttachments", err.(aws.ErrInvalidParams))
		}
	}
	if s.LookupPolicy != nil {
		if err := s.LookupPolicy.Validate(); err != nil {
			invalidParams.AddNested("LookupPolicy", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchReadOperation) MarshalFields(e protocol.FieldEncoder) error {
	if s.GetLinkAttributes != nil {
		v := s.GetLinkAttributes

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "GetLinkAttributes", v, metadata)
	}
	if s.GetObjectAttributes != nil {
		v := s.GetObjectAttributes

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "GetObjectAttributes", v, metadata)
	}
	if s.GetObjectInformation != nil {
		v := s.GetObjectInformation

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "GetObjectInformation", v, metadata)
	}
	if s.ListAttachedIndices != nil {
		v := s.ListAttachedIndices

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ListAttachedIndices", v, metadata)
	}
	if s.ListIncomingTypedLinks != nil {
		v := s.ListIncomingTypedLinks

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ListIncomingTypedLinks", v, metadata)
	}
	if s.ListIndex != nil {
		v := s.ListIndex

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ListIndex", v, metadata)
	}
	if s.ListObjectAttributes != nil {
		v := s.ListObjectAttributes

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ListObjectAttributes", v, metadata)
	}
	if s.ListObjectChildren != nil {
		v := s.ListObjectChildren

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ListObjectChildren", v, metadata)
	}
	if s.ListObjectParentPaths != nil {
		v := s.ListObjectParentPaths

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ListObjectParentPaths", v, metadata)
	}
	if s.ListObjectParents != nil {
		v := s.ListObjectParents

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ListObjectParents", v, metadata)
	}
	if s.ListObjectPolicies != nil {
		v := s.ListObjectPolicies

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ListObjectPolicies", v, metadata)
	}
	if s.ListOutgoingTypedLinks != nil {
		v := s.ListOutgoingTypedLinks

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ListOutgoingTypedLinks", v, metadata)
	}
	if s.ListPolicyAttachments != nil {
		v := s.ListPolicyAttachments

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ListPolicyAttachments", v, metadata)
	}
	if s.LookupPolicy != nil {
		v := s.LookupPolicy

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "LookupPolicy", v, metadata)
	}
	return nil
}

// Represents the output of a BatchRead response operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/BatchReadOperationResponse
type BatchReadOperationResponse struct {
	_ struct{} `type:"structure"`

	// Identifies which operation in a batch has failed.
	ExceptionResponse *BatchReadException `type:"structure"`

	// Identifies which operation in a batch has succeeded.
	SuccessfulResponse *BatchReadSuccessfulResponse `type:"structure"`
}

// String returns the string representation
func (s BatchReadOperationResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchReadOperationResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.ExceptionResponse != nil {
		v := s.ExceptionResponse

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ExceptionResponse", v, metadata)
	}
	if s.SuccessfulResponse != nil {
		v := s.SuccessfulResponse

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "SuccessfulResponse", v, metadata)
	}
	return nil
}

// Represents the output of a BatchRead success response operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/BatchReadSuccessfulResponse
type BatchReadSuccessfulResponse struct {
	_ struct{} `type:"structure"`

	// The list of attributes to retrieve from the typed link.
	GetLinkAttributes *BatchGetLinkAttributesResponse `type:"structure"`

	// Retrieves attributes within a facet that are associated with an object.
	GetObjectAttributes *BatchGetObjectAttributesResponse `type:"structure"`

	// Retrieves metadata about an object.
	GetObjectInformation *BatchGetObjectInformationResponse `type:"structure"`

	// Lists indices attached to an object.
	ListAttachedIndices *BatchListAttachedIndicesResponse `type:"structure"`

	// Returns a paginated list of all the incoming TypedLinkSpecifier information
	// for an object. It also supports filtering by typed link facet and identity
	// attributes. For more information, see Typed Links (https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink).
	ListIncomingTypedLinks *BatchListIncomingTypedLinksResponse `type:"structure"`

	// Lists objects attached to the specified index.
	ListIndex *BatchListIndexResponse `type:"structure"`

	// Lists all attributes that are associated with an object.
	ListObjectAttributes *BatchListObjectAttributesResponse `type:"structure"`

	// Returns a paginated list of child objects that are associated with a given
	// object.
	ListObjectChildren *BatchListObjectChildrenResponse `type:"structure"`

	// Retrieves all available parent paths for any object type such as node, leaf
	// node, policy node, and index node objects. For more information about objects,
	// see Directory Structure (https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directorystructure.html).
	ListObjectParentPaths *BatchListObjectParentPathsResponse `type:"structure"`

	ListObjectParents *BatchListObjectParentsResponse `type:"structure"`

	// Returns policies attached to an object in pagination fashion.
	ListObjectPolicies *BatchListObjectPoliciesResponse `type:"structure"`

	// Returns a paginated list of all the outgoing TypedLinkSpecifier information
	// for an object. It also supports filtering by typed link facet and identity
	// attributes. For more information, see Typed Links (https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink).
	ListOutgoingTypedLinks *BatchListOutgoingTypedLinksResponse `type:"structure"`

	// Returns all of the ObjectIdentifiers to which a given policy is attached.
	ListPolicyAttachments *BatchListPolicyAttachmentsResponse `type:"structure"`

	// Lists all policies from the root of the Directory to the object specified.
	// If there are no policies present, an empty list is returned. If policies
	// are present, and if some objects don't have the policies attached, it returns
	// the ObjectIdentifier for such objects. If policies are present, it returns
	// ObjectIdentifier, policyId, and policyType. Paths that don't lead to the
	// root from the target object are ignored. For more information, see Policies
	// (https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies).
	LookupPolicy *BatchLookupPolicyResponse `type:"structure"`
}

// String returns the string representation
func (s BatchReadSuccessfulResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchReadSuccessfulResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.GetLinkAttributes != nil {
		v := s.GetLinkAttributes

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "GetLinkAttributes", v, metadata)
	}
	if s.GetObjectAttributes != nil {
		v := s.GetObjectAttributes

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "GetObjectAttributes", v, metadata)
	}
	if s.GetObjectInformation != nil {
		v := s.GetObjectInformation

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "GetObjectInformation", v, metadata)
	}
	if s.ListAttachedIndices != nil {
		v := s.ListAttachedIndices

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ListAttachedIndices", v, metadata)
	}
	if s.ListIncomingTypedLinks != nil {
		v := s.ListIncomingTypedLinks

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ListIncomingTypedLinks", v, metadata)
	}
	if s.ListIndex != nil {
		v := s.ListIndex

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ListIndex", v, metadata)
	}
	if s.ListObjectAttributes != nil {
		v := s.ListObjectAttributes

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ListObjectAttributes", v, metadata)
	}
	if s.ListObjectChildren != nil {
		v := s.ListObjectChildren

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ListObjectChildren", v, metadata)
	}
	if s.ListObjectParentPaths != nil {
		v := s.ListObjectParentPaths

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ListObjectParentPaths", v, metadata)
	}
	if s.ListObjectParents != nil {
		v := s.ListObjectParents

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ListObjectParents", v, metadata)
	}
	if s.ListObjectPolicies != nil {
		v := s.ListObjectPolicies

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ListObjectPolicies", v, metadata)
	}
	if s.ListOutgoingTypedLinks != nil {
		v := s.ListOutgoingTypedLinks

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ListOutgoingTypedLinks", v, metadata)
	}
	if s.ListPolicyAttachments != nil {
		v := s.ListPolicyAttachments

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ListPolicyAttachments", v, metadata)
	}
	if s.LookupPolicy != nil {
		v := s.LookupPolicy

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "LookupPolicy", v, metadata)
	}
	return nil
}

// A batch operation to remove a facet from an object.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/BatchRemoveFacetFromObject
type BatchRemoveFacetFromObject struct {
	_ struct{} `type:"structure"`

	// A reference to the object whose facet will be removed.
	//
	// ObjectReference is a required field
	ObjectReference *ObjectReference `type:"structure" required:"true"`

	// The facet to remove from the object.
	//
	// SchemaFacet is a required field
	SchemaFacet *SchemaFacet `type:"structure" required:"true"`
}

// String returns the string representation
func (s BatchRemoveFacetFromObject) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchRemoveFacetFromObject) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BatchRemoveFacetFromObject"}

	if s.ObjectReference == nil {
		invalidParams.Add(aws.NewErrParamRequired("ObjectReference"))
	}

	if s.SchemaFacet == nil {
		invalidParams.Add(aws.NewErrParamRequired("SchemaFacet"))
	}
	if s.SchemaFacet != nil {
		if err := s.SchemaFacet.Validate(); err != nil {
			invalidParams.AddNested("SchemaFacet", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchRemoveFacetFromObject) MarshalFields(e protocol.FieldEncoder) error {
	if s.ObjectReference != nil {
		v := s.ObjectReference

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ObjectReference", v, metadata)
	}
	if s.SchemaFacet != nil {
		v := s.SchemaFacet

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "SchemaFacet", v, metadata)
	}
	return nil
}

// An empty result that represents success.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/BatchRemoveFacetFromObjectResponse
type BatchRemoveFacetFromObjectResponse struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s BatchRemoveFacetFromObjectResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchRemoveFacetFromObjectResponse) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

// Updates a given typed link’s attributes inside a BatchRead operation. Attributes
// to be updated must not contribute to the typed link’s identity, as defined
// by its IdentityAttributeOrder. For more information, see UpdateLinkAttributes
// and BatchReadRequest$Operations.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/BatchUpdateLinkAttributes
type BatchUpdateLinkAttributes struct {
	_ struct{} `type:"structure"`

	// The attributes update structure.
	//
	// AttributeUpdates is a required field
	AttributeUpdates []LinkAttributeUpdate `type:"list" required:"true"`

	// Allows a typed link specifier to be accepted as input.
	//
	// TypedLinkSpecifier is a required field
	TypedLinkSpecifier *TypedLinkSpecifier `type:"structure" required:"true"`
}

// String returns the string representation
func (s BatchUpdateLinkAttributes) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchUpdateLinkAttributes) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BatchUpdateLinkAttributes"}

	if s.AttributeUpdates == nil {
		invalidParams.Add(aws.NewErrParamRequired("AttributeUpdates"))
	}

	if s.TypedLinkSpecifier == nil {
		invalidParams.Add(aws.NewErrParamRequired("TypedLinkSpecifier"))
	}
	if s.AttributeUpdates != nil {
		for i, v := range s.AttributeUpdates {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AttributeUpdates", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.TypedLinkSpecifier != nil {
		if err := s.TypedLinkSpecifier.Validate(); err != nil {
			invalidParams.AddNested("TypedLinkSpecifier", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchUpdateLinkAttributes) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.AttributeUpdates) > 0 {
		v := s.AttributeUpdates

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "AttributeUpdates", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.TypedLinkSpecifier != nil {
		v := s.TypedLinkSpecifier

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "TypedLinkSpecifier", v, metadata)
	}
	return nil
}

// Represents the output of a UpdateLinkAttributes response operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/BatchUpdateLinkAttributesResponse
type BatchUpdateLinkAttributesResponse struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s BatchUpdateLinkAttributesResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchUpdateLinkAttributesResponse) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

// Represents the output of a BatchUpdate operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/BatchUpdateObjectAttributes
type BatchUpdateObjectAttributes struct {
	_ struct{} `type:"structure"`

	// Attributes update structure.
	//
	// AttributeUpdates is a required field
	AttributeUpdates []ObjectAttributeUpdate `type:"list" required:"true"`

	// Reference that identifies the object.
	//
	// ObjectReference is a required field
	ObjectReference *ObjectReference `type:"structure" required:"true"`
}

// String returns the string representation
func (s BatchUpdateObjectAttributes) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchUpdateObjectAttributes) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BatchUpdateObjectAttributes"}

	if s.AttributeUpdates == nil {
		invalidParams.Add(aws.NewErrParamRequired("AttributeUpdates"))
	}

	if s.ObjectReference == nil {
		invalidParams.Add(aws.NewErrParamRequired("ObjectReference"))
	}
	if s.AttributeUpdates != nil {
		for i, v := range s.AttributeUpdates {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AttributeUpdates", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchUpdateObjectAttributes) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.AttributeUpdates) > 0 {
		v := s.AttributeUpdates

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "AttributeUpdates", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ObjectReference != nil {
		v := s.ObjectReference

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ObjectReference", v, metadata)
	}
	return nil
}

// Represents the output of a BatchUpdate response operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/BatchUpdateObjectAttributesResponse
type BatchUpdateObjectAttributesResponse struct {
	_ struct{} `type:"structure"`

	// ID that is associated with the object.
	ObjectIdentifier *string `type:"string"`
}

// String returns the string representation
func (s BatchUpdateObjectAttributesResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchUpdateObjectAttributesResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.ObjectIdentifier != nil {
		v := *s.ObjectIdentifier

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ObjectIdentifier", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Represents the output of a BatchWrite operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/BatchWriteOperation
type BatchWriteOperation struct {
	_ struct{} `type:"structure"`

	// A batch operation that adds a facet to an object.
	AddFacetToObject *BatchAddFacetToObject `type:"structure"`

	// Attaches an object to a Directory.
	AttachObject *BatchAttachObject `type:"structure"`

	// Attaches a policy object to a regular object. An object can have a limited
	// number of attached policies.
	AttachPolicy *BatchAttachPolicy `type:"structure"`

	// Attaches the specified object to the specified index.
	AttachToIndex *BatchAttachToIndex `type:"structure"`

	// Attaches a typed link to a specified source and target object. For more information,
	// see Typed Links (https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink).
	AttachTypedLink *BatchAttachTypedLink `type:"structure"`

	// Creates an index object. See Indexing and search (https://docs.aws.amazon.com/clouddirectory/latest/developerguide/indexing_search.htm)
	// for more information.
	CreateIndex *BatchCreateIndex `type:"structure"`

	// Creates an object.
	CreateObject *BatchCreateObject `type:"structure"`

	// Deletes an object in a Directory.
	DeleteObject *BatchDeleteObject `type:"structure"`

	// Detaches the specified object from the specified index.
	DetachFromIndex *BatchDetachFromIndex `type:"structure"`

	// Detaches an object from a Directory.
	DetachObject *BatchDetachObject `type:"structure"`

	// Detaches a policy from a Directory.
	DetachPolicy *BatchDetachPolicy `type:"structure"`

	// Detaches a typed link from a specified source and target object. For more
	// information, see Typed Links (https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink).
	DetachTypedLink *BatchDetachTypedLink `type:"structure"`

	// A batch operation that removes a facet from an object.
	RemoveFacetFromObject *BatchRemoveFacetFromObject `type:"structure"`

	// Updates a given object's attributes.
	UpdateLinkAttributes *BatchUpdateLinkAttributes `type:"structure"`

	// Updates a given object's attributes.
	UpdateObjectAttributes *BatchUpdateObjectAttributes `type:"structure"`
}

// String returns the string representation
func (s BatchWriteOperation) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchWriteOperation) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BatchWriteOperation"}
	if s.AddFacetToObject != nil {
		if err := s.AddFacetToObject.Validate(); err != nil {
			invalidParams.AddNested("AddFacetToObject", err.(aws.ErrInvalidParams))
		}
	}
	if s.AttachObject != nil {
		if err := s.AttachObject.Validate(); err != nil {
			invalidParams.AddNested("AttachObject", err.(aws.ErrInvalidParams))
		}
	}
	if s.AttachPolicy != nil {
		if err := s.AttachPolicy.Validate(); err != nil {
			invalidParams.AddNested("AttachPolicy", err.(aws.ErrInvalidParams))
		}
	}
	if s.AttachToIndex != nil {
		if err := s.AttachToIndex.Validate(); err != nil {
			invalidParams.AddNested("AttachToIndex", err.(aws.ErrInvalidParams))
		}
	}
	if s.AttachTypedLink != nil {
		if err := s.AttachTypedLink.Validate(); err != nil {
			invalidParams.AddNested("AttachTypedLink", err.(aws.ErrInvalidParams))
		}
	}
	if s.CreateIndex != nil {
		if err := s.CreateIndex.Validate(); err != nil {
			invalidParams.AddNested("CreateIndex", err.(aws.ErrInvalidParams))
		}
	}
	if s.CreateObject != nil {
		if err := s.CreateObject.Validate(); err != nil {
			invalidParams.AddNested("CreateObject", err.(aws.ErrInvalidParams))
		}
	}
	if s.DeleteObject != nil {
		if err := s.DeleteObject.Validate(); err != nil {
			invalidParams.AddNested("DeleteObject", err.(aws.ErrInvalidParams))
		}
	}
	if s.DetachFromIndex != nil {
		if err := s.DetachFromIndex.Validate(); err != nil {
			invalidParams.AddNested("DetachFromIndex", err.(aws.ErrInvalidParams))
		}
	}
	if s.DetachObject != nil {
		if err := s.DetachObject.Validate(); err != nil {
			invalidParams.AddNested("DetachObject", err.(aws.ErrInvalidParams))
		}
	}
	if s.DetachPolicy != nil {
		if err := s.DetachPolicy.Validate(); err != nil {
			invalidParams.AddNested("DetachPolicy", err.(aws.ErrInvalidParams))
		}
	}
	if s.DetachTypedLink != nil {
		if err := s.DetachTypedLink.Validate(); err != nil {
			invalidParams.AddNested("DetachTypedLink", err.(aws.ErrInvalidParams))
		}
	}
	if s.RemoveFacetFromObject != nil {
		if err := s.RemoveFacetFromObject.Validate(); err != nil {
			invalidParams.AddNested("RemoveFacetFromObject", err.(aws.ErrInvalidParams))
		}
	}
	if s.UpdateLinkAttributes != nil {
		if err := s.UpdateLinkAttributes.Validate(); err != nil {
			invalidParams.AddNested("UpdateLinkAttributes", err.(aws.ErrInvalidParams))
		}
	}
	if s.UpdateObjectAttributes != nil {
		if err := s.UpdateObjectAttributes.Validate(); err != nil {
			invalidParams.AddNested("UpdateObjectAttributes", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchWriteOperation) MarshalFields(e protocol.FieldEncoder) error {
	if s.AddFacetToObject != nil {
		v := s.AddFacetToObject

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "AddFacetToObject", v, metadata)
	}
	if s.AttachObject != nil {
		v := s.AttachObject

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "AttachObject", v, metadata)
	}
	if s.AttachPolicy != nil {
		v := s.AttachPolicy

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "AttachPolicy", v, metadata)
	}
	if s.AttachToIndex != nil {
		v := s.AttachToIndex

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "AttachToIndex", v, metadata)
	}
	if s.AttachTypedLink != nil {
		v := s.AttachTypedLink

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "AttachTypedLink", v, metadata)
	}
	if s.CreateIndex != nil {
		v := s.CreateIndex

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "CreateIndex", v, metadata)
	}
	if s.CreateObject != nil {
		v := s.CreateObject

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "CreateObject", v, metadata)
	}
	if s.DeleteObject != nil {
		v := s.DeleteObject

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "DeleteObject", v, metadata)
	}
	if s.DetachFromIndex != nil {
		v := s.DetachFromIndex

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "DetachFromIndex", v, metadata)
	}
	if s.DetachObject != nil {
		v := s.DetachObject

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "DetachObject", v, metadata)
	}
	if s.DetachPolicy != nil {
		v := s.DetachPolicy

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "DetachPolicy", v, metadata)
	}
	if s.DetachTypedLink != nil {
		v := s.DetachTypedLink

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "DetachTypedLink", v, metadata)
	}
	if s.RemoveFacetFromObject != nil {
		v := s.RemoveFacetFromObject

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "RemoveFacetFromObject", v, metadata)
	}
	if s.UpdateLinkAttributes != nil {
		v := s.UpdateLinkAttributes

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "UpdateLinkAttributes", v, metadata)
	}
	if s.UpdateObjectAttributes != nil {
		v := s.UpdateObjectAttributes

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "UpdateObjectAttributes", v, metadata)
	}
	return nil
}

// Represents the output of a BatchWrite response operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/BatchWriteOperationResponse
type BatchWriteOperationResponse struct {
	_ struct{} `type:"structure"`

	// The result of an add facet to object batch operation.
	AddFacetToObject *BatchAddFacetToObjectResponse `type:"structure"`

	// Attaches an object to a Directory.
	AttachObject *BatchAttachObjectResponse `type:"structure"`

	// Attaches a policy object to a regular object. An object can have a limited
	// number of attached policies.
	AttachPolicy *BatchAttachPolicyResponse `type:"structure"`

	// Attaches the specified object to the specified index.
	AttachToIndex *BatchAttachToIndexResponse `type:"structure"`

	// Attaches a typed link to a specified source and target object. For more information,
	// see Typed Links (https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink).
	AttachTypedLink *BatchAttachTypedLinkResponse `type:"structure"`

	// Creates an index object. See Indexing and search (https://docs.aws.amazon.com/clouddirectory/latest/developerguide/indexing_search.htm)
	// for more information.
	CreateIndex *BatchCreateIndexResponse `type:"structure"`

	// Creates an object in a Directory.
	CreateObject *BatchCreateObjectResponse `type:"structure"`

	// Deletes an object in a Directory.
	DeleteObject *BatchDeleteObjectResponse `type:"structure"`

	// Detaches the specified object from the specified index.
	DetachFromIndex *BatchDetachFromIndexResponse `type:"structure"`

	// Detaches an object from a Directory.
	DetachObject *BatchDetachObjectResponse `type:"structure"`

	// Detaches a policy from a Directory.
	DetachPolicy *BatchDetachPolicyResponse `type:"structure"`

	// Detaches a typed link from a specified source and target object. For more
	// information, see Typed Links (https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink).
	DetachTypedLink *BatchDetachTypedLinkResponse `type:"structure"`

	// The result of a batch remove facet from object operation.
	RemoveFacetFromObject *BatchRemoveFacetFromObjectResponse `type:"structure"`

	// Represents the output of a BatchWrite response operation.
	UpdateLinkAttributes *BatchUpdateLinkAttributesResponse `type:"structure"`

	// Updates a given object’s attributes.
	UpdateObjectAttributes *BatchUpdateObjectAttributesResponse `type:"structure"`
}

// String returns the string representation
func (s BatchWriteOperationResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchWriteOperationResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.AddFacetToObject != nil {
		v := s.AddFacetToObject

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "AddFacetToObject", v, metadata)
	}
	if s.AttachObject != nil {
		v := s.AttachObject

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "AttachObject", v, metadata)
	}
	if s.AttachPolicy != nil {
		v := s.AttachPolicy

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "AttachPolicy", v, metadata)
	}
	if s.AttachToIndex != nil {
		v := s.AttachToIndex

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "AttachToIndex", v, metadata)
	}
	if s.AttachTypedLink != nil {
		v := s.AttachTypedLink

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "AttachTypedLink", v, metadata)
	}
	if s.CreateIndex != nil {
		v := s.CreateIndex

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "CreateIndex", v, metadata)
	}
	if s.CreateObject != nil {
		v := s.CreateObject

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "CreateObject", v, metadata)
	}
	if s.DeleteObject != nil {
		v := s.DeleteObject

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "DeleteObject", v, metadata)
	}
	if s.DetachFromIndex != nil {
		v := s.DetachFromIndex

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "DetachFromIndex", v, metadata)
	}
	if s.DetachObject != nil {
		v := s.DetachObject

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "DetachObject", v, metadata)
	}
	if s.DetachPolicy != nil {
		v := s.DetachPolicy

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "DetachPolicy", v, metadata)
	}
	if s.DetachTypedLink != nil {
		v := s.DetachTypedLink

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "DetachTypedLink", v, metadata)
	}
	if s.RemoveFacetFromObject != nil {
		v := s.RemoveFacetFromObject

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "RemoveFacetFromObject", v, metadata)
	}
	if s.UpdateLinkAttributes != nil {
		v := s.UpdateLinkAttributes

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "UpdateLinkAttributes", v, metadata)
	}
	if s.UpdateObjectAttributes != nil {
		v := s.UpdateObjectAttributes

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "UpdateObjectAttributes", v, metadata)
	}
	return nil
}

// Directory structure that includes the directory name and directory ARN.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/Directory
type Directory struct {
	_ struct{} `type:"structure"`

	// The date and time when the directory was created.
	CreationDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The Amazon Resource Name (ARN) that is associated with the directory. For
	// more information, see arns.
	DirectoryArn *string `type:"string"`

	// The name of the directory.
	Name *string `min:"1" type:"string"`

	// The state of the directory. Can be either Enabled, Disabled, or Deleted.
	State DirectoryState `type:"string" enum:"true"`
}

// String returns the string representation
func (s Directory) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Directory) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreationDateTime != nil {
		v := *s.CreationDateTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationDateTime", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.DirectoryArn != nil {
		v := *s.DirectoryArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DirectoryArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.State) > 0 {
		v := s.State

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "State", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// A structure that contains Name, ARN, Attributes, Rules, and ObjectTypes.
// See Facets (https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_whatarefacets.html)
// for more information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/Facet
type Facet struct {
	_ struct{} `type:"structure"`

	// There are two different styles that you can define on any given facet, Static
	// and Dynamic. For static facets, all attributes must be defined in the schema.
	// For dynamic facets, attributes can be defined during data plane operations.
	FacetStyle FacetStyle `type:"string" enum:"true"`

	// The name of the Facet.
	Name *string `min:"1" type:"string"`

	// The object type that is associated with the facet. See CreateFacetRequest$ObjectType
	// for more details.
	ObjectType ObjectType `type:"string" enum:"true"`
}

// String returns the string representation
func (s Facet) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Facet) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.FacetStyle) > 0 {
		v := s.FacetStyle

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FacetStyle", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ObjectType) > 0 {
		v := s.ObjectType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ObjectType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// An attribute that is associated with the Facet.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/FacetAttribute
type FacetAttribute struct {
	_ struct{} `type:"structure"`

	// A facet attribute consists of either a definition or a reference. This structure
	// contains the attribute definition. See Attribute References (https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_attributereferences.html)
	// for more information.
	AttributeDefinition *FacetAttributeDefinition `type:"structure"`

	// An attribute reference that is associated with the attribute. See Attribute
	// References (https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_attributereferences.html)
	// for more information.
	AttributeReference *FacetAttributeReference `type:"structure"`

	// The name of the facet attribute.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The required behavior of the FacetAttribute.
	RequiredBehavior RequiredAttributeBehavior `type:"string" enum:"true"`
}

// String returns the string representation
func (s FacetAttribute) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FacetAttribute) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "FacetAttribute"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if s.AttributeDefinition != nil {
		if err := s.AttributeDefinition.Validate(); err != nil {
			invalidParams.AddNested("AttributeDefinition", err.(aws.ErrInvalidParams))
		}
	}
	if s.AttributeReference != nil {
		if err := s.AttributeReference.Validate(); err != nil {
			invalidParams.AddNested("AttributeReference", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FacetAttribute) MarshalFields(e protocol.FieldEncoder) error {
	if s.AttributeDefinition != nil {
		v := s.AttributeDefinition

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "AttributeDefinition", v, metadata)
	}
	if s.AttributeReference != nil {
		v := s.AttributeReference

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "AttributeReference", v, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.RequiredBehavior) > 0 {
		v := s.RequiredBehavior

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RequiredBehavior", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// A facet attribute definition. See Attribute References (https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_attributereferences.html)
// for more information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/FacetAttributeDefinition
type FacetAttributeDefinition struct {
	_ struct{} `type:"structure"`

	// The default value of the attribute (if configured).
	DefaultValue *TypedAttributeValue `type:"structure"`

	// Whether the attribute is mutable or not.
	IsImmutable *bool `type:"boolean"`

	// Validation rules attached to the attribute definition.
	Rules map[string]Rule `type:"map"`

	// The type of the attribute.
	//
	// Type is a required field
	Type FacetAttributeType `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s FacetAttributeDefinition) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FacetAttributeDefinition) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "FacetAttributeDefinition"}
	if len(s.Type) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FacetAttributeDefinition) MarshalFields(e protocol.FieldEncoder) error {
	if s.DefaultValue != nil {
		v := s.DefaultValue

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "DefaultValue", v, metadata)
	}
	if s.IsImmutable != nil {
		v := *s.IsImmutable

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IsImmutable", protocol.BoolValue(v), metadata)
	}
	if len(s.Rules) > 0 {
		v := s.Rules

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Rules", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetFields(k1, v1)
		}
		ms0.End()

	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// The facet attribute reference that specifies the attribute definition that
// contains the attribute facet name and attribute name.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/FacetAttributeReference
type FacetAttributeReference struct {
	_ struct{} `type:"structure"`

	// The target attribute name that is associated with the facet reference. See
	// Attribute References (https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_attributereferences.html)
	// for more information.
	//
	// TargetAttributeName is a required field
	TargetAttributeName *string `min:"1" type:"string" required:"true"`

	// The target facet name that is associated with the facet reference. See Attribute
	// References (https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_attributereferences.html)
	// for more information.
	//
	// TargetFacetName is a required field
	TargetFacetName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s FacetAttributeReference) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FacetAttributeReference) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "FacetAttributeReference"}

	if s.TargetAttributeName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TargetAttributeName"))
	}
	if s.TargetAttributeName != nil && len(*s.TargetAttributeName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TargetAttributeName", 1))
	}

	if s.TargetFacetName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TargetFacetName"))
	}
	if s.TargetFacetName != nil && len(*s.TargetFacetName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TargetFacetName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FacetAttributeReference) MarshalFields(e protocol.FieldEncoder) error {
	if s.TargetAttributeName != nil {
		v := *s.TargetAttributeName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TargetAttributeName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TargetFacetName != nil {
		v := *s.TargetFacetName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TargetFacetName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A structure that contains information used to update an attribute.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/FacetAttributeUpdate
type FacetAttributeUpdate struct {
	_ struct{} `type:"structure"`

	// The action to perform when updating the attribute.
	Action UpdateActionType `type:"string" enum:"true"`

	// The attribute to update.
	Attribute *FacetAttribute `type:"structure"`
}

// String returns the string representation
func (s FacetAttributeUpdate) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FacetAttributeUpdate) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "FacetAttributeUpdate"}
	if s.Attribute != nil {
		if err := s.Attribute.Validate(); err != nil {
			invalidParams.AddNested("Attribute", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FacetAttributeUpdate) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Action) > 0 {
		v := s.Action

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Action", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Attribute != nil {
		v := s.Attribute

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Attribute", v, metadata)
	}
	return nil
}

// Represents an index and an attached object.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/IndexAttachment
type IndexAttachment struct {
	_ struct{} `type:"structure"`

	// The indexed attribute values.
	IndexedAttributes []AttributeKeyAndValue `type:"list"`

	// In response to ListIndex, the ObjectIdentifier of the object attached to
	// the index. In response to ListAttachedIndices, the ObjectIdentifier of the
	// index attached to the object. This field will always contain the ObjectIdentifier
	// of the object on the opposite side of the attachment specified in the query.
	ObjectIdentifier *string `type:"string"`
}

// String returns the string representation
func (s IndexAttachment) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s IndexAttachment) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.IndexedAttributes) > 0 {
		v := s.IndexedAttributes

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "IndexedAttributes", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ObjectIdentifier != nil {
		v := *s.ObjectIdentifier

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ObjectIdentifier", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The action to take on a typed link attribute value. Updates are only supported
// for attributes which don’t contribute to link identity.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/LinkAttributeAction
type LinkAttributeAction struct {
	_ struct{} `type:"structure"`

	// A type that can be either UPDATE_OR_CREATE or DELETE.
	AttributeActionType UpdateActionType `type:"string" enum:"true"`

	// The value that you want to update to.
	AttributeUpdateValue *TypedAttributeValue `type:"structure"`
}

// String returns the string representation
func (s LinkAttributeAction) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s LinkAttributeAction) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.AttributeActionType) > 0 {
		v := s.AttributeActionType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AttributeActionType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.AttributeUpdateValue != nil {
		v := s.AttributeUpdateValue

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "AttributeUpdateValue", v, metadata)
	}
	return nil
}

// Structure that contains attribute update information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/LinkAttributeUpdate
type LinkAttributeUpdate struct {
	_ struct{} `type:"structure"`

	// The action to perform as part of the attribute update.
	AttributeAction *LinkAttributeAction `type:"structure"`

	// The key of the attribute being updated.
	AttributeKey *AttributeKey `type:"structure"`
}

// String returns the string representation
func (s LinkAttributeUpdate) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LinkAttributeUpdate) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LinkAttributeUpdate"}
	if s.AttributeKey != nil {
		if err := s.AttributeKey.Validate(); err != nil {
			invalidParams.AddNested("AttributeKey", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s LinkAttributeUpdate) MarshalFields(e protocol.FieldEncoder) error {
	if s.AttributeAction != nil {
		v := s.AttributeAction

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "AttributeAction", v, metadata)
	}
	if s.AttributeKey != nil {
		v := s.AttributeKey

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "AttributeKey", v, metadata)
	}
	return nil
}

// The action to take on the object attribute.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ObjectAttributeAction
type ObjectAttributeAction struct {
	_ struct{} `type:"structure"`

	// A type that can be either Update or Delete.
	ObjectAttributeActionType UpdateActionType `type:"string" enum:"true"`

	// The value that you want to update to.
	ObjectAttributeUpdateValue *TypedAttributeValue `type:"structure"`
}

// String returns the string representation
func (s ObjectAttributeAction) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ObjectAttributeAction) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.ObjectAttributeActionType) > 0 {
		v := s.ObjectAttributeActionType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ObjectAttributeActionType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.ObjectAttributeUpdateValue != nil {
		v := s.ObjectAttributeUpdateValue

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ObjectAttributeUpdateValue", v, metadata)
	}
	return nil
}

// A range of attributes.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ObjectAttributeRange
type ObjectAttributeRange struct {
	_ struct{} `type:"structure"`

	// The key of the attribute that the attribute range covers.
	AttributeKey *AttributeKey `type:"structure"`

	// The range of attribute values being selected.
	Range *TypedAttributeValueRange `type:"structure"`
}

// String returns the string representation
func (s ObjectAttributeRange) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ObjectAttributeRange) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ObjectAttributeRange"}
	if s.AttributeKey != nil {
		if err := s.AttributeKey.Validate(); err != nil {
			invalidParams.AddNested("AttributeKey", err.(aws.ErrInvalidParams))
		}
	}
	if s.Range != nil {
		if err := s.Range.Validate(); err != nil {
			invalidParams.AddNested("Range", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ObjectAttributeRange) MarshalFields(e protocol.FieldEncoder) error {
	if s.AttributeKey != nil {
		v := s.AttributeKey

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "AttributeKey", v, metadata)
	}
	if s.Range != nil {
		v := s.Range

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Range", v, metadata)
	}
	return nil
}

// Structure that contains attribute update information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ObjectAttributeUpdate
type ObjectAttributeUpdate struct {
	_ struct{} `type:"structure"`

	// The action to perform as part of the attribute update.
	ObjectAttributeAction *ObjectAttributeAction `type:"structure"`

	// The key of the attribute being updated.
	ObjectAttributeKey *AttributeKey `type:"structure"`
}

// String returns the string representation
func (s ObjectAttributeUpdate) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ObjectAttributeUpdate) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ObjectAttributeUpdate"}
	if s.ObjectAttributeKey != nil {
		if err := s.ObjectAttributeKey.Validate(); err != nil {
			invalidParams.AddNested("ObjectAttributeKey", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ObjectAttributeUpdate) MarshalFields(e protocol.FieldEncoder) error {
	if s.ObjectAttributeAction != nil {
		v := s.ObjectAttributeAction

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ObjectAttributeAction", v, metadata)
	}
	if s.ObjectAttributeKey != nil {
		v := s.ObjectAttributeKey

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ObjectAttributeKey", v, metadata)
	}
	return nil
}

// A pair of ObjectIdentifier and LinkName.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ObjectIdentifierAndLinkNameTuple
type ObjectIdentifierAndLinkNameTuple struct {
	_ struct{} `type:"structure"`

	// The name of the link between the parent and the child object.
	LinkName *string `min:"1" type:"string"`

	// The ID that is associated with the object.
	ObjectIdentifier *string `type:"string"`
}

// String returns the string representation
func (s ObjectIdentifierAndLinkNameTuple) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ObjectIdentifierAndLinkNameTuple) MarshalFields(e protocol.FieldEncoder) error {
	if s.LinkName != nil {
		v := *s.LinkName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LinkName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ObjectIdentifier != nil {
		v := *s.ObjectIdentifier

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ObjectIdentifier", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The reference that identifies an object.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ObjectReference
type ObjectReference struct {
	_ struct{} `type:"structure"`

	// A path selector supports easy selection of an object by the parent/child
	// links leading to it from the directory root. Use the link names from each
	// parent/child link to construct the path. Path selectors start with a slash
	// (/) and link names are separated by slashes. For more information about paths,
	// see Access Objects (https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_access_objects.html).
	// You can identify an object in one of the following ways:
	//
	//    * $ObjectIdentifier - An object identifier is an opaque string provided
	//    by Amazon Cloud Directory. When creating objects, the system will provide
	//    you with the identifier of the created object. An object’s identifier
	//    is immutable and no two objects will ever share the same object identifier
	//
	//    * /some/path - Identifies the object based on path
	//
	//    * #SomeBatchReference - Identifies the object in a batch call
	Selector *string `type:"string"`
}

// String returns the string representation
func (s ObjectReference) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ObjectReference) MarshalFields(e protocol.FieldEncoder) error {
	if s.Selector != nil {
		v := *s.Selector

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Selector", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Returns the path to the ObjectIdentifiers that is associated with the directory.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/PathToObjectIdentifiers
type PathToObjectIdentifiers struct {
	_ struct{} `type:"structure"`

	// Lists ObjectIdentifiers starting from directory root to the object in the
	// request.
	ObjectIdentifiers []string `type:"list"`

	// The path that is used to identify the object starting from directory root.
	Path *string `type:"string"`
}

// String returns the string representation
func (s PathToObjectIdentifiers) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PathToObjectIdentifiers) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.ObjectIdentifiers) > 0 {
		v := s.ObjectIdentifiers

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ObjectIdentifiers", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.Path != nil {
		v := *s.Path

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Path", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains the PolicyType, PolicyId, and the ObjectIdentifier to which it is
// attached. For more information, see Policies (https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/PolicyAttachment
type PolicyAttachment struct {
	_ struct{} `type:"structure"`

	// The ObjectIdentifier that is associated with PolicyAttachment.
	ObjectIdentifier *string `type:"string"`

	// The ID of PolicyAttachment.
	PolicyId *string `type:"string"`

	// The type of policy that can be associated with PolicyAttachment.
	PolicyType *string `type:"string"`
}

// String returns the string representation
func (s PolicyAttachment) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PolicyAttachment) MarshalFields(e protocol.FieldEncoder) error {
	if s.ObjectIdentifier != nil {
		v := *s.ObjectIdentifier

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ObjectIdentifier", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PolicyId != nil {
		v := *s.PolicyId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PolicyId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PolicyType != nil {
		v := *s.PolicyType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PolicyType", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Used when a regular object exists in a Directory and you want to find all
// of the policies that are associated with that object and the parent to that
// object.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/PolicyToPath
type PolicyToPath struct {
	_ struct{} `type:"structure"`

	// The path that is referenced from the root.
	Path *string `type:"string"`

	// List of policy objects.
	Policies []PolicyAttachment `type:"list"`
}

// String returns the string representation
func (s PolicyToPath) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PolicyToPath) MarshalFields(e protocol.FieldEncoder) error {
	if s.Path != nil {
		v := *s.Path

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Path", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Policies) > 0 {
		v := s.Policies

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Policies", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Contains an Amazon Resource Name (ARN) and parameters that are associated
// with the rule.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/Rule
type Rule struct {
	_ struct{} `type:"structure"`

	// The minimum and maximum parameters that are associated with the rule.
	Parameters map[string]string `type:"map"`

	// The type of attribute validation rule.
	Type RuleType `type:"string" enum:"true"`
}

// String returns the string representation
func (s Rule) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Rule) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Parameters) > 0 {
		v := s.Parameters

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Parameters", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// A facet.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/SchemaFacet
type SchemaFacet struct {
	_ struct{} `type:"structure"`

	// The name of the facet.
	FacetName *string `min:"1" type:"string"`

	// The ARN of the schema that contains the facet with no minor component. See
	// arns and In-Place Schema Upgrade (https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_inplaceschemaupgrade.html)
	// for a description of when to provide minor versions.
	SchemaArn *string `type:"string"`
}

// String returns the string representation
func (s SchemaFacet) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SchemaFacet) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SchemaFacet"}
	if s.FacetName != nil && len(*s.FacetName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FacetName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SchemaFacet) MarshalFields(e protocol.FieldEncoder) error {
	if s.FacetName != nil {
		v := *s.FacetName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FacetName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SchemaArn != nil {
		v := *s.SchemaArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SchemaArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The tag structure that contains a tag key and value.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/Tag
type Tag struct {
	_ struct{} `type:"structure"`

	// The key that is associated with the tag.
	Key *string `type:"string"`

	// The value that is associated with the tag.
	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Tag) MarshalFields(e protocol.FieldEncoder) error {
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Key", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Value", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Represents the data for a typed attribute. You can set one, and only one,
// of the elements. Each attribute in an item is a name-value pair. Attributes
// have a single value.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/TypedAttributeValue
type TypedAttributeValue struct {
	_ struct{} `type:"structure"`

	// A binary data value.
	//
	// BinaryValue is automatically base64 encoded/decoded by the SDK.
	BinaryValue []byte `type:"blob"`

	// A Boolean data value.
	BooleanValue *bool `type:"boolean"`

	// A date and time value.
	DatetimeValue *time.Time `type:"timestamp" timestampFormat:"unix"`

	// A number data value.
	NumberValue *string `type:"string"`

	// A string data value.
	StringValue *string `type:"string"`
}

// String returns the string representation
func (s TypedAttributeValue) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TypedAttributeValue) MarshalFields(e protocol.FieldEncoder) error {
	if s.BinaryValue != nil {
		v := s.BinaryValue

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BinaryValue", protocol.QuotedValue{ValueMarshaler: protocol.BytesValue(v)}, metadata)
	}
	if s.BooleanValue != nil {
		v := *s.BooleanValue

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BooleanValue", protocol.BoolValue(v), metadata)
	}
	if s.DatetimeValue != nil {
		v := *s.DatetimeValue

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DatetimeValue", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.NumberValue != nil {
		v := *s.NumberValue

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NumberValue", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StringValue != nil {
		v := *s.StringValue

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StringValue", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A range of attribute values. For more information, see Range Filters (https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_range_filters.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/TypedAttributeValueRange
type TypedAttributeValueRange struct {
	_ struct{} `type:"structure"`

	// The inclusive or exclusive range end.
	//
	// EndMode is a required field
	EndMode RangeMode `type:"string" required:"true" enum:"true"`

	// The attribute value to terminate the range at.
	EndValue *TypedAttributeValue `type:"structure"`

	// The inclusive or exclusive range start.
	//
	// StartMode is a required field
	StartMode RangeMode `type:"string" required:"true" enum:"true"`

	// The value to start the range at.
	StartValue *TypedAttributeValue `type:"structure"`
}

// String returns the string representation
func (s TypedAttributeValueRange) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TypedAttributeValueRange) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TypedAttributeValueRange"}
	if len(s.EndMode) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("EndMode"))
	}
	if len(s.StartMode) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("StartMode"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TypedAttributeValueRange) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.EndMode) > 0 {
		v := s.EndMode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EndMode", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.EndValue != nil {
		v := s.EndValue

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "EndValue", v, metadata)
	}
	if len(s.StartMode) > 0 {
		v := s.StartMode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StartMode", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.StartValue != nil {
		v := s.StartValue

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "StartValue", v, metadata)
	}
	return nil
}

// A typed link attribute definition.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/TypedLinkAttributeDefinition
type TypedLinkAttributeDefinition struct {
	_ struct{} `type:"structure"`

	// The default value of the attribute (if configured).
	DefaultValue *TypedAttributeValue `type:"structure"`

	// Whether the attribute is mutable or not.
	IsImmutable *bool `type:"boolean"`

	// The unique name of the typed link attribute.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The required behavior of the TypedLinkAttributeDefinition.
	//
	// RequiredBehavior is a required field
	RequiredBehavior RequiredAttributeBehavior `type:"string" required:"true" enum:"true"`

	// Validation rules that are attached to the attribute definition.
	Rules map[string]Rule `type:"map"`

	// The type of the attribute.
	//
	// Type is a required field
	Type FacetAttributeType `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s TypedLinkAttributeDefinition) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TypedLinkAttributeDefinition) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TypedLinkAttributeDefinition"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if len(s.RequiredBehavior) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("RequiredBehavior"))
	}
	if len(s.Type) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TypedLinkAttributeDefinition) MarshalFields(e protocol.FieldEncoder) error {
	if s.DefaultValue != nil {
		v := s.DefaultValue

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "DefaultValue", v, metadata)
	}
	if s.IsImmutable != nil {
		v := *s.IsImmutable

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IsImmutable", protocol.BoolValue(v), metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.RequiredBehavior) > 0 {
		v := s.RequiredBehavior

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RequiredBehavior", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.Rules) > 0 {
		v := s.Rules

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Rules", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetFields(k1, v1)
		}
		ms0.End()

	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Identifies the range of attributes that are used by a specified filter.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/TypedLinkAttributeRange
type TypedLinkAttributeRange struct {
	_ struct{} `type:"structure"`

	// The unique name of the typed link attribute.
	AttributeName *string `min:"1" type:"string"`

	// The range of attribute values that are being selected.
	//
	// Range is a required field
	Range *TypedAttributeValueRange `type:"structure" required:"true"`
}

// String returns the string representation
func (s TypedLinkAttributeRange) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TypedLinkAttributeRange) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TypedLinkAttributeRange"}
	if s.AttributeName != nil && len(*s.AttributeName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AttributeName", 1))
	}

	if s.Range == nil {
		invalidParams.Add(aws.NewErrParamRequired("Range"))
	}
	if s.Range != nil {
		if err := s.Range.Validate(); err != nil {
			invalidParams.AddNested("Range", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TypedLinkAttributeRange) MarshalFields(e protocol.FieldEncoder) error {
	if s.AttributeName != nil {
		v := *s.AttributeName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AttributeName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Range != nil {
		v := s.Range

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Range", v, metadata)
	}
	return nil
}

// Defines the typed links structure and its attributes. To create a typed link
// facet, use the CreateTypedLinkFacet API.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/TypedLinkFacet
type TypedLinkFacet struct {
	_ struct{} `type:"structure"`

	// A set of key-value pairs associated with the typed link. Typed link attributes
	// are used when you have data values that are related to the link itself, and
	// not to one of the two objects being linked. Identity attributes also serve
	// to distinguish the link from others of the same type between the same objects.
	//
	// Attributes is a required field
	Attributes []TypedLinkAttributeDefinition `type:"list" required:"true"`

	// The set of attributes that distinguish links made from this facet from each
	// other, in the order of significance. Listing typed links can filter on the
	// values of these attributes. See ListOutgoingTypedLinks and ListIncomingTypedLinks
	// for details.
	//
	// IdentityAttributeOrder is a required field
	IdentityAttributeOrder []string `type:"list" required:"true"`

	// The unique name of the typed link facet.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s TypedLinkFacet) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TypedLinkFacet) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TypedLinkFacet"}

	if s.Attributes == nil {
		invalidParams.Add(aws.NewErrParamRequired("Attributes"))
	}

	if s.IdentityAttributeOrder == nil {
		invalidParams.Add(aws.NewErrParamRequired("IdentityAttributeOrder"))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Attributes != nil {
		for i, v := range s.Attributes {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Attributes", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TypedLinkFacet) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Attributes) > 0 {
		v := s.Attributes

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Attributes", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.IdentityAttributeOrder) > 0 {
		v := s.IdentityAttributeOrder

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "IdentityAttributeOrder", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A typed link facet attribute update.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/TypedLinkFacetAttributeUpdate
type TypedLinkFacetAttributeUpdate struct {
	_ struct{} `type:"structure"`

	// The action to perform when updating the attribute.
	//
	// Action is a required field
	Action UpdateActionType `type:"string" required:"true" enum:"true"`

	// The attribute to update.
	//
	// Attribute is a required field
	Attribute *TypedLinkAttributeDefinition `type:"structure" required:"true"`
}

// String returns the string representation
func (s TypedLinkFacetAttributeUpdate) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TypedLinkFacetAttributeUpdate) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TypedLinkFacetAttributeUpdate"}
	if len(s.Action) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Action"))
	}

	if s.Attribute == nil {
		invalidParams.Add(aws.NewErrParamRequired("Attribute"))
	}
	if s.Attribute != nil {
		if err := s.Attribute.Validate(); err != nil {
			invalidParams.AddNested("Attribute", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TypedLinkFacetAttributeUpdate) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Action) > 0 {
		v := s.Action

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Action", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Attribute != nil {
		v := s.Attribute

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Attribute", v, metadata)
	}
	return nil
}

// Identifies the schema Amazon Resource Name (ARN) and facet name for the typed
// link.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/TypedLinkSchemaAndFacetName
type TypedLinkSchemaAndFacetName struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that is associated with the schema. For more
	// information, see arns.
	//
	// SchemaArn is a required field
	SchemaArn *string `type:"string" required:"true"`

	// The unique name of the typed link facet.
	//
	// TypedLinkName is a required field
	TypedLinkName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s TypedLinkSchemaAndFacetName) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TypedLinkSchemaAndFacetName) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TypedLinkSchemaAndFacetName"}

	if s.SchemaArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("SchemaArn"))
	}

	if s.TypedLinkName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TypedLinkName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TypedLinkSchemaAndFacetName) MarshalFields(e protocol.FieldEncoder) error {
	if s.SchemaArn != nil {
		v := *s.SchemaArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SchemaArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TypedLinkName != nil {
		v := *s.TypedLinkName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TypedLinkName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains all the information that is used to uniquely identify a typed link.
// The parameters discussed in this topic are used to uniquely specify the typed
// link being operated on. The AttachTypedLink API returns a typed link specifier
// while the DetachTypedLink API accepts one as input. Similarly, the ListIncomingTypedLinks
// and ListOutgoingTypedLinks API operations provide typed link specifiers as
// output. You can also construct a typed link specifier from scratch.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/TypedLinkSpecifier
type TypedLinkSpecifier struct {
	_ struct{} `type:"structure"`

	// Identifies the attribute value to update.
	//
	// IdentityAttributeValues is a required field
	IdentityAttributeValues []AttributeNameAndValue `type:"list" required:"true"`

	// Identifies the source object that the typed link will attach to.
	//
	// SourceObjectReference is a required field
	SourceObjectReference *ObjectReference `type:"structure" required:"true"`

	// Identifies the target object that the typed link will attach to.
	//
	// TargetObjectReference is a required field
	TargetObjectReference *ObjectReference `type:"structure" required:"true"`

	// Identifies the typed link facet that is associated with the typed link.
	//
	// TypedLinkFacet is a required field
	TypedLinkFacet *TypedLinkSchemaAndFacetName `type:"structure" required:"true"`
}

// String returns the string representation
func (s TypedLinkSpecifier) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TypedLinkSpecifier) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TypedLinkSpecifier"}

	if s.IdentityAttributeValues == nil {
		invalidParams.Add(aws.NewErrParamRequired("IdentityAttributeValues"))
	}

	if s.SourceObjectReference == nil {
		invalidParams.Add(aws.NewErrParamRequired("SourceObjectReference"))
	}

	if s.TargetObjectReference == nil {
		invalidParams.Add(aws.NewErrParamRequired("TargetObjectReference"))
	}

	if s.TypedLinkFacet == nil {
		invalidParams.Add(aws.NewErrParamRequired("TypedLinkFacet"))
	}
	if s.IdentityAttributeValues != nil {
		for i, v := range s.IdentityAttributeValues {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "IdentityAttributeValues", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.TypedLinkFacet != nil {
		if err := s.TypedLinkFacet.Validate(); err != nil {
			invalidParams.AddNested("TypedLinkFacet", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TypedLinkSpecifier) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.IdentityAttributeValues) > 0 {
		v := s.IdentityAttributeValues

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "IdentityAttributeValues", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.SourceObjectReference != nil {
		v := s.SourceObjectReference

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "SourceObjectReference", v, metadata)
	}
	if s.TargetObjectReference != nil {
		v := s.TargetObjectReference

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "TargetObjectReference", v, metadata)
	}
	if s.TypedLinkFacet != nil {
		v := s.TypedLinkFacet

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "TypedLinkFacet", v, metadata)
	}
	return nil
}
