// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudtrail

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/PutEventSelectorsRequest
type PutEventSelectorsInput struct {
	_ struct{} `type:"structure"`

	// Specifies the settings for your event selectors. You can configure up to
	// five event selectors for a trail.
	//
	// EventSelectors is a required field
	EventSelectors []EventSelector `type:"list" required:"true"`

	// Specifies the name of the trail or trail ARN. If you specify a trail name,
	// the string must meet the following requirements:
	//
	//    * Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores
	//    (_), or dashes (-)
	//
	//    * Start with a letter or number, and end with a letter or number
	//
	//    * Be between 3 and 128 characters
	//
	//    * Have no adjacent periods, underscores or dashes. Names like my-_namespace
	//    and my--namespace are invalid.
	//
	//    * Not be in IP address format (for example, 192.168.5.4)
	//
	// If you specify a trail ARN, it must be in the format:
	//
	// arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail
	//
	// TrailName is a required field
	TrailName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s PutEventSelectorsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutEventSelectorsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutEventSelectorsInput"}

	if s.EventSelectors == nil {
		invalidParams.Add(aws.NewErrParamRequired("EventSelectors"))
	}

	if s.TrailName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TrailName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/PutEventSelectorsResponse
type PutEventSelectorsOutput struct {
	_ struct{} `type:"structure"`

	// Specifies the event selectors configured for your trail.
	EventSelectors []EventSelector `type:"list"`

	// Specifies the ARN of the trail that was updated with event selectors. The
	// format of a trail ARN is:
	//
	// arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail
	TrailARN *string `type:"string"`
}

// String returns the string representation
func (s PutEventSelectorsOutput) String() string {
	return awsutil.Prettify(s)
}

const opPutEventSelectors = "PutEventSelectors"

// PutEventSelectorsRequest returns a request value for making API operation for
// AWS CloudTrail.
//
// Configures an event selector for your trail. Use event selectors to further
// specify the management and data event settings for your trail. By default,
// trails created without specific event selectors will be configured to log
// all read and write management events, and no data events.
//
// When an event occurs in your account, CloudTrail evaluates the event selectors
// in all trails. For each trail, if the event matches any event selector, the
// trail processes and logs the event. If the event doesn't match any event
// selector, the trail doesn't log the event.
//
// Example
//
// You create an event selector for a trail and specify that you want write-only
// events.
//
// The EC2 GetConsoleOutput and RunInstances API operations occur in your account.
//
// CloudTrail evaluates whether the events match your event selectors.
//
// The RunInstances is a write-only event and it matches your event selector.
// The trail logs the event.
//
// The GetConsoleOutput is a read-only event but it doesn't match your event
// selector. The trail doesn't log the event.
//
// The PutEventSelectors operation must be called from the region in which the
// trail was created; otherwise, an InvalidHomeRegionException is thrown.
//
// You can configure up to five event selectors for each trail. For more information,
// see Logging Data and Management Events for Trails (http://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-management-and-data-events-with-cloudtrail.html)
// and Limits in AWS CloudTrail (https://docs.aws.amazon.com/awscloudtrail/latest/userguide/WhatIsCloudTrail-Limits.html)
// in the AWS CloudTrail User Guide.
//
//    // Example sending a request using PutEventSelectorsRequest.
//    req := client.PutEventSelectorsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/PutEventSelectors
func (c *Client) PutEventSelectorsRequest(input *PutEventSelectorsInput) PutEventSelectorsRequest {
	op := &aws.Operation{
		Name:       opPutEventSelectors,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutEventSelectorsInput{}
	}

	req := c.newRequest(op, input, &PutEventSelectorsOutput{})
	return PutEventSelectorsRequest{Request: req, Input: input, Copy: c.PutEventSelectorsRequest}
}

// PutEventSelectorsRequest is the request type for the
// PutEventSelectors API operation.
type PutEventSelectorsRequest struct {
	*aws.Request
	Input *PutEventSelectorsInput
	Copy  func(*PutEventSelectorsInput) PutEventSelectorsRequest
}

// Send marshals and sends the PutEventSelectors API request.
func (r PutEventSelectorsRequest) Send(ctx context.Context) (*PutEventSelectorsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutEventSelectorsResponse{
		PutEventSelectorsOutput: r.Request.Data.(*PutEventSelectorsOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutEventSelectorsResponse is the response type for the
// PutEventSelectors API operation.
type PutEventSelectorsResponse struct {
	*PutEventSelectorsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutEventSelectors request.
func (r *PutEventSelectorsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
