// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cognitoidentity

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Input to the LookupDeveloperIdentityInput action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/LookupDeveloperIdentityInput
type LookupDeveloperIdentityInput struct {
	_ struct{} `type:"structure"`

	// A unique ID used by your backend authentication process to identify a user.
	// Typically, a developer identity provider would issue many developer user
	// identifiers, in keeping with the number of users.
	DeveloperUserIdentifier *string `min:"1" type:"string"`

	// A unique identifier in the format REGION:GUID.
	IdentityId *string `min:"1" type:"string"`

	// An identity pool ID in the format REGION:GUID.
	//
	// IdentityPoolId is a required field
	IdentityPoolId *string `min:"1" type:"string" required:"true"`

	// The maximum number of identities to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// A pagination token. The first call you make will have NextToken set to null.
	// After that the service will return NextToken values as needed. For example,
	// let's say you make a request with MaxResults set to 10, and there are 20
	// matches in the database. The service will return a pagination token as a
	// part of the response. This token can be used to call the API again and get
	// results starting from the 11th match.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s LookupDeveloperIdentityInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LookupDeveloperIdentityInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LookupDeveloperIdentityInput"}
	if s.DeveloperUserIdentifier != nil && len(*s.DeveloperUserIdentifier) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DeveloperUserIdentifier", 1))
	}
	if s.IdentityId != nil && len(*s.IdentityId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("IdentityId", 1))
	}

	if s.IdentityPoolId == nil {
		invalidParams.Add(aws.NewErrParamRequired("IdentityPoolId"))
	}
	if s.IdentityPoolId != nil && len(*s.IdentityPoolId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("IdentityPoolId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Returned in response to a successful LookupDeveloperIdentity action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/LookupDeveloperIdentityResponse
type LookupDeveloperIdentityOutput struct {
	_ struct{} `type:"structure"`

	// This is the list of developer user identifiers associated with an identity
	// ID. Cognito supports the association of multiple developer user identifiers
	// with an identity ID.
	DeveloperUserIdentifierList []string `type:"list"`

	// A unique identifier in the format REGION:GUID.
	IdentityId *string `min:"1" type:"string"`

	// A pagination token. The first call you make will have NextToken set to null.
	// After that the service will return NextToken values as needed. For example,
	// let's say you make a request with MaxResults set to 10, and there are 20
	// matches in the database. The service will return a pagination token as a
	// part of the response. This token can be used to call the API again and get
	// results starting from the 11th match.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s LookupDeveloperIdentityOutput) String() string {
	return awsutil.Prettify(s)
}

const opLookupDeveloperIdentity = "LookupDeveloperIdentity"

// LookupDeveloperIdentityRequest returns a request value for making API operation for
// Amazon Cognito Identity.
//
// Retrieves the IdentityID associated with a DeveloperUserIdentifier or the
// list of DeveloperUserIdentifier values associated with an IdentityId for
// an existing identity. Either IdentityID or DeveloperUserIdentifier must not
// be null. If you supply only one of these values, the other value will be
// searched in the database and returned as a part of the response. If you supply
// both, DeveloperUserIdentifier will be matched against IdentityID. If the
// values are verified against the database, the response returns both values
// and is the same as the request. Otherwise a ResourceConflictException is
// thrown.
//
// LookupDeveloperIdentity is intended for low-throughput control plane operations:
// for example, to enable customer service to locate an identity ID by username.
// If you are using it for higher-volume operations such as user authentication,
// your requests are likely to be throttled. GetOpenIdTokenForDeveloperIdentity
// is a better option for higher-volume operations for user authentication.
//
// You must use AWS Developer credentials to call this API.
//
//    // Example sending a request using LookupDeveloperIdentityRequest.
//    req := client.LookupDeveloperIdentityRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/LookupDeveloperIdentity
func (c *Client) LookupDeveloperIdentityRequest(input *LookupDeveloperIdentityInput) LookupDeveloperIdentityRequest {
	op := &aws.Operation{
		Name:       opLookupDeveloperIdentity,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &LookupDeveloperIdentityInput{}
	}

	req := c.newRequest(op, input, &LookupDeveloperIdentityOutput{})
	return LookupDeveloperIdentityRequest{Request: req, Input: input, Copy: c.LookupDeveloperIdentityRequest}
}

// LookupDeveloperIdentityRequest is the request type for the
// LookupDeveloperIdentity API operation.
type LookupDeveloperIdentityRequest struct {
	*aws.Request
	Input *LookupDeveloperIdentityInput
	Copy  func(*LookupDeveloperIdentityInput) LookupDeveloperIdentityRequest
}

// Send marshals and sends the LookupDeveloperIdentity API request.
func (r LookupDeveloperIdentityRequest) Send(ctx context.Context) (*LookupDeveloperIdentityResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &LookupDeveloperIdentityResponse{
		LookupDeveloperIdentityOutput: r.Request.Data.(*LookupDeveloperIdentityOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// LookupDeveloperIdentityResponse is the response type for the
// LookupDeveloperIdentity API operation.
type LookupDeveloperIdentityResponse struct {
	*LookupDeveloperIdentityOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// LookupDeveloperIdentity request.
func (r *LookupDeveloperIdentityResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
