// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package configservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigRuleEvaluationStatusRequest
type DescribeConfigRuleEvaluationStatusInput struct {
	_ struct{} `type:"structure"`

	// The name of the AWS managed Config rules for which you want status information.
	// If you do not specify any names, AWS Config returns status information for
	// all AWS managed Config rules that you use.
	ConfigRuleNames []string `type:"list"`

	// The number of rule evaluation results that you want returned.
	//
	// This parameter is required if the rule limit for your account is more than
	// the default of 150 rules.
	//
	// For information about requesting a rule limit increase, see AWS Config Limits
	// (http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_config)
	// in the AWS General Reference Guide.
	Limit *int64 `type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeConfigRuleEvaluationStatusInput) String() string {
	return awsutil.Prettify(s)
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigRuleEvaluationStatusResponse
type DescribeConfigRuleEvaluationStatusOutput struct {
	_ struct{} `type:"structure"`

	// Status information about your AWS managed Config rules.
	ConfigRulesEvaluationStatus []ConfigRuleEvaluationStatus `type:"list"`

	// The string that you use in a subsequent request to get the next page of results
	// in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeConfigRuleEvaluationStatusOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeConfigRuleEvaluationStatus = "DescribeConfigRuleEvaluationStatus"

// DescribeConfigRuleEvaluationStatusRequest returns a request value for making API operation for
// AWS Config.
//
// Returns status information for each of your AWS managed Config rules. The
// status includes information such as the last time AWS Config invoked the
// rule, the last time AWS Config failed to invoke the rule, and the related
// error for the last failure.
//
//    // Example sending a request using DescribeConfigRuleEvaluationStatusRequest.
//    req := client.DescribeConfigRuleEvaluationStatusRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigRuleEvaluationStatus
func (c *Client) DescribeConfigRuleEvaluationStatusRequest(input *DescribeConfigRuleEvaluationStatusInput) DescribeConfigRuleEvaluationStatusRequest {
	op := &aws.Operation{
		Name:       opDescribeConfigRuleEvaluationStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeConfigRuleEvaluationStatusInput{}
	}

	req := c.newRequest(op, input, &DescribeConfigRuleEvaluationStatusOutput{})
	return DescribeConfigRuleEvaluationStatusRequest{Request: req, Input: input, Copy: c.DescribeConfigRuleEvaluationStatusRequest}
}

// DescribeConfigRuleEvaluationStatusRequest is the request type for the
// DescribeConfigRuleEvaluationStatus API operation.
type DescribeConfigRuleEvaluationStatusRequest struct {
	*aws.Request
	Input *DescribeConfigRuleEvaluationStatusInput
	Copy  func(*DescribeConfigRuleEvaluationStatusInput) DescribeConfigRuleEvaluationStatusRequest
}

// Send marshals and sends the DescribeConfigRuleEvaluationStatus API request.
func (r DescribeConfigRuleEvaluationStatusRequest) Send(ctx context.Context) (*DescribeConfigRuleEvaluationStatusResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeConfigRuleEvaluationStatusResponse{
		DescribeConfigRuleEvaluationStatusOutput: r.Request.Data.(*DescribeConfigRuleEvaluationStatusOutput),
		response:                                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeConfigRuleEvaluationStatusResponse is the response type for the
// DescribeConfigRuleEvaluationStatus API operation.
type DescribeConfigRuleEvaluationStatusResponse struct {
	*DescribeConfigRuleEvaluationStatusOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeConfigRuleEvaluationStatus request.
func (r *DescribeConfigRuleEvaluationStatusResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
