// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package configservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

// The input for the PutDeliveryChannel action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutDeliveryChannelRequest
type PutDeliveryChannelInput struct {
	_ struct{} `type:"structure"`

	// The configuration delivery channel object that delivers the configuration
	// information to an Amazon S3 bucket and to an Amazon SNS topic.
	//
	// DeliveryChannel is a required field
	DeliveryChannel *DeliveryChannel `type:"structure" required:"true"`
}

// String returns the string representation
func (s PutDeliveryChannelInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutDeliveryChannelInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutDeliveryChannelInput"}

	if s.DeliveryChannel == nil {
		invalidParams.Add(aws.NewErrParamRequired("DeliveryChannel"))
	}
	if s.DeliveryChannel != nil {
		if err := s.DeliveryChannel.Validate(); err != nil {
			invalidParams.AddNested("DeliveryChannel", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutDeliveryChannelOutput
type PutDeliveryChannelOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutDeliveryChannelOutput) String() string {
	return awsutil.Prettify(s)
}

const opPutDeliveryChannel = "PutDeliveryChannel"

// PutDeliveryChannelRequest returns a request value for making API operation for
// AWS Config.
//
// Creates a delivery channel object to deliver configuration information to
// an Amazon S3 bucket and Amazon SNS topic.
//
// Before you can create a delivery channel, you must create a configuration
// recorder.
//
// You can use this action to change the Amazon S3 bucket or an Amazon SNS topic
// of the existing delivery channel. To change the Amazon S3 bucket or an Amazon
// SNS topic, call this action and specify the changed values for the S3 bucket
// and the SNS topic. If you specify a different value for either the S3 bucket
// or the SNS topic, this action will keep the existing value for the parameter
// that is not changed.
//
// You can have only one delivery channel per region in your account.
//
//    // Example sending a request using PutDeliveryChannelRequest.
//    req := client.PutDeliveryChannelRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutDeliveryChannel
func (c *Client) PutDeliveryChannelRequest(input *PutDeliveryChannelInput) PutDeliveryChannelRequest {
	op := &aws.Operation{
		Name:       opPutDeliveryChannel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutDeliveryChannelInput{}
	}

	req := c.newRequest(op, input, &PutDeliveryChannelOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return PutDeliveryChannelRequest{Request: req, Input: input, Copy: c.PutDeliveryChannelRequest}
}

// PutDeliveryChannelRequest is the request type for the
// PutDeliveryChannel API operation.
type PutDeliveryChannelRequest struct {
	*aws.Request
	Input *PutDeliveryChannelInput
	Copy  func(*PutDeliveryChannelInput) PutDeliveryChannelRequest
}

// Send marshals and sends the PutDeliveryChannel API request.
func (r PutDeliveryChannelRequest) Send(ctx context.Context) (*PutDeliveryChannelResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutDeliveryChannelResponse{
		PutDeliveryChannelOutput: r.Request.Data.(*PutDeliveryChannelOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutDeliveryChannelResponse is the response type for the
// PutDeliveryChannel API operation.
type PutDeliveryChannelResponse struct {
	*PutDeliveryChannelOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutDeliveryChannel request.
func (r *PutDeliveryChannelResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
