// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package configservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutRetentionConfigurationRequest
type PutRetentionConfigurationInput struct {
	_ struct{} `type:"structure"`

	// Number of days AWS Config stores your historical information.
	//
	// Currently, only applicable to the configuration item history.
	//
	// RetentionPeriodInDays is a required field
	RetentionPeriodInDays *int64 `min:"30" type:"integer" required:"true"`
}

// String returns the string representation
func (s PutRetentionConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutRetentionConfigurationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutRetentionConfigurationInput"}

	if s.RetentionPeriodInDays == nil {
		invalidParams.Add(aws.NewErrParamRequired("RetentionPeriodInDays"))
	}
	if s.RetentionPeriodInDays != nil && *s.RetentionPeriodInDays < 30 {
		invalidParams.Add(aws.NewErrParamMinValue("RetentionPeriodInDays", 30))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutRetentionConfigurationResponse
type PutRetentionConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// Returns a retention configuration object.
	RetentionConfiguration *RetentionConfiguration `type:"structure"`
}

// String returns the string representation
func (s PutRetentionConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

const opPutRetentionConfiguration = "PutRetentionConfiguration"

// PutRetentionConfigurationRequest returns a request value for making API operation for
// AWS Config.
//
// Creates and updates the retention configuration with details about retention
// period (number of days) that AWS Config stores your historical information.
// The API creates the RetentionConfiguration object and names the object as
// default. When you have a RetentionConfiguration object named default, calling
// the API modifies the default object.
//
// Currently, AWS Config supports only one retention configuration per region
// in your account.
//
//    // Example sending a request using PutRetentionConfigurationRequest.
//    req := client.PutRetentionConfigurationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutRetentionConfiguration
func (c *Client) PutRetentionConfigurationRequest(input *PutRetentionConfigurationInput) PutRetentionConfigurationRequest {
	op := &aws.Operation{
		Name:       opPutRetentionConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutRetentionConfigurationInput{}
	}

	req := c.newRequest(op, input, &PutRetentionConfigurationOutput{})
	return PutRetentionConfigurationRequest{Request: req, Input: input, Copy: c.PutRetentionConfigurationRequest}
}

// PutRetentionConfigurationRequest is the request type for the
// PutRetentionConfiguration API operation.
type PutRetentionConfigurationRequest struct {
	*aws.Request
	Input *PutRetentionConfigurationInput
	Copy  func(*PutRetentionConfigurationInput) PutRetentionConfigurationRequest
}

// Send marshals and sends the PutRetentionConfiguration API request.
func (r PutRetentionConfigurationRequest) Send(ctx context.Context) (*PutRetentionConfigurationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutRetentionConfigurationResponse{
		PutRetentionConfigurationOutput: r.Request.Data.(*PutRetentionConfigurationOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutRetentionConfigurationResponse is the response type for the
// PutRetentionConfiguration API operation.
type PutRetentionConfigurationResponse struct {
	*PutRetentionConfigurationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutRetentionConfiguration request.
func (r *PutRetentionConfigurationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
