// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package configservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/StartConfigRulesEvaluationRequest
type StartConfigRulesEvaluationInput struct {
	_ struct{} `type:"structure"`

	// The list of names of AWS Config rules that you want to run evaluations for.
	ConfigRuleNames []string `min:"1" type:"list"`
}

// String returns the string representation
func (s StartConfigRulesEvaluationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartConfigRulesEvaluationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StartConfigRulesEvaluationInput"}
	if s.ConfigRuleNames != nil && len(s.ConfigRuleNames) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ConfigRuleNames", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The output when you start the evaluation for the specified AWS Config rule.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/StartConfigRulesEvaluationResponse
type StartConfigRulesEvaluationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StartConfigRulesEvaluationOutput) String() string {
	return awsutil.Prettify(s)
}

const opStartConfigRulesEvaluation = "StartConfigRulesEvaluation"

// StartConfigRulesEvaluationRequest returns a request value for making API operation for
// AWS Config.
//
// Runs an on-demand evaluation for the specified AWS Config rules against the
// last known configuration state of the resources. Use StartConfigRulesEvaluation
// when you want to test that a rule you updated is working as expected. StartConfigRulesEvaluation
// does not re-record the latest configuration state for your resources. It
// re-runs an evaluation against the last known state of your resources.
//
// You can specify up to 25 AWS Config rules per request.
//
// An existing StartConfigRulesEvaluation call for the specified rules must
// complete before you can call the API again. If you chose to have AWS Config
// stream to an Amazon SNS topic, you will receive a ConfigRuleEvaluationStarted
// notification when the evaluation starts.
//
// You don't need to call the StartConfigRulesEvaluation API to run an evaluation
// for a new rule. When you create a rule, AWS Config evaluates your resources
// against the rule automatically.
//
// The StartConfigRulesEvaluation API is useful if you want to run on-demand
// evaluations, such as the following example:
//
// You have a custom rule that evaluates your IAM resources every 24 hours.
//
// You update your Lambda function to add additional conditions to your rule.
//
// Instead of waiting for the next periodic evaluation, you call the StartConfigRulesEvaluation
// API.
//
// AWS Config invokes your Lambda function and evaluates your IAM resources.
//
// Your custom rule will still run periodic evaluations every 24 hours.
//
//    // Example sending a request using StartConfigRulesEvaluationRequest.
//    req := client.StartConfigRulesEvaluationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/StartConfigRulesEvaluation
func (c *Client) StartConfigRulesEvaluationRequest(input *StartConfigRulesEvaluationInput) StartConfigRulesEvaluationRequest {
	op := &aws.Operation{
		Name:       opStartConfigRulesEvaluation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartConfigRulesEvaluationInput{}
	}

	req := c.newRequest(op, input, &StartConfigRulesEvaluationOutput{})
	return StartConfigRulesEvaluationRequest{Request: req, Input: input, Copy: c.StartConfigRulesEvaluationRequest}
}

// StartConfigRulesEvaluationRequest is the request type for the
// StartConfigRulesEvaluation API operation.
type StartConfigRulesEvaluationRequest struct {
	*aws.Request
	Input *StartConfigRulesEvaluationInput
	Copy  func(*StartConfigRulesEvaluationInput) StartConfigRulesEvaluationRequest
}

// Send marshals and sends the StartConfigRulesEvaluation API request.
func (r StartConfigRulesEvaluationRequest) Send(ctx context.Context) (*StartConfigRulesEvaluationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StartConfigRulesEvaluationResponse{
		StartConfigRulesEvaluationOutput: r.Request.Data.(*StartConfigRulesEvaluationOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StartConfigRulesEvaluationResponse is the response type for the
// StartConfigRulesEvaluation API operation.
type StartConfigRulesEvaluationResponse struct {
	*StartConfigRulesEvaluationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StartConfigRulesEvaluation request.
func (r *StartConfigRulesEvaluationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
