// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package configservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

// The input for the StopConfigurationRecorder action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/StopConfigurationRecorderRequest
type StopConfigurationRecorderInput struct {
	_ struct{} `type:"structure"`

	// The name of the recorder object that records each configuration change made
	// to the resources.
	//
	// ConfigurationRecorderName is a required field
	ConfigurationRecorderName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StopConfigurationRecorderInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopConfigurationRecorderInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StopConfigurationRecorderInput"}

	if s.ConfigurationRecorderName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ConfigurationRecorderName"))
	}
	if s.ConfigurationRecorderName != nil && len(*s.ConfigurationRecorderName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ConfigurationRecorderName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/StopConfigurationRecorderOutput
type StopConfigurationRecorderOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StopConfigurationRecorderOutput) String() string {
	return awsutil.Prettify(s)
}

const opStopConfigurationRecorder = "StopConfigurationRecorder"

// StopConfigurationRecorderRequest returns a request value for making API operation for
// AWS Config.
//
// Stops recording configurations of the AWS resources you have selected to
// record in your AWS account.
//
//    // Example sending a request using StopConfigurationRecorderRequest.
//    req := client.StopConfigurationRecorderRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/StopConfigurationRecorder
func (c *Client) StopConfigurationRecorderRequest(input *StopConfigurationRecorderInput) StopConfigurationRecorderRequest {
	op := &aws.Operation{
		Name:       opStopConfigurationRecorder,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopConfigurationRecorderInput{}
	}

	req := c.newRequest(op, input, &StopConfigurationRecorderOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return StopConfigurationRecorderRequest{Request: req, Input: input, Copy: c.StopConfigurationRecorderRequest}
}

// StopConfigurationRecorderRequest is the request type for the
// StopConfigurationRecorder API operation.
type StopConfigurationRecorderRequest struct {
	*aws.Request
	Input *StopConfigurationRecorderInput
	Copy  func(*StopConfigurationRecorderInput) StopConfigurationRecorderRequest
}

// Send marshals and sends the StopConfigurationRecorder API request.
func (r StopConfigurationRecorderRequest) Send(ctx context.Context) (*StopConfigurationRecorderResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StopConfigurationRecorderResponse{
		StopConfigurationRecorderOutput: r.Request.Data.(*StopConfigurationRecorderOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StopConfigurationRecorderResponse is the response type for the
// StopConfigurationRecorder API operation.
type StopConfigurationRecorderResponse struct {
	*StopConfigurationRecorderOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StopConfigurationRecorder request.
func (r *StopConfigurationRecorderResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
