// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package datasync

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// DeleteLocation
// Please also see https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DeleteLocationRequest
type DeleteLocationInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the location to delete.
	//
	// LocationArn is a required field
	LocationArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteLocationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteLocationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteLocationInput"}

	if s.LocationArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("LocationArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DeleteLocationResponse
type DeleteLocationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteLocationOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteLocation = "DeleteLocation"

// DeleteLocationRequest returns a request value for making API operation for
// AWS DataSync.
//
// Deletes the configuration of a location used by AWS DataSync.
//
//    // Example sending a request using DeleteLocationRequest.
//    req := client.DeleteLocationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DeleteLocation
func (c *Client) DeleteLocationRequest(input *DeleteLocationInput) DeleteLocationRequest {
	op := &aws.Operation{
		Name:       opDeleteLocation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteLocationInput{}
	}

	req := c.newRequest(op, input, &DeleteLocationOutput{})
	return DeleteLocationRequest{Request: req, Input: input, Copy: c.DeleteLocationRequest}
}

// DeleteLocationRequest is the request type for the
// DeleteLocation API operation.
type DeleteLocationRequest struct {
	*aws.Request
	Input *DeleteLocationInput
	Copy  func(*DeleteLocationInput) DeleteLocationRequest
}

// Send marshals and sends the DeleteLocation API request.
func (r DeleteLocationRequest) Send(ctx context.Context) (*DeleteLocationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteLocationResponse{
		DeleteLocationOutput: r.Request.Data.(*DeleteLocationOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteLocationResponse is the response type for the
// DeleteLocation API operation.
type DeleteLocationResponse struct {
	*DeleteLocationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteLocation request.
func (r *DeleteLocationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
