// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package directoryservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/CreateLogSubscriptionRequest
type CreateLogSubscriptionInput struct {
	_ struct{} `type:"structure"`

	// Identifier (ID) of the directory to which you want to subscribe and receive
	// real-time logs to your specified CloudWatch log group.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`

	// The name of the CloudWatch log group where the real-time domain controller
	// logs are forwarded.
	//
	// LogGroupName is a required field
	LogGroupName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateLogSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLogSubscriptionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateLogSubscriptionInput"}

	if s.DirectoryId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DirectoryId"))
	}

	if s.LogGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("LogGroupName"))
	}
	if s.LogGroupName != nil && len(*s.LogGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LogGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/CreateLogSubscriptionResult
type CreateLogSubscriptionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateLogSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateLogSubscription = "CreateLogSubscription"

// CreateLogSubscriptionRequest returns a request value for making API operation for
// AWS Directory Service.
//
// Creates a subscription to forward real time Directory Service domain controller
// security logs to the specified CloudWatch log group in your AWS account.
//
//    // Example sending a request using CreateLogSubscriptionRequest.
//    req := client.CreateLogSubscriptionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/CreateLogSubscription
func (c *Client) CreateLogSubscriptionRequest(input *CreateLogSubscriptionInput) CreateLogSubscriptionRequest {
	op := &aws.Operation{
		Name:       opCreateLogSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateLogSubscriptionInput{}
	}

	req := c.newRequest(op, input, &CreateLogSubscriptionOutput{})
	return CreateLogSubscriptionRequest{Request: req, Input: input, Copy: c.CreateLogSubscriptionRequest}
}

// CreateLogSubscriptionRequest is the request type for the
// CreateLogSubscription API operation.
type CreateLogSubscriptionRequest struct {
	*aws.Request
	Input *CreateLogSubscriptionInput
	Copy  func(*CreateLogSubscriptionInput) CreateLogSubscriptionRequest
}

// Send marshals and sends the CreateLogSubscription API request.
func (r CreateLogSubscriptionRequest) Send(ctx context.Context) (*CreateLogSubscriptionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateLogSubscriptionResponse{
		CreateLogSubscriptionOutput: r.Request.Data.(*CreateLogSubscriptionOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateLogSubscriptionResponse is the response type for the
// CreateLogSubscription API operation.
type CreateLogSubscriptionResponse struct {
	*CreateLogSubscriptionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateLogSubscription request.
func (r *CreateLogSubscriptionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
