// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package directoryservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Contains the inputs for the DescribeDirectories operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeDirectoriesRequest
type DescribeDirectoriesInput struct {
	_ struct{} `type:"structure"`

	// A list of identifiers of the directories for which to obtain the information.
	// If this member is null, all directories that belong to the current account
	// are returned.
	//
	// An empty list results in an InvalidParameterException being thrown.
	DirectoryIds []string `type:"list"`

	// The maximum number of items to return. If this value is zero, the maximum
	// number of items is specified by the limitations of the operation.
	Limit *int64 `type:"integer"`

	// The DescribeDirectoriesResult.NextToken value from a previous call to DescribeDirectories.
	// Pass null if this is the first call.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeDirectoriesInput) String() string {
	return awsutil.Prettify(s)
}

// Contains the results of the DescribeDirectories operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeDirectoriesResult
type DescribeDirectoriesOutput struct {
	_ struct{} `type:"structure"`

	// The list of DirectoryDescription objects that were retrieved.
	//
	// It is possible that this list contains less than the number of items specified
	// in the Limit member of the request. This occurs if there are less than the
	// requested number of items left to retrieve, or if the limitations of the
	// operation have been exceeded.
	DirectoryDescriptions []DirectoryDescription `type:"list"`

	// If not null, more results are available. Pass this value for the NextToken
	// parameter in a subsequent call to DescribeDirectories to retrieve the next
	// set of items.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeDirectoriesOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeDirectories = "DescribeDirectories"

// DescribeDirectoriesRequest returns a request value for making API operation for
// AWS Directory Service.
//
// Obtains information about the directories that belong to this account.
//
// You can retrieve information about specific directories by passing the directory
// identifiers in the DirectoryIds parameter. Otherwise, all directories that
// belong to the current account are returned.
//
// This operation supports pagination with the use of the NextToken request
// and response parameters. If more results are available, the DescribeDirectoriesResult.NextToken
// member contains a token that you pass in the next call to DescribeDirectories
// to retrieve the next set of items.
//
// You can also specify a maximum number of return results with the Limit parameter.
//
//    // Example sending a request using DescribeDirectoriesRequest.
//    req := client.DescribeDirectoriesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeDirectories
func (c *Client) DescribeDirectoriesRequest(input *DescribeDirectoriesInput) DescribeDirectoriesRequest {
	op := &aws.Operation{
		Name:       opDescribeDirectories,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDirectoriesInput{}
	}

	req := c.newRequest(op, input, &DescribeDirectoriesOutput{})
	return DescribeDirectoriesRequest{Request: req, Input: input, Copy: c.DescribeDirectoriesRequest}
}

// DescribeDirectoriesRequest is the request type for the
// DescribeDirectories API operation.
type DescribeDirectoriesRequest struct {
	*aws.Request
	Input *DescribeDirectoriesInput
	Copy  func(*DescribeDirectoriesInput) DescribeDirectoriesRequest
}

// Send marshals and sends the DescribeDirectories API request.
func (r DescribeDirectoriesRequest) Send(ctx context.Context) (*DescribeDirectoriesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeDirectoriesResponse{
		DescribeDirectoriesOutput: r.Request.Data.(*DescribeDirectoriesOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeDirectoriesResponse is the response type for the
// DescribeDirectories API operation.
type DescribeDirectoriesResponse struct {
	*DescribeDirectoriesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeDirectories request.
func (r *DescribeDirectoriesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
