// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package dlm

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

var _ aws.Config
var _ = awsutil.Prettify

// Specifies when to create snapshots of EBS volumes.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dlm-2018-01-12/CreateRule
type CreateRule struct {
	_ struct{} `type:"structure"`

	// The interval. The supported values are 12 and 24.
	//
	// Interval is a required field
	Interval *int64 `min:"1" type:"integer" required:"true"`

	// The interval unit.
	//
	// IntervalUnit is a required field
	IntervalUnit IntervalUnitValues `type:"string" required:"true" enum:"true"`

	// The time, in UTC, to start the operation.
	//
	// The operation occurs within a one-hour window following the specified time.
	Times []string `type:"list"`
}

// String returns the string representation
func (s CreateRule) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRule) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateRule"}

	if s.Interval == nil {
		invalidParams.Add(aws.NewErrParamRequired("Interval"))
	}
	if s.Interval != nil && *s.Interval < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Interval", 1))
	}
	if len(s.IntervalUnit) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("IntervalUnit"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateRule) MarshalFields(e protocol.FieldEncoder) error {
	if s.Interval != nil {
		v := *s.Interval

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Interval", protocol.Int64Value(v), metadata)
	}
	if len(s.IntervalUnit) > 0 {
		v := s.IntervalUnit

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IntervalUnit", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.Times) > 0 {
		v := s.Times

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Times", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// Detailed information about a lifecycle policy.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dlm-2018-01-12/LifecyclePolicy
type LifecyclePolicy struct {
	_ struct{} `type:"structure"`

	// The local date and time when the lifecycle policy was created.
	DateCreated *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The local date and time when the lifecycle policy was last modified.
	DateModified *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The description of the lifecycle policy.
	Description *string `type:"string"`

	// The Amazon Resource Name (ARN) of the IAM role used to run the operations
	// specified by the lifecycle policy.
	ExecutionRoleArn *string `type:"string"`

	// The configuration of the lifecycle policy
	PolicyDetails *PolicyDetails `type:"structure"`

	// The identifier of the lifecycle policy.
	PolicyId *string `type:"string"`

	// The activation state of the lifecycle policy.
	State GettablePolicyStateValues `type:"string" enum:"true"`
}

// String returns the string representation
func (s LifecyclePolicy) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s LifecyclePolicy) MarshalFields(e protocol.FieldEncoder) error {
	if s.DateCreated != nil {
		v := *s.DateCreated

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DateCreated", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.DateModified != nil {
		v := *s.DateModified

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DateModified", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ExecutionRoleArn != nil {
		v := *s.ExecutionRoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ExecutionRoleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PolicyDetails != nil {
		v := s.PolicyDetails

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "PolicyDetails", v, metadata)
	}
	if s.PolicyId != nil {
		v := *s.PolicyId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PolicyId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.State) > 0 {
		v := s.State

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "State", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Summary information about a lifecycle policy.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dlm-2018-01-12/LifecyclePolicySummary
type LifecyclePolicySummary struct {
	_ struct{} `type:"structure"`

	// The description of the lifecycle policy.
	Description *string `type:"string"`

	// The identifier of the lifecycle policy.
	PolicyId *string `type:"string"`

	// The activation state of the lifecycle policy.
	State GettablePolicyStateValues `type:"string" enum:"true"`
}

// String returns the string representation
func (s LifecyclePolicySummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s LifecyclePolicySummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PolicyId != nil {
		v := *s.PolicyId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PolicyId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.State) > 0 {
		v := s.State

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "State", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Specifies the configuration of a lifecycle policy.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dlm-2018-01-12/PolicyDetails
type PolicyDetails struct {
	_ struct{} `type:"structure"`

	// The resource type.
	ResourceTypes []ResourceTypeValues `min:"1" type:"list"`

	// The schedule of policy-defined actions.
	Schedules []Schedule `min:"1" type:"list"`

	// The single tag that identifies targeted resources for this policy.
	TargetTags []Tag `min:"1" type:"list"`
}

// String returns the string representation
func (s PolicyDetails) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PolicyDetails) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PolicyDetails"}
	if s.ResourceTypes != nil && len(s.ResourceTypes) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceTypes", 1))
	}
	if s.Schedules != nil && len(s.Schedules) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Schedules", 1))
	}
	if s.TargetTags != nil && len(s.TargetTags) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TargetTags", 1))
	}
	if s.Schedules != nil {
		for i, v := range s.Schedules {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Schedules", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.TargetTags != nil {
		for i, v := range s.TargetTags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TargetTags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PolicyDetails) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.ResourceTypes) > 0 {
		v := s.ResourceTypes

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ResourceTypes", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if len(s.Schedules) > 0 {
		v := s.Schedules

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Schedules", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.TargetTags) > 0 {
		v := s.TargetTags

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "TargetTags", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Specifies the number of snapshots to keep for each EBS volume.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dlm-2018-01-12/RetainRule
type RetainRule struct {
	_ struct{} `type:"structure"`

	// The number of snapshots to keep for each volume, up to a maximum of 1000.
	//
	// Count is a required field
	Count *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s RetainRule) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RetainRule) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RetainRule"}

	if s.Count == nil {
		invalidParams.Add(aws.NewErrParamRequired("Count"))
	}
	if s.Count != nil && *s.Count < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Count", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RetainRule) MarshalFields(e protocol.FieldEncoder) error {
	if s.Count != nil {
		v := *s.Count

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Count", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Specifies a schedule.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dlm-2018-01-12/Schedule
type Schedule struct {
	_ struct{} `type:"structure"`

	CopyTags *bool `type:"boolean"`

	// The create rule.
	CreateRule *CreateRule `type:"structure"`

	// The name of the schedule.
	Name *string `type:"string"`

	// The retain rule.
	RetainRule *RetainRule `type:"structure"`

	// The tags to apply to policy-created resources. These user-defined tags are
	// in addition to the AWS-added lifecycle tags.
	TagsToAdd []Tag `type:"list"`
}

// String returns the string representation
func (s Schedule) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Schedule) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Schedule"}
	if s.CreateRule != nil {
		if err := s.CreateRule.Validate(); err != nil {
			invalidParams.AddNested("CreateRule", err.(aws.ErrInvalidParams))
		}
	}
	if s.RetainRule != nil {
		if err := s.RetainRule.Validate(); err != nil {
			invalidParams.AddNested("RetainRule", err.(aws.ErrInvalidParams))
		}
	}
	if s.TagsToAdd != nil {
		for i, v := range s.TagsToAdd {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TagsToAdd", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Schedule) MarshalFields(e protocol.FieldEncoder) error {
	if s.CopyTags != nil {
		v := *s.CopyTags

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CopyTags", protocol.BoolValue(v), metadata)
	}
	if s.CreateRule != nil {
		v := s.CreateRule

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "CreateRule", v, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RetainRule != nil {
		v := s.RetainRule

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "RetainRule", v, metadata)
	}
	if len(s.TagsToAdd) > 0 {
		v := s.TagsToAdd

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "TagsToAdd", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Specifies a tag for a resource.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dlm-2018-01-12/Tag
type Tag struct {
	_ struct{} `type:"structure"`

	// The tag key.
	//
	// Key is a required field
	Key *string `type:"string" required:"true"`

	// The tag value.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Tag"}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Tag) MarshalFields(e protocol.FieldEncoder) error {
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Key", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Value", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}
