// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package dynamodb

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/TransactGetItemsInput
type TransactGetItemsInput struct {
	_ struct{} `type:"structure"`

	// A value of TOTAL causes consumed capacity information to be returned, and
	// a value of NONE prevents that information from being returned. No other value
	// is valid.
	ReturnConsumedCapacity ReturnConsumedCapacity `type:"string" enum:"true"`

	// An ordered array of up to 10 TransactGetItem objects, each of which contains
	// a Get structure.
	//
	// TransactItems is a required field
	TransactItems []TransactGetItem `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s TransactGetItemsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TransactGetItemsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TransactGetItemsInput"}

	if s.TransactItems == nil {
		invalidParams.Add(aws.NewErrParamRequired("TransactItems"))
	}
	if s.TransactItems != nil && len(s.TransactItems) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TransactItems", 1))
	}
	if s.TransactItems != nil {
		for i, v := range s.TransactItems {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TransactItems", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/TransactGetItemsOutput
type TransactGetItemsOutput struct {
	_ struct{} `type:"structure"`

	// If the ReturnConsumedCapacity value was TOTAL, this is an array of ConsumedCapacity
	// objects, one for each table addressed by TransactGetItem objects in the TransactItems
	// parameter. These ConsumedCapacity objects report the read-capacity units
	// consumed by the TransactGetItems call in that table.
	ConsumedCapacity []ConsumedCapacity `type:"list"`

	// An ordered array of up to 10 ItemResponse objects, each of which corresponds
	// to the TransactGetItem object in the same position in the TransactItems array.
	// Each ItemResponse object contains a Map of the name-value pairs that are
	// the projected attributes of the requested item.
	//
	// If a requested item could not be retrieved, the corresponding ItemResponse
	// object is Null, or if the requested item has no projected attributes, the
	// corresponding ItemResponse object is an empty Map.
	Responses []ItemResponse `min:"1" type:"list"`
}

// String returns the string representation
func (s TransactGetItemsOutput) String() string {
	return awsutil.Prettify(s)
}

const opTransactGetItems = "TransactGetItems"

// TransactGetItemsRequest returns a request value for making API operation for
// Amazon DynamoDB.
//
// TransactGetItems is a synchronous operation that atomically retrieves multiple
// items from one or more tables (but not from indexes) in a single account
// and region. A TransactGetItems call can contain up to 10 TransactGetItem
// objects, each of which contains a Get structure that specifies an item to
// retrieve from a table in the account and region. A call to TransactGetItems
// cannot retrieve items from tables in more than one AWS account or region.
//
// DynamoDB rejects the entire TransactGetItems request if any of the following
// is true:
//
//    * A conflicting operation is in the process of updating an item to be
//    read.
//
//    * There is insufficient provisioned capacity for the transaction to be
//    completed.
//
//    * There is a user error, such as an invalid data format.
//
//    // Example sending a request using TransactGetItemsRequest.
//    req := client.TransactGetItemsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/TransactGetItems
func (c *Client) TransactGetItemsRequest(input *TransactGetItemsInput) TransactGetItemsRequest {
	op := &aws.Operation{
		Name:       opTransactGetItems,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TransactGetItemsInput{}
	}

	req := c.newRequest(op, input, &TransactGetItemsOutput{})
	return TransactGetItemsRequest{Request: req, Input: input, Copy: c.TransactGetItemsRequest}
}

// TransactGetItemsRequest is the request type for the
// TransactGetItems API operation.
type TransactGetItemsRequest struct {
	*aws.Request
	Input *TransactGetItemsInput
	Copy  func(*TransactGetItemsInput) TransactGetItemsRequest
}

// Send marshals and sends the TransactGetItems API request.
func (r TransactGetItemsRequest) Send(ctx context.Context) (*TransactGetItemsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &TransactGetItemsResponse{
		TransactGetItemsOutput: r.Request.Data.(*TransactGetItemsOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// TransactGetItemsResponse is the response type for the
// TransactGetItems API operation.
type TransactGetItemsResponse struct {
	*TransactGetItemsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// TransactGetItems request.
func (r *TransactGetItemsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
