// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package dynamodb

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/UpdateContinuousBackupsInput
type UpdateContinuousBackupsInput struct {
	_ struct{} `type:"structure"`

	// Represents the settings used to enable point in time recovery.
	//
	// PointInTimeRecoverySpecification is a required field
	PointInTimeRecoverySpecification *PointInTimeRecoverySpecification `type:"structure" required:"true"`

	// The name of the table.
	//
	// TableName is a required field
	TableName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateContinuousBackupsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateContinuousBackupsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateContinuousBackupsInput"}

	if s.PointInTimeRecoverySpecification == nil {
		invalidParams.Add(aws.NewErrParamRequired("PointInTimeRecoverySpecification"))
	}

	if s.TableName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("TableName", 3))
	}
	if s.PointInTimeRecoverySpecification != nil {
		if err := s.PointInTimeRecoverySpecification.Validate(); err != nil {
			invalidParams.AddNested("PointInTimeRecoverySpecification", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/UpdateContinuousBackupsOutput
type UpdateContinuousBackupsOutput struct {
	_ struct{} `type:"structure"`

	// Represents the continuous backups and point in time recovery settings on
	// the table.
	ContinuousBackupsDescription *ContinuousBackupsDescription `type:"structure"`
}

// String returns the string representation
func (s UpdateContinuousBackupsOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateContinuousBackups = "UpdateContinuousBackups"

// UpdateContinuousBackupsRequest returns a request value for making API operation for
// Amazon DynamoDB.
//
// UpdateContinuousBackups enables or disables point in time recovery for the
// specified table. A successful UpdateContinuousBackups call returns the current
// ContinuousBackupsDescription. Continuous backups are ENABLED on all tables
// at table creation. If point in time recovery is enabled, PointInTimeRecoveryStatus
// will be set to ENABLED.
//
// Once continuous backups and point in time recovery are enabled, you can restore
// to any point in time within EarliestRestorableDateTime and LatestRestorableDateTime.
//
// LatestRestorableDateTime is typically 5 minutes before the current time.
// You can restore your table to any point in time during the last 35 days..
//
//    // Example sending a request using UpdateContinuousBackupsRequest.
//    req := client.UpdateContinuousBackupsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/UpdateContinuousBackups
func (c *Client) UpdateContinuousBackupsRequest(input *UpdateContinuousBackupsInput) UpdateContinuousBackupsRequest {
	op := &aws.Operation{
		Name:       opUpdateContinuousBackups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateContinuousBackupsInput{}
	}

	req := c.newRequest(op, input, &UpdateContinuousBackupsOutput{})
	return UpdateContinuousBackupsRequest{Request: req, Input: input, Copy: c.UpdateContinuousBackupsRequest}
}

// UpdateContinuousBackupsRequest is the request type for the
// UpdateContinuousBackups API operation.
type UpdateContinuousBackupsRequest struct {
	*aws.Request
	Input *UpdateContinuousBackupsInput
	Copy  func(*UpdateContinuousBackupsInput) UpdateContinuousBackupsRequest
}

// Send marshals and sends the UpdateContinuousBackups API request.
func (r UpdateContinuousBackupsRequest) Send(ctx context.Context) (*UpdateContinuousBackupsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateContinuousBackupsResponse{
		UpdateContinuousBackupsOutput: r.Request.Data.(*UpdateContinuousBackupsOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateContinuousBackupsResponse is the response type for the
// UpdateContinuousBackups API operation.
type UpdateContinuousBackupsResponse struct {
	*UpdateContinuousBackupsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateContinuousBackups request.
func (r *UpdateContinuousBackupsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
