// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/ec2query"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteKeyPairRequest
type DeleteKeyPairInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The name of the key pair.
	//
	// KeyName is a required field
	KeyName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteKeyPairInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteKeyPairInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteKeyPairInput"}

	if s.KeyName == nil {
		invalidParams.Add(aws.NewErrParamRequired("KeyName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteKeyPairOutput
type DeleteKeyPairOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteKeyPairOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteKeyPair = "DeleteKeyPair"

// DeleteKeyPairRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Deletes the specified key pair, by removing the public key from Amazon EC2.
//
//    // Example sending a request using DeleteKeyPairRequest.
//    req := client.DeleteKeyPairRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteKeyPair
func (c *Client) DeleteKeyPairRequest(input *DeleteKeyPairInput) DeleteKeyPairRequest {
	op := &aws.Operation{
		Name:       opDeleteKeyPair,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteKeyPairInput{}
	}

	req := c.newRequest(op, input, &DeleteKeyPairOutput{})
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeleteKeyPairRequest{Request: req, Input: input, Copy: c.DeleteKeyPairRequest}
}

// DeleteKeyPairRequest is the request type for the
// DeleteKeyPair API operation.
type DeleteKeyPairRequest struct {
	*aws.Request
	Input *DeleteKeyPairInput
	Copy  func(*DeleteKeyPairInput) DeleteKeyPairRequest
}

// Send marshals and sends the DeleteKeyPair API request.
func (r DeleteKeyPairRequest) Send(ctx context.Context) (*DeleteKeyPairResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteKeyPairResponse{
		DeleteKeyPairOutput: r.Request.Data.(*DeleteKeyPairOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteKeyPairResponse is the response type for the
// DeleteKeyPair API operation.
type DeleteKeyPairResponse struct {
	*DeleteKeyPairOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteKeyPair request.
func (r *DeleteKeyPairResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
