// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Contains the parameters for DescribeReservedInstancesListings.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeReservedInstancesListingsRequest
type DescribeReservedInstancesListingsInput struct {
	_ struct{} `type:"structure"`

	// One or more filters.
	//
	//    * reserved-instances-id - The ID of the Reserved Instances.
	//
	//    * reserved-instances-listing-id - The ID of the Reserved Instances listing.
	//
	//    * status - The status of the Reserved Instance listing (pending | active
	//    | cancelled | closed).
	//
	//    * status-message - The reason for the status.
	Filters []Filter `locationName:"Filter" locationNameList:"Filter" type:"list"`

	// One or more Reserved Instance IDs.
	ReservedInstancesId *string `locationName:"reservedInstancesId" type:"string"`

	// One or more Reserved Instance listing IDs.
	ReservedInstancesListingId *string `locationName:"reservedInstancesListingId" type:"string"`
}

// String returns the string representation
func (s DescribeReservedInstancesListingsInput) String() string {
	return awsutil.Prettify(s)
}

// Contains the output of DescribeReservedInstancesListings.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeReservedInstancesListingsResult
type DescribeReservedInstancesListingsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the Reserved Instance listing.
	ReservedInstancesListings []ReservedInstancesListing `locationName:"reservedInstancesListingsSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeReservedInstancesListingsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeReservedInstancesListings = "DescribeReservedInstancesListings"

// DescribeReservedInstancesListingsRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Describes your account's Reserved Instance listings in the Reserved Instance
// Marketplace.
//
// The Reserved Instance Marketplace matches sellers who want to resell Reserved
// Instance capacity that they no longer need with buyers who want to purchase
// additional capacity. Reserved Instances bought and sold through the Reserved
// Instance Marketplace work like any other Reserved Instances.
//
// As a seller, you choose to list some or all of your Reserved Instances, and
// you specify the upfront price to receive for them. Your Reserved Instances
// are then listed in the Reserved Instance Marketplace and are available for
// purchase.
//
// As a buyer, you specify the configuration of the Reserved Instance to purchase,
// and the Marketplace matches what you're searching for with what's available.
// The Marketplace first sells the lowest priced Reserved Instances to you,
// and continues to sell available Reserved Instance listings to you until your
// demand is met. You are charged based on the total price of all of the listings
// that you purchase.
//
// For more information, see Reserved Instance Marketplace (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
//    // Example sending a request using DescribeReservedInstancesListingsRequest.
//    req := client.DescribeReservedInstancesListingsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeReservedInstancesListings
func (c *Client) DescribeReservedInstancesListingsRequest(input *DescribeReservedInstancesListingsInput) DescribeReservedInstancesListingsRequest {
	op := &aws.Operation{
		Name:       opDescribeReservedInstancesListings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeReservedInstancesListingsInput{}
	}

	req := c.newRequest(op, input, &DescribeReservedInstancesListingsOutput{})
	return DescribeReservedInstancesListingsRequest{Request: req, Input: input, Copy: c.DescribeReservedInstancesListingsRequest}
}

// DescribeReservedInstancesListingsRequest is the request type for the
// DescribeReservedInstancesListings API operation.
type DescribeReservedInstancesListingsRequest struct {
	*aws.Request
	Input *DescribeReservedInstancesListingsInput
	Copy  func(*DescribeReservedInstancesListingsInput) DescribeReservedInstancesListingsRequest
}

// Send marshals and sends the DescribeReservedInstancesListings API request.
func (r DescribeReservedInstancesListingsRequest) Send(ctx context.Context) (*DescribeReservedInstancesListingsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeReservedInstancesListingsResponse{
		DescribeReservedInstancesListingsOutput: r.Request.Data.(*DescribeReservedInstancesListingsOutput),
		response:                                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeReservedInstancesListingsResponse is the response type for the
// DescribeReservedInstancesListings API operation.
type DescribeReservedInstancesListingsResponse struct {
	*DescribeReservedInstancesListingsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeReservedInstancesListings request.
func (r *DescribeReservedInstancesListingsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
