// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ModifyHostsRequest
type ModifyHostsInput struct {
	_ struct{} `type:"structure"`

	// Specify whether to enable or disable auto-placement.
	//
	// AutoPlacement is a required field
	AutoPlacement AutoPlacement `locationName:"autoPlacement" type:"string" required:"true" enum:"true"`

	// The IDs of the Dedicated Hosts to modify.
	//
	// HostIds is a required field
	HostIds []string `locationName:"hostId" locationNameList:"item" type:"list" required:"true"`
}

// String returns the string representation
func (s ModifyHostsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyHostsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ModifyHostsInput"}
	if len(s.AutoPlacement) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("AutoPlacement"))
	}

	if s.HostIds == nil {
		invalidParams.Add(aws.NewErrParamRequired("HostIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ModifyHostsResult
type ModifyHostsOutput struct {
	_ struct{} `type:"structure"`

	// The IDs of the Dedicated Hosts that were successfully modified.
	Successful []string `locationName:"successful" locationNameList:"item" type:"list"`

	// The IDs of the Dedicated Hosts that could not be modified. Check whether
	// the setting you requested can be used.
	Unsuccessful []UnsuccessfulItem `locationName:"unsuccessful" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s ModifyHostsOutput) String() string {
	return awsutil.Prettify(s)
}

const opModifyHosts = "ModifyHosts"

// ModifyHostsRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Modify the auto-placement setting of a Dedicated Host. When auto-placement
// is enabled, any instances that you launch with a tenancy of host but without
// a specific host ID are placed onto any available Dedicated Host in your account
// that has auto-placement enabled. When auto-placement is disabled, you need
// to provide a host ID to have the instance launch onto a specific host. If
// no host ID is provided, the instance is launched onto a suitable host with
// auto-placement enabled.
//
//    // Example sending a request using ModifyHostsRequest.
//    req := client.ModifyHostsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ModifyHosts
func (c *Client) ModifyHostsRequest(input *ModifyHostsInput) ModifyHostsRequest {
	op := &aws.Operation{
		Name:       opModifyHosts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyHostsInput{}
	}

	req := c.newRequest(op, input, &ModifyHostsOutput{})
	return ModifyHostsRequest{Request: req, Input: input, Copy: c.ModifyHostsRequest}
}

// ModifyHostsRequest is the request type for the
// ModifyHosts API operation.
type ModifyHostsRequest struct {
	*aws.Request
	Input *ModifyHostsInput
	Copy  func(*ModifyHostsInput) ModifyHostsRequest
}

// Send marshals and sends the ModifyHosts API request.
func (r ModifyHostsRequest) Send(ctx context.Context) (*ModifyHostsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ModifyHostsResponse{
		ModifyHostsOutput: r.Request.Data.(*ModifyHostsOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ModifyHostsResponse is the response type for the
// ModifyHosts API operation.
type ModifyHostsResponse struct {
	*ModifyHostsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ModifyHosts request.
func (r *ModifyHostsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
