// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/ec2query"
)

// Contains the parameters for UnassignPrivateIpAddresses.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/UnassignPrivateIpAddressesRequest
type UnassignPrivateIpAddressesInput struct {
	_ struct{} `type:"structure"`

	// The ID of the network interface.
	//
	// NetworkInterfaceId is a required field
	NetworkInterfaceId *string `locationName:"networkInterfaceId" type:"string" required:"true"`

	// The secondary private IP addresses to unassign from the network interface.
	// You can specify this option multiple times to unassign more than one IP address.
	//
	// PrivateIpAddresses is a required field
	PrivateIpAddresses []string `locationName:"privateIpAddress" locationNameList:"PrivateIpAddress" type:"list" required:"true"`
}

// String returns the string representation
func (s UnassignPrivateIpAddressesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UnassignPrivateIpAddressesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UnassignPrivateIpAddressesInput"}

	if s.NetworkInterfaceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("NetworkInterfaceId"))
	}

	if s.PrivateIpAddresses == nil {
		invalidParams.Add(aws.NewErrParamRequired("PrivateIpAddresses"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/UnassignPrivateIpAddressesOutput
type UnassignPrivateIpAddressesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UnassignPrivateIpAddressesOutput) String() string {
	return awsutil.Prettify(s)
}

const opUnassignPrivateIpAddresses = "UnassignPrivateIpAddresses"

// UnassignPrivateIpAddressesRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Unassigns one or more secondary private IP addresses from a network interface.
//
//    // Example sending a request using UnassignPrivateIpAddressesRequest.
//    req := client.UnassignPrivateIpAddressesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/UnassignPrivateIpAddresses
func (c *Client) UnassignPrivateIpAddressesRequest(input *UnassignPrivateIpAddressesInput) UnassignPrivateIpAddressesRequest {
	op := &aws.Operation{
		Name:       opUnassignPrivateIpAddresses,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UnassignPrivateIpAddressesInput{}
	}

	req := c.newRequest(op, input, &UnassignPrivateIpAddressesOutput{})
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return UnassignPrivateIpAddressesRequest{Request: req, Input: input, Copy: c.UnassignPrivateIpAddressesRequest}
}

// UnassignPrivateIpAddressesRequest is the request type for the
// UnassignPrivateIpAddresses API operation.
type UnassignPrivateIpAddressesRequest struct {
	*aws.Request
	Input *UnassignPrivateIpAddressesInput
	Copy  func(*UnassignPrivateIpAddressesInput) UnassignPrivateIpAddressesRequest
}

// Send marshals and sends the UnassignPrivateIpAddresses API request.
func (r UnassignPrivateIpAddressesRequest) Send(ctx context.Context) (*UnassignPrivateIpAddressesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UnassignPrivateIpAddressesResponse{
		UnassignPrivateIpAddressesOutput: r.Request.Data.(*UnassignPrivateIpAddressesOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UnassignPrivateIpAddressesResponse is the response type for the
// UnassignPrivateIpAddresses API operation.
type UnassignPrivateIpAddressesResponse struct {
	*UnassignPrivateIpAddressesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UnassignPrivateIpAddresses request.
func (r *UnassignPrivateIpAddressesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
