// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticsearchservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Container for the parameters to the DescribeElasticsearchDomain operation.
type DescribeElasticsearchDomainInput struct {
	_ struct{} `type:"structure"`

	// The name of the Elasticsearch domain for which you want information.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeElasticsearchDomainInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeElasticsearchDomainInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeElasticsearchDomainInput"}

	if s.DomainName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeElasticsearchDomainInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.DomainName != nil {
		v := *s.DomainName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "DomainName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The result of a DescribeElasticsearchDomain request. Contains the status
// of the domain specified in the request.
type DescribeElasticsearchDomainOutput struct {
	_ struct{} `type:"structure"`

	// The current status of the Elasticsearch domain.
	//
	// DomainStatus is a required field
	DomainStatus *ElasticsearchDomainStatus `type:"structure" required:"true"`
}

// String returns the string representation
func (s DescribeElasticsearchDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeElasticsearchDomainOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.DomainStatus != nil {
		v := s.DomainStatus

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "DomainStatus", v, metadata)
	}
	return nil
}

const opDescribeElasticsearchDomain = "DescribeElasticsearchDomain"

// DescribeElasticsearchDomainRequest returns a request value for making API operation for
// Amazon Elasticsearch Service.
//
// Returns domain configuration information about the specified Elasticsearch
// domain, including the domain ID, domain endpoint, and domain ARN.
//
//    // Example sending a request using DescribeElasticsearchDomainRequest.
//    req := client.DescribeElasticsearchDomainRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) DescribeElasticsearchDomainRequest(input *DescribeElasticsearchDomainInput) DescribeElasticsearchDomainRequest {
	op := &aws.Operation{
		Name:       opDescribeElasticsearchDomain,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-01-01/es/domain/{DomainName}",
	}

	if input == nil {
		input = &DescribeElasticsearchDomainInput{}
	}

	req := c.newRequest(op, input, &DescribeElasticsearchDomainOutput{})
	return DescribeElasticsearchDomainRequest{Request: req, Input: input, Copy: c.DescribeElasticsearchDomainRequest}
}

// DescribeElasticsearchDomainRequest is the request type for the
// DescribeElasticsearchDomain API operation.
type DescribeElasticsearchDomainRequest struct {
	*aws.Request
	Input *DescribeElasticsearchDomainInput
	Copy  func(*DescribeElasticsearchDomainInput) DescribeElasticsearchDomainRequest
}

// Send marshals and sends the DescribeElasticsearchDomain API request.
func (r DescribeElasticsearchDomainRequest) Send(ctx context.Context) (*DescribeElasticsearchDomainResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeElasticsearchDomainResponse{
		DescribeElasticsearchDomainOutput: r.Request.Data.(*DescribeElasticsearchDomainOutput),
		response:                          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeElasticsearchDomainResponse is the response type for the
// DescribeElasticsearchDomain API operation.
type DescribeElasticsearchDomainResponse struct {
	*DescribeElasticsearchDomainOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeElasticsearchDomain request.
func (r *DescribeElasticsearchDomainResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
