// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package emr

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// This input determines which step to describe.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/DescribeStepInput
type DescribeStepInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the cluster with steps to describe.
	//
	// ClusterId is a required field
	ClusterId *string `type:"string" required:"true"`

	// The identifier of the step to describe.
	//
	// StepId is a required field
	StepId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeStepInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeStepInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeStepInput"}

	if s.ClusterId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClusterId"))
	}

	if s.StepId == nil {
		invalidParams.Add(aws.NewErrParamRequired("StepId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// This output contains the description of the cluster step.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/DescribeStepOutput
type DescribeStepOutput struct {
	_ struct{} `type:"structure"`

	// The step details for the requested step identifier.
	Step *Step `type:"structure"`
}

// String returns the string representation
func (s DescribeStepOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeStep = "DescribeStep"

// DescribeStepRequest returns a request value for making API operation for
// Amazon Elastic MapReduce.
//
// Provides more detail about the cluster step.
//
//    // Example sending a request using DescribeStepRequest.
//    req := client.DescribeStepRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/DescribeStep
func (c *Client) DescribeStepRequest(input *DescribeStepInput) DescribeStepRequest {
	op := &aws.Operation{
		Name:       opDescribeStep,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeStepInput{}
	}

	req := c.newRequest(op, input, &DescribeStepOutput{})
	return DescribeStepRequest{Request: req, Input: input, Copy: c.DescribeStepRequest}
}

// DescribeStepRequest is the request type for the
// DescribeStep API operation.
type DescribeStepRequest struct {
	*aws.Request
	Input *DescribeStepInput
	Copy  func(*DescribeStepInput) DescribeStepRequest
}

// Send marshals and sends the DescribeStep API request.
func (r DescribeStepRequest) Send(ctx context.Context) (*DescribeStepResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeStepResponse{
		DescribeStepOutput: r.Request.Data.(*DescribeStepOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeStepResponse is the response type for the
// DescribeStep API operation.
type DescribeStepResponse struct {
	*DescribeStepOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeStep request.
func (r *DescribeStepResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
