// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package emr

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/PutAutoScalingPolicyInput
type PutAutoScalingPolicyInput struct {
	_ struct{} `type:"structure"`

	// Specifies the definition of the automatic scaling policy.
	//
	// AutoScalingPolicy is a required field
	AutoScalingPolicy *AutoScalingPolicy `type:"structure" required:"true"`

	// Specifies the ID of a cluster. The instance group to which the automatic
	// scaling policy is applied is within this cluster.
	//
	// ClusterId is a required field
	ClusterId *string `type:"string" required:"true"`

	// Specifies the ID of the instance group to which the automatic scaling policy
	// is applied.
	//
	// InstanceGroupId is a required field
	InstanceGroupId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s PutAutoScalingPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutAutoScalingPolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutAutoScalingPolicyInput"}

	if s.AutoScalingPolicy == nil {
		invalidParams.Add(aws.NewErrParamRequired("AutoScalingPolicy"))
	}

	if s.ClusterId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClusterId"))
	}

	if s.InstanceGroupId == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceGroupId"))
	}
	if s.AutoScalingPolicy != nil {
		if err := s.AutoScalingPolicy.Validate(); err != nil {
			invalidParams.AddNested("AutoScalingPolicy", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/PutAutoScalingPolicyOutput
type PutAutoScalingPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The automatic scaling policy definition.
	AutoScalingPolicy *AutoScalingPolicyDescription `type:"structure"`

	// Specifies the ID of a cluster. The instance group to which the automatic
	// scaling policy is applied is within this cluster.
	ClusterId *string `type:"string"`

	// Specifies the ID of the instance group to which the scaling policy is applied.
	InstanceGroupId *string `type:"string"`
}

// String returns the string representation
func (s PutAutoScalingPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

const opPutAutoScalingPolicy = "PutAutoScalingPolicy"

// PutAutoScalingPolicyRequest returns a request value for making API operation for
// Amazon Elastic MapReduce.
//
// Creates or updates an automatic scaling policy for a core instance group
// or task instance group in an Amazon EMR cluster. The automatic scaling policy
// defines how an instance group dynamically adds and terminates EC2 instances
// in response to the value of a CloudWatch metric.
//
//    // Example sending a request using PutAutoScalingPolicyRequest.
//    req := client.PutAutoScalingPolicyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/PutAutoScalingPolicy
func (c *Client) PutAutoScalingPolicyRequest(input *PutAutoScalingPolicyInput) PutAutoScalingPolicyRequest {
	op := &aws.Operation{
		Name:       opPutAutoScalingPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutAutoScalingPolicyInput{}
	}

	req := c.newRequest(op, input, &PutAutoScalingPolicyOutput{})
	return PutAutoScalingPolicyRequest{Request: req, Input: input, Copy: c.PutAutoScalingPolicyRequest}
}

// PutAutoScalingPolicyRequest is the request type for the
// PutAutoScalingPolicy API operation.
type PutAutoScalingPolicyRequest struct {
	*aws.Request
	Input *PutAutoScalingPolicyInput
	Copy  func(*PutAutoScalingPolicyInput) PutAutoScalingPolicyRequest
}

// Send marshals and sends the PutAutoScalingPolicy API request.
func (r PutAutoScalingPolicyRequest) Send(ctx context.Context) (*PutAutoScalingPolicyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutAutoScalingPolicyResponse{
		PutAutoScalingPolicyOutput: r.Request.Data.(*PutAutoScalingPolicyOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutAutoScalingPolicyResponse is the response type for the
// PutAutoScalingPolicy API operation.
type PutAutoScalingPolicyResponse struct {
	*PutAutoScalingPolicyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutAutoScalingPolicy request.
func (r *PutAutoScalingPolicyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
