// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package fms

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/PutPolicyRequest
type PutPolicyInput struct {
	_ struct{} `type:"structure"`

	// The details of the AWS Firewall Manager policy to be created.
	//
	// Policy is a required field
	Policy *Policy `type:"structure" required:"true"`
}

// String returns the string representation
func (s PutPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutPolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutPolicyInput"}

	if s.Policy == nil {
		invalidParams.Add(aws.NewErrParamRequired("Policy"))
	}
	if s.Policy != nil {
		if err := s.Policy.Validate(); err != nil {
			invalidParams.AddNested("Policy", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/PutPolicyResponse
type PutPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The details of the AWS Firewall Manager policy that was created.
	Policy *Policy `type:"structure"`

	// The Amazon Resource Name (ARN) of the policy that was created.
	PolicyArn *string `min:"1" type:"string"`
}

// String returns the string representation
func (s PutPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

const opPutPolicy = "PutPolicy"

// PutPolicyRequest returns a request value for making API operation for
// Firewall Management Service.
//
// Creates an AWS Firewall Manager policy.
//
// Firewall Manager provides two types of policies: A Shield Advanced policy,
// which applies Shield Advanced protection to specified accounts and resources,
// or a WAF policy, which contains a rule group and defines which resources
// are to be protected by that rule group. A policy is specific to either WAF
// or Shield Advanced. If you want to enforce both WAF rules and Shield Advanced
// protection across accounts, you can create multiple policies. You can create
// one or more policies for WAF rules, and one or more policies for Shield Advanced.
//
// You must be subscribed to Shield Advanced to create a Shield Advanced policy.
// For more information on subscribing to Shield Advanced, see CreateSubscription
// (https://docs.aws.amazon.com/waf/latest/DDOSAPIReference/API_CreateSubscription.html).
//
//    // Example sending a request using PutPolicyRequest.
//    req := client.PutPolicyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/PutPolicy
func (c *Client) PutPolicyRequest(input *PutPolicyInput) PutPolicyRequest {
	op := &aws.Operation{
		Name:       opPutPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutPolicyInput{}
	}

	req := c.newRequest(op, input, &PutPolicyOutput{})
	return PutPolicyRequest{Request: req, Input: input, Copy: c.PutPolicyRequest}
}

// PutPolicyRequest is the request type for the
// PutPolicy API operation.
type PutPolicyRequest struct {
	*aws.Request
	Input *PutPolicyInput
	Copy  func(*PutPolicyInput) PutPolicyRequest
}

// Send marshals and sends the PutPolicy API request.
func (r PutPolicyRequest) Send(ctx context.Context) (*PutPolicyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutPolicyResponse{
		PutPolicyOutput: r.Request.Data.(*PutPolicyOutput),
		response:        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutPolicyResponse is the response type for the
// PutPolicy API operation.
type PutPolicyResponse struct {
	*PutPolicyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutPolicy request.
func (r *PutPolicyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
