// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package glue

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateDevEndpointRequest
type CreateDevEndpointInput struct {
	_ struct{} `type:"structure"`

	// A map of arguments used to configure the DevEndpoint.
	Arguments map[string]string `type:"map"`

	// The name to be assigned to the new DevEndpoint.
	//
	// EndpointName is a required field
	EndpointName *string `type:"string" required:"true"`

	// Path to one or more Java Jars in an S3 bucket that should be loaded in your
	// DevEndpoint.
	ExtraJarsS3Path *string `type:"string"`

	// Path(s) to one or more Python libraries in an S3 bucket that should be loaded
	// in your DevEndpoint. Multiple values must be complete paths separated by
	// a comma.
	//
	// Please note that only pure Python libraries can currently be used on a DevEndpoint.
	// Libraries that rely on C extensions, such as the pandas (http://pandas.pydata.org/)
	// Python data analysis library, are not yet supported.
	ExtraPythonLibsS3Path *string `type:"string"`

	// The number of AWS Glue Data Processing Units (DPUs) to allocate to this DevEndpoint.
	NumberOfNodes *int64 `type:"integer"`

	// The public key to be used by this DevEndpoint for authentication. This attribute
	// is provided for backward compatibility, as the recommended attribute to use
	// is public keys.
	PublicKey *string `type:"string"`

	// A list of public keys to be used by the DevEndpoints for authentication.
	// The use of this attribute is preferred over a single public key because the
	// public keys allow you to have a different private key per client.
	//
	// If you previously created an endpoint with a public key, you must remove
	// that key to be able to set a list of public keys: call the UpdateDevEndpoint
	// API with the public key content in the deletePublicKeys attribute, and the
	// list of new keys in the addPublicKeys attribute.
	PublicKeys []string `type:"list"`

	// The IAM role for the DevEndpoint.
	//
	// RoleArn is a required field
	RoleArn *string `type:"string" required:"true"`

	// The name of the SecurityConfiguration structure to be used with this DevEndpoint.
	SecurityConfiguration *string `min:"1" type:"string"`

	// Security group IDs for the security groups to be used by the new DevEndpoint.
	SecurityGroupIds []string `type:"list"`

	// The subnet ID for the new DevEndpoint to use.
	SubnetId *string `type:"string"`

	// The tags to use with this DevEndpoint. You may use tags to limit access to
	// the DevEndpoint. For more information about tags in AWS Glue, see AWS Tags
	// in AWS Glue (http://docs.aws.amazon.com/glue/latest/dg/monitor-tags.html)
	// in the developer guide.
	Tags map[string]string `type:"map"`
}

// String returns the string representation
func (s CreateDevEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDevEndpointInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateDevEndpointInput"}

	if s.EndpointName == nil {
		invalidParams.Add(aws.NewErrParamRequired("EndpointName"))
	}

	if s.RoleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleArn"))
	}
	if s.SecurityConfiguration != nil && len(*s.SecurityConfiguration) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SecurityConfiguration", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateDevEndpointResponse
type CreateDevEndpointOutput struct {
	_ struct{} `type:"structure"`

	// The map of arguments used to configure this DevEndpoint.
	Arguments map[string]string `type:"map"`

	// The AWS availability zone where this DevEndpoint is located.
	AvailabilityZone *string `type:"string"`

	// The point in time at which this DevEndpoint was created.
	CreatedTimestamp *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The name assigned to the new DevEndpoint.
	EndpointName *string `type:"string"`

	// Path to one or more Java Jars in an S3 bucket that will be loaded in your
	// DevEndpoint.
	ExtraJarsS3Path *string `type:"string"`

	// Path(s) to one or more Python libraries in an S3 bucket that will be loaded
	// in your DevEndpoint.
	ExtraPythonLibsS3Path *string `type:"string"`

	// The reason for a current failure in this DevEndpoint.
	FailureReason *string `type:"string"`

	// The number of AWS Glue Data Processing Units (DPUs) allocated to this DevEndpoint.
	NumberOfNodes *int64 `type:"integer"`

	// The AWS ARN of the role assigned to the new DevEndpoint.
	RoleArn *string `type:"string"`

	// The name of the SecurityConfiguration structure being used with this DevEndpoint.
	SecurityConfiguration *string `min:"1" type:"string"`

	// The security groups assigned to the new DevEndpoint.
	SecurityGroupIds []string `type:"list"`

	// The current status of the new DevEndpoint.
	Status *string `type:"string"`

	// The subnet ID assigned to the new DevEndpoint.
	SubnetId *string `type:"string"`

	// The ID of the VPC used by this DevEndpoint.
	VpcId *string `type:"string"`

	// The address of the YARN endpoint used by this DevEndpoint.
	YarnEndpointAddress *string `type:"string"`

	// The Apache Zeppelin port for the remote Apache Spark interpreter.
	ZeppelinRemoteSparkInterpreterPort *int64 `type:"integer"`
}

// String returns the string representation
func (s CreateDevEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateDevEndpoint = "CreateDevEndpoint"

// CreateDevEndpointRequest returns a request value for making API operation for
// AWS Glue.
//
// Creates a new DevEndpoint.
//
//    // Example sending a request using CreateDevEndpointRequest.
//    req := client.CreateDevEndpointRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateDevEndpoint
func (c *Client) CreateDevEndpointRequest(input *CreateDevEndpointInput) CreateDevEndpointRequest {
	op := &aws.Operation{
		Name:       opCreateDevEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDevEndpointInput{}
	}

	req := c.newRequest(op, input, &CreateDevEndpointOutput{})
	return CreateDevEndpointRequest{Request: req, Input: input, Copy: c.CreateDevEndpointRequest}
}

// CreateDevEndpointRequest is the request type for the
// CreateDevEndpoint API operation.
type CreateDevEndpointRequest struct {
	*aws.Request
	Input *CreateDevEndpointInput
	Copy  func(*CreateDevEndpointInput) CreateDevEndpointRequest
}

// Send marshals and sends the CreateDevEndpoint API request.
func (r CreateDevEndpointRequest) Send(ctx context.Context) (*CreateDevEndpointResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateDevEndpointResponse{
		CreateDevEndpointOutput: r.Request.Data.(*CreateDevEndpointOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateDevEndpointResponse is the response type for the
// CreateDevEndpoint API operation.
type CreateDevEndpointResponse struct {
	*CreateDevEndpointOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateDevEndpoint request.
func (r *CreateDevEndpointResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
