// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package groundstation

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/DeleteDataflowEndpointGroupRequest
type DeleteDataflowEndpointGroupInput struct {
	_ struct{} `type:"structure"`

	// ID of a dataflow endpoint group.
	//
	// DataflowEndpointGroupId is a required field
	DataflowEndpointGroupId *string `location:"uri" locationName:"dataflowEndpointGroupId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDataflowEndpointGroupInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDataflowEndpointGroupInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteDataflowEndpointGroupInput"}

	if s.DataflowEndpointGroupId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DataflowEndpointGroupId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteDataflowEndpointGroupInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/x-amz-json-1.1"), protocol.Metadata{})

	if s.DataflowEndpointGroupId != nil {
		v := *s.DataflowEndpointGroupId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "dataflowEndpointGroupId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/DataflowEndpointGroupIdResponse
type DeleteDataflowEndpointGroupOutput struct {
	_ struct{} `type:"structure"`

	// ID of a dataflow endpoint group.
	DataflowEndpointGroupId *string `locationName:"dataflowEndpointGroupId" type:"string"`
}

// String returns the string representation
func (s DeleteDataflowEndpointGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteDataflowEndpointGroupOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.DataflowEndpointGroupId != nil {
		v := *s.DataflowEndpointGroupId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "dataflowEndpointGroupId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opDeleteDataflowEndpointGroup = "DeleteDataflowEndpointGroup"

// DeleteDataflowEndpointGroupRequest returns a request value for making API operation for
// AWS Ground Station.
//
// Deletes a dataflow endpoint group.
//
//    // Example sending a request using DeleteDataflowEndpointGroupRequest.
//    req := client.DeleteDataflowEndpointGroupRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/DeleteDataflowEndpointGroup
func (c *Client) DeleteDataflowEndpointGroupRequest(input *DeleteDataflowEndpointGroupInput) DeleteDataflowEndpointGroupRequest {
	op := &aws.Operation{
		Name:       opDeleteDataflowEndpointGroup,
		HTTPMethod: "DELETE",
		HTTPPath:   "/dataflowEndpointGroup/{dataflowEndpointGroupId}",
	}

	if input == nil {
		input = &DeleteDataflowEndpointGroupInput{}
	}

	req := c.newRequest(op, input, &DeleteDataflowEndpointGroupOutput{})
	return DeleteDataflowEndpointGroupRequest{Request: req, Input: input, Copy: c.DeleteDataflowEndpointGroupRequest}
}

// DeleteDataflowEndpointGroupRequest is the request type for the
// DeleteDataflowEndpointGroup API operation.
type DeleteDataflowEndpointGroupRequest struct {
	*aws.Request
	Input *DeleteDataflowEndpointGroupInput
	Copy  func(*DeleteDataflowEndpointGroupInput) DeleteDataflowEndpointGroupRequest
}

// Send marshals and sends the DeleteDataflowEndpointGroup API request.
func (r DeleteDataflowEndpointGroupRequest) Send(ctx context.Context) (*DeleteDataflowEndpointGroupResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteDataflowEndpointGroupResponse{
		DeleteDataflowEndpointGroupOutput: r.Request.Data.(*DeleteDataflowEndpointGroupOutput),
		response:                          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteDataflowEndpointGroupResponse is the response type for the
// DeleteDataflowEndpointGroup API operation.
type DeleteDataflowEndpointGroupResponse struct {
	*DeleteDataflowEndpointGroupOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteDataflowEndpointGroup request.
func (r *DeleteDataflowEndpointGroupResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
