// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package guardduty

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// DeleteMembers request body.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeleteMembersRequest
type DeleteMembersInput struct {
	_ struct{} `type:"structure"`

	// A list of account IDs of the GuardDuty member accounts that you want to delete.
	//
	// AccountIds is a required field
	AccountIds []string `locationName:"accountIds" type:"list" required:"true"`

	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteMembersInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMembersInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteMembersInput"}

	if s.AccountIds == nil {
		invalidParams.Add(aws.NewErrParamRequired("AccountIds"))
	}

	if s.DetectorId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DetectorId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteMembersInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/x-amz-json-1.1"), protocol.Metadata{})

	if len(s.AccountIds) > 0 {
		v := s.AccountIds

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "accountIds", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.DetectorId != nil {
		v := *s.DetectorId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "detectorId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// DeleteMembers response object.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeleteMembersResponse
type DeleteMembersOutput struct {
	_ struct{} `type:"structure"`

	// A list of objects containing the unprocessed account and a result string
	// explaining why it was unprocessed.
	UnprocessedAccounts []UnprocessedAccount `locationName:"unprocessedAccounts" type:"list"`
}

// String returns the string representation
func (s DeleteMembersOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteMembersOutput) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.UnprocessedAccounts) > 0 {
		v := s.UnprocessedAccounts

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "unprocessedAccounts", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opDeleteMembers = "DeleteMembers"

// DeleteMembersRequest returns a request value for making API operation for
// Amazon GuardDuty.
//
// Deletes GuardDuty member accounts (to the current GuardDuty master account)
// specified by the account IDs.
//
//    // Example sending a request using DeleteMembersRequest.
//    req := client.DeleteMembersRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeleteMembers
func (c *Client) DeleteMembersRequest(input *DeleteMembersInput) DeleteMembersRequest {
	op := &aws.Operation{
		Name:       opDeleteMembers,
		HTTPMethod: "POST",
		HTTPPath:   "/detector/{detectorId}/member/delete",
	}

	if input == nil {
		input = &DeleteMembersInput{}
	}

	req := c.newRequest(op, input, &DeleteMembersOutput{})
	return DeleteMembersRequest{Request: req, Input: input, Copy: c.DeleteMembersRequest}
}

// DeleteMembersRequest is the request type for the
// DeleteMembers API operation.
type DeleteMembersRequest struct {
	*aws.Request
	Input *DeleteMembersInput
	Copy  func(*DeleteMembersInput) DeleteMembersRequest
}

// Send marshals and sends the DeleteMembers API request.
func (r DeleteMembersRequest) Send(ctx context.Context) (*DeleteMembersResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteMembersResponse{
		DeleteMembersOutput: r.Request.Data.(*DeleteMembersOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteMembersResponse is the response type for the
// DeleteMembers API operation.
type DeleteMembersResponse struct {
	*DeleteMembersOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteMembers request.
func (r *DeleteMembersResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
