// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package guardduty

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetThreatIntelSetRequest
type GetThreatIntelSetInput struct {
	_ struct{} `type:"structure"`

	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" type:"string" required:"true"`

	// ThreatIntelSetId is a required field
	ThreatIntelSetId *string `location:"uri" locationName:"threatIntelSetId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetThreatIntelSetInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetThreatIntelSetInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetThreatIntelSetInput"}

	if s.DetectorId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DetectorId"))
	}

	if s.ThreatIntelSetId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ThreatIntelSetId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetThreatIntelSetInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/x-amz-json-1.1"), protocol.Metadata{})

	if s.DetectorId != nil {
		v := *s.DetectorId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "detectorId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ThreatIntelSetId != nil {
		v := *s.ThreatIntelSetId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "threatIntelSetId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// GetThreatIntelSet response object
// Please also see https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetThreatIntelSetResponse
type GetThreatIntelSetOutput struct {
	_ struct{} `type:"structure"`

	// The format of the threatIntelSet.
	Format ThreatIntelSetFormat `locationName:"format" type:"string" enum:"true"`

	// The URI of the file that contains the ThreatIntelSet. For example (https://s3.us-west-2.amazonaws.com/my-bucket/my-object-key).
	Location *string `locationName:"location" type:"string"`

	// A user-friendly ThreatIntelSet name that is displayed in all finding generated
	// by activity that involves IP addresses included in this ThreatIntelSet.
	Name *string `locationName:"name" type:"string"`

	// The status of threatIntelSet file uploaded.
	Status ThreatIntelSetStatus `locationName:"status" type:"string" enum:"true"`
}

// String returns the string representation
func (s GetThreatIntelSetOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetThreatIntelSetOutput) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Format) > 0 {
		v := s.Format

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "format", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Location != nil {
		v := *s.Location

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "location", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

const opGetThreatIntelSet = "GetThreatIntelSet"

// GetThreatIntelSetRequest returns a request value for making API operation for
// Amazon GuardDuty.
//
// Retrieves the ThreatIntelSet that is specified by the ThreatIntelSet ID.
//
//    // Example sending a request using GetThreatIntelSetRequest.
//    req := client.GetThreatIntelSetRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetThreatIntelSet
func (c *Client) GetThreatIntelSetRequest(input *GetThreatIntelSetInput) GetThreatIntelSetRequest {
	op := &aws.Operation{
		Name:       opGetThreatIntelSet,
		HTTPMethod: "GET",
		HTTPPath:   "/detector/{detectorId}/threatintelset/{threatIntelSetId}",
	}

	if input == nil {
		input = &GetThreatIntelSetInput{}
	}

	req := c.newRequest(op, input, &GetThreatIntelSetOutput{})
	return GetThreatIntelSetRequest{Request: req, Input: input, Copy: c.GetThreatIntelSetRequest}
}

// GetThreatIntelSetRequest is the request type for the
// GetThreatIntelSet API operation.
type GetThreatIntelSetRequest struct {
	*aws.Request
	Input *GetThreatIntelSetInput
	Copy  func(*GetThreatIntelSetInput) GetThreatIntelSetRequest
}

// Send marshals and sends the GetThreatIntelSet API request.
func (r GetThreatIntelSetRequest) Send(ctx context.Context) (*GetThreatIntelSetResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetThreatIntelSetResponse{
		GetThreatIntelSetOutput: r.Request.Data.(*GetThreatIntelSetOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetThreatIntelSetResponse is the response type for the
// GetThreatIntelSet API operation.
type GetThreatIntelSetResponse struct {
	*GetThreatIntelSetOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetThreatIntelSet request.
func (r *GetThreatIntelSetResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
