// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iam

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/query"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteRolePermissionsBoundaryRequest
type DeleteRolePermissionsBoundaryInput struct {
	_ struct{} `type:"structure"`

	// The name (friendly name, not ARN) of the IAM role from which you want to
	// remove the permissions boundary.
	//
	// RoleName is a required field
	RoleName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteRolePermissionsBoundaryInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRolePermissionsBoundaryInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteRolePermissionsBoundaryInput"}

	if s.RoleName == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleName"))
	}
	if s.RoleName != nil && len(*s.RoleName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RoleName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteRolePermissionsBoundaryOutput
type DeleteRolePermissionsBoundaryOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteRolePermissionsBoundaryOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteRolePermissionsBoundary = "DeleteRolePermissionsBoundary"

// DeleteRolePermissionsBoundaryRequest returns a request value for making API operation for
// AWS Identity and Access Management.
//
// Deletes the permissions boundary for the specified IAM role.
//
// Deleting the permissions boundary for a role might increase its permissions.
// For example, it might allow anyone who assumes the role to perform all the
// actions granted in its permissions policies.
//
//    // Example sending a request using DeleteRolePermissionsBoundaryRequest.
//    req := client.DeleteRolePermissionsBoundaryRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteRolePermissionsBoundary
func (c *Client) DeleteRolePermissionsBoundaryRequest(input *DeleteRolePermissionsBoundaryInput) DeleteRolePermissionsBoundaryRequest {
	op := &aws.Operation{
		Name:       opDeleteRolePermissionsBoundary,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRolePermissionsBoundaryInput{}
	}

	req := c.newRequest(op, input, &DeleteRolePermissionsBoundaryOutput{})
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeleteRolePermissionsBoundaryRequest{Request: req, Input: input, Copy: c.DeleteRolePermissionsBoundaryRequest}
}

// DeleteRolePermissionsBoundaryRequest is the request type for the
// DeleteRolePermissionsBoundary API operation.
type DeleteRolePermissionsBoundaryRequest struct {
	*aws.Request
	Input *DeleteRolePermissionsBoundaryInput
	Copy  func(*DeleteRolePermissionsBoundaryInput) DeleteRolePermissionsBoundaryRequest
}

// Send marshals and sends the DeleteRolePermissionsBoundary API request.
func (r DeleteRolePermissionsBoundaryRequest) Send(ctx context.Context) (*DeleteRolePermissionsBoundaryResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteRolePermissionsBoundaryResponse{
		DeleteRolePermissionsBoundaryOutput: r.Request.Data.(*DeleteRolePermissionsBoundaryOutput),
		response:                            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteRolePermissionsBoundaryResponse is the response type for the
// DeleteRolePermissionsBoundary API operation.
type DeleteRolePermissionsBoundaryResponse struct {
	*DeleteRolePermissionsBoundaryOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteRolePermissionsBoundary request.
func (r *DeleteRolePermissionsBoundaryResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
