// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iam

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/query"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteSSHPublicKeyRequest
type DeleteSSHPublicKeyInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the SSH public key.
	//
	// This parameter allows (through its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters that can consist of any upper or lowercased letter
	// or digit.
	//
	// SSHPublicKeyId is a required field
	SSHPublicKeyId *string `min:"20" type:"string" required:"true"`

	// The name of the IAM user associated with the SSH public key.
	//
	// This parameter allows (through its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: _+=,.@-
	//
	// UserName is a required field
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteSSHPublicKeyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSSHPublicKeyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteSSHPublicKeyInput"}

	if s.SSHPublicKeyId == nil {
		invalidParams.Add(aws.NewErrParamRequired("SSHPublicKeyId"))
	}
	if s.SSHPublicKeyId != nil && len(*s.SSHPublicKeyId) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("SSHPublicKeyId", 20))
	}

	if s.UserName == nil {
		invalidParams.Add(aws.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteSSHPublicKeyOutput
type DeleteSSHPublicKeyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteSSHPublicKeyOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteSSHPublicKey = "DeleteSSHPublicKey"

// DeleteSSHPublicKeyRequest returns a request value for making API operation for
// AWS Identity and Access Management.
//
// Deletes the specified SSH public key.
//
// The SSH public key deleted by this operation is used only for authenticating
// the associated IAM user to an AWS CodeCommit repository. For more information
// about using SSH keys to authenticate to an AWS CodeCommit repository, see
// Set up AWS CodeCommit for SSH Connections (https://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-credentials-ssh.html)
// in the AWS CodeCommit User Guide.
//
//    // Example sending a request using DeleteSSHPublicKeyRequest.
//    req := client.DeleteSSHPublicKeyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteSSHPublicKey
func (c *Client) DeleteSSHPublicKeyRequest(input *DeleteSSHPublicKeyInput) DeleteSSHPublicKeyRequest {
	op := &aws.Operation{
		Name:       opDeleteSSHPublicKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSSHPublicKeyInput{}
	}

	req := c.newRequest(op, input, &DeleteSSHPublicKeyOutput{})
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeleteSSHPublicKeyRequest{Request: req, Input: input, Copy: c.DeleteSSHPublicKeyRequest}
}

// DeleteSSHPublicKeyRequest is the request type for the
// DeleteSSHPublicKey API operation.
type DeleteSSHPublicKeyRequest struct {
	*aws.Request
	Input *DeleteSSHPublicKeyInput
	Copy  func(*DeleteSSHPublicKeyInput) DeleteSSHPublicKeyRequest
}

// Send marshals and sends the DeleteSSHPublicKey API request.
func (r DeleteSSHPublicKeyRequest) Send(ctx context.Context) (*DeleteSSHPublicKeyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteSSHPublicKeyResponse{
		DeleteSSHPublicKeyOutput: r.Request.Data.(*DeleteSSHPublicKeyOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteSSHPublicKeyResponse is the response type for the
// DeleteSSHPublicKey API operation.
type DeleteSSHPublicKeyResponse struct {
	*DeleteSSHPublicKeyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteSSHPublicKey request.
func (r *DeleteSSHPublicKeyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
