// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package inspector

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListAssessmentTargetsRequest
type ListAssessmentTargetsInput struct {
	_ struct{} `type:"structure"`

	// You can use this parameter to specify a subset of data to be included in
	// the action's response.
	//
	// For a record to match a filter, all specified filter attributes must match.
	// When multiple values are specified for a filter attribute, any of the values
	// can match.
	Filter *AssessmentTargetFilter `locationName:"filter" type:"structure"`

	// You can use this parameter to indicate the maximum number of items you want
	// in the response. The default value is 10. The maximum value is 500.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// You can use this parameter when paginating results. Set the value of this
	// parameter to null on your first call to the ListAssessmentTargets action.
	// Subsequent calls to the action fill nextToken in the request with the value
	// of NextToken from the previous response to continue listing data.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListAssessmentTargetsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAssessmentTargetsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListAssessmentTargetsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListAssessmentTargetsResponse
type ListAssessmentTargetsOutput struct {
	_ struct{} `type:"structure"`

	// A list of ARNs that specifies the assessment targets that are returned by
	// the action.
	//
	// AssessmentTargetArns is a required field
	AssessmentTargetArns []string `locationName:"assessmentTargetArns" type:"list" required:"true"`

	// When a response is generated, if there is more data to be listed, this parameter
	// is present in the response and contains the value to use for the nextToken
	// parameter in a subsequent pagination request. If there is no more data to
	// be listed, this parameter is set to null.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListAssessmentTargetsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListAssessmentTargets = "ListAssessmentTargets"

// ListAssessmentTargetsRequest returns a request value for making API operation for
// Amazon Inspector.
//
// Lists the ARNs of the assessment targets within this AWS account. For more
// information about assessment targets, see Amazon Inspector Assessment Targets
// (https://docs.aws.amazon.com/inspector/latest/userguide/inspector_applications.html).
//
//    // Example sending a request using ListAssessmentTargetsRequest.
//    req := client.ListAssessmentTargetsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListAssessmentTargets
func (c *Client) ListAssessmentTargetsRequest(input *ListAssessmentTargetsInput) ListAssessmentTargetsRequest {
	op := &aws.Operation{
		Name:       opListAssessmentTargets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAssessmentTargetsInput{}
	}

	req := c.newRequest(op, input, &ListAssessmentTargetsOutput{})
	return ListAssessmentTargetsRequest{Request: req, Input: input, Copy: c.ListAssessmentTargetsRequest}
}

// ListAssessmentTargetsRequest is the request type for the
// ListAssessmentTargets API operation.
type ListAssessmentTargetsRequest struct {
	*aws.Request
	Input *ListAssessmentTargetsInput
	Copy  func(*ListAssessmentTargetsInput) ListAssessmentTargetsRequest
}

// Send marshals and sends the ListAssessmentTargets API request.
func (r ListAssessmentTargetsRequest) Send(ctx context.Context) (*ListAssessmentTargetsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListAssessmentTargetsResponse{
		ListAssessmentTargetsOutput: r.Request.Data.(*ListAssessmentTargetsOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListAssessmentTargetsRequestPaginator returns a paginator for ListAssessmentTargets.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListAssessmentTargetsRequest(input)
//   p := inspector.NewListAssessmentTargetsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListAssessmentTargetsPaginator(req ListAssessmentTargetsRequest) ListAssessmentTargetsPaginator {
	return ListAssessmentTargetsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListAssessmentTargetsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListAssessmentTargetsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListAssessmentTargetsPaginator struct {
	aws.Pager
}

func (p *ListAssessmentTargetsPaginator) CurrentPage() *ListAssessmentTargetsOutput {
	return p.Pager.CurrentPage().(*ListAssessmentTargetsOutput)
}

// ListAssessmentTargetsResponse is the response type for the
// ListAssessmentTargets API operation.
type ListAssessmentTargetsResponse struct {
	*ListAssessmentTargetsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListAssessmentTargets request.
func (r *ListAssessmentTargetsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
